/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Jsonata;

public class Timebox {
    long timeout = 5000L;
    int maxDepth = 100;
    long time = System.currentTimeMillis();
    int depth = 0;

    public Timebox(Jsonata.Frame expr) {
        this(expr, 5000L, 100);
    }

    public Timebox(Jsonata.Frame expr, long timeout, int maxDepth) {
        this.timeout = timeout;
        this.maxDepth = maxDepth;
        expr.setEvaluateEntryCallback((_exp, _input, _env) -> {
            if (_env.isParallelCall) {
                return;
            }
            ++this.depth;
            this.checkRunnaway();
        });
        expr.setEvaluateExitCallback((_exp, _input, _env, _res) -> {
            if (_env.isParallelCall) {
                return;
            }
            --this.depth;
            this.checkRunnaway();
        });
    }

    void checkRunnaway() {
        if (this.depth > this.maxDepth) {
            throw new JException("Stack overflow error: Check for non-terminating recursive function.  Consider rewriting as tail-recursive. Depth=" + this.depth + " max=" + this.maxDepth, -1);
        }
        if (System.currentTimeMillis() - this.time > this.timeout) {
            throw new JException("Expression evaluation timeout: Check for infinite loop", -1);
        }
    }
}

