/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Jsonata;
import com.dashjoin.jsonata.Parser;
import com.dashjoin.jsonata.Utils;
import com.dashjoin.jsonata.json.Json;
import com.dashjoin.jsonata.utils.DateTimeUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.TimeZone;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Functions {
    public static Number sum(List<Number> args) {
        if (args == null) {
            return null;
        }
        double total = args.stream().mapToDouble(Number::doubleValue).sum();
        return total;
    }

    public static Number count(List<Object> args) {
        if (args == null) {
            return 0;
        }
        return args.size();
    }

    public static Number max(List<Number> args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        OptionalDouble res = args.stream().mapToDouble(Number::doubleValue).max();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        return null;
    }

    public static Number min(List<Number> args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        OptionalDouble res = args.stream().mapToDouble(Number::doubleValue).min();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        return null;
    }

    public static Number average(List<Number> args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        OptionalDouble res = args.stream().mapToDouble(Number::doubleValue).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        return null;
    }

    public static String string(Object arg, Boolean prettify) {
        if (arg instanceof Utils.JList && ((Utils.JList)arg).outerWrapper) {
            arg = ((Utils.JList)arg).get(0);
        }
        if (arg == null) {
            return null;
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        StringBuilder sb = new StringBuilder();
        Functions.string(sb, arg, prettify != null && prettify != false, "");
        return sb.toString();
    }

    static void string(StringBuilder b, Object arg, boolean prettify, String indent) {
        if (arg == null || arg == Jsonata.NULL_VALUE) {
            b.append("null");
            return;
        }
        if (arg instanceof Jsonata.JFunction) {
            return;
        }
        if (arg instanceof Parser.Symbol) {
            return;
        }
        if (arg instanceof Double) {
            BigDecimal bd = new BigDecimal((Double)arg, new MathContext(15));
            String res = bd.stripTrailingZeros().toString();
            if (res.indexOf("E+") > 0) {
                res = res.replace("E+", "e+");
            }
            if (res.indexOf("E-") > 0) {
                res = res.replace("E-", "e-");
            }
            b.append(res);
            return;
        }
        if (arg instanceof Number || arg instanceof Boolean) {
            b.append(arg);
            return;
        }
        if (arg instanceof String) {
            Utils.quote((String)arg, b);
            return;
        }
        if (arg instanceof Map) {
            b.append('{');
            if (prettify) {
                b.append('\n');
            }
            for (Map.Entry e : ((Map)arg).entrySet()) {
                Object v;
                if (prettify) {
                    b.append(indent);
                    b.append("  ");
                }
                b.append('\"');
                b.append((String)e.getKey());
                b.append('\"');
                b.append(':');
                if (prettify) {
                    b.append(' ');
                }
                if ((v = e.getValue()) instanceof String || v instanceof Parser.Symbol || v instanceof Jsonata.JFunction) {
                    b.append('\"');
                    Functions.string(b, v, prettify, indent + "  ");
                    b.append('\"');
                } else {
                    Functions.string(b, v, prettify, indent + "  ");
                }
                b.append(',');
                if (!prettify) continue;
                b.append('\n');
            }
            if (!((Map)arg).isEmpty()) {
                b.deleteCharAt(b.length() - (prettify ? 2 : 1));
            }
            if (prettify) {
                b.append(indent);
            }
            b.append('}');
            return;
        }
        if (arg instanceof List) {
            if (((List)arg).isEmpty()) {
                b.append("[]");
                return;
            }
            b.append('[');
            if (prettify) {
                b.append('\n');
            }
            for (Object v : (List)arg) {
                if (prettify) {
                    b.append(indent);
                    b.append("  ");
                }
                if (v instanceof String || v instanceof Parser.Symbol || v instanceof Jsonata.JFunction) {
                    b.append('\"');
                    Functions.string(b, v, prettify, indent + "  ");
                    b.append('\"');
                } else {
                    Functions.string(b, v, prettify, indent + "  ");
                }
                b.append(',');
                if (!prettify) continue;
                b.append('\n');
            }
            if (!((List)arg).isEmpty()) {
                b.deleteCharAt(b.length() - (prettify ? 2 : 1));
            }
            if (prettify) {
                b.append(indent);
            }
            b.append(']');
            return;
        }
        throw new IllegalArgumentException("Only JSON types (values, Map, List) can be stringified. Unsupported type: " + arg.getClass().getName());
    }

    public static void validateInput(Object arg) {
        if (arg == null || arg == Jsonata.NULL_VALUE) {
            return;
        }
        if (arg instanceof Jsonata.JFunction) {
            return;
        }
        if (arg instanceof Parser.Symbol) {
            return;
        }
        if (arg instanceof Double) {
            return;
        }
        if (arg instanceof Number || arg instanceof Boolean) {
            return;
        }
        if (arg instanceof String) {
            return;
        }
        if (arg instanceof Map) {
            for (Map.Entry e : ((Map)arg).entrySet()) {
                Functions.validateInput(e.getKey());
                Functions.validateInput(e.getValue());
            }
            return;
        }
        if (arg instanceof List) {
            for (Object v : (List)arg) {
                Functions.validateInput(v);
            }
            return;
        }
        throw new IllegalArgumentException("Only JSON types (values, Map, List) are allowed as input. Unsupported type: " + arg.getClass().getCanonicalName());
    }

    public static String substring(String str, Number _start, Number _length) {
        if (str == null) {
            return null;
        }
        Integer start = _start != null ? Integer.valueOf(_start.intValue()) : null;
        Integer length = _length != null ? Integer.valueOf(_length.intValue()) : null;
        int strLength = str.length();
        if (strLength + start < 0) {
            start = 0;
        }
        if (length != null) {
            if (length <= 0) {
                return "";
            }
            return Functions.substr(str, start, length);
        }
        return Functions.substr(str, start, strLength);
    }

    public static String substr(String str, Integer start, Integer length) {
        int origLen = str.length();
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        if (start >= strLen) {
            return "";
        }
        if ((start = Integer.valueOf(strData.offsetByCodePoints(0, start >= 0 ? start : (strLen + start < 0 ? 0 : strLen + start)))) < 0) {
            start = 0;
        }
        if (length == null) {
            length = strData.length();
        } else {
            if (length < 0) {
                return "";
            }
            if (length > strData.length()) {
                length = strData.length();
            }
        }
        length = strData.offsetByCodePoints(0, length);
        if (start >= 0 && start >= origLen) {
            return "";
        }
        int end = start + length;
        if (end > origLen) {
            end = origLen;
        }
        return strData.substring(start, end);
    }

    public static String substringBefore(String str, String chars) {
        if (str == null) {
            return null;
        }
        if (chars == null) {
            return str;
        }
        int pos = str.indexOf(chars);
        if (pos > -1) {
            return str.substring(0, pos);
        }
        return str;
    }

    public static String substringAfter(String str, String chars) {
        if (str == null) {
            return null;
        }
        int pos = str.indexOf(chars);
        if (pos > -1) {
            return str.substring(pos + chars.length());
        }
        return str;
    }

    public static String lowercase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String uppercase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static Integer length(String str) {
        if (str == null) {
            return null;
        }
        return str.codePointCount(0, str.length());
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return "";
        }
        String result = str.replaceAll("[ \t\n\r]+", " ");
        if (result.charAt(0) == ' ') {
            result = result.substring(1);
        }
        if (result.isEmpty()) {
            return "";
        }
        if (result.charAt(result.length() - 1) == ' ') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String pad(String str, Integer width, String _char) {
        if (str == null) {
            return null;
        }
        if (_char == null || _char.isEmpty()) {
            _char = " ";
        }
        String result = width < 0 ? Functions.leftPad(str, -width.intValue(), _char) : Functions.rightPad(str, width, _char);
        return result;
    }

    public static String leftPad(String str, int size, String padStr) {
        int pads;
        if (str == null) {
            return null;
        }
        if (padStr == null) {
            padStr = " ";
        }
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        String padData = Objects.requireNonNull(padStr).intern();
        int padLen = padData.codePointCount(0, padData.length());
        if (padLen == 0) {
            padStr = " ";
        }
        if ((pads = size - strLen) <= 0) {
            return str;
        }
        Object padding = "";
        for (int i = 0; i < pads + 1; ++i) {
            padding = (String)padding + padStr;
        }
        return Functions.substr((String)padding, 0, pads).concat(str);
    }

    public static String rightPad(String str, int size, String padStr) {
        int pads;
        if (str == null) {
            return null;
        }
        if (padStr == null) {
            padStr = " ";
        }
        String strData = Objects.requireNonNull(str).intern();
        int strLen = strData.codePointCount(0, strData.length());
        String padData = Objects.requireNonNull(padStr).intern();
        int padLen = padData.codePointCount(0, padData.length());
        if (padLen == 0) {
            padStr = " ";
        }
        if ((pads = size - strLen) <= 0) {
            return str;
        }
        Object padding = "";
        for (int i = 0; i < pads + 1; ++i) {
            padding = (String)padding + padStr;
        }
        return str.concat(Functions.substr((String)padding, 0, pads));
    }

    public static List<RegexpMatch> evaluateMatcher(Pattern matcher, String str) {
        ArrayList<RegexpMatch> res = new ArrayList<RegexpMatch>();
        Matcher m = matcher.matcher(str);
        while (m.find()) {
            RegexpMatch rm = new RegexpMatch();
            rm.index = m.start();
            rm.match = m.group();
            ArrayList<String> groups = new ArrayList<String>();
            for (int g = 1; g <= m.groupCount(); ++g) {
                groups.add(m.group(g));
            }
            rm.groups = groups;
            res.add(rm);
        }
        return res;
    }

    public static Boolean contains(String str, Object token) {
        boolean result;
        if (str == null) {
            return null;
        }
        if (token instanceof String) {
            result = str.indexOf((String)token) != -1;
        } else if (token instanceof Pattern) {
            List<RegexpMatch> matches = Functions.evaluateMatcher((Pattern)token, str);
            result = !matches.isEmpty();
        } else {
            throw new Error("unknown type to match: " + String.valueOf(token));
        }
        return result;
    }

    public static List<Map> match(String str, Pattern regex, Integer limit) {
        if (str == null) {
            return null;
        }
        if (limit != null && limit < 0) {
            throw new JException("D3040", -1, limit);
        }
        List<Object> result = Utils.createSequence();
        List<RegexpMatch> matches = Functions.evaluateMatcher(regex, str);
        int max = Integer.MAX_VALUE;
        if (limit != null) {
            max = limit;
        }
        for (int i = 0; i < matches.size(); ++i) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            RegexpMatch rm = matches.get(i);
            m.put("match", rm.match);
            m.put("index", rm.index);
            m.put("groups", rm.groups);
            result.add(m);
            if (i >= max) break;
        }
        return result;
    }

    public static String join(List<String> strs, String separator) {
        if (strs == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        return String.join((CharSequence)separator, strs);
    }

    static String safeReplacement(String in) {
        return in.replaceAll("\\$\\$", "\\\\\\$").replaceAll("([^\\\\]|^)\\$([^0-9^<])", "$1\\\\\\$$2").replaceAll("\\$$", "\\\\\\$");
    }

    static String safeReplaceAll(String s, Pattern pattern, Object _replacement) {
        if (!(_replacement instanceof String)) {
            return Functions.safeReplaceAllFn(s, pattern, _replacement);
        }
        String replacement = (String)_replacement;
        replacement = Functions.safeReplacement(replacement);
        Matcher m = pattern.matcher(s);
        String r = null;
        for (int i = 0; i < 10; ++i) {
            try {
                r = m.replaceAll(replacement);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                String msg = e.getMessage();
                if (!msg.contains("No group")) {
                    throw e;
                }
                String g = "" + msg.charAt(msg.length() - 1);
                replacement = replacement.replace("$" + g, "");
                continue;
            }
        }
        return r;
    }

    static Map toJsonataMatch(MatchResult mr) {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("match", mr.group());
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i <= mr.groupCount(); ++i) {
            groups.add(mr.group(i));
        }
        obj.put("groups", groups);
        return obj;
    }

    static String safeReplaceAllFn(String s, Pattern pattern, Object fn) {
        Matcher m = pattern.matcher(s);
        String r = null;
        r = m.replaceAll(t -> {
            try {
                Object res = Functions.funcApply(fn, List.of(Functions.toJsonataMatch(t)));
                if (res instanceof String) {
                    return (String)res;
                }
                return null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        });
        return r;
    }

    static String safeReplaceFirst(String s, Pattern pattern, String replacement) {
        replacement = Functions.safeReplacement(replacement);
        Matcher m = pattern.matcher(s);
        String r = null;
        for (int i = 0; i < 10; ++i) {
            try {
                r = m.replaceFirst(replacement);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                String msg = e.getMessage();
                if (!msg.contains("No group")) {
                    throw e;
                }
                String g = "" + msg.charAt(msg.length() - 1);
                replacement = replacement.replace("$" + g, "");
                continue;
            }
        }
        return r;
    }

    public static String replace(String str, Object pattern, Object replacement, Integer limit) {
        if (str == null) {
            return null;
        }
        if (pattern instanceof String && ((String)pattern).isEmpty()) {
            throw new JException("Second argument of replace function cannot be an empty string", 0);
        }
        if (limit == null) {
            if (pattern instanceof String) {
                return str.replace((String)pattern, (String)replacement);
            }
            return Functions.safeReplaceAll(str, (Pattern)pattern, replacement);
        }
        if (limit < 0) {
            throw new JException("Fourth argument of replace function must evaluate to a positive number", 0);
        }
        for (int i = 0; i < limit; ++i) {
            str = pattern instanceof String ? str.replaceFirst((String)pattern, (String)replacement) : Functions.safeReplaceFirst(str, (Pattern)pattern, (String)replacement);
        }
        return str;
    }

    public static String base64encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Base64.getEncoder().encodeToString(str.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String base64decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Base64.getDecoder().decode(str), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeUrlComponent(String str) {
        if (str == null) {
            return null;
        }
        Utils.checkUrl(str);
        return URLEncoder.encode(str, StandardCharsets.UTF_8).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
    }

    public static String encodeUrl(String str) {
        if (str == null) {
            return null;
        }
        Utils.checkUrl(str);
        try {
            URL url = new URL(str);
            String query = url.getQuery();
            if (query != null) {
                int offset = str.indexOf(query);
                String strResult = str.substring(0, offset);
                return strResult + Functions.encodeURI(query);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    static String encodeURI(String uri) {
        String result = null;
        if (uri != null) {
            try {
                result = URLEncoder.encode(uri, "UTF-8").replaceAll("\\+", "%20").replaceAll("%20", " ").replaceAll("\\%21", "!").replaceAll("\\%23", "#").replaceAll("\\%24", "$").replaceAll("\\%26", "&").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%2A", "*").replaceAll("\\%2B", "+").replaceAll("\\%2C", ",").replaceAll("\\%2D", "-").replaceAll("\\%2E", ".").replaceAll("\\%2F", "/").replaceAll("\\%3A", ":").replaceAll("\\%3B", ";").replaceAll("\\%3D", "=").replaceAll("\\%3F", "?").replaceAll("\\%40", "@").replaceAll("\\%5F", "_").replaceAll("\\%7E", "~");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String decodeUrlComponent(String str) {
        if (str == null) {
            return null;
        }
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static String decodeUrl(String str) {
        if (str == null) {
            return null;
        }
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static List<String> split(String str, Object pattern, Number limit) {
        if (str == null) {
            return null;
        }
        if (limit != null && limit.intValue() < 0) {
            throw new JException("D3020", -1, str);
        }
        List<String> result = new ArrayList<String>();
        if (limit != null && limit.intValue() == 0) {
            return result;
        }
        if (pattern instanceof String) {
            String sep = (String)pattern;
            if (sep.isEmpty()) {
                int l = limit != null ? limit.intValue() : Integer.MAX_VALUE;
                for (int i = 0; i < str.length() && i < l; ++i) {
                    result.add("" + str.charAt(i));
                }
            } else {
                result = Arrays.asList(str.split(Pattern.quote(sep), -1));
            }
        } else {
            result = Arrays.asList(((Pattern)pattern).split(str, -1));
        }
        if (limit != null && limit.intValue() < result.size()) {
            result = result.subList(0, limit.intValue());
        }
        return result;
    }

    public static String formatNumber(Number value, String picture, Map options) {
        if (value == null) {
            return null;
        }
        if (picture != null) {
            if (picture.contains(",,")) {
                throw new RuntimeException("The sub-picture must not contain two adjacent instances of the 'grouping-separator' character");
            }
            if (picture.indexOf(37) >= 0 && picture.indexOf(101) >= 0) {
                throw new RuntimeException("A sub-picture that contains a 'percent' or 'per-mille' character must not contain a character treated as an 'exponent-separator");
            }
        }
        DecimalFormatSymbols symbols = options == null ? new DecimalFormatSymbols(Locale.US) : Functions.processOptionsArg(options);
        DecimalFormat formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(symbols);
        String fixedPicture = picture;
        for (char c = '1'; c <= '9'; c = (char)(c + '\u0001')) {
            fixedPicture = fixedPicture.replace(c, '0');
        }
        boolean littleE = false;
        if (fixedPicture.contains("e")) {
            fixedPicture = fixedPicture.replace("e", "E");
            littleE = true;
        }
        formatter.applyLocalizedPattern(fixedPicture);
        String result = formatter.format(value);
        if (littleE) {
            result = result.replace("E", "e");
        }
        return result;
    }

    private static DecimalFormatSymbols processOptionsArg(Map argOptions) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        block24: for (String fieldName : argOptions.keySet()) {
            String valueNode = (String)argOptions.get(fieldName);
            switch (fieldName) {
                case "decimal-separator": {
                    String value = Functions.getFormattingCharacter(valueNode, "decimal-separator", true);
                    symbols.setDecimalSeparator(value.charAt(0));
                    continue block24;
                }
                case "grouping-separator": {
                    String value = Functions.getFormattingCharacter(valueNode, "grouping-separator", true);
                    symbols.setGroupingSeparator(value.charAt(0));
                    continue block24;
                }
                case "infinity": {
                    String value = Functions.getFormattingCharacter(valueNode, "infinity", false);
                    symbols.setInfinity(value);
                    continue block24;
                }
                case "minus-sign": {
                    String value = Functions.getFormattingCharacter(valueNode, "minus-sign", true);
                    symbols.setMinusSign(value.charAt(0));
                    continue block24;
                }
                case "NaN": {
                    String value = Functions.getFormattingCharacter(valueNode, "NaN", false);
                    symbols.setNaN(value);
                    continue block24;
                }
                case "percent": {
                    String value = Functions.getFormattingCharacter(valueNode, "percent", true);
                    symbols.setPercent(value.charAt(0));
                    continue block24;
                }
                case "per-mille": {
                    String value = Functions.getFormattingCharacter(valueNode, "per-mille", false);
                    symbols.setPerMill(value.charAt(0));
                    continue block24;
                }
                case "zero-digit": {
                    String value = Functions.getFormattingCharacter(valueNode, "zero-digit", true);
                    symbols.setZeroDigit(value.charAt(0));
                    continue block24;
                }
                case "digit": {
                    String value = Functions.getFormattingCharacter(valueNode, "digit", true);
                    symbols.setDigit(value.charAt(0));
                    continue block24;
                }
                case "pattern-separator": {
                    String value = Functions.getFormattingCharacter(valueNode, "pattern-separator", true);
                    symbols.setPatternSeparator(value.charAt(0));
                    continue block24;
                }
            }
            throw new RuntimeException("Error parsing formatNumber format string");
        }
        return symbols;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFormattingCharacter(String value, String propertyName, boolean isChar) {
        String formattingChar = null;
        if (value != null && !value.isEmpty()) {
            if (!isChar) return value;
            if (value.length() != 1) throw new RuntimeException();
            return value;
        }
        String msgTemplate = isChar ? "Argument 3 of function %s is invalid. The value of the %s property must be a single character" : "Argument 3 of function %s is invalid. The value of the %s property must be a string";
        throw new RuntimeException(msgTemplate);
    }

    public static String formatBase(Number value, Number _radix) {
        if (value == null) {
            return null;
        }
        value = Functions.round(value, 0);
        int radix = _radix == null ? 10 : _radix.intValue();
        if (radix < 2 || radix > 36) {
            throw new JException("D3100", radix);
        }
        String result = Long.toString(value.longValue(), radix);
        return result;
    }

    public static Number number(Object arg) throws NumberFormatException, JException {
        Number result = null;
        if (arg == null) {
            return null;
        }
        if (arg == Jsonata.NULL_VALUE) {
            throw new JException("T0410", -1);
        }
        if (arg instanceof Number) {
            result = (Number)arg;
        } else if (arg instanceof String) {
            String s = (String)arg;
            result = s.startsWith("0x") ? (Number)Long.parseLong(s.substring(2), 16) : (Number)(s.startsWith("0B") ? (Number)Long.parseLong(s.substring(2), 2) : (Number)(s.startsWith("0O") ? (Number)Long.parseLong(s.substring(2), 8) : (Number)Double.valueOf((String)arg)));
        } else if (arg instanceof Boolean) {
            result = (Boolean)arg != false ? 1 : 0;
        }
        return result;
    }

    public static Number abs(Number arg) {
        if (arg == null) {
            return null;
        }
        return arg instanceof Double ? Math.abs(arg.doubleValue()) : (double)Math.abs(arg.longValue());
    }

    public static Number floor(Number arg) {
        if (arg == null) {
            return null;
        }
        return Math.floor(arg.doubleValue());
    }

    public static Number ceil(Number arg) {
        if (arg == null) {
            return null;
        }
        return Math.ceil(arg.doubleValue());
    }

    public static Number round(Number arg, Number precision) {
        if (arg == null) {
            return null;
        }
        BigDecimal b = new BigDecimal(String.valueOf(arg));
        if (precision == null) {
            precision = 0;
        }
        b = b.setScale(precision.intValue(), RoundingMode.HALF_EVEN);
        return b.doubleValue();
    }

    public static Number sqrt(Number arg) {
        if (arg == null) {
            return null;
        }
        if (arg.doubleValue() < 0.0) {
            throw new JException("D3060", 1, arg);
        }
        return Math.sqrt(arg.doubleValue());
    }

    public static Number power(Number arg, Number exp) {
        if (arg == null) {
            return null;
        }
        double result = Math.pow(arg.doubleValue(), exp.doubleValue());
        if (!Double.isFinite(result)) {
            throw new JException("D3061", 1, arg, exp);
        }
        return result;
    }

    public static Number random() {
        return Math.random();
    }

    public static Boolean toBoolean(Object arg) {
        if (arg == null) {
            return null;
        }
        boolean result = false;
        if (arg instanceof List) {
            List l = (List)arg;
            if (l.size() == 1) {
                result = Functions.toBoolean(l.get(0));
            } else if (l.size() > 1) {
                long truesLength = l.stream().filter(e -> Jsonata.boolize(e)).count();
                result = truesLength > 0L;
            }
        } else if (arg instanceof String) {
            String s = (String)arg;
            if (s.length() > 0) {
                result = true;
            }
        } else if (arg instanceof Number) {
            if (((Number)arg).doubleValue() != 0.0) {
                result = true;
            }
        } else if (arg instanceof Map) {
            if (!((Map)arg).isEmpty()) {
                result = true;
            }
        } else if (arg instanceof Boolean) {
            result = (Boolean)arg;
        }
        return result;
    }

    public static Boolean not(Object arg) {
        if (arg == null) {
            return null;
        }
        return Functions.toBoolean(arg) == false;
    }

    public static int getFunctionArity(Object func) {
        if (func instanceof Jsonata.JFunction) {
            return ((Jsonata.JFunction)func).signature.getMinNumberOfArgs();
        }
        return ((Parser.Symbol)func).arguments.size();
    }

    public static List hofFuncArgs(Object func, Object arg1, Object arg2, Object arg3) {
        ArrayList<Object> func_args = new ArrayList<Object>();
        func_args.add(arg1);
        int length = Functions.getFunctionArity(func);
        if (length >= 2) {
            func_args.add(arg2);
        }
        if (length >= 3) {
            func_args.add(arg3);
        }
        return func_args;
    }

    public static Object funcApply(Object func, List funcArgs) throws Throwable {
        Object res = Functions.isLambda(func) ? Jsonata.current.get().apply(func, funcArgs, null, Jsonata.current.get().environment) : ((Jsonata.JFunction)func).call(null, funcArgs);
        return res;
    }

    public static List map(List arr, Object func) throws Throwable {
        if (arr == null) {
            return null;
        }
        List<Object> result = Utils.createSequence();
        for (int i = 0; i < arr.size(); ++i) {
            Object arg = arr.get(i);
            List funcArgs = Functions.hofFuncArgs(func, arg, i, arr);
            Object res = Functions.funcApply(func, funcArgs);
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    public static List filter(List arr, Object func) throws Throwable {
        if (arr == null) {
            return null;
        }
        List<Object> result = Utils.createSequence();
        for (int i = 0; i < arr.size(); ++i) {
            Object entry = arr.get(i);
            List func_args = Functions.hofFuncArgs(func, entry, i, arr);
            Object res = Functions.funcApply(func, func_args);
            if (!Functions.toBoolean(res).booleanValue()) continue;
            result.add(entry);
        }
        return result;
    }

    public static Object single(List arr, Object func) throws Throwable {
        if (arr == null) {
            return null;
        }
        boolean hasFoundMatch = false;
        Object result = null;
        for (int i = 0; i < arr.size(); ++i) {
            Object entry = arr.get(i);
            boolean positiveResult = true;
            if (func != null) {
                List func_args = Functions.hofFuncArgs(func, entry, i, arr);
                Object res = Functions.funcApply(func, func_args);
                positiveResult = Functions.toBoolean(res);
            }
            if (!positiveResult) continue;
            if (!hasFoundMatch) {
                result = entry;
                hasFoundMatch = true;
                continue;
            }
            throw new JException("D3138", i);
        }
        if (!hasFoundMatch) {
            throw new JException("D3139", -1);
        }
        return result;
    }

    public static List zip(Utils.JList<List> args) {
        int nargs;
        ArrayList result = new ArrayList();
        int length = Integer.MAX_VALUE;
        for (nargs = 0; nargs < args.size(); ++nargs) {
            if (args.get(nargs) == null) {
                length = 0;
                break;
            }
            length = Math.min(length, ((List)args.get(nargs)).size());
        }
        for (int i = 0; i < length; ++i) {
            ArrayList tuple = new ArrayList();
            for (int k = 0; k < nargs; ++k) {
                tuple.add(((List)args.get(k)).get(i));
            }
            result.add(tuple);
        }
        return result;
    }

    public static Object foldLeft(List sequence, Object func, Object init) throws Throwable {
        int index;
        if (sequence == null) {
            return null;
        }
        Object result = null;
        int arity = Functions.getFunctionArity(func);
        if (arity < 2) {
            throw new JException("D3050", 1);
        }
        if (init == null && sequence.size() > 0) {
            result = sequence.get(0);
            index = 1;
        } else {
            result = init;
            index = 0;
        }
        while (index < sequence.size()) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(result);
            args.add(sequence.get(index));
            if (arity >= 3) {
                args.add(index);
            }
            if (arity >= 4) {
                args.add(sequence);
            }
            result = Functions.funcApply(func, args);
            ++index;
        }
        return result;
    }

    public static List keys(Object arg) {
        List<Object> result = Utils.createSequence();
        if (arg instanceof List) {
            LinkedHashSet keys = new LinkedHashSet();
            for (Object el : (List)arg) {
                keys.addAll(Functions.keys(el));
            }
            result.addAll(keys);
        } else if (arg instanceof Map) {
            result.addAll(((Map)arg).keySet());
        }
        return result;
    }

    public static boolean exists(Object arg) {
        return arg != null;
    }

    public static Object spread(Object arg) {
        Object result = Utils.createSequence();
        if (arg instanceof List) {
            for (Object item : (List)arg) {
                result = Functions.append(result, Functions.spread(item));
            }
        } else if (arg instanceof Map) {
            for (Map.Entry entry : ((Map)arg).entrySet()) {
                LinkedHashMap obj = new LinkedHashMap();
                obj.put(entry.getKey(), entry.getValue());
                ((List)result).add(obj);
            }
        } else {
            return arg;
        }
        return result;
    }

    public static Object merge(List arg) {
        if (arg == null) {
            return null;
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Object obj : arg) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static List reverse(List arr) {
        if (arr == null) {
            return null;
        }
        if (arr.size() <= 1) {
            return arr;
        }
        ArrayList result = new ArrayList(arr);
        Collections.reverse(result);
        return result;
    }

    public static List each(Map obj, Object func) throws Throwable {
        if (obj == null) {
            return null;
        }
        List<Object> result = Utils.createSequence();
        for (Object key : obj.keySet()) {
            List func_args = Functions.hofFuncArgs(func, obj.get(key), key, obj);
            Object val = Functions.funcApply(func, func_args);
            if (val == null) continue;
            result.add(val);
        }
        return result;
    }

    public static void error(String message) throws Throwable {
        throw new JException("D3137", -1, message != null ? message : "$error() function evaluated");
    }

    public static void assertFn(boolean condition, String message) throws Throwable {
        if (!condition) {
            throw new JException("D3141", -1, "$assert() statement failed");
        }
    }

    public static String type(Object value) {
        if (value == null) {
            return null;
        }
        if (value == Jsonata.NULL_VALUE) {
            return "null";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof List) {
            return "array";
        }
        if (Utils.isFunction(value) || Functions.isLambda(value)) {
            return "function";
        }
        return "object";
    }

    public static List sort(List arr, final Object comparator) {
        if (arr == null) {
            return null;
        }
        if (arr.size() <= 1) {
            return arr;
        }
        ArrayList result = new ArrayList(arr);
        if (comparator != null) {
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        boolean swap = (Boolean)Functions.funcApply(comparator, Arrays.asList(o1, o2));
                        if (swap) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            if (comparator instanceof Comparator) {
                result.sort((Comparator)comparator);
            } else {
                result.sort(comp);
            }
        } else {
            result.sort(null);
        }
        return result;
    }

    public static List shuffle(List arr) {
        if (arr == null) {
            return null;
        }
        if (arr.size() <= 1) {
            return arr;
        }
        ArrayList result = new ArrayList(arr);
        Collections.shuffle(result);
        return result;
    }

    public static Object distinct(Object _arr) {
        if (_arr == null) {
            return null;
        }
        if (!(_arr instanceof List) || ((List)_arr).size() <= 1) {
            return _arr;
        }
        List arr = (List)_arr;
        ArrayList results = arr instanceof Utils.JList ? Utils.createSequence() : new ArrayList();
        LinkedHashSet set = new LinkedHashSet(arr.size());
        set.addAll(arr);
        results.addAll(set);
        return results;
    }

    public static Object sift(Map<Object, Object> arg, Object func) throws Throwable {
        if (arg == null) {
            return null;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Object item : arg.keySet()) {
            Object entry = arg.get(item);
            List func_args = Functions.hofFuncArgs(func, entry, item, arg);
            Object res = Functions.funcApply(func, func_args);
            if (!Jsonata.boolize(res)) continue;
            result.put(item, entry);
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public static Object append(Object arg1, Object arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        if (!(arg1 instanceof List)) {
            arg1 = Utils.createSequence(arg1);
        }
        if (!(arg2 instanceof List)) {
            arg2 = new Utils.JList<Object>(Arrays.asList(arg2));
        }
        if (arg1.isEmpty() && arg2 instanceof Utils.RangeList) {
            return arg2;
        }
        arg1 = new Utils.JList<Object>(arg1);
        arg1.addAll((Collection<Object>)arg2);
        return arg1;
    }

    public static boolean isLambda(Object result) {
        return result instanceof Parser.Symbol && ((Parser.Symbol)result)._jsonata_lambda;
    }

    public static Object lookup(Object input, String key) {
        Object result = null;
        if (input instanceof List) {
            List _input = (List)input;
            result = Utils.createSequence();
            for (int ii = 0; ii < _input.size(); ++ii) {
                Object res = Functions.lookup(_input.get(ii), key);
                if (res == null) continue;
                if (res instanceof List) {
                    ((List)result).addAll((List)res);
                    continue;
                }
                ((List)result).add(res);
            }
        } else if (input instanceof Map && (result = ((Map)input).get(key)) == null && ((Map)input).containsKey(key)) {
            result = Jsonata.NULL_VALUE;
        }
        return result;
    }

    public static String test(String a, String b) {
        return a + b;
    }

    public static Method getFunction(Class clz, String name) {
        Method[] methods;
        for (Method m : methods = Functions.class.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Object call(Class clz, Object instance, String name, List<Object> args) throws Throwable {
        return Functions.call(instance, Functions.getFunction(clz, name), args);
    }

    public static Object call(Object instance, Method m, List<Object> args) throws Throwable {
        Object arg1;
        Class<?>[] types = m.getParameterTypes();
        int nargs = m.getParameterTypes().length;
        List<Object> callArgs = new ArrayList<Object>(args);
        while (callArgs.size() < nargs) {
            callArgs.add(null);
        }
        if (nargs > 0 && List.class.isAssignableFrom(types[0]) && !(callArgs.get(0) instanceof List) && (arg1 = callArgs.get(0)) != null) {
            ArrayList wrap = new ArrayList();
            wrap.add(arg1);
            callArgs.set(0, wrap);
        }
        if (nargs == 1 && types[0] == Utils.JList.class) {
            Utils.JList<Object> allArgs = new Utils.JList<Object>(args);
            callArgs = List.of(allArgs);
        }
        try {
            Object res = m.invoke(null, callArgs.toArray());
            if (res instanceof Number) {
                res = Utils.convertNumber((Number)res);
            }
            return res;
        }
        catch (IllegalAccessException e) {
            throw new Exception("Access error calling function " + m.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("Argument error calling function " + m.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Long dateTimeToMillis(String timestamp, String picture) throws ParseException {
        if (timestamp == null) {
            return null;
        }
        if (picture == null) {
            if (Functions.isNumeric((CharSequence)timestamp)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf.parse((String)timestamp).getTime();
            }
            try {
                int len = ((String)timestamp).length();
                if (len > 5 && (((String)timestamp).charAt(len - 5) == '+' || ((String)timestamp).charAt(len - 5) == '-') && Character.isDigit(((String)timestamp).charAt(len - 4)) && Character.isDigit(((String)timestamp).charAt(len - 3)) && Character.isDigit(((String)timestamp).charAt(len - 2)) && Character.isDigit(((String)timestamp).charAt(len - 1))) {
                    timestamp = ((String)timestamp).substring(0, len - 2) + ":" + ((String)timestamp).substring(len - 2, len);
                }
                return OffsetDateTime.parse((CharSequence)timestamp).toInstant().toEpochMilli();
            }
            catch (RuntimeException e) {
                LocalDate ldt = LocalDate.parse((CharSequence)timestamp, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                return ldt.atStartOfDay().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli();
            }
        }
        return DateTimeUtils.parseDateTime((String)timestamp, picture);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String dateTimeFromMillis(Number millis, String picture, String timezone) {
        if (millis == null) {
            return null;
        }
        return DateTimeUtils.formatDateTime(millis.longValue(), picture, timezone);
    }

    public static String formatInteger(Number value, String picture) {
        if (value == null) {
            return null;
        }
        return DateTimeUtils.formatInteger(value.longValue(), picture);
    }

    public static Number parseInteger(String value, String picture) throws ParseException, JException {
        if (value == null) {
            return null;
        }
        if (picture != null) {
            if (picture.equals("#")) {
                throw new ParseException("Formatting or parsing an integer as a sequence starting with \"#\" is not supported by this implementation", 0);
            }
            if (picture.endsWith(";o")) {
                picture = picture.substring(0, picture.length() - 2);
            }
            if (picture.equals("a")) {
                return DateTimeUtils.lettersToDecimal(value, 'a');
            }
            if (picture.equals("A")) {
                return DateTimeUtils.lettersToDecimal(value, 'A');
            }
            if (picture.equals("i")) {
                return DateTimeUtils.romanToDecimal(value.toUpperCase());
            }
            if (picture.equals("I")) {
                return DateTimeUtils.romanToDecimal(value);
            }
            if (picture.equals("w")) {
                return DateTimeUtils.wordsToLong(value);
            }
            if (picture.equals("W") || picture.equals("wW") || picture.equals("Ww")) {
                return DateTimeUtils.wordsToLong(value.toLowerCase());
            }
            if (picture.indexOf(58) >= 0) {
                value = value.replace(':', ',');
                picture = picture.replace(':', ',');
            }
        }
        try {
            DecimalFormat formatter = picture != null ? new DecimalFormat(picture, new DecimalFormatSymbols(Locale.US)) : new DecimalFormat();
            return formatter.parse(value);
        }
        catch (IllegalArgumentException ill) {
            throw new ParseException("Formatting or parsing an integer as a sequence starting with \"" + picture + "\" is not supported by this implementation", 0);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object functionClone(Object arg) {
        if (arg == null) {
            return null;
        }
        Object res = Json.parseJson(Functions.string(arg, false));
        return res;
    }

    public static Object functionEval(String expr, Object focus) {
        Jsonata ast;
        if (expr == null) {
            return null;
        }
        List<Object> input = Jsonata.current.get().input;
        if (focus != null && (input = focus) instanceof List && !Utils.isSequence(input)) {
            input = Utils.createSequence(input);
            ((Utils.JList)input).outerWrapper = true;
        }
        Jsonata.Frame env = Jsonata.current.get().environment;
        try {
            ast = Jsonata.jsonata(expr);
        }
        catch (Throwable err) {
            throw new JException("D3120", -1);
        }
        Object result = null;
        try {
            result = ast.evaluate(input, env);
        }
        catch (Throwable err) {
            throw new JException("D3121", -1);
        }
        return result;
    }

    public static String now(String picture, String timezone) {
        long t = Jsonata.current.get().timestamp;
        return Functions.dateTimeFromMillis(t, picture, timezone);
    }

    public static long millis() {
        long t = Jsonata.current.get().timestamp;
        return t;
    }

    static class RegexpMatch {
        String match;
        int index;
        List<String> groups;

        RegexpMatch() {
        }

        public String toString() {
            return "regexpMatch " + this.match + " idx=" + this.index + " groups=" + String.valueOf(this.groups);
        }
    }
}

