/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata.utils;

import com.dashjoin.jsonata.Functions;
import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.type.NullType;

public class Signature
implements Serializable {
    private static final long serialVersionUID = -450755246855587271L;
    Param _param = new Param();
    List<Param> _params = new ArrayList<Param>();
    Param _prevParam = this._param;
    Pattern _regex = null;
    String _signature = "";
    String functionName;

    public Signature(String signature, String function) {
        this.functionName = function;
        this.parseSignature(signature);
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public static void main(String[] args) {
        Signature s = new Signature("<s-:s>", "test");
        System.out.println(s._params);
    }

    int findClosingBracket(String str, int start, char openSymbol, char closeSymbol) {
        int depth = 1;
        int position = start;
        while (position < str.length()) {
            char symbol;
            if ((symbol = str.charAt(++position)) == closeSymbol) {
                if (--depth != 0) continue;
                break;
            }
            if (symbol != openSymbol) continue;
            ++depth;
        }
        return position;
    }

    String getSymbol(Object value) {
        String symbol = value == null ? "m" : (Utils.isFunction(value) || Functions.isLambda(value) || value instanceof Pattern ? "f" : (value instanceof String ? "s" : (value instanceof Number ? "n" : (value instanceof Boolean ? "b" : (value instanceof List ? "a" : (value instanceof Map ? "o" : (value instanceof NullType ? "l" : "m")))))));
        return symbol;
    }

    void next() {
        this._params.add(this._param);
        this._prevParam = this._param;
        this._param = new Param();
    }

    Pattern parseSignature(String signature) {
        char symbol;
        block13: for (int position = 1; position < signature.length() && (symbol = signature.charAt(position)) != ':'; ++position) {
            switch (symbol) {
                case 'b': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 's': {
                    this._param.regex = "[" + symbol + "m]";
                    this._param.type = "" + symbol;
                    this.next();
                    continue block13;
                }
                case 'a': {
                    this._param.regex = "[asnblfom]";
                    this._param.type = "" + symbol;
                    this._param.array = true;
                    this.next();
                    continue block13;
                }
                case 'f': {
                    this._param.regex = "f";
                    this._param.type = "" + symbol;
                    this.next();
                    continue block13;
                }
                case 'j': {
                    this._param.regex = "[asnblom]";
                    this._param.type = "" + symbol;
                    this.next();
                    continue block13;
                }
                case 'x': {
                    this._param.regex = "[asnblfom]";
                    this._param.type = "" + symbol;
                    this.next();
                    continue block13;
                }
                case '-': {
                    this._prevParam.context = true;
                    this._prevParam.regex = this._prevParam.regex + "?";
                    continue block13;
                }
                case '+': 
                case '?': {
                    this._prevParam.regex = this._prevParam.regex + symbol;
                    continue block13;
                }
                case '(': {
                    int endParen = this.findClosingBracket(signature, position, '(', ')');
                    String choice = signature.substring(position + 1, endParen);
                    if (choice.indexOf("<") != -1) {
                        throw new RuntimeException("Choice groups containing parameterized types are not supported");
                    }
                    this._param.regex = "[" + choice + "m]";
                    this._param.type = "(" + choice + ")";
                    position = endParen;
                    this.next();
                    continue block13;
                }
                case '<': {
                    String test = this._prevParam.type;
                    if (test != null) {
                        String type = test;
                        if (type.equals("a") || type.equals("f")) {
                            int endPos = this.findClosingBracket(signature, position, '<', '>');
                            this._prevParam.subtype = signature.substring(position + 1, endPos);
                            position = endPos;
                            continue block13;
                        }
                        throw new RuntimeException("Type parameters can only be applied to functions and arrays");
                    }
                    throw new RuntimeException("Type parameters can only be applied to functions and arrays");
                }
            }
        }
        Object regexStr = "^";
        for (Param param : this._params) {
            regexStr = (String)regexStr + "(" + param.regex + ")";
        }
        regexStr = (String)regexStr + "$";
        this._regex = null;
        try {
            this._regex = Pattern.compile((String)regexStr);
            this._signature = regexStr;
        }
        catch (PatternSyntaxException pse) {
            throw new RuntimeException(pse.getLocalizedMessage());
        }
        return this._regex;
    }

    void throwValidationError(List<?> badArgs, String badSig, String functionName) {
        Object partialPattern = "^";
        int goodTo = 0;
        for (int index = 0; index < this._params.size(); ++index) {
            Pattern tester = Pattern.compile((String)(partialPattern = (String)partialPattern + this._params.get((int)index).regex));
            Matcher match = tester.matcher(badSig);
            if (!match.matches()) {
                throw new JException("T0410", -1, goodTo + 1, functionName);
            }
            goodTo = match.end();
        }
        throw new JException("T0410", -1, goodTo + 1, functionName);
    }

    public Object validate(Object _args, Object context) {
        ArrayList result = new ArrayList();
        List args = (List)_args;
        Object suppliedSig = "";
        for (Object arg : args) {
            suppliedSig = (String)suppliedSig + this.getSymbol(arg);
        }
        Matcher isValid = this._regex.matcher((CharSequence)suppliedSig);
        if (isValid != null && isValid.matches()) {
            ArrayList<Object> validatedArgs = new ArrayList<Object>();
            int argIndex = 0;
            int index = 0;
            Iterator<Param> iterator = this._params.iterator();
            while (iterator.hasNext()) {
                String[] singles;
                Param _param;
                Param param = _param = iterator.next();
                ArrayList arg = argIndex < args.size() ? (ArrayList)args.get(argIndex) : null;
                String match = isValid.group(index + 1);
                if ("".equals(match)) {
                    if (param.context && param.regex != null) {
                        String contextType = this.getSymbol(context);
                        if (Pattern.matches(param.regex, contextType)) {
                            validatedArgs.add(context);
                            continue;
                        }
                        throw new JException("T0411", -1, context, argIndex + 1);
                    }
                    validatedArgs.add(arg);
                    ++argIndex;
                    continue;
                }
                for (String single : singles = match.split("")) {
                    if (param.type.equals("a")) {
                        if (single.equals("m")) {
                            arg = null;
                        } else {
                            arg = argIndex < args.size() ? (ArrayList)args.get(argIndex) : null;
                            boolean arrayOK = true;
                            if (param.subtype != null) {
                                List argArr;
                                if (!single.equals("a") && !match.equals(param.subtype)) {
                                    arrayOK = false;
                                } else if (single.equals("a") && (argArr = (List)arg).size() > 0) {
                                    String itemType = this.getSymbol(argArr.get(0));
                                    if (!itemType.equals("" + param.subtype.charAt(0))) {
                                        arrayOK = false;
                                    } else {
                                        for (Object o : argArr) {
                                            if (this.getSymbol(o).equals(itemType)) continue;
                                            arrayOK = false;
                                            break;
                                        }
                                    }
                                }
                            }
                            if (!arrayOK) {
                                throw new JException("T0412", -1, arg, param.subtype);
                            }
                            if (!single.equals("a")) {
                                ArrayList _arg = new ArrayList();
                                _arg.add(arg);
                                arg = _arg;
                            }
                        }
                        validatedArgs.add(arg);
                        ++argIndex;
                        continue;
                    }
                    validatedArgs.add(arg);
                    ++argIndex;
                }
            }
            return validatedArgs;
        }
        this.throwValidationError(args, (String)suppliedSig, this.functionName);
        return null;
    }

    public int getNumberOfArgs() {
        return this._params.size();
    }

    public int getMinNumberOfArgs() {
        int res = 0;
        for (Param p : this._params) {
            if (p.regex.contains("?")) continue;
            ++res;
        }
        return res;
    }

    static class Param {
        String type;
        String regex;
        boolean context;
        boolean array;
        String subtype;
        String contextRegex;

        Param() {
        }

        public String toString() {
            return "Param " + this.type + " regex=" + this.regex + " ctx=" + this.context + " array=" + this.array;
        }
    }
}

