/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonata;

import com.dashjoin.jsonata.Jsonata;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jsonata.JsonataComponent;
import org.apache.camel.component.jsonata.JsonataFrameBinding;
import org.apache.camel.component.jsonata.JsonataInputOutputType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="jsonata", title="JSONata", syntax="jsonata:resourceUri", producerOnly=true, remote=false, category={Category.TRANSFORMATION})
public class JsonataEndpoint
extends ResourceEndpoint {
    private final ObjectMapper mapper = new ObjectMapper();
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType outputType;
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType inputType;
    @UriParam(label="advanced", description="To configure the Jsonata frame binding. Allows custom functions to be added.")
    private JsonataFrameBinding frameBinding;

    public JsonataEndpoint() {
    }

    public JsonataEndpoint(String uri, JsonataComponent component, String resourceUri, JsonataFrameBinding frameBinding) {
        super(uri, (Component)component, resourceUri);
        this.frameBinding = frameBinding;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    @Override
    protected String createEndpointUri() {
        return "Jsonata:" + this.getResourceUri();
    }

    public JsonataInputOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JsonataInputOutputType outputType) {
        this.outputType = outputType;
    }

    public JsonataInputOutputType getInputType() {
        return this.inputType;
    }

    public void setInputType(JsonataInputOutputType inputType) {
        this.inputType = inputType;
    }

    public void setFrameBinding(JsonataFrameBinding frameBinding) {
        this.frameBinding = frameBinding;
    }

    public JsonataFrameBinding getFrameBinding() {
        return this.frameBinding;
    }

    @Override
    protected void onExchange(Exchange exchange) throws Exception {
        Map<String, Object> input;
        String path = this.getResourceUri();
        ObjectHelper.notNull(path, "resourceUri");
        if (this.getInputType() == JsonataInputOutputType.JsonString) {
            InputStream inputStream = exchange.getIn().getBody(InputStream.class);
            input = this.mapper.readValue(inputStream, new TypeReference<Map<String, Object>>(){});
        } else {
            input = this.mapper.convertValue(exchange.getIn().getBody(), new TypeReference<Map<String, Object>>(){});
        }
        Object output = null;
        Jsonata expression = null;
        try (InputStreamReader inputStreamReader = new InputStreamReader(this.getResourceAsInputStream(), StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String spec = bufferedReader.lines().collect(Collectors.joining("\n"));
            expression = Jsonata.jsonata(spec);
        }
        Jsonata.Frame frame = expression.createFrame();
        if (this.frameBinding != null) {
            this.frameBinding.bindToFrame(frame);
        }
        Object body = output = expression.evaluate(input, frame);
        if (this.getOutputType() == JsonataInputOutputType.JsonString) {
            body = this.mapper.writeValueAsString(output);
        }
        ExchangeHelper.setInOutBodyPatternAware(exchange, body);
    }
}

