/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonb;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="jsonb")
@Metadata(includeProperties="unmarshalTypeName,unmarshalType,objectMapper,prettyPrint,binaryStrategy,encoding,propertyOrder,propertyNamingStrategy,skipNull")
public class JsonbDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private Jsonb objectMapper;
    private String unmarshalTypeName;
    private Class<?> unmarshalType;
    private Type customType;
    private boolean prettyPrint;
    private String encoding = "UTF-8";
    private String binaryStrategy = "BASE_64";
    private String propertyOrder = "ANY";
    private String propertyNamingStrategy = "IDENTITY";
    private boolean skipNull = true;

    public JsonbDataFormat() {
        this(Object.class);
    }

    public JsonbDataFormat(Type customType) {
        this.customType = customType;
    }

    public JsonbDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    public JsonbDataFormat(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public JsonbDataFormat(Jsonb mapper, Class<?> unmarshalType) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public String getDataFormatName() {
        return "jsonb";
    }

    public Jsonb getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(Jsonb objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public void setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
    }

    public String getBinaryStrategy() {
        return this.binaryStrategy;
    }

    public void setBinaryStrategy(String binaryStrategy) {
        this.binaryStrategy = binaryStrategy;
    }

    public String getPropertyOrder() {
        return this.propertyOrder;
    }

    public void setPropertyOrder(String propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public String getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public void setPropertyNamingStrategy(String propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        this.objectMapper.toJson(graph, stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        Class<?> expectedType = this.unmarshalType;
        String type = exchange.getIn().getHeader("CamelJsonbUnmarshallType", String.class);
        if (type != null) {
            expectedType = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (expectedType == null && this.customType != null) {
            if (body instanceof String) {
                String str = (String)body;
                return this.objectMapper.fromJson(str, this.customType);
            }
            if (body instanceof Reader) {
                Reader r = (Reader)body;
                return this.objectMapper.fromJson(r, this.customType);
            }
            InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            return this.objectMapper.fromJson(is, this.customType);
        }
        if (body instanceof String) {
            String str = (String)body;
            return this.objectMapper.fromJson(str, expectedType);
        }
        if (body instanceof Reader) {
            Reader r = (Reader)body;
            return this.objectMapper.fromJson(r, expectedType);
        }
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
        return this.objectMapper.fromJson(is, expectedType);
    }

    @Override
    protected void doInit() {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
    }

    @Override
    protected void doStart() {
        if (this.objectMapper == null) {
            this.objectMapper = JsonbBuilder.create(new JsonbConfig().withFormatting(this.prettyPrint).withNullValues(!this.skipNull).withBinaryDataStrategy(this.binaryStrategy).withPropertyOrderStrategy(this.propertyOrder).withPropertyNamingStrategy(this.propertyNamingStrategy).withEncoding(this.encoding));
        }
    }

    @Override
    protected void doStop() {
    }
}

