/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.AbstractFileResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.FileSet;
import org.apache.camel.resume.cache.ResumeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDirectoryEntriesResumeAdapter
extends AbstractFileResumeAdapter
implements DirectoryEntriesResumeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryEntriesResumeAdapter.class);

    DefaultDirectoryEntriesResumeAdapter() {
    }

    @Override
    protected boolean add(Object key, Object offset) {
        if (!(offset instanceof File)) {
            throw new UnsupportedOperationException("This adapter cannot be used for file offsets");
        }
        FileSet fileSet = (FileSet)this.cache.computeIfAbsent((File)key, k -> new FileSet());
        fileSet.update((File)offset);
        return true;
    }

    @Override
    public void resume() {
    }

    private boolean processed(ResumeCache<File> cache, File directory, File file) {
        LOG.trace("Checking if file {} with key {} is cached: {}, {}", (Object)file, (Object)directory);
        FileSet cached = cache.get(directory, FileSet.class);
        if (cached == null) {
            LOG.trace("FileSet is not cached, therefore has not been processed yet");
            return false;
        }
        boolean isCached = cached.contains(file);
        LOG.trace("FileSet is cached. Checking if it contains {}: {}", (Object)file, (Object)isCached);
        return isCached;
    }

    @Override
    public boolean resume(File file) {
        return this.processed(this.cache, file.getParentFile(), file);
    }

    public void deserializeFileEntry(File keyObj, File valueObj) {
        LOG.trace("Deserializing file key {} with value {}", (Object)keyObj, (Object)valueObj);
        FileSet fileSet = (FileSet)this.cache.computeIfAbsent(keyObj, obj -> new FileSet());
        fileSet.update(valueObj);
    }
}

