/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.LifecycleStrategySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAutowiredLifecycleStrategy
extends LifecycleStrategySupport
implements AutowiredLifecycleStrategy,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAutowiredLifecycleStrategy.class);
    private final ExtendedCamelContext camelContext;

    public DefaultAutowiredLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = (ExtendedCamelContext)camelContext;
    }

    @Override
    public int getOrder() {
        return 2147482647;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        this.autowireComponent(name, component);
    }

    @Override
    public void onDataFormatCreated(String name, DataFormat dataFormat) {
        this.autowireDataFormat(name, dataFormat);
    }

    @Override
    public void onLanguageCreated(String name, Language language) {
        this.autowireLanguage(name, language);
    }

    private void autowireComponent(String name, Component component) {
        boolean enabled;
        boolean bl = enabled = this.camelContext.isAutowiredEnabled() != false && component.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "component", component);
        }
    }

    private void autowireDataFormat(String name, DataFormat dataFormat) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "dataformat", dataFormat);
        }
    }

    private void autowireLanguage(String name, Language language) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "language", language);
        }
    }

    private void autwire(String name, String kind, Object target) {
        PropertyConfigurerGetter getter;
        String[] names;
        PropertyConfigurer pc = this.camelContext.getConfigurerResolver().resolvePropertyConfigurer(name + "-" + kind, this.camelContext);
        if (pc instanceof PropertyConfigurerGetter && (names = (getter = (PropertyConfigurerGetter)((Object)pc)).getAutowiredNames()) != null) {
            for (String option : names) {
                boolean hit;
                Set<?> set;
                Object value = getter.getOptionValue(target, option, true);
                if (value != null) continue;
                Class<?> type = getter.getOptionType(option, true);
                if (type != null && (set = this.camelContext.getRegistry().findByType(type)).size() == 1) {
                    value = set.iterator().next();
                }
                if (value == null || !(hit = pc.configure(this.camelContext, target, option, value, true))) continue;
                LOG.info("Autowired property: {} on {}: {} as exactly one instance of type: {} ({}) found in the registry", new Object[]{option, kind, name, type.getName(), value.getClass().getName()});
            }
        }
    }
}

