/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Option;
import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.jsonpath.JsonPath;
import org.apache.camel.jsonpath.JsonPathExpression;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.util.ObjectHelper;

public class JsonPathAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String expression = this.getExpressionFromAnnotation(annotation);
        JsonPathExpression answer = new JsonPathExpression(expression);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        if (resultType != null) {
            answer.setResultType(resultType);
        }
        if (annotation instanceof JsonPath) {
            JsonPath jsonPathAnnotation = (JsonPath)annotation;
            answer.setSuppressExceptions(jsonPathAnnotation.suppressExceptions());
            answer.setAllowSimple(jsonPathAnnotation.allowSimple());
            if (ObjectHelper.isNotEmpty(jsonPathAnnotation.headerName())) {
                answer.setHeaderName(jsonPathAnnotation.headerName());
            }
            if (ObjectHelper.isNotEmpty(jsonPathAnnotation.propertyName())) {
                answer.setPropertyName(jsonPathAnnotation.propertyName());
            }
            Option[] options = jsonPathAnnotation.options();
            answer.setOptions(options);
        }
        answer.init(camelContext);
        return answer;
    }

    private Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }
}

