/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Option;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.jsonpath.JsonPathEngine;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateParser;
import org.apache.camel.support.ExpressionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathExpression
extends ExpressionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathExpression.class);
    private final String expression;
    private JsonPathEngine engine;
    private boolean predicate;
    private Class<?> resultType;
    private boolean suppressExceptions;
    private boolean allowSimple = true;
    private boolean allowEasyPredicate = true;
    private boolean writeAsString;
    private boolean unpackArray;
    private String headerName;
    private String propertyName;
    private Option[] options;

    public JsonPathExpression(String expression) {
        this.expression = expression;
    }

    public boolean isPredicate() {
        return this.predicate;
    }

    public void setPredicate(boolean predicate) {
        this.predicate = predicate;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public boolean isAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public boolean isAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public boolean isWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(boolean writeAsString) {
        this.writeAsString = writeAsString;
    }

    public boolean isUnpackArray() {
        return this.unpackArray;
    }

    public void setUnpackArray(boolean unpackArray) {
        this.unpackArray = unpackArray;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option[] options) {
        this.options = options;
    }

    @Override
    public Object evaluate(Exchange exchange) {
        try {
            Object result = this.evaluateJsonPath(exchange, this.engine);
            if (this.resultType != null) {
                if (this.unpackArray) {
                    boolean singleElement;
                    boolean resultIsCollection = Collection.class.isAssignableFrom(this.resultType);
                    boolean bl = singleElement = result instanceof List && ((List)result).size() == 1;
                    if (singleElement && !resultIsCollection) {
                        result = ((List)result).get(0);
                        LOG.trace("Unwrapping result: {} from single element List before converting to: {}", result, this.resultType);
                    }
                }
                return exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this, exchange, e);
        }
    }

    @Override
    public void init(CamelContext context) {
        EasyPredicateParser parser;
        String exp = this.expression;
        if (this.predicate && this.isAllowEasyPredicate() && !(exp = (parser = new EasyPredicateParser()).parse(this.expression)).equals(this.expression)) {
            LOG.debug("EasyPredicateParser parsed {} -> {}", (Object)this.expression, (Object)exp);
        }
        LOG.debug("Initializing {} using: {}", (Object)(this.predicate ? "predicate" : "expression"), (Object)exp);
        try {
            this.engine = new JsonPathEngine(exp, this.writeAsString, this.suppressExceptions, this.allowSimple, this.headerName, this.propertyName, this.options, context);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(exp, e);
        }
    }

    public String toString() {
        return "jsonpath[" + this.expression + "]";
    }

    private Object evaluateJsonPath(Exchange exchange, JsonPathEngine engine) throws Exception {
        return engine.read(exchange);
    }
}

