/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.jsonpath.JsonPathExpression;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateParser;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="jsonpath")
public class JsonPathLanguage
extends SingleInputTypedLanguageSupport
implements PropertyConfigurer {
    private boolean suppressExceptions;
    private boolean allowSimple = true;
    private boolean allowEasyPredicate = true;
    private boolean writeAsString;
    private boolean unpackArray;
    private Option[] options;

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public boolean isAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public boolean isAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public boolean isWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(boolean writeAsString) {
        this.writeAsString = writeAsString;
    }

    public boolean isUnpackArray() {
        return this.unpackArray;
    }

    public void setUnpackArray(boolean unpackArray) {
        this.unpackArray = unpackArray;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option ... options) {
        this.options = options;
    }

    @Override
    public Predicate createPredicate(String expression) {
        JsonPathExpression answer = (JsonPathExpression)this.createExpression(expression);
        answer.setPredicate(true);
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        JsonPathExpression answer = new JsonPathExpression(expression);
        answer.setResultType(this.getResultType());
        answer.setSuppressExceptions(this.suppressExceptions);
        answer.setAllowSimple(this.allowSimple);
        answer.setAllowEasyPredicate(this.allowEasyPredicate);
        answer.setHeaderName(this.getHeaderName());
        answer.setWriteAsString(this.writeAsString);
        answer.setUnpackArray(this.unpackArray);
        answer.setPropertyName(this.getPropertyName());
        answer.setOptions(this.options);
        answer.init(this.getCamelContext());
        return answer;
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        JsonPathExpression json = (JsonPathExpression)this.createExpression(expression, properties);
        json.setPredicate(true);
        return json;
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        JsonPathExpression answer = new JsonPathExpression(expression);
        answer.setResultType(this.property(Class.class, properties, 0, this.getResultType()));
        answer.setSuppressExceptions(this.property(Boolean.TYPE, properties, 1, this.suppressExceptions));
        answer.setAllowSimple(this.property(Boolean.TYPE, properties, 2, this.allowSimple));
        answer.setAllowEasyPredicate(this.property(Boolean.TYPE, properties, 3, this.allowEasyPredicate));
        answer.setWriteAsString(this.property(Boolean.TYPE, properties, 4, this.writeAsString));
        answer.setUnpackArray(this.property(Boolean.TYPE, properties, 5, this.unpackArray));
        answer.setHeaderName(this.property(String.class, properties, 6, this.getHeaderName()));
        String option = (String)properties[7];
        if (option != null) {
            ArrayList<Option> list = new ArrayList<Option>();
            for (String s : option.split(",")) {
                list.add(this.getCamelContext().getTypeConverter().convertTo(Option.class, s));
            }
            answer.setOptions(list.toArray(new Option[0]));
        }
        answer.setPropertyName(this.property(String.class, properties, 8, this.getPropertyName()));
        answer.init(this.getCamelContext());
        return answer;
    }

    public boolean validateExpression(String expression) {
        JsonPath.compile(expression, new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    public boolean validatePredicate(String expression) {
        EasyPredicateParser parser = new EasyPredicateParser();
        String exp = parser.parse(expression);
        JsonPath.compile(exp, new com.jayway.jsonpath.Predicate[0]);
        return true;
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType(PropertyConfigurerSupport.property(camelContext, Class.class, value));
                return true;
            }
            case "suppressexceptions": 
            case "suppressExceptions": {
                this.setSuppressExceptions(PropertyConfigurerSupport.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowsimple": 
            case "allowSimple": {
                this.setAllowSimple(PropertyConfigurerSupport.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "alloweasypredicate": 
            case "allowEasyPredicate": {
                this.setAllowEasyPredicate(PropertyConfigurerSupport.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "propertyname": 
            case "propertyName": {
                this.setPropertyName(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "writeasstring": 
            case "writeAsString": {
                this.setWriteAsString(PropertyConfigurerSupport.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "unpackarray": 
            case "unpackArray": {
                this.setUnpackArray(PropertyConfigurerSupport.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "options": {
                this.setOptions(PropertyConfigurerSupport.property(camelContext, Option[].class, value));
                return true;
            }
        }
        return false;
    }
}

