/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategyFactory;
import org.apache.camel.component.file.strategy.FileChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentChangedRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentRenameRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileLockExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public final class FileProcessStrategyFactory
implements GenericFileProcessStrategyFactory<File> {
    @Override
    public GenericFileProcessStrategy<File> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            return FileProcessStrategyFactory.newGenericFileDeleteProcessStrategy(params, preMoveExpression, moveFailedExpression);
        }
        if (isMove || isNoop) {
            return FileProcessStrategyFactory.newGenericFileRenameProcessStrategy(context, params, isNoop, moveExpression, preMoveExpression, moveFailedExpression);
        }
        return FileProcessStrategyFactory.newGenericFileRenameProcessStrategy(context, params);
    }

    private static GenericFileRenameProcessStrategy<File> newGenericFileRenameProcessStrategy(CamelContext context, Map<String, Object> params) {
        GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
        strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
        return strategy;
    }

    private static GenericFileRenameProcessStrategy<File> newGenericFileRenameProcessStrategy(CamelContext context, Map<String, Object> params, boolean isNoop, Expression moveExpression, Expression preMoveExpression, Expression moveFailedExpression) {
        GenericFileExpressionRenamer renamer;
        GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
        strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        if (!isNoop) {
            if (moveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveExpression);
                strategy.setCommitRenamer(renamer);
            } else {
                strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
            }
        }
        if (preMoveExpression != null) {
            renamer = new GenericFileExpressionRenamer();
            renamer.setExpression(preMoveExpression);
            strategy.setBeginRenamer(renamer);
        }
        if (moveFailedExpression != null) {
            renamer = new GenericFileExpressionRenamer();
            renamer.setExpression(moveFailedExpression);
            strategy.setFailureRenamer(renamer);
        }
        return strategy;
    }

    private static GenericFileDeleteProcessStrategy<File> newGenericFileDeleteProcessStrategy(Map<String, Object> params, Expression preMoveExpression, Expression moveFailedExpression) {
        GenericFileExpressionRenamer renamer;
        GenericFileDeleteProcessStrategy<File> strategy = new GenericFileDeleteProcessStrategy<File>();
        strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        if (preMoveExpression != null) {
            renamer = new GenericFileExpressionRenamer();
            renamer.setExpression(preMoveExpression);
            strategy.setBeginRenamer(renamer);
        }
        if (moveFailedExpression != null) {
            renamer = new GenericFileExpressionRenamer();
            renamer.setExpression(moveFailedExpression);
            strategy.setFailureRenamer(renamer);
        }
        return strategy;
    }

    private static GenericFileExpressionRenamer<File> getDefaultCommitRenamer(CamelContext context) {
        Language language = context.resolveLanguage("file");
        Expression expression = language.createExpression("${file:parent}/.camel/${file:onlyname}");
        return new GenericFileExpressionRenamer<File>(expression);
    }

    private static GenericFileExclusiveReadLockStrategy<File> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy strategy = (GenericFileExclusiveReadLockStrategy)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        return FileProcessStrategyFactory.fallbackToReadLock(params);
    }

    private static GenericFileExclusiveReadLockStrategy<File> fallbackToReadLock(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy<File> strategy = null;
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("markerFile".equals(readLock)) {
                strategy = new MarkerFileExclusiveReadLockStrategy();
            } else if ("fileLock".equals(readLock)) {
                strategy = new FileLockExclusiveReadLockStrategy();
            } else if ("rename".equals(readLock)) {
                strategy = new FileRenameExclusiveReadLockStrategy();
            } else if ("changed".equals(readLock)) {
                strategy = FileProcessStrategyFactory.newStrategyForChanged(params);
            } else if ("idempotent".equals(readLock)) {
                strategy = FileProcessStrategyFactory.newStrategyForIdempotent(params);
            } else if ("idempotent-changed".equals(readLock)) {
                strategy = FileProcessStrategyFactory.newStrategyForIdempotentChanged(params);
            } else if ("idempotent-rename".equals(readLock)) {
                strategy = FileProcessStrategyFactory.newStrategyForIdempotentRename(params);
            }
            if (strategy != null) {
                FileProcessStrategyFactory.setupStrategy(params, strategy);
            }
        }
        return strategy;
    }

    private static void setupStrategy(Map<String, Object> params, GenericFileExclusiveReadLockStrategy<File> strategy) {
        Boolean readLockDeleteOrphanLockFiles;
        Boolean readLockMarkerFile;
        LoggingLevel readLockLoggingLevel;
        Long checkInterval;
        Long timeout = (Long)params.get("readLockTimeout");
        if (timeout != null) {
            strategy.setTimeout(timeout);
        }
        if ((checkInterval = (Long)params.get("readLockCheckInterval")) != null) {
            strategy.setCheckInterval(checkInterval);
        }
        if ((readLockLoggingLevel = (LoggingLevel)((Object)params.get("readLockLoggingLevel"))) != null) {
            strategy.setReadLockLoggingLevel(readLockLoggingLevel);
        }
        if ((readLockMarkerFile = (Boolean)params.get("readLockMarkerFile")) != null) {
            strategy.setMarkerFiler(readLockMarkerFile);
        }
        if ((readLockDeleteOrphanLockFiles = (Boolean)params.get("readLockDeleteOrphanLockFiles")) != null) {
            strategy.setDeleteOrphanLockFiles(readLockDeleteOrphanLockFiles);
        }
    }

    private static GenericFileExclusiveReadLockStrategy<File> newStrategyForChanged(Map<String, Object> params) {
        Long minAge;
        FileChangedExclusiveReadLockStrategy readLockStrategy = new FileChangedExclusiveReadLockStrategy();
        Long minLength = (Long)params.get("readLockMinLength");
        if (minLength != null) {
            readLockStrategy.setMinLength(minLength);
        }
        if (null != (minAge = (Long)params.get("readLockMinAge"))) {
            readLockStrategy.setMinAge(minAge);
        }
        FileChangedExclusiveReadLockStrategy strategy = readLockStrategy;
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<File> newStrategyForIdempotentRename(Map<String, Object> params) {
        IdempotentRepository repo;
        Boolean readLockRemoveOnCommit;
        FileIdempotentRenameRepositoryReadLockStrategy readLockStrategy = new FileIdempotentRenameRepositoryReadLockStrategy();
        Boolean readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
        if (readLockRemoveOnRollback != null) {
            readLockStrategy.setRemoveOnRollback(readLockRemoveOnRollback);
        }
        if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
            readLockStrategy.setRemoveOnCommit(readLockRemoveOnCommit);
        }
        if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
            readLockStrategy.setIdempotentRepository(repo);
        }
        FileIdempotentRenameRepositoryReadLockStrategy strategy = readLockStrategy;
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<File> newStrategyForIdempotentChanged(Map<String, Object> params) {
        ScheduledExecutorService readLockIdempotentReleaseExecutorService;
        Integer readLockIdempotentReleaseAsyncPoolSize;
        Boolean readLockIdempotentReleaseAsync;
        Integer readLockIdempotentReleaseDelay;
        Long minAge;
        Long minLength;
        IdempotentRepository repo;
        Boolean readLockRemoveOnCommit;
        FileIdempotentChangedRepositoryReadLockStrategy readLockStrategy = new FileIdempotentChangedRepositoryReadLockStrategy();
        Boolean readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
        if (readLockRemoveOnRollback != null) {
            readLockStrategy.setRemoveOnRollback(readLockRemoveOnRollback);
        }
        if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
            readLockStrategy.setRemoveOnCommit(readLockRemoveOnCommit);
        }
        if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
            readLockStrategy.setIdempotentRepository(repo);
        }
        if ((minLength = (Long)params.get("readLockMinLength")) != null) {
            readLockStrategy.setMinLength(minLength);
        }
        if (null != (minAge = (Long)params.get("readLockMinAge"))) {
            readLockStrategy.setMinAge(minAge);
        }
        if ((readLockIdempotentReleaseDelay = (Integer)params.get("readLockIdempotentReleaseDelay")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseDelay(readLockIdempotentReleaseDelay);
        }
        if ((readLockIdempotentReleaseAsync = (Boolean)params.get("readLockIdempotentReleaseAsync")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseAsync(readLockIdempotentReleaseAsync);
        }
        if ((readLockIdempotentReleaseAsyncPoolSize = (Integer)params.get("readLockIdempotentReleaseAsyncPoolSize")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseAsyncPoolSize(readLockIdempotentReleaseAsyncPoolSize);
        }
        if ((readLockIdempotentReleaseExecutorService = (ScheduledExecutorService)params.get("readLockIdempotentReleaseExecutorService")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseExecutorService(readLockIdempotentReleaseExecutorService);
        }
        FileIdempotentChangedRepositoryReadLockStrategy strategy = readLockStrategy;
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<File> newStrategyForIdempotent(Map<String, Object> params) {
        ScheduledExecutorService readLockIdempotentReleaseExecutorService;
        Integer readLockIdempotentReleaseAsyncPoolSize;
        Boolean readLockIdempotentReleaseAsync;
        Integer readLockIdempotentReleaseDelay;
        IdempotentRepository repo;
        Boolean readLockRemoveOnCommit;
        FileIdempotentRepositoryReadLockStrategy readLockStrategy = new FileIdempotentRepositoryReadLockStrategy();
        Boolean readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
        if (readLockRemoveOnRollback != null) {
            readLockStrategy.setRemoveOnRollback(readLockRemoveOnRollback);
        }
        if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
            readLockStrategy.setRemoveOnCommit(readLockRemoveOnCommit);
        }
        if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
            readLockStrategy.setIdempotentRepository(repo);
        }
        if ((readLockIdempotentReleaseDelay = (Integer)params.get("readLockIdempotentReleaseDelay")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseDelay(readLockIdempotentReleaseDelay);
        }
        if ((readLockIdempotentReleaseAsync = (Boolean)params.get("readLockIdempotentReleaseAsync")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseAsync(readLockIdempotentReleaseAsync);
        }
        if ((readLockIdempotentReleaseAsyncPoolSize = (Integer)params.get("readLockIdempotentReleaseAsyncPoolSize")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseAsyncPoolSize(readLockIdempotentReleaseAsyncPoolSize);
        }
        if ((readLockIdempotentReleaseExecutorService = (ScheduledExecutorService)params.get("readLockIdempotentReleaseExecutorService")) != null) {
            readLockStrategy.setReadLockIdempotentReleaseExecutorService(readLockIdempotentReleaseExecutorService);
        }
        FileIdempotentRepositoryReadLockStrategy strategy = readLockStrategy;
        return strategy;
    }
}

