/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.LoggingLevel;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultBacklogDebugger
extends ServiceSupport
implements BacklogDebugger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBacklogDebugger.class);
    private long fallbackTimeout = 300L;
    private final CamelContext camelContext;
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    private final CamelLogger logger = new CamelLogger(LOG, this.loggingLevel);
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final AtomicBoolean standby = new AtomicBoolean();
    private final AtomicLong debugCounter = new AtomicLong();
    private final Debugger debugger;
    private final ConcurrentMap<String, NodeBreakpoint> breakpoints = new ConcurrentHashMap<String, NodeBreakpoint>();
    private final ConcurrentMap<String, SuspendedExchange> suspendedBreakpoints = new ConcurrentHashMap<String, SuspendedExchange>();
    private final ConcurrentMap<String, BacklogTracerEventMessage> suspendedBreakpointMessages = new ConcurrentHashMap<String, BacklogTracerEventMessage>();
    private final AtomicReference<CountDownLatch> suspend = new AtomicReference();
    private volatile String singleStepExchangeId;
    private boolean suspendMode;
    private String initialBreakpoints;
    private boolean singleStepIncludeStartEnd;
    private int bodyMaxChars = 32768;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;
    private boolean includeExchangeProperties = true;
    private boolean includeExchangeVariables = true;
    private boolean includeException = true;

    private DefaultBacklogDebugger(CamelContext camelContext, boolean suspendMode) {
        this.camelContext = camelContext;
        this.debugger = new DefaultDebugger(camelContext);
        this.suspendMode = suspendMode;
        this.detach();
    }

    public static BacklogDebugger createDebugger(CamelContext context) {
        context.setSourceLocationEnabled(true);
        context.setMessageHistory(true);
        DefaultBacklogDebugger answer = new DefaultBacklogDebugger(context, DefaultBacklogDebugger.resolveSuspendMode());
        answer.setStandby(context.isDebugStandby());
        return answer;
    }

    public static BacklogDebugger getBacklogDebugger(CamelContext context) {
        return context.hasService(DefaultBacklogDebugger.class);
    }

    @Override
    public String getInitialBreakpoints() {
        return this.initialBreakpoints;
    }

    @Override
    public void setInitialBreakpoints(String initialBreakpoints) {
        this.initialBreakpoints = initialBreakpoints;
    }

    @Override
    public String getLoggingLevel() {
        return this.loggingLevel.name();
    }

    @Override
    public void setLoggingLevel(String level) {
        this.loggingLevel = LoggingLevel.valueOf(level);
        this.logger.setLevel(this.loggingLevel);
    }

    @Override
    public void enableDebugger() {
        this.logger.log("Enabling Camel debugger");
        try {
            ServiceHelper.startService(this.debugger);
            this.enabled.set(true);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void disableDebugger() {
        this.logger.log("Disabling Camel debugger");
        try {
            this.enabled.set(false);
            ServiceHelper.stopService(this.debugger);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearBreakpoints();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean isStandby() {
        return this.standby.get();
    }

    @Override
    public void setStandby(boolean standby) {
        this.standby.set(standby);
    }

    @Override
    public boolean hasBreakpoint(String nodeId) {
        return this.breakpoints.containsKey(nodeId);
    }

    @Override
    public void setSuspendMode(boolean suspendMode) {
        this.suspendMode = suspendMode;
    }

    @Override
    public boolean isSuspendMode() {
        return this.suspendMode;
    }

    @Override
    public boolean isSingleStepMode() {
        return this.singleStepExchangeId != null;
    }

    @Override
    public void attach() {
        if (this.suspendMode) {
            this.logger.log("A debugger has been attached");
            this.resumeMessageProcessing();
        }
    }

    @Override
    public void detach() {
        if (this.suspendMode) {
            this.logger.log("Waiting for a debugger to attach");
            this.suspendMessageProcessing();
        }
    }

    private static boolean resolveSuspendMode() {
        String value = IOHelper.lookupEnvironmentVariable("CAMEL_DEBUGGER_SUSPEND");
        return value == null ? Boolean.getBoolean("org.apache.camel.debugger.suspend") : Boolean.parseBoolean(value);
    }

    private void suspendIfNeeded() {
        CountDownLatch countDownLatch = this.suspend.get();
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void suspendMessageProcessing() {
        this.suspend.compareAndSet(null, new CountDownLatch(1));
    }

    private void resumeMessageProcessing() {
        CountDownLatch countDownLatch;
        while ((countDownLatch = this.suspend.get()) != null) {
            if (!this.suspend.compareAndSet(countDownLatch, null)) continue;
            countDownLatch.countDown();
        }
    }

    @Override
    public void addBreakpoint(String nodeId) {
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint == null) {
            this.logger.log("Adding breakpoint " + nodeId);
            breakpoint = new NodeBreakpoint(nodeId, null);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else {
            breakpoint.setCondition(null);
        }
    }

    @Override
    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        Predicate condition = this.camelContext.resolveLanguage(language).createPredicate(predicate);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint == null) {
            this.logger.log("Adding conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint = new NodeBreakpoint(nodeId, condition);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else if (breakpoint.getCondition() == null) {
            this.logger.log("Updating to conditional breakpoint " + nodeId + " [" + predicate + "]");
            this.debugger.removeBreakpoint(breakpoint);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else {
            this.logger.log("Updating conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint.setCondition(condition);
        }
    }

    @Override
    public void removeBreakpoint(String nodeId) {
        this.logger.log("Removing breakpoint " + nodeId);
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.remove(nodeId);
        if (breakpoint != null) {
            this.debugger.removeBreakpoint(breakpoint);
        }
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    @Override
    public void removeAllBreakpoints() {
        this.singleStepExchangeId = null;
        for (String nodeId : this.getSuspendedBreakpointNodeIds()) {
            this.removeBreakpoint(nodeId);
        }
    }

    @Override
    public Set<String> getBreakpoints() {
        return new LinkedHashSet<String>(this.breakpoints.keySet());
    }

    @Override
    public void resumeBreakpoint(String nodeId) {
        this.resumeBreakpoint(nodeId, false);
    }

    @Override
    public void resumeBreakpoint(String nodeId, boolean stepMode) {
        this.logger.log("Resume breakpoint " + nodeId);
        if (!stepMode && this.singleStepExchangeId != null) {
            this.debugger.stopSingleStepExchange(this.singleStepExchangeId);
            this.singleStepExchangeId = null;
        }
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                Class<?> oldType = se.getExchange().getMessage().getBody() == null ? null : se.getExchange().getMessage().getBody().getClass();
                this.setMessageBodyOnBreakpoint(nodeId, body, oldType);
            }
        }
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body, Class<?> type) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                this.logger.log(String.format("Breakpoint at node %s is updating message body on exchangeId: %s with new body: %s", nodeId, se.getExchange().getExchangeId(), body));
                if (type == null) {
                    se.getExchange().getMessage().setBody(body);
                } else {
                    se.getExchange().getMessage().setBody(body, type);
                }
                this.refreshBacklogTracerEventMessage(nodeId, se);
            }
        }
    }

    @Override
    public void removeMessageBodyOnBreakpoint(String nodeId) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log(String.format("Breakpoint at node %s is removing message body on exchangeId: %s", nodeId, se.getExchange().getExchangeId()));
            se.getExchange().getMessage().setBody(null);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(headerName) == null ? null : se.getExchange().getMessage().getHeader(headerName).getClass();
            this.setMessageHeaderOnBreakpoint(nodeId, headerName, value, oldType);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating message header on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + headerName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().getMessage().setHeader(headerName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().getMessage().setHeader(headerName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(exchangePropertyName) == null ? null : se.getExchange().getMessage().getHeader(exchangePropertyName).getClass();
            this.setExchangePropertyOnBreakpoint(nodeId, exchangePropertyName, value, oldType);
        }
    }

    @Override
    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating exchange property on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + exchangePropertyName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().setProperty(exchangePropertyName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().setProperty(exchangePropertyName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void removeExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing exchange property on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + exchangePropertyName);
            se.getExchange().removeProperty(exchangePropertyName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(variableName) == null ? null : se.getExchange().getMessage().getHeader(variableName).getClass();
            this.setExchangeVariableOnBreakpoint(nodeId, variableName, value, oldType);
        }
    }

    @Override
    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating exchange variable on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + variableName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().setVariable(variableName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().setVariable(variableName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void removeExchangeVariableOnBreakpoint(String nodeId, String variableName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing variable on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + variableName);
            se.getExchange().removeVariable(variableName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public long getFallbackTimeout() {
        return this.fallbackTimeout;
    }

    @Override
    public void setFallbackTimeout(long fallbackTimeout) {
        this.fallbackTimeout = fallbackTimeout;
    }

    @Override
    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing message header on exchangeId: " + se.getExchange().getExchangeId() + " with header: " + headerName);
            se.getExchange().getMessage().removeHeader(headerName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    @Override
    public void resumeAll() {
        this.logger.log("Resume all");
        this.singleStepExchangeId = null;
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    @Override
    public void stepBreakpoint() {
        String nodeId;
        NodeBreakpoint breakpoint;
        if (this.isSingleStepMode()) {
            this.logger.log("Step breakpoint is already in single step mode, so stepping instead.");
            this.step();
        }
        if (this.suspendedBreakpointMessages.size() != 1) {
            return;
        }
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.values().iterator().next();
        if (msg != null && (breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId = msg.getToNode())) != null) {
            this.singleStepExchangeId = msg.getExchangeId();
            if (this.debugger.startSingleStepExchange(this.singleStepExchangeId, new StepBreakpoint())) {
                this.resumeBreakpoint(nodeId, true);
            }
        }
    }

    @Override
    public void stepBreakpoint(String nodeId) {
        if (this.isSingleStepMode()) {
            this.logger.log("Step breakpoint " + nodeId + " is already in single step mode, so stepping instead.");
            this.step();
        }
        this.logger.log("Step breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (msg != null && breakpoint != null) {
            this.singleStepExchangeId = msg.getExchangeId();
            if (this.debugger.startSingleStepExchange(this.singleStepExchangeId, new StepBreakpoint())) {
                this.resumeBreakpoint(nodeId, true);
            }
        }
    }

    @Override
    public void step() {
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    @Override
    public Set<String> getSuspendedBreakpointNodeIds() {
        return new LinkedHashSet<String>(this.suspendedBreakpoints.keySet());
    }

    @Override
    public Exchange getSuspendedExchange(String id) {
        SuspendedExchange suspendedExchange = (SuspendedExchange)this.suspendedBreakpoints.get(id);
        return suspendedExchange == null ? null : suspendedExchange.getExchange();
    }

    @Override
    public BacklogTracerEventMessage getSuspendedBreakpointMessage(String id) {
        return (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(id);
    }

    @Override
    public void disableBreakpoint(String nodeId) {
        this.logger.log("Disable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint != null) {
            breakpoint.suspend();
        }
    }

    @Override
    public void enableBreakpoint(String nodeId) {
        this.logger.log("Enable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint != null) {
            breakpoint.activate();
        }
    }

    @Override
    public boolean isSingleStepIncludeStartEnd() {
        return this.singleStepIncludeStartEnd;
    }

    @Override
    public void setSingleStepIncludeStartEnd(boolean singleStepIncludeStartEnd) {
        this.singleStepIncludeStartEnd = singleStepIncludeStartEnd;
    }

    @Override
    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    @Override
    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    @Override
    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    @Override
    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    @Override
    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    @Override
    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    @Override
    public boolean isIncludeExchangeProperties() {
        return this.includeExchangeProperties;
    }

    @Override
    public void setIncludeExchangeProperties(boolean includeExchangeProperties) {
        this.includeExchangeProperties = includeExchangeProperties;
    }

    @Override
    public boolean isIncludeExchangeVariables() {
        return this.includeExchangeVariables;
    }

    @Override
    public void setIncludeExchangeVariables(boolean includeExchangeVariables) {
        this.includeExchangeVariables = includeExchangeVariables;
    }

    @Override
    public boolean isIncludeException() {
        return this.includeException;
    }

    @Override
    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    @Override
    public String dumpTracedMessagesAsXml(String nodeId) {
        this.logger.log("Dump trace message from breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        if (msg == null) {
            return null;
        }
        return msg.toXml(0);
    }

    @Override
    public String dumpTracedMessagesAsJSon(String nodeId) {
        this.logger.log("Dump trace message from breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        if (msg == null) {
            return null;
        }
        return msg.toJSon(0);
    }

    @Override
    public long getDebugCounter() {
        return this.debugCounter.get();
    }

    @Override
    public void resetDebugCounter() {
        this.logger.log("Reset debug counter");
        this.debugCounter.set(0L);
    }

    @Override
    public StopWatch beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
        this.suspendIfNeeded();
        if (this.isEnabled() && (this.hasBreakpoint(definition.getId()) || this.isSingleStepMode())) {
            StopWatch watch = new StopWatch();
            this.debugger.beforeProcess(exchange, processor, definition);
            return watch;
        }
        return null;
    }

    @Override
    public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
        this.debugger.afterProcess(exchange, processor, definition, timeTaken);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.initialBreakpoints != null) {
            for (String b : this.initialBreakpoints.split(",")) {
                if ("_all_routes_".equals(b = b.trim())) continue;
                this.addBreakpoint(b);
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.enabled.get()) {
            this.disableDebugger();
        }
        this.clearBreakpoints();
    }

    private void clearBreakpoints() {
        this.breakpoints.clear();
        for (SuspendedExchange se : this.suspendedBreakpoints.values()) {
            se.getLatch().countDown();
        }
        this.suspendedBreakpoints.clear();
        this.suspendedBreakpointMessages.clear();
    }

    private void refreshBacklogTracerEventMessage(String nodeId, SuspendedExchange suspendedExchange) {
        this.suspendedBreakpointMessages.computeIfPresent(nodeId, (nId, message) -> new DefaultBacklogTracerEventMessage(false, false, message.getUid(), message.getTimestamp(), message.getLocation(), message.getRouteId(), message.getToNode(), message.getExchangeId(), false, false, this.dumpAsJSonObject(suspendedExchange.getExchange())));
    }

    private JsonObject dumpAsJSonObject(Exchange exchange) {
        return MessageHelper.dumpAsJSonObject(exchange.getIn(), this.includeExchangeProperties, this.includeExchangeVariables, true, true, this.isBodyIncludeStreams(), this.isBodyIncludeFiles(), this.getBodyMaxChars());
    }

    private final class NodeBreakpoint
    extends BreakpointSupport
    implements Condition {
        private final String nodeId;
        private Predicate condition;

        private NodeBreakpoint(String nodeId, Predicate condition) {
            this.nodeId = nodeId;
            this.condition = condition;
        }

        public Predicate getCondition() {
            return this.condition;
        }

        public void setCondition(Predicate predicate) {
            this.condition = predicate;
        }

        @Override
        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId(definition);
            String exchangeId = exchange.getExchangeId();
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName(definition);
            boolean first = "from".equals(definition.getShortName());
            JsonObject data = DefaultBacklogDebugger.this.dumpAsJSonObject(exchange);
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(first, false, uid, timestamp, source, routeId, toNode, exchangeId, false, false, data);
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(this.nodeId, msg);
            SuspendedExchange se = (SuspendedExchange)DefaultBacklogDebugger.this.suspendedBreakpoints.get(this.nodeId);
            if (se != null) {
                DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchangeId));
                try {
                    boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                    if (!hit) {
                        DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchangeId), LoggingLevel.WARN);
                    } else {
                        DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s is continued exchangeId: %s", toNode, exchangeId));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
            if (!before) {
                return false;
            }
            if (!this.nodeId.equals(definition.getId())) {
                return false;
            }
            if (this.condition != null && !this.condition.matches(exchange)) {
                return false;
            }
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            boolean existing = DefaultBacklogDebugger.this.suspendedBreakpoints.putIfAbsent(this.nodeId, se) != null;
            return !existing;
        }

        @Override
        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return false;
        }
    }

    private static final class SuspendedExchange {
        private final Exchange exchange;
        private final CountDownLatch latch;

        private SuspendedExchange(Exchange exchange, CountDownLatch latch) {
            this.exchange = exchange;
            this.latch = latch;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }

    private final class StepBreakpoint
    extends BreakpointSupport
    implements Condition {
        private StepBreakpoint() {
        }

        @Override
        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId(definition);
            String exchangeId = exchange.getExchangeId();
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName(definition);
            JsonObject data = DefaultBacklogDebugger.this.dumpAsJSonObject(exchange);
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(false, false, uid, timestamp, source, routeId, toNode, exchangeId, false, false, data);
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(toNode, msg);
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            DefaultBacklogDebugger.this.suspendedBreakpoints.put(toNode, se);
            DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchange.getExchangeId()));
            try {
                boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                if (!hit) {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchange.getExchangeId()), LoggingLevel.WARN);
                } else {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is continued exchangeId: %s", toNode, exchange.getExchangeId()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
            return true;
        }

        @Override
        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
            if (event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent) {
                Throwable cause = null;
                if (event instanceof CamelEvent.ExchangeFailedEvent) {
                    CamelEvent.ExchangeFailedEvent fe = (CamelEvent.ExchangeFailedEvent)event;
                    cause = fe.getCause();
                }
                NamedRoute route = this.getOriginalRoute(exchange);
                String completedId = event.getExchange().getExchangeId();
                try {
                    if (DefaultBacklogDebugger.this.isSingleStepIncludeStartEnd() && DefaultBacklogDebugger.this.singleStepExchangeId != null && DefaultBacklogDebugger.this.singleStepExchangeId.equals(completedId)) {
                        this.doCompleted(exchange, definition, route, cause);
                    }
                }
                finally {
                    DefaultBacklogDebugger.this.logger.log("ExchangeId: " + completedId + " is completed, so exiting single step mode.");
                    DefaultBacklogDebugger.this.singleStepExchangeId = null;
                }
            }
        }

        private NamedRoute getOriginalRoute(Exchange exchange) {
            List list = exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
            if (list != null) {
                for (MessageHistory h : list) {
                    boolean skip;
                    NamedNode n = h.getNode();
                    NamedRoute nr = CamelContextHelper.getRoute(n);
                    if (nr == null || (skip = nr.isCreatedFromRest() || nr.isCreatedFromTemplate())) continue;
                    return nr;
                }
            }
            return null;
        }

        private void doCompleted(Exchange exchange, NamedNode definition, NamedRoute route, Throwable cause) {
            long timestamp = System.currentTimeMillis();
            String toNode = CamelContextHelper.getRouteId(definition);
            String routeId = route != null ? route.getRouteId() : toNode;
            String exchangeId = exchange.getExchangeId();
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName(route != null ? route : definition);
            JsonObject data = DefaultBacklogDebugger.this.dumpAsJSonObject(exchange);
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(false, true, uid, timestamp, source, routeId, toNode, exchangeId, false, false, data);
            if (cause != null) {
                msg.setException(cause);
            }
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(toNode, msg);
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            DefaultBacklogDebugger.this.suspendedBreakpoints.put(toNode, se);
            DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchange.getExchangeId()));
            try {
                boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                if (!hit) {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchange.getExchangeId()), LoggingLevel.WARN);
                } else {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is continued exchangeId: %s", toNode, exchange.getExchangeId()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

