/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;

public class SetBodyProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Expression expression;

    public SetBodyProcessor(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            boolean copyNeeded;
            Object newBody = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            Message old = exchange.getMessage();
            boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
            if (copyNeeded) {
                DefaultMessage msg = new DefaultMessage(exchange.getContext());
                msg.copyFromWithNewBody(old, newBody);
                ExchangeHelper.replaceMessage(exchange, msg, false);
            } else {
                old.setBody(newBody);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "setBody[" + String.valueOf(this.expression) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

