/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.StreamCache;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.jsonpath.JsonPathAdapter;
import org.apache.camel.jsonpath.JsonStream;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathEngine.class);
    private static final String JACKSON_JSON_ADAPTER = "org.apache.camel.jsonpath.jackson.JacksonJsonAdapter";
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("\\$\\{[^\\}]+\\}", 8);
    private final String expression;
    private final boolean writeAsString;
    private final Configuration configuration;
    private final boolean hasSimple;
    private final Expression source;
    private JsonPathAdapter adapter;
    private volatile boolean initJsonAdapter;

    @Deprecated
    public JsonPathEngine(String expression) {
        this(expression, null, false, false, true, null, null);
    }

    public JsonPathEngine(String expression, Expression source, boolean writeAsString, boolean suppressExceptions, boolean allowSimple, Option[] options, CamelContext context) {
        Matcher matcher;
        ObjectMapper objectMapper;
        this.expression = expression;
        this.source = source;
        this.writeAsString = writeAsString;
        Configuration.ConfigurationBuilder builder = Configuration.builder();
        if (options != null) {
            builder.options(options);
        }
        if ((objectMapper = this.findRegisteredMapper(context)) != null) {
            builder.jsonProvider(new JacksonJsonProvider(objectMapper));
            builder.mappingProvider(new JacksonMappingProvider(objectMapper));
        } else {
            builder.jsonProvider(new JacksonJsonProvider());
            builder.mappingProvider(new JacksonMappingProvider());
        }
        if (suppressExceptions) {
            builder.options(Option.SUPPRESS_EXCEPTIONS);
        }
        this.configuration = builder.build();
        boolean simpleInUse = false;
        if (allowSimple && (matcher = SIMPLE_PATTERN.matcher(expression)).find()) {
            simpleInUse = true;
        }
        this.hasSimple = simpleInUse;
    }

    private ObjectMapper findRegisteredMapper(CamelContext context) {
        if (context != null) {
            return context.getRegistry().findSingleByType(ObjectMapper.class);
        }
        return null;
    }

    public Object read(Exchange exchange) throws Exception {
        Object answer;
        if (this.hasSimple) {
            Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(this.expression);
            String text = exp.evaluate(exchange, String.class);
            LOG.debug("Compiled dynamic JsonPath: {}", (Object)text);
            answer = this.doRead(text, exchange);
        } else {
            answer = this.doRead(this.expression, exchange);
        }
        if (this.writeAsString) {
            if (!this.initJsonAdapter) {
                this.doInitAdapter(exchange);
            }
            if (this.adapter == null) {
                LOG.debug("Cannot writeAsString as adapter cannot be initialized");
                return answer;
            }
            if (answer instanceof Iterable) {
                ArrayList<String> list = new ArrayList<String>();
                Iterable it = (Iterable)answer;
                for (Object o : it) {
                    String json;
                    if (this.adapter == null || (json = this.adapter.writeAsString(o, exchange)) == null) continue;
                    list.add(json);
                }
                return list;
            }
            if (answer instanceof Map) {
                Map map = (Map)answer;
                for (Map.Entry entry : map.entrySet()) {
                    String json;
                    Object value = entry.getValue();
                    if (this.adapter == null || (json = this.adapter.writeAsString(value, exchange)) == null) continue;
                    map.put(entry.getKey(), json);
                }
                return map;
            }
            String json = this.adapter.writeAsString(answer, exchange);
            if (json != null) {
                return json;
            }
        }
        return answer;
    }

    private Object getPayload(Exchange exchange) {
        return this.source != null ? this.source.evaluate(exchange, Object.class) : exchange.getMessage().getBody();
    }

    private Object doRead(String path, Exchange exchange) throws IOException, CamelExchangeException {
        Object json = this.getPayload(exchange);
        if (json instanceof InputStream) {
            return this.readWithInputStream(path, exchange);
        }
        if (json instanceof GenericFile) {
            LOG.trace("JSonPath: {} is read as generic file: {}", (Object)path, json);
            GenericFile genericFile = (GenericFile)json;
            if (genericFile.getCharset() != null) {
                FileInputStream inputStream = new FileInputStream((File)genericFile.getFile());
                return JsonPath.using(this.configuration).parse(inputStream, genericFile.getCharset()).read(path, new Predicate[0]);
            }
        }
        if (json instanceof String) {
            LOG.trace("JSonPath: {} is read as String: {}", (Object)path, json);
            String str = (String)json;
            return JsonPath.using(this.configuration).parse(str).read(path, new Predicate[0]);
        }
        if (json instanceof Map) {
            LOG.trace("JSonPath: {} is read as Map: {}", (Object)path, json);
            Map map = (Map)json;
            return JsonPath.using(this.configuration).parse(map).read(path, new Predicate[0]);
        }
        if (json instanceof List) {
            LOG.trace("JSonPath: {} is read as List: {}", (Object)path, json);
            List list = (List)json;
            return JsonPath.using(this.configuration).parse(list).read(path, new Predicate[0]);
        }
        Object answer = this.readWithInputStream(path, exchange);
        if (answer == null) {
            answer = this.readWithAdapter(path, exchange);
        }
        if (answer != null) {
            return answer;
        }
        if (this.configuration.getOptions().contains((Object)Option.SUPPRESS_EXCEPTIONS) || this.configuration.getOptions().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
            if (this.configuration.getOptions().contains((Object)Option.ALWAYS_RETURN_LIST)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (this.source != null) {
            throw new CamelExchangeException("Cannot read " + String.valueOf(this.source) + " as supported JSON value", exchange);
        }
        throw new CamelExchangeException("Cannot read message body as supported JSON value", exchange);
    }

    private Object readWithInputStream(String path, Exchange exchange) throws IOException {
        Object json = this.getPayload(exchange);
        LOG.trace("JSonPath: {} is read as InputStream: {}", (Object)path, json);
        InputStream is = exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, exchange, json);
        if (json instanceof StreamCache) {
            ((StreamCache)json).reset();
        }
        if (is != null) {
            String jsonEncoding = exchange.getIn().getHeader("CamelJsonPathJsonEncoding", String.class);
            if (jsonEncoding != null) {
                return JsonPath.using(this.configuration).parse(is, jsonEncoding).read(path, new Predicate[0]);
            }
            JsonStream jsonStream = new JsonStream(is);
            return JsonPath.using(this.configuration).parse(jsonStream, jsonStream.getEncoding().name()).read(path, new Predicate[0]);
        }
        return null;
    }

    private Object readWithAdapter(String path, Exchange exchange) {
        Object json = this.getPayload(exchange);
        LOG.trace("JSonPath: {} is read with adapter: {}", (Object)path, json);
        this.doInitAdapter(exchange);
        if (this.adapter != null) {
            LOG.trace("Attempting to use JacksonJsonAdapter: {}", (Object)this.adapter);
            Map map = this.adapter.readValue(json, exchange);
            if (json instanceof StreamCache) {
                ((StreamCache)json).reset();
            }
            if (map != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JacksonJsonAdapter converted object from: {} to: java.util.Map", (Object)ObjectHelper.classCanonicalName(json));
                }
                return JsonPath.using(this.configuration).parse(map).read(path, new Predicate[0]);
            }
        }
        return null;
    }

    private void doInitAdapter(Exchange exchange) {
        if (!this.initJsonAdapter) {
            try {
                Object obj;
                LOG.debug("Attempting to enable JacksonJsonAdapter by resolving: {} from classpath", (Object)JACKSON_JSON_ADAPTER);
                Class<?> clazz = exchange.getContext().getClassResolver().resolveClass(JACKSON_JSON_ADAPTER);
                if (clazz != null && (obj = exchange.getContext().getInjector().newInstance(clazz)) instanceof JsonPathAdapter) {
                    this.adapter = (JsonPathAdapter)obj;
                    this.adapter.init(exchange.getContext());
                    LOG.debug("JacksonJsonAdapter found on classpath and enabled for camel-jsonpath: {}", (Object)this.adapter);
                }
            }
            catch (Exception e) {
                LOG.debug("Cannot load {} from classpath to enable JacksonJsonAdapter due {}. JacksonJsonAdapter is not enabled.", new Object[]{JACKSON_JSON_ADAPTER, e.getMessage(), e});
            }
            this.initJsonAdapter = true;
        }
    }
}

