/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.EventLog;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.ToolboxWrapper;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class AS400JDBCDataSource
extends ToolboxWrapper
implements DataSource,
Referenceable,
Serializable,
Cloneable {
    static final long serialVersionUID = 4L;
    private static final String DATABASE_NAME = "databaseName";
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String DESCRIPTION = "description";
    private static final String SERVER_NAME = "serverName";
    private static final String USER = "userName";
    private static final String PASSWORD = "pw";
    private static final String SECURE = "secure";
    private static final String SAVE_PASSWORD = "savepw";
    private static final String PLAIN_TEXT_PASSWORD = "pwd";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String TOOLBOX_DRIVER = "jdbc:as400:";
    private static final int MAX_THRESHOLD = 0x1000000;
    static final int MAX_SCALE = 63;
    private static final String SOCKET_KEEP_ALIVE = "soKeepAlive";
    private static final String SOCKET_RECEIVE_BUFFER_SIZE = "soReceiveBufferSize";
    private static final String SOCKET_SEND_BUFFER_SIZE = "soSendBufferSize";
    private static final String SOCKET_LINGER = "soLinger";
    private static final String SOCKET_TIMEOUT = "soTimeout";
    private static final String SOCKET_LOGIN_TIMEOUT = "loginTimeout";
    private static final String SOCKET_TCP_NO_DELAY = "soTCPNoDelay";
    private transient AS400 as400_;
    private String dataSourceName_ = "";
    private String description_ = "";
    private JDProperties properties_;
    private SocketProperties sockProps_;
    private transient PrintWriter writer_;
    private transient EventLog log_;
    private String serialServerName_;
    private String serialUserName_;
    transient PropertyChangeSupport changes_;
    private boolean isSecure_ = false;
    private char[] serialPWBytes_ = null;
    private boolean savePasswordWhenSerialized_ = false;
    public static final int MAX_STORAGE_LIMIT = 2147352578;
    static final int TRACE_CLIENT = 1;
    public static final int SERVER_TRACE_START_DATABASE_MONITOR = 2;
    public static final int SERVER_TRACE_DEBUG_SERVER_JOB = 4;
    public static final int SERVER_TRACE_SAVE_SERVER_JOBLOG = 8;
    public static final int SERVER_TRACE_TRACE_SERVER_JOB = 16;
    public static final int SERVER_TRACE_SAVE_SQL_INFORMATION = 32;
    public static final int CONCURRENTACCESS_NOT_SET = 0;
    public static final int CONCURRENTACCESS_USE_CURRENTLY_COMMITTED = 1;
    public static final int CONCURRENTACCESS_WAIT_FOR_OUTCOME = 2;
    public static final int CONCURRENTACCESS_SKIP_LOCKS = 3;

    public AS400JDBCDataSource() {
        this.initializeTransient();
        this.properties_ = new JDProperties(null, null, null, null);
        this.sockProps_ = new SocketProperties();
    }

    public AS400JDBCDataSource(String serverName) {
        this();
        this.setServerName(serverName);
    }

    public AS400JDBCDataSource(String serverName, String user, String password) {
        this();
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    public AS400JDBCDataSource(String serverName, String user, char[] password) {
        this();
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    public AS400JDBCDataSource(String serverName, String user, char[] password, char[] additionalAuthenticationFactor) {
        this();
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
        this.setAdditionalAuthenticationFactor(additionalAuthenticationFactor);
    }

    public AS400JDBCDataSource(AS400 as400) {
        this();
        this.as400_ = as400;
        if (as400 instanceof SecureAS400) {
            this.setSecure(true);
        }
    }

    public AS400JDBCDataSource(String serverName, String user, String password, String keyRingNameX, String keyRingPasswordX) {
        this();
        this.setSecure(true);
        this.as400_ = new SecureAS400(this.as400_);
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    AS400JDBCDataSource(Reference reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.changes_ = new PropertyChangeSupport(this);
        if (((String)reference.get(SECURE).getContent()).equalsIgnoreCase(TRUE_)) {
            this.isSecure_ = true;
            this.as400_ = new SecureAS400();
        } else {
            this.isSecure_ = false;
            this.as400_ = new AS400();
        }
        this.properties_ = new JDProperties(null, null, null, null);
        Properties properties = new Properties();
        this.sockProps_ = new SocketProperties();
        Enumeration<RefAddr> list = reference.getAll();
        while (list.hasMoreElements()) {
            StringRefAddr refAddr = (StringRefAddr)list.nextElement();
            String property = refAddr.getType();
            String value = (String)reference.get(property).getContent();
            if (property.equals(DATABASE_NAME)) {
                this.setDatabaseName(value);
                continue;
            }
            if (property.equals(DATASOURCE_NAME)) {
                this.setDataSourceName(value);
                continue;
            }
            if (property.equals(DESCRIPTION)) {
                this.setDescription(value);
                continue;
            }
            if (property.equals(SERVER_NAME)) {
                this.setServerName(value);
                continue;
            }
            if (property.equals(USER)) {
                this.setUser(value);
                continue;
            }
            if (property.equals(PLAIN_TEXT_PASSWORD)) {
                this.setPassword(value);
                continue;
            }
            if (property.equals(PASSWORD)) {
                if (reference.get(PLAIN_TEXT_PASSWORD) != null) {
                    this.setPassword((String)reference.get(PLAIN_TEXT_PASSWORD).getContent());
                    continue;
                }
                this.serialPWBytes_ = value.toCharArray();
                char[] passwordArray = AS400JDBCDataSource.xpwDeconfuseToChar(this.serialPWBytes_);
                this.as400_.setPassword(passwordArray);
                CredentialVault.clearArray(passwordArray);
                continue;
            }
            if (property.equals(SAVE_PASSWORD)) {
                this.savePasswordWhenSerialized_ = value.equals(TRUE_);
                continue;
            }
            if (property.equals(SOCKET_KEEP_ALIVE)) {
                this.sockProps_.setKeepAlive(value.equals(TRUE_));
                continue;
            }
            if (property.equals(SOCKET_RECEIVE_BUFFER_SIZE)) {
                this.sockProps_.setReceiveBufferSize(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_SEND_BUFFER_SIZE)) {
                this.sockProps_.setSendBufferSize(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_LINGER)) {
                this.sockProps_.setSoLinger(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_TIMEOUT)) {
                this.sockProps_.setSoTimeout(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_LOGIN_TIMEOUT)) {
                this.sockProps_.setLoginTimeout(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_TCP_NO_DELAY)) {
                this.sockProps_.setTcpNoDelay(value.equals(TRUE_));
                continue;
            }
            properties.put(property, value);
        }
        this.properties_ = new JDProperties(properties, null, null, null);
        String prmpt = this.properties_.getString(18);
        if (prmpt != null && prmpt.equalsIgnoreCase(FALSE_)) {
            this.setPrompt(false);
        } else if (prmpt != null && prmpt.equalsIgnoreCase(TRUE_)) {
            this.setPrompt(true);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(listener);
        this.as400_.addPropertyChangeListener(listener);
    }

    public Object clone() {
        try {
            Trace.log(3, "AS400JDBCDataSource.close()");
            AS400JDBCDataSource clone = (AS400JDBCDataSource)super.clone();
            clone.properties_ = (JDProperties)this.properties_.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, e);
            throw new UnsupportedOperationException("clone()");
        }
    }

    public String getAccess() {
        return this.properties_.getString(0);
    }

    public int getBehaviorOverride() {
        return this.properties_.getInt(50);
    }

    public int getBidiStringType() {
        String value = this.properties_.getString(42);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getBlockCriteria() {
        return this.properties_.getInt(2);
    }

    public int getBlockSize() {
        return this.properties_.getInt(1);
    }

    public String getCharacterTruncation() {
        return this.properties_.getString(91);
    }

    @Override
    public Connection getConnection() throws SQLException {
        char[] aaf = this.properties_.getAdditionalAuthenticationFactor();
        if (this.isSecure_ || this.isSecure()) {
            SecureAS400 newAs400 = new SecureAS400(this.as400_);
            if (aaf != null) {
                newAs400.setAdditionalAuthenticationFactor(aaf);
            }
            return this.getConnection(newAs400);
        }
        AS400 newAs400 = new AS400(this.as400_);
        if (aaf != null) {
            newAs400.setAdditionalAuthenticationFactor(aaf);
        }
        return this.getConnection(newAs400);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (password == null) {
            return this.getConnection(user, (char[])null);
        }
        char[] passwordChars = password.toCharArray();
        Connection c = this.getConnection(user, passwordChars);
        CredentialVault.clearArray(passwordChars);
        return c;
    }

    public Connection getConnection(String user, char[] password) throws SQLException {
        return this.getConnection(user, password, null);
    }

    public Connection getConnection(String user, char[] password, char[] additionalAuthenticationFactor) throws SQLException {
        AS400 as400Object;
        String secureCurrentUser = SystemProperties.getProperty("com.ibm.as400.access.JDBC.secureCurrentUser");
        boolean isSecureCurrentUser = true;
        if (secureCurrentUser != null && !Boolean.valueOf(secureCurrentUser).booleanValue() || !this.isSecureCurrentUser()) {
            isSecureCurrentUser = false;
        }
        boolean forcePrompt = false;
        if ("".equals(user) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (password != null && password.length == 0 && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = new char[]{};
        }
        if (user.compareToIgnoreCase("*CURRENT") == 0 && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        if (CredentialVault.isStarCurrent(password) && isSecureCurrentUser) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Userid/password cannot be \"\" or *CURRENT due to security constraints.  Use null instead");
            }
            forcePrompt = true;
        }
        try {
            as400Object = this.isSecure_ || this.isSecure() ? new SecureAS400(this.getServerName(), user, password, additionalAuthenticationFactor) : new AS400(this.getServerName(), user, password, additionalAuthenticationFactor);
        }
        catch (AS400SecurityException e) {
            JDError.throwSQLException((Object)this, "08004", e);
            throw new SQLException("PREVENT COMPILER ERROR");
        }
        catch (IOException e) {
            JDError.throwSQLException((Object)this, "08001", e);
            throw new SQLException("PREVENT COMPILER ERROR");
        }
        try {
            if (!this.as400_.isThreadUsed()) {
                as400Object.setThreadUsed(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!this.isPrompt()) {
                as400Object.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (forcePrompt) {
            as400Object.forcePrompt();
        }
        return this.getConnection(as400Object);
    }

    private Connection getConnection(AS400 as400) throws SQLException {
        if (this.sockProps_ != null) {
            as400.setSocketProperties(this.sockProps_);
        } else if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sockProps_:  null");
        }
        AS400JDBCConnection connection = null;
        connection = this.properties_.getInt(93) == 1 ? new AS400JDBCConnectionRedirect() : new AS400JDBCConnectionImpl();
        connection.setSystem(as400);
        connection.setProperties(new JDDataSourceURL("jdbc:as400://" + as400.getSystemName()), this.properties_, as400);
        this.log(ResourceBundleLoader.getText("AS400_JDBC_DS_CONN_CREATED"));
        return connection;
    }

    public int getConcurrentAccessResolution() {
        return this.properties_.getInt(79);
    }

    public String getCursorSensitivity() {
        return this.properties_.getString(49);
    }

    public String getDatabaseName() {
        return this.properties_.getString(47);
    }

    public String getDataSourceName() {
        return this.dataSourceName_;
    }

    public String getDateFormat() {
        return this.properties_.getString(3);
    }

    public String getDateSeparator() {
        return this.properties_.getString(4);
    }

    public String getDecfloatRoundingMode() {
        return this.properties_.getString(74);
    }

    public String getDecimalSeparator() {
        return this.properties_.getString(5);
    }

    public String getIgnoreWarnings() {
        return this.properties_.getString(77);
    }

    public String getDecimalDataErrors() {
        return this.properties_.getString(86);
    }

    public String getDescribeOption() {
        return this.properties_.getString(85);
    }

    public String getDescription() {
        return this.description_;
    }

    public String getDriver() {
        return this.properties_.getString(41);
    }

    public String getErrors() {
        return this.properties_.getString(6);
    }

    public String getLibraries() {
        return this.properties_.getString(8);
    }

    public int getLobThreshold() {
        return this.properties_.getInt(31);
    }

    @Override
    public int getLoginTimeout() {
        return this.properties_.getInt(58);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.writer_;
    }

    public int getMetaDataSource() {
        return this.properties_.getInt(72);
    }

    public int getMetadataSource() {
        return this.getMetaDataSource();
    }

    public String getNaming() {
        return this.properties_.getString(9);
    }

    public String getNumericRangeError() {
        return this.properties_.getString(90);
    }

    public String getPackage() {
        return this.properties_.getString(10);
    }

    public String getPackageCriteria() {
        return this.properties_.getString(30);
    }

    public String getPackageError() {
        return this.properties_.getString(14);
    }

    public String getPackageLibrary() {
        return this.properties_.getString(15);
    }

    public String getProxyServer() {
        return this.properties_.getString(34);
    }

    @Override
    public Reference getReference() throws NamingException {
        Trace.log(3, "AS400JDBCDataSource.getReference");
        Reference ref = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        DriverPropertyInfo[] propertyList = this.properties_.getInfo();
        for (int i = 0; i < propertyList.length; ++i) {
            if (propertyList[i].value == null) continue;
            ref.add(new StringRefAddr(propertyList[i].name, propertyList[i].value));
        }
        if (this.sockProps_.keepAliveSet_) {
            ref.add(new StringRefAddr(SOCKET_KEEP_ALIVE, this.sockProps_.keepAlive_ ? TRUE_ : FALSE_));
        }
        if (this.sockProps_.receiveBufferSizeSet_) {
            ref.add(new StringRefAddr(SOCKET_RECEIVE_BUFFER_SIZE, Integer.toString(this.sockProps_.receiveBufferSize_)));
        }
        if (this.sockProps_.sendBufferSizeSet_) {
            ref.add(new StringRefAddr(SOCKET_SEND_BUFFER_SIZE, Integer.toString(this.sockProps_.sendBufferSize_)));
        }
        if (this.sockProps_.soLingerSet_) {
            ref.add(new StringRefAddr(SOCKET_LINGER, Integer.toString(this.sockProps_.soLinger_)));
        }
        if (this.sockProps_.soTimeoutSet_) {
            ref.add(new StringRefAddr(SOCKET_TIMEOUT, Integer.toString(this.sockProps_.soTimeout_)));
        }
        if (this.sockProps_.loginTimeoutSet_) {
            ref.add(new StringRefAddr(SOCKET_LOGIN_TIMEOUT, Integer.toString(this.sockProps_.loginTimeout_)));
        }
        if (this.sockProps_.tcpNoDelaySet_) {
            ref.add(new StringRefAddr(SOCKET_TCP_NO_DELAY, this.sockProps_.tcpNoDelay_ ? TRUE_ : FALSE_));
        }
        if (this.getDatabaseName() != null) {
            ref.add(new StringRefAddr(DATABASE_NAME, this.getDatabaseName()));
        }
        if (this.getDataSourceName() != null) {
            ref.add(new StringRefAddr(DATASOURCE_NAME, this.getDataSourceName()));
        }
        if (this.getDescription() != null) {
            ref.add(new StringRefAddr(DESCRIPTION, this.getDescription()));
        }
        ref.add(new StringRefAddr(SERVER_NAME, this.getServerName()));
        ref.add(new StringRefAddr(USER, this.getUser()));
        if (this.savePasswordWhenSerialized_) {
            ref.add(new StringRefAddr(PASSWORD, new String(this.serialPWBytes_)));
        }
        ref.add(new StringRefAddr(SECURE, this.isSecure_ ? TRUE_ : FALSE_));
        ref.add(new StringRefAddr(SAVE_PASSWORD, this.savePasswordWhenSerialized_ ? TRUE_ : FALSE_));
        return ref;
    }

    public String getRemarks() {
        return this.properties_.getString(19);
    }

    public String getSecondaryUrl() {
        return this.properties_.getString(35);
    }

    public String getSecondaryURL() {
        return this.getSecondaryUrl();
    }

    public String getServerName() {
        return this.as400_.getSystemName();
    }

    public int getServerTraceCategories() {
        return this.properties_.getInt(46);
    }

    public int getServerTrace() {
        return this.getServerTraceCategories();
    }

    public int getSocketTimeout() {
        return this.getSoTimeout();
    }

    public String getSort() {
        return this.properties_.getString(20);
    }

    public String getSortLanguage() {
        return this.properties_.getString(21);
    }

    public String getSortTable() {
        return this.properties_.getString(22);
    }

    public String getSortWeight() {
        return this.properties_.getString(23);
    }

    public String getTimeFormat() {
        return this.properties_.getString(24);
    }

    public String getTimeSeparator() {
        return this.properties_.getString(25);
    }

    public String getTimestampFormat() {
        return this.properties_.getString(87);
    }

    public String getTransactionIsolation() {
        return this.properties_.getString(27);
    }

    public String getUser() {
        return this.as400_.getUserId();
    }

    public int getPortNumber() {
        return this.properties_.getInt(92);
    }

    public String getQaqqiniLibrary() {
        return this.properties_.getString(57);
    }

    public String getQaqqinilib() {
        return this.getQaqqiniLibrary();
    }

    public int getQueryOptimizeGoal() {
        return this.properties_.getInt(66);
    }

    public int getQueryStorageLimit() {
        return this.properties_.getInt(73);
    }

    public String getQueryReplaceTruncatedParameter() {
        return this.properties_.getString(89);
    }

    public String getQueryTimeoutMechanism() {
        return this.properties_.getString(84);
    }

    public int getXALooselyCoupledSupport() {
        return this.properties_.getInt(70);
    }

    private void initializeTransient() {
        Trace.log(3, "AS400JDBCDataSource.initializeTransient");
        this.changes_ = new PropertyChangeSupport(this);
        this.as400_ = this.isSecure_ ? new SecureAS400() : new AS400();
        if (this.serialServerName_ != null) {
            this.setServerName(this.serialServerName_);
        }
        if (this.serialUserName_ != null) {
            this.setUser(this.serialUserName_);
            if (this.serialPWBytes_ != null && this.serialPWBytes_.length > 0) {
                char[] passwordChars = AS400JDBCDataSource.xpwDeconfuseToChar(this.serialPWBytes_);
                this.as400_.setPassword(passwordChars);
                CredentialVault.clearArray(passwordChars);
            }
        }
        try {
            if (this.properties_ != null && !this.isPrompt()) {
                this.as400_.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public boolean isTrueAutoCommit() {
        return this.properties_.getBoolean(59);
    }

    public boolean isTrueAutocommit() {
        return this.isTrueAutoCommit();
    }

    public boolean isVariableFieldCompression() {
        String value = this.properties_.getString(65);
        return TRUE_.equals(value) || "all".equals(value) || "insert".equals(value);
    }

    public String getVariableFieldCompression() {
        return this.properties_.getString(65);
    }

    public boolean isAutoCommit() {
        return this.properties_.getBoolean(76);
    }

    public boolean isAutocommitException() {
        return this.properties_.getBoolean(75);
    }

    public boolean isBidiImplicitReordering() {
        return this.properties_.getBoolean(60);
    }

    public boolean isBidiNumericOrdering() {
        return this.properties_.getBoolean(61);
    }

    public boolean isBigDecimal() {
        return this.properties_.getBoolean(37);
    }

    public boolean isCursorHold() {
        return this.properties_.getBoolean(39);
    }

    public boolean isDataCompression() {
        return this.properties_.getBoolean(36);
    }

    public boolean isDataTruncation() {
        return this.properties_.getBoolean(33);
    }

    public boolean isExtendedDynamic() {
        return this.properties_.getBoolean(7);
    }

    public boolean isExtendedMetaData() {
        return this.properties_.getBoolean(48);
    }

    public boolean isExtendedMetadata() {
        return this.isExtendedMetaData();
    }

    public boolean isFullOpen() {
        return this.properties_.getBoolean(45);
    }

    public boolean isJvm16Synchronize() {
        return this.properties_.getBoolean(80);
    }

    public boolean isLazyClose() {
        return this.properties_.getBoolean(40);
    }

    public boolean isHoldInputLocators() {
        return this.properties_.getBoolean(62);
    }

    public boolean isPackageAdd() {
        return this.properties_.getBoolean(11);
    }

    public boolean isPackageCache() {
        return this.properties_.getBoolean(12);
    }

    public boolean isPackageClear() {
        return false;
    }

    public boolean isPrefetch() {
        return this.properties_.getBoolean(17);
    }

    public boolean isPrompt() {
        return this.properties_.getBoolean(18);
    }

    public boolean isRollbackCursorHold() {
        return this.properties_.getBoolean(64);
    }

    public boolean isHoldStatements() {
        return this.properties_.getBoolean(63);
    }

    public boolean isSavePasswordWhenSerialized() {
        return this.savePasswordWhenSerialized_;
    }

    public boolean isSecure() {
        return this.properties_.getBoolean(32);
    }

    public boolean isSecureCurrentUser() {
        return this.properties_.getBoolean(78);
    }

    public boolean isThreadUsed() {
        return this.properties_.getBoolean(38);
    }

    public boolean isTrace() {
        return this.properties_.getBoolean(26);
    }

    public boolean isTranslateBinary() {
        return this.properties_.getBoolean(28);
    }

    public boolean isTranslateBoolean() {
        return this.properties_.getBoolean(71);
    }

    public boolean isUseBlockUpdate() {
        return this.properties_.getBoolean(82);
    }

    public boolean isUseDrdaMetadataVersion() {
        return this.properties_.getBoolean(88);
    }

    void log(String message) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, message);
        }
        if (this.log_ != null) {
            this.log_.log(message);
        }
    }

    private void logProperty(String property, String value) {
        if (Trace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "log1", property, value);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(listener);
        this.as400_.removePropertyChangeListener(listener);
    }

    public void setAccess(String access) {
        String property = "access";
        if (access == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, access, 0);
        String old = this.getAccess();
        this.properties_.setString(0, access);
        this.changes_.firePropertyChange(property, old, access);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + access);
        }
    }

    public void setAdditionalAuthenticationFactor(char[] additionalAuthenticationFactor) {
        this.properties_.setAdditionalAuthenticationFactor(additionalAuthenticationFactor);
    }

    public void setAutoCommit(boolean value) {
        String property = "autoCommit";
        Boolean oldValue = this.isAutoCommit();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(76, TRUE_);
        } else {
            this.properties_.setString(76, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setAutocommitException(boolean value) {
        String property = "autocommitException";
        Boolean oldValue = this.isAutocommitException();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(75, TRUE_);
        } else {
            this.properties_.setString(75, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setTrueAutoCommit(boolean value) {
        String property = "trueAutoCommit";
        Boolean oldValue = this.isTrueAutoCommit();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(59, TRUE_);
        } else {
            this.properties_.setString(59, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setTrueAutocommit(boolean value) {
        this.setTrueAutoCommit(value);
    }

    public void setBehaviorOverride(int behaviors) {
        String property = "behaviorOverride";
        Integer oldValue = this.getBehaviorOverride();
        Integer newValue = behaviors;
        this.properties_.setString(50, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + behaviors);
        }
    }

    public void setBidiStringType(int bidiStringType) {
        String property = "bidiStringType";
        Integer oldBidiStringType = this.getBidiStringType();
        Integer newBidiStringType = bidiStringType;
        this.validateProperty(property, newBidiStringType.toString(), 42);
        this.properties_.setString(42, newBidiStringType.toString());
        this.changes_.firePropertyChange(property, oldBidiStringType, newBidiStringType);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + bidiStringType);
        }
    }

    public void setBidiImplicitReordering(boolean value) {
        String property = "bidiImplicitReordering";
        Boolean oldValue = this.isBidiImplicitReordering();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(60, TRUE_);
        } else {
            this.properties_.setString(60, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setBidiNumericOrdering(boolean value) {
        String property = "bidiNumericOrdering";
        Boolean oldValue = this.isBidiNumericOrdering();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(61, TRUE_);
        } else {
            this.properties_.setString(61, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setBigDecimal(boolean value) {
        String property = "bigDecimal";
        Boolean oldValue = this.isBigDecimal();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(37, TRUE_);
        } else {
            this.properties_.setString(37, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setBlockCriteria(int blockCriteria) {
        String property = "blockCriteria";
        Integer oldCriteria = this.getBlockCriteria();
        Integer newCriteria = blockCriteria;
        this.validateProperty(property, newCriteria.toString(), 2);
        this.properties_.setString(2, newCriteria.toString());
        this.changes_.firePropertyChange(property, oldCriteria, newCriteria);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + blockCriteria);
        }
    }

    public void setBlockSize(int blockSize) {
        String property = "blockSize";
        Integer oldBlockSize = this.getBlockSize();
        Integer newBlockSize = blockSize;
        this.validateProperty(property, newBlockSize.toString(), 1);
        this.properties_.setString(1, Integer.toString(blockSize));
        this.changes_.firePropertyChange(property, oldBlockSize, newBlockSize);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + blockSize);
            if (blockSize == 0) {
                Exception setLocation = new Exception("Set Location");
                JDTrace.logException(this, "setBlockSize", setLocation);
            }
        }
    }

    public void setCharacterTruncation(String setting) {
        String property = "characterTruncation";
        String oldSetting = this.getCharacterTruncation();
        String newSetting = setting;
        this.validateProperty(property, newSetting, 91);
        this.properties_.setString(91, newSetting);
        this.changes_.firePropertyChange(property, oldSetting, newSetting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) {
        String property = "concurrentAccessResolution";
        Integer oldValue = this.getConcurrentAccessResolution();
        Integer newValue = concurrentAccessResolution;
        this.validateProperty(property, newValue.toString(), 79);
        this.properties_.setString(79, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + concurrentAccessResolution);
        }
    }

    public void setCursorSensitivity(String cursorSensitivity) {
        String property = "cursorSensitivity";
        String oldCursorSensitivity = this.getCursorSensitivity();
        String newCursorSensitivity = cursorSensitivity;
        this.validateProperty(property, newCursorSensitivity, 49);
        this.properties_.setString(49, cursorSensitivity);
        this.changes_.firePropertyChange(property, oldCursorSensitivity, newCursorSensitivity);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + cursorSensitivity);
        }
    }

    public void setCursorHold(boolean cursorHold) {
        String property = "cursorHold";
        Boolean oldHold = this.isCursorHold();
        Boolean newHold = cursorHold;
        if (cursorHold) {
            this.properties_.setString(39, TRUE_);
        } else {
            this.properties_.setString(39, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldHold, newHold);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + cursorHold);
        }
    }

    public void setDatabaseName(String databaseName) {
        String property = DATABASE_NAME;
        if (databaseName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getDatabaseName();
        this.properties_.setString(47, databaseName);
        this.changes_.firePropertyChange(property, old, databaseName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + databaseName);
        }
    }

    public void setDataCompression(boolean compression) {
        Boolean oldCompression = this.isDataCompression();
        Boolean newCompression = compression;
        if (compression) {
            this.properties_.setString(36, TRUE_);
        } else {
            this.properties_.setString(36, FALSE_);
        }
        this.changes_.firePropertyChange("dataCompression", oldCompression, newCompression);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "dataCompression: " + compression);
        }
    }

    public void setDataSourceName(String dataSourceName) {
        String property = DATASOURCE_NAME;
        if (dataSourceName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getDataSourceName();
        this.dataSourceName_ = dataSourceName;
        this.changes_.firePropertyChange(property, old, dataSourceName);
        this.logProperty("dataSource", this.dataSourceName_);
    }

    public void setDataTruncation(boolean truncation) {
        Boolean oldTruncation = this.isDataTruncation();
        Boolean newTruncation = truncation;
        if (truncation) {
            this.properties_.setString(33, TRUE_);
        } else {
            this.properties_.setString(33, FALSE_);
        }
        this.changes_.firePropertyChange("dataTruncation", oldTruncation, newTruncation);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "dataTruncation: " + truncation);
        }
    }

    public void setDateFormat(String dateFormat) {
        String property = "dateFormat";
        if (dateFormat == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, dateFormat, 3);
        String old = this.getDateFormat();
        this.properties_.setString(3, dateFormat);
        this.changes_.firePropertyChange(property, old, dateFormat);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + dateFormat);
        }
    }

    public void setDateSeparator(String dateSeparator) {
        String property = "dateSeparator";
        if (dateSeparator == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, dateSeparator, 4);
        String old = this.getDateSeparator();
        this.properties_.setString(4, dateSeparator);
        this.changes_.firePropertyChange(property, old, dateSeparator);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + dateSeparator);
        }
    }

    public void setDecfloatRoundingMode(String decfloatRoundingMode) {
        String property = "decfloatRoundingMode";
        if (decfloatRoundingMode == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, decfloatRoundingMode, 74);
        String old = this.getDecfloatRoundingMode();
        this.properties_.setString(74, decfloatRoundingMode);
        this.changes_.firePropertyChange(property, old, decfloatRoundingMode);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + decfloatRoundingMode);
        }
    }

    public void setDecimalDataErrors(String decimalDataErrors) {
        String property = "decimalDataErrors";
        if (decimalDataErrors == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, decimalDataErrors, 86);
        String old = this.getDecimalDataErrors();
        this.properties_.setString(5, decimalDataErrors);
        this.changes_.firePropertyChange(property, old, decimalDataErrors);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + decimalDataErrors);
        }
    }

    public void setDecimalSeparator(String decimalSeparator) {
        String property = "decimalSeparator";
        if (decimalSeparator == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, decimalSeparator, 5);
        String old = this.getDecimalSeparator();
        this.properties_.setString(5, decimalSeparator);
        this.changes_.firePropertyChange(property, old, decimalSeparator);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + decimalSeparator);
        }
    }

    public void setIgnoreWarnings(String ignoreWarnings) {
        String property = "ignoreWarnings";
        if (ignoreWarnings == null) {
            throw new NullPointerException(property);
        }
        String old = this.getIgnoreWarnings();
        this.properties_.setString(77, ignoreWarnings);
        this.changes_.firePropertyChange(property, old, ignoreWarnings);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + ignoreWarnings);
        }
    }

    public void setDescription(String description) {
        String property = DESCRIPTION;
        if (description == null) {
            throw new NullPointerException(property);
        }
        String old = this.getDescription();
        this.description_ = description;
        this.changes_.firePropertyChange(property, old, description);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + description);
        }
    }

    public void setSort(String sort) {
        String property = "sort";
        if (sort == null) {
            throw new NullPointerException(property);
        }
        if (sort.equals("job")) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, property + ": " + this.getSort() + " (warning: " + this.getSort() + " will be used since sort=job is not valid)");
            }
            return;
        }
        this.validateProperty(property, sort, 20);
        String old = this.getSort();
        this.properties_.setString(20, sort);
        this.changes_.firePropertyChange(property, old, sort);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + sort);
        }
    }

    public void setErrors(String errors) {
        String property = "errors";
        if (errors == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, errors, 6);
        String old = this.getErrors();
        this.properties_.setString(6, errors);
        this.changes_.firePropertyChange(property, old, errors);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + errors);
        }
    }

    public void setExtendedDynamic(boolean extendedDynamic) {
        Boolean oldValue = this.isExtendedDynamic();
        Boolean newValue = extendedDynamic;
        if (extendedDynamic) {
            this.properties_.setString(7, TRUE_);
        } else {
            this.properties_.setString(7, FALSE_);
        }
        this.changes_.firePropertyChange("extendedDynamic", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "extendedDynamic: " + extendedDynamic);
        }
    }

    public void setExtendedMetaData(boolean extendedMetaData) {
        Boolean oldValue = this.isExtendedMetaData();
        Boolean newValue = extendedMetaData;
        if (extendedMetaData) {
            this.properties_.setString(48, TRUE_);
        } else {
            this.properties_.setString(48, FALSE_);
        }
        this.changes_.firePropertyChange("extendedMetaData", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "extendedMetaData: " + extendedMetaData);
        }
    }

    public void setExtendedMetadata(boolean extendedMetaData) {
        this.setExtendedMetaData(extendedMetaData);
    }

    public void setFullOpen(boolean fullOpen) {
        Boolean oldValue = this.isFullOpen();
        Boolean newValue = fullOpen;
        if (fullOpen) {
            this.properties_.setString(45, TRUE_);
        } else {
            this.properties_.setString(45, FALSE_);
        }
        this.changes_.firePropertyChange("fullOpen", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "fullOpen: " + fullOpen);
        }
    }

    public void setHoldInputLocators(boolean value) {
        String property = "holdInputLocators";
        Boolean oldValue = this.isHoldInputLocators();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(62, TRUE_);
        } else {
            this.properties_.setString(62, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setHoldStatements(boolean value) {
        String property = "holdStatements";
        Boolean oldValue = this.isHoldStatements();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(63, TRUE_);
        } else {
            this.properties_.setString(63, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setJvm16Synchronize(boolean value) {
        String property = "jvm16 synchronize";
        Boolean oldValue = this.isJvm16Synchronize();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(80, TRUE_);
        } else {
            this.properties_.setString(80, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setLazyClose(boolean lazyClose) {
        Boolean oldValue = this.isLazyClose();
        Boolean newValue = lazyClose;
        if (lazyClose) {
            this.properties_.setString(40, TRUE_);
        } else {
            this.properties_.setString(40, FALSE_);
        }
        this.changes_.firePropertyChange("lazyClose", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "lazyClose: " + lazyClose);
        }
    }

    public void setLibraries(String libraries) {
        String property = "libraries";
        if (libraries == null) {
            throw new NullPointerException("libraries");
        }
        String old = this.getLibraries();
        this.properties_.setString(8, libraries);
        this.changes_.firePropertyChange(property, old, libraries);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + libraries);
        }
    }

    public void setLobThreshold(int threshold) {
        String property = "threshold";
        if (threshold < 0 || threshold > 0x1000000) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        Integer oldValue = this.getLobThreshold();
        Integer newValue = threshold;
        this.properties_.setString(31, Integer.toString(threshold));
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + threshold);
        }
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.sockProps_.setLoginTimeout(timeout * 1000);
        String property = SOCKET_LOGIN_TIMEOUT;
        Integer oldValue = this.getLoginTimeout();
        Integer newValue = timeout;
        this.properties_.setString(58, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timeout);
        }
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        String property = "writer";
        PrintWriter old = this.getLogWriter();
        this.writer_ = writer;
        this.changes_.firePropertyChange(property, old, writer);
        if (writer == null) {
            this.log_ = null;
            return;
        }
        this.log_ = new EventLog(writer);
    }

    public void setMetaDataSource(int mds) {
        String property = "metaDataSource";
        Integer oldValue = this.getMetaDataSource();
        Integer newValue = mds;
        this.properties_.setString(72, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + mds);
        }
    }

    public void setMetadataSource(int mds) {
        this.setMetaDataSource(mds);
    }

    public void setNaming(String naming) {
        String property = "naming";
        if (naming == null) {
            throw new NullPointerException("naming");
        }
        this.validateProperty(property, naming, 9);
        String old = this.getNaming();
        this.properties_.setString(9, naming);
        this.changes_.firePropertyChange(property, old, naming);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + naming);
        }
    }

    public void setPackage(String packageName) {
        String property = "packageName";
        if (packageName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getPackage();
        this.properties_.setString(10, packageName);
        this.changes_.firePropertyChange(property, old, packageName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + packageName);
        }
    }

    public void setPackageAdd(boolean add) {
        Boolean oldValue = this.isPackageAdd();
        Boolean newValue = add;
        if (add) {
            this.properties_.setString(11, TRUE_);
        } else {
            this.properties_.setString(11, FALSE_);
        }
        this.changes_.firePropertyChange("packageAdd", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "packageAdd: " + add);
        }
    }

    public void setPackageCache(boolean cache) {
        Boolean oldValue = this.isPackageCache();
        Boolean newValue = cache;
        if (cache) {
            this.properties_.setString(12, TRUE_);
        } else {
            this.properties_.setString(12, FALSE_);
        }
        this.changes_.firePropertyChange("packageCache", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "packageCache: " + cache);
        }
    }

    public void setPackageClear(boolean clear) {
    }

    public void setPackageCriteria(String packageCriteria) {
        String property = "packageCriteria";
        if (packageCriteria == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, packageCriteria, 30);
        String old = this.getPackageCriteria();
        this.properties_.setString(30, packageCriteria);
        this.changes_.firePropertyChange(property, old, packageCriteria);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + packageCriteria);
        }
    }

    public void setPackageError(String packageError) {
        String property = "packageError";
        if (packageError == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, packageError, 14);
        String old = this.getPackageError();
        this.properties_.setString(14, packageError);
        this.changes_.firePropertyChange(property, old, packageError);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + packageError);
        }
    }

    public void setPackageLibrary(String packageLibrary) {
        String property = "packageLibrary";
        if (packageLibrary == null) {
            throw new NullPointerException(property);
        }
        String old = this.getPackageLibrary();
        this.properties_.setString(15, packageLibrary);
        this.changes_.firePropertyChange(property, old, packageLibrary);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + packageLibrary);
        }
    }

    public void setPassword(String password) {
        this.as400_.setPassword(password);
        this.serialPWBytes_ = AS400JDBCDataSource.xpwConfuse(password);
        this.log(ResourceBundleLoader.getText("AS400_JDBC_DS_PASSWORD_SET"));
    }

    public void setPassword(char[] password) {
        this.as400_.setPassword(password);
        this.serialPWBytes_ = AS400JDBCDataSource.xpwConfuse(password);
        this.log(ResourceBundleLoader.getText("AS400_JDBC_DS_PASSWORD_SET"));
    }

    public void setPrefetch(boolean prefetch) {
        Boolean oldValue = this.isPrefetch();
        Boolean newValue = prefetch;
        if (prefetch) {
            this.properties_.setString(17, TRUE_);
        } else {
            this.properties_.setString(17, FALSE_);
        }
        this.changes_.firePropertyChange("prefetch", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "prefetch: " + prefetch);
        }
    }

    public void setPrompt(boolean prompt) {
        Boolean oldValue = this.isPrompt();
        Boolean newValue = prompt;
        if (prompt) {
            this.properties_.setString(18, TRUE_);
        } else {
            this.properties_.setString(18, FALSE_);
        }
        try {
            this.as400_.setGuiAvailable(prompt);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange("prompt", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "prompt: " + prompt);
        }
    }

    public void setProperties(String propertiesString) {
        propertiesString = "jdbc:as400://dummyhost;" + (String)propertiesString;
        JDDataSourceURL dsURL = new JDDataSourceURL((String)propertiesString);
        Properties properties = dsURL.getProperties();
        this.setProperties(properties);
    }

    public void setProperties(Properties newProperties) {
        if (JDProperties.isTraceSet(newProperties, null) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(newProperties, null) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(newProperties, null) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        Enumeration<Object> e = newProperties.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = newProperties.getProperty(propertyName);
            int propIndex = JDProperties.getPropertyIndex(propertyName);
            if (propIndex == 47) {
                this.setDatabaseName(propertyValue);
                continue;
            }
            if (propIndex == 29) {
                this.setUser(propertyValue);
                continue;
            }
            if (propIndex == 16) {
                char[] clearPassword = propertyValue.toCharArray();
                this.setPassword(clearPassword);
                CredentialVault.clearArray(clearPassword);
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Use of password property not recommended:  using setPassword(char[]) instead");
                continue;
            }
            if (propIndex == 32) {
                this.setSecure(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == 67) {
                this.setKeepAlive(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == 68) {
                this.setReceiveBufferSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propIndex == 69) {
                this.setSendBufferSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propIndex == 18) {
                this.setPrompt(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == -1) continue;
            this.properties_.setString(propIndex, propertyValue);
        }
    }

    public void setProxyServer(String proxyServer) {
        String property = "proxyServer";
        if (proxyServer == null) {
            throw new NullPointerException(property);
        }
        String old = this.getProxyServer();
        this.properties_.setString(34, proxyServer);
        this.changes_.firePropertyChange(property, old, proxyServer);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + proxyServer);
        }
    }

    public void setRemarks(String remarks) {
        String property = "remarks";
        if (remarks == null) {
            throw new NullPointerException("remarks");
        }
        this.validateProperty(property, remarks, 19);
        String old = this.getRemarks();
        this.properties_.setString(19, remarks);
        this.changes_.firePropertyChange(property, old, remarks);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + remarks);
        }
    }

    public void setRollbackCursorHold(boolean cursorHold) {
        String property = "rollbackCursorHold";
        Boolean oldHold = this.isRollbackCursorHold();
        Boolean newHold = cursorHold;
        if (cursorHold) {
            this.properties_.setString(64, TRUE_);
        } else {
            this.properties_.setString(64, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldHold, newHold);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + cursorHold);
        }
    }

    public void setSecondaryUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        String old = this.getSecondaryUrl();
        this.properties_.setString(35, url);
        this.changes_.firePropertyChange("secondaryUrl", old, url);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "secondaryUrl: " + url);
        }
    }

    public void setSecondaryURL(String url) {
        this.setSecondaryUrl(url);
    }

    public void setSecure(boolean secure) {
        Boolean oldValue = this.isSecure();
        Boolean newValue = secure;
        if (!secure && this.isSecure_) {
            throw new ExtendedIllegalStateException(SECURE, 5);
        }
        this.isSecure_ = secure;
        if (secure) {
            this.properties_.setString(32, TRUE_);
        } else {
            this.properties_.setString(32, FALSE_);
        }
        this.changes_.firePropertyChange(SECURE, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "secure: " + secure);
        }
    }

    public void setSecureCurrentUser(boolean secureCurrentUser) {
        String property = "secureCurrentUser";
        Boolean oldVal = this.isSecureCurrentUser();
        Boolean newVal = secureCurrentUser;
        if (secureCurrentUser) {
            this.properties_.setString(78, TRUE_);
        } else {
            this.properties_.setString(78, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldVal, newVal);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + secureCurrentUser);
        }
    }

    public void setServerName(String serverName) {
        String property = SERVER_NAME;
        if (serverName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getServerName();
        this.serialServerName_ = serverName;
        try {
            this.as400_.setSystemName(serverName);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange(property, old, serverName);
        this.logProperty("server name", this.as400_.getSystemName());
    }

    public void setServerTraceCategories(int traceCategories) {
        String property = "serverTrace";
        Integer oldValue = this.getServerTraceCategories();
        Integer newValue = traceCategories;
        this.properties_.setString(46, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + traceCategories);
        }
    }

    public void setServerTrace(int traceCategories) {
        this.setServerTraceCategories(traceCategories);
    }

    public void setStayAlive(long milliseconds) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting stay-alive: " + milliseconds);
        }
    }

    public void setDescribeOption(String option) {
        String property = "describeOption";
        this.validateProperty(property, option, 85);
        String old = this.getDescribeOption();
        this.properties_.setString(85, option);
        this.changes_.firePropertyChange(property, old, option);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + option);
        }
    }

    public void setDriver(String driver) {
        String property = "driver";
        if (driver == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, driver, 41);
        String old = this.getDriver();
        this.properties_.setString(41, driver);
        this.changes_.firePropertyChange(property, old, driver);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + driver);
        }
    }

    public void setSavePasswordWhenSerialized(boolean savePassword) {
        String property = "savePasswordWhenSerialized";
        boolean oldValue = this.isSavePasswordWhenSerialized();
        boolean newValue = savePassword;
        this.savePasswordWhenSerialized_ = savePassword;
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "save password: " + savePassword);
        }
    }

    public void setSortLanguage(String language) {
        if (language == null) {
            throw new NullPointerException("language");
        }
        String old = this.getSortLanguage();
        this.properties_.setString(21, language);
        this.changes_.firePropertyChange("sortLanguage", old, language);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sortLanguage: " + language);
        }
    }

    public void setSortTable(String table) {
        if (table == null) {
            throw new NullPointerException("table");
        }
        String old = this.getSortTable();
        this.properties_.setString(22, table);
        this.changes_.firePropertyChange("sortTable", old, table);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "sortTable: " + table);
        }
    }

    public void setSortWeight(String sortWeight) {
        String property = "sortWeight";
        if (sortWeight == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, sortWeight, 23);
        String old = this.getSortWeight();
        this.properties_.setString(23, sortWeight);
        this.changes_.firePropertyChange(property, old, sortWeight);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + sortWeight);
        }
    }

    public void setThreadUsed(boolean threadUsed) {
        Boolean oldValue = this.isThreadUsed();
        Boolean newValue = threadUsed;
        if (threadUsed) {
            this.properties_.setString(38, TRUE_);
        } else {
            this.properties_.setString(38, FALSE_);
        }
        try {
            this.as400_.setThreadUsed(threadUsed);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange("threadUsed", oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "threadUsed: " + threadUsed);
        }
    }

    public void setTimeFormat(String timeFormat) {
        String property = "timeFormat";
        if (timeFormat == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, timeFormat, 24);
        String old = this.getTimeFormat();
        this.properties_.setString(24, timeFormat);
        this.changes_.firePropertyChange(property, old, timeFormat);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timeFormat);
        }
    }

    public void setTimeSeparator(String timeSeparator) {
        String property = "timeSeparator";
        if (timeSeparator == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, timeSeparator, 25);
        String old = this.getTimeSeparator();
        this.properties_.setString(25, timeSeparator);
        this.changes_.firePropertyChange(property, old, timeSeparator);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timeSeparator);
        }
    }

    public void setTimestampFormat(String timestampFormat) {
        String property = "timestampFormat";
        if (timestampFormat == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, timestampFormat, 87);
        String old = this.getTimeFormat();
        this.properties_.setString(87, timestampFormat);
        this.changes_.firePropertyChange(property, old, timestampFormat);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timestampFormat);
        }
    }

    public void setTrace(boolean trace) {
        Boolean oldValue = this.isTrace();
        Boolean newValue = trace;
        if (trace) {
            this.properties_.setString(26, TRUE_);
        } else {
            this.properties_.setString(26, FALSE_);
        }
        this.changes_.firePropertyChange("trace", oldValue, newValue);
        if (trace) {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else {
            JDTrace.setTraceOn(false);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "trace: " + trace);
        }
    }

    public void setTransactionIsolation(String transactionIsolation) {
        String property = "transactionIsolation";
        if (transactionIsolation == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, transactionIsolation, 27);
        String old = this.getTransactionIsolation();
        this.properties_.setString(27, transactionIsolation);
        this.changes_.firePropertyChange(property, old, transactionIsolation);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + transactionIsolation);
        }
    }

    public void setTranslateBinary(boolean translate) {
        String property = "translateBinary";
        Boolean oldValue = this.isTranslateBinary();
        Boolean newValue = translate;
        if (translate) {
            this.properties_.setString(28, TRUE_);
        } else {
            this.properties_.setString(28, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + translate);
        }
    }

    public void setTranslateBoolean(boolean translate) {
        String property = "translateBoolean";
        Boolean oldValue = this.isTranslateBoolean();
        Boolean newValue = translate;
        if (translate) {
            this.properties_.setString(71, TRUE_);
        } else {
            this.properties_.setString(71, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + translate);
        }
    }

    public void setUseBlockUpdate(boolean value) {
        String property = "use block update";
        Boolean oldValue = this.isUseBlockUpdate();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(82, TRUE_);
        } else {
            this.properties_.setString(82, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setUseDrdaMetadataVersion(boolean value) {
        String property = "use drda metadata version";
        Boolean oldValue = this.isUseDrdaMetadataVersion();
        Boolean newValue = value;
        if (value) {
            this.properties_.setString(88, TRUE_);
        } else {
            this.properties_.setString(88, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setUser(String user) {
        String property = "user";
        String old = this.getUser();
        this.serialUserName_ = user;
        try {
            this.as400_.setUserId(user);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.changes_.firePropertyChange(property, old, user);
        this.logProperty("user", this.as400_.getUserId());
    }

    public void setVariableFieldCompression(boolean compress) {
        String property = "variableFieldCompression";
        Boolean oldValue = this.isVariableFieldCompression();
        Boolean newValue = compress;
        if (compress) {
            this.properties_.setString(65, TRUE_);
        } else {
            this.properties_.setString(65, FALSE_);
        }
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + compress);
        }
    }

    public void setVariableFieldCompression(String compress) {
        String property = "variableFieldCompression";
        String oldValue = this.getVariableFieldCompression();
        if (TRUE_.equals(compress) || FALSE_.equals(compress) || "insert".equals(compress) || "all".equals(compress)) {
            this.properties_.setString(65, compress);
            this.changes_.firePropertyChange(property, oldValue, compress);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, property + ": " + compress);
            }
        }
    }

    public boolean getKeepAlive() {
        return this.sockProps_.isKeepAlive();
    }

    public boolean isKeepAlive() {
        return this.sockProps_.isKeepAlive();
    }

    public int getReceiveBufferSize() {
        return this.sockProps_.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return this.sockProps_.getSendBufferSize();
    }

    public int getSoLinger() {
        return this.sockProps_.getSoLinger();
    }

    public int getSoTimeout() {
        return this.sockProps_.getSoTimeout();
    }

    public boolean getTcpNoDelay() {
        return this.sockProps_.isTcpNoDelay();
    }

    public boolean isTcpNoDelay() {
        return this.sockProps_.isTcpNoDelay();
    }

    public void setKeepAlive(boolean keepAlive) {
        this.sockProps_.setKeepAlive(keepAlive);
    }

    public void setReceiveBufferSize(int size) {
        this.sockProps_.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) {
        this.sockProps_.setSendBufferSize(size);
    }

    public void setSoLinger(int seconds) {
        this.sockProps_.setSoLinger(seconds);
    }

    public void setSoTimeout(int milliseconds) {
        this.sockProps_.setSoTimeout(milliseconds);
    }

    public void setSocketTimeout(int milliseconds) {
        this.setSoTimeout(milliseconds);
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.sockProps_.setTcpNoDelay(noDelay);
    }

    public int getPackageCCSID() {
        return this.properties_.getInt(51);
    }

    public int getPackageCcsid() {
        return this.getPackageCCSID();
    }

    public void setPackageCCSID(int ccsid) {
        String property = "packageCCSID";
        Integer oldPackageCCSID = this.getPackageCCSID();
        Integer newPackageCCSID = ccsid;
        this.validateProperty(property, newPackageCCSID.toString(), 51);
        this.properties_.setString(51, newPackageCCSID.toString());
        this.changes_.firePropertyChange(property, oldPackageCCSID, newPackageCCSID);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + ccsid);
        }
    }

    public void setPackageCcsid(int ccsid) {
        this.setPackageCCSID(ccsid);
    }

    public int getMinimumDivideScale() {
        return this.properties_.getInt(52);
    }

    public int getMaximumBlockedInputRows() {
        return this.properties_.getInt(83);
    }

    public int getMaximumPrecision() {
        return this.properties_.getInt(53);
    }

    public int getMaximumScale() {
        return this.properties_.getInt(54);
    }

    public void setMinimumDivideScale(int scale) {
        String property = "minimumDivideScale";
        Integer oldValue = this.getMinimumDivideScale();
        Integer newValue = scale;
        this.validateProperty(property, newValue.toString(), 52);
        this.properties_.setString(52, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + scale);
        }
    }

    public void setMaximumBlockedInputRows(int maximumBlockedInputRows) {
        String property = "maximumBlockedInputRows";
        Integer oldValue = this.getMaximumBlockedInputRows();
        Integer newValue = maximumBlockedInputRows;
        if (maximumBlockedInputRows < 0 || maximumBlockedInputRows > 32000) {
            throw new ExtendedIllegalArgumentException(property, 2);
        }
        if (maximumBlockedInputRows == 0) {
            maximumBlockedInputRows = 32000;
        }
        this.properties_.setString(83, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + maximumBlockedInputRows);
        }
    }

    public void setMaximumPrecision(int precision) {
        String property = "maximumPrecision";
        Integer oldValue = this.getMaximumPrecision();
        Integer newValue = precision;
        this.validateProperty(property, newValue.toString(), 53);
        this.properties_.setString(53, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + precision);
        }
    }

    public void setMaximumScale(int scale) {
        String property = "maximumScale";
        Integer oldValue = this.getMaximumScale();
        Integer newValue = scale;
        this.validateProperty(property, newValue.toString(), 54);
        this.properties_.setString(54, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + scale);
        }
    }

    public void setNumericRangeError(String setting) {
        String property = "translateHex";
        String oldSetting = this.getNumericRangeError();
        String newSetting = setting;
        this.validateProperty(property, newSetting, 90);
        this.properties_.setString(90, newSetting);
        this.changes_.firePropertyChange(property, oldSetting, newSetting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public String getTranslateHex() {
        return this.properties_.getString(55);
    }

    public void setTranslateHex(String parseOption) {
        String property = "translateHex";
        String oldOption = this.getTranslateHex();
        String newOption = parseOption;
        this.validateProperty(property, newOption, 55);
        this.properties_.setString(55, newOption);
        this.changes_.firePropertyChange(property, oldOption, newOption);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + parseOption);
        }
    }

    public void setPortNumber(int portNumber) {
        String property = "portNumber";
        int old = this.getPortNumber();
        this.properties_.setString(92, "" + portNumber);
        this.changes_.firePropertyChange(property, old, portNumber);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + portNumber);
        }
    }

    public void setQaqqiniLibrary(String libraryName) {
        String property = "qaqqiniLibrary";
        if (libraryName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getQaqqiniLibrary();
        this.properties_.setString(57, libraryName);
        this.changes_.firePropertyChange(property, old, libraryName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + libraryName);
        }
    }

    public void setQaqqinilib(String libraryName) {
        this.setQaqqiniLibrary(libraryName);
    }

    public void setQueryOptimizeGoal(int goal) {
        String property = "queryOptimizeGoal";
        Integer oldValue = this.getQueryOptimizeGoal();
        Integer newValue = goal;
        this.properties_.setString(66, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + goal);
        }
    }

    public void setQueryStorageLimit(int limit) {
        String property = "queryStorageLimit";
        if (limit < -1 || limit > 2147352578) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        Integer oldValue = this.getQueryStorageLimit();
        Integer newValue = limit;
        this.properties_.setString(73, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + limit);
        }
    }

    public void setQueryReplaceTruncatedParameter(String queryReplaceTruncatedParameter) {
        String property = "queryReplaceTruncatedParameter";
        String oldOption = this.getQueryReplaceTruncatedParameter();
        String newOption = queryReplaceTruncatedParameter;
        this.properties_.setString(89, newOption);
        this.changes_.firePropertyChange(property, oldOption, newOption);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + queryReplaceTruncatedParameter);
        }
    }

    public void setQueryTimeoutMechanism(String timeoutMechanism) {
        String property = "queryTimeoutMechanism";
        String oldOption = this.getQueryTimeoutMechanism();
        String newOption = timeoutMechanism;
        this.validateProperty(property, newOption, 84);
        this.properties_.setString(84, newOption);
        this.changes_.firePropertyChange(property, oldOption, newOption);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timeoutMechanism);
        }
    }

    public void setXALooselyCoupledSupport(int lcs) {
        String property = "xaLooselyCoupledSupport";
        Integer oldValue = this.getXALooselyCoupledSupport();
        Integer newValue = lcs;
        this.properties_.setString(70, newValue.toString());
        this.changes_.firePropertyChange(property, oldValue, newValue);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + lcs);
        }
    }

    public String getToolboxTraceCategory() {
        return this.properties_.getString(56);
    }

    public String getToolboxTrace() {
        return this.getToolboxTraceCategory();
    }

    public void setToolboxTraceCategory(String traceCategory) {
        String property = "toolboxTrace";
        String oldOption = this.getToolboxTraceCategory();
        String newOption = traceCategory;
        this.validateProperty(property, newOption, 56);
        this.properties_.setString(56, newOption);
        this.changes_.firePropertyChange(property, oldOption, newOption);
        if (!traceCategory.equals("") && !traceCategory.equals("none")) {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            if (traceCategory.equals("datastream")) {
                Trace.setTraceDatastreamOn(true);
            } else if (traceCategory.equals("diagnostic")) {
                Trace.setTraceDiagnosticOn(true);
            } else if (traceCategory.equals("error")) {
                Trace.setTraceErrorOn(true);
            } else if (traceCategory.equals("information")) {
                Trace.setTraceInformationOn(true);
            } else if (traceCategory.equals("warning")) {
                Trace.setTraceWarningOn(true);
            } else if (traceCategory.equals("conversion")) {
                Trace.setTraceConversionOn(true);
            } else if (traceCategory.equals("proxy")) {
                Trace.setTraceProxyOn(true);
            } else if (traceCategory.equals("pcml")) {
                Trace.setTracePCMLOn(true);
            } else if (traceCategory.equals("jdbc")) {
                Trace.setTraceJDBCOn(true);
            } else if (traceCategory.equals("all")) {
                Trace.setTraceAllOn(true);
            } else if (traceCategory.equals("thread")) {
                Trace.setTraceThreadOn(true);
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + traceCategory);
        }
    }

    public void setToolboxTrace(String traceCategory) {
        this.setToolboxTraceCategory(traceCategory);
    }

    private void validateProperty(String property, String value, int index) {
        if (value.length() != 0) {
            DriverPropertyInfo[] info = this.properties_.getInfo();
            String[] choices = info[index].choices;
            if (index == 51) {
                try {
                    int ccsid = Integer.valueOf(value);
                    if (ccsid < 1) {
                        throw new ExtendedIllegalArgumentException(property, 2);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    throw new ExtendedIllegalArgumentException(property, 2);
                }
            }
            boolean notValid = true;
            int current = 0;
            while (notValid && current < choices.length) {
                if (value.equalsIgnoreCase(choices[current])) {
                    notValid = false;
                    continue;
                }
                ++current;
            }
            if (notValid) {
                throw new ExtendedIllegalArgumentException(property, 2);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Trace.log(3, "AS400JDBCDataSource.writeObject");
        if (!this.savePasswordWhenSerialized_) {
            this.serialPWBytes_ = null;
        }
        out.defaultWriteObject();
    }

    public String toString() {
        String name = this.getDataSourceName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    static char[] xpwConfuse(String info) {
        Random rng = new Random();
        byte[] adderBytes = new byte[18];
        rng.nextBytes(adderBytes);
        char[] adder = BinaryConverter.byteArrayToCharArray(adderBytes);
        byte[] maskBytes = new byte[14];
        rng.nextBytes(maskBytes);
        char[] mask = BinaryConverter.byteArrayToCharArray(maskBytes);
        char[] infoBytes = AS400JDBCDataSource.xencode(adder, mask, info.toCharArray());
        char[] returnBytes = new char[info.length() + 16];
        System.arraycopy(adder, 0, returnBytes, 0, 9);
        System.arraycopy(mask, 0, returnBytes, 9, 7);
        System.arraycopy(infoBytes, 0, returnBytes, 16, info.length());
        return returnBytes;
    }

    static char[] xpwConfuse(char[] info) {
        Random rng = new Random();
        byte[] adderBytes = new byte[18];
        rng.nextBytes(adderBytes);
        char[] adder = BinaryConverter.byteArrayToCharArray(adderBytes);
        byte[] maskBytes = new byte[14];
        rng.nextBytes(maskBytes);
        char[] mask = BinaryConverter.byteArrayToCharArray(maskBytes);
        char[] infoBytes = AS400JDBCDataSource.xencode(adder, mask, info);
        char[] returnBytes = new char[info.length + 16];
        System.arraycopy(adder, 0, returnBytes, 0, 9);
        System.arraycopy(mask, 0, returnBytes, 9, 7);
        System.arraycopy(infoBytes, 0, returnBytes, 16, info.length);
        return returnBytes;
    }

    static char[] xpwDeconfuseToChar(char[] info) {
        char[] adder = new char[9];
        System.arraycopy(info, 0, adder, 0, 9);
        char[] mask = new char[7];
        System.arraycopy(info, 9, mask, 0, 7);
        char[] infoBytes = new char[info.length - 16];
        System.arraycopy(info, 16, infoBytes, 0, info.length - 16);
        return AS400JDBCDataSource.xdecode(adder, mask, infoBytes);
    }

    private static char[] xencode(char[] adder, char[] mask, char[] bytes) {
        int i;
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        char[] buf = new char[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(bytes[i] + adder[i % 9]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(buf[i] ^ mask[i % 7]);
        }
        return buf;
    }

    private static char[] xdecode(char[] adder, char[] mask, char[] bytes) {
        int i;
        int length = bytes.length;
        char[] buf = new char[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(mask[i % 7] ^ bytes[i]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(buf[i] - adder[i % 9]);
        }
        return buf;
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCDataSource", "javax.sql.DataSource"};
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public int getEnableClientAffinitiesList() {
        return this.properties_.getInt(93);
    }

    public void setEnableClientAffinitiesList(int setting) {
        String property = "enableClientAffinitiesList";
        int old = this.getEnableClientAffinitiesList();
        this.properties_.setString(93, "" + setting);
        this.changes_.firePropertyChange(property, old, setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getAffinityFailbackInterval() {
        return this.properties_.getInt(99);
    }

    public void setAffinityFailbackInterval(int setting) {
        String property = "affinityFailbackInterval";
        int old = this.getAffinityFailbackInterval();
        this.properties_.setString(99, "" + setting);
        this.changes_.firePropertyChange(property, old, setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public String getClientRerouteAlternateServerName() {
        return this.properties_.getString(94);
    }

    public void setClientRerouteAlternateServerName(String alternateServerName) {
        String property = "clientRerouteAlternateServerName";
        if (alternateServerName == null) {
            throw new NullPointerException(property);
        }
        String old = this.getClientRerouteAlternateServerName();
        this.properties_.setString(94, alternateServerName);
        this.changes_.firePropertyChange(property, old, alternateServerName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + alternateServerName);
        }
    }

    public String getClientRerouteAlternatePortNumber() {
        return this.properties_.getString(95);
    }

    public void setClientRerouteAlternatePortNumber(String alternatePortNumber) {
        String property = "clientRerouteAlternatePortNumber";
        if (alternatePortNumber == null) {
            throw new NullPointerException(property);
        }
        String old = this.getClientRerouteAlternatePortNumber();
        this.properties_.setString(95, alternatePortNumber);
        this.changes_.firePropertyChange(property, old, alternatePortNumber);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + alternatePortNumber);
        }
    }

    public int getMaxRetriesForClientReroute() {
        return this.properties_.getInt(96);
    }

    public void setMaxRetriesForClientReroute(int setting) {
        String property = "maxRetriesForClientReroute";
        int old = this.getMaxRetriesForClientReroute();
        this.properties_.setString(96, "" + setting);
        this.changes_.firePropertyChange(property, old, setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getRetryIntervalForClientReroute() {
        return this.properties_.getInt(97);
    }

    public void setRetryIntervalForClientReroute(int setting) {
        String property = "retryIntervalForClientReroute";
        int old = this.getRetryIntervalForClientReroute();
        this.properties_.setString(97, "" + setting);
        this.changes_.firePropertyChange(property, old, setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getEnableSeamlessFailover() {
        return this.properties_.getInt(98);
    }

    public void setEnableSeamlessFailover(int setting) {
        String property = "enableSeamlessFailover";
        int old = this.getEnableSeamlessFailover();
        this.properties_.setString(98, "" + setting);
        this.changes_.firePropertyChange(property, old, setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }
}

