/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.sql.Timestamp;
import java.util.Date;

public class AS400JDBCTimestamp
extends Timestamp {
    static final String copyright = "Copyright (C) 2012-2013 International Business Machines Corporation and others.";
    private static final long serialVersionUID = 1L;
    long picos_ = (long)super.getNanos() * 1000L;
    int length_;

    public AS400JDBCTimestamp(long time, int length) {
        super(time);
        this.length_ = length;
    }

    public AS400JDBCTimestamp(long time) {
        super(time);
        this.length_ = 32;
    }

    public long getPicos() {
        return this.picos_;
    }

    public void setPicos(long picos) {
        this.picos_ = picos;
        super.setNanos((int)(this.picos_ / 1000L));
    }

    @Override
    public int getNanos() {
        return (int)(this.getPicos() / 1000L);
    }

    @Override
    public void setNanos(int nanos) {
        this.setPicos((long)nanos * 1000L);
        super.setNanos(nanos);
    }

    @Override
    public String toString() {
        String nonFractional = super.toString();
        StringBuffer sb = new StringBuffer();
        int dotIndex = nonFractional.indexOf(46);
        if (dotIndex > 0) {
            nonFractional = nonFractional.substring(0, dotIndex);
        }
        sb.append(nonFractional);
        if (this.length_ >= 20 && this.picos_ != 0L) {
            sb.append(".");
            int currentLength = 20;
            for (long digitPlace = 100000000000L; currentLength < this.length_ && digitPlace > 0L; ++currentLength, digitPlace /= 10L) {
                char digit = (char)(48L + this.picos_ / digitPlace % 10L);
                sb.append(digit);
            }
            while (sb.charAt(sb.length() - 1) == '0') {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    @Override
    public void setTime(long millis) {
        super.setTime(millis);
        this.picos_ = (long)super.getNanos() * 1000L;
    }

    @Override
    public boolean equals(Timestamp ts) {
        return this.compareTo(ts) == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Timestamp) {
            return this.equals((Timestamp)obj);
        }
        return false;
    }

    @Override
    public boolean before(Timestamp ts) {
        return this.compareTo(ts) < 0;
    }

    @Override
    public boolean after(Timestamp ts) {
        return this.compareTo(ts) > 0;
    }

    @Override
    public int compareTo(Timestamp ts) {
        long otherTime;
        long thisTime = this.getTime();
        if (thisTime != (otherTime = ts.getTime())) {
            if (thisTime < otherTime) {
                return -1;
            }
            return 1;
        }
        long otherPicos = ts instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)ts).getPicos() : (long)(ts.getNanos() * 1000);
        if (this.picos_ == otherPicos) {
            return 0;
        }
        if (this.picos_ < otherPicos) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Date o) {
        return this.compareTo((Timestamp)o);
    }

    public static Timestamp valueOf(String inString) {
        AS400JDBCTimestamp returnTimestamp = null;
        if (inString != null) {
            inString = inString.trim();
        }
        if (inString == null || inString.length() <= 29) {
            return Timestamp.valueOf(inString);
        }
        Timestamp ts = Timestamp.valueOf(inString.substring(0, 29));
        Object picoString = inString.substring(29);
        int picoStringLength = ((String)picoString).length();
        if (picoStringLength == 1) {
            picoString = (String)picoString + "00";
        } else if (picoStringLength == 2) {
            picoString = (String)picoString + "0";
        } else if (picoStringLength > 3) {
            picoString = ((String)picoString).substring(0, 3);
        }
        long picos = Integer.parseInt((String)picoString);
        if (picos == 0L) {
            return ts;
        }
        returnTimestamp = new AS400JDBCTimestamp(ts.getTime());
        returnTimestamp.setPicos(picos += 1000L * (long)ts.getNanos());
        return returnTimestamp;
    }
}

