/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;

class PxEventSupport {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Hashtable idToListeners_ = new Hashtable();

    PxEventSupport() {
    }

    public boolean addListener(long proxyId, EventListener listener) {
        boolean first = true;
        Object key = PxEventSupport.toKey(proxyId);
        if (this.idToListeners_.containsKey(key)) {
            Vector listeners = (Vector)this.idToListeners_.get(key);
            Class<?> listenerClass = listener.getClass();
            Enumeration list = listeners.elements();
            while (list.hasMoreElements() && first) {
                if (!list.nextElement().getClass().equals(listenerClass)) continue;
                first = false;
            }
            listeners.addElement(listener);
        } else {
            Vector<EventListener> listeners = new Vector<EventListener>();
            listeners.addElement(listener);
            this.idToListeners_.put(key, listeners);
        }
        return first;
    }

    public void fireEvent(long proxyId, String listenerInterfaceName, String listenerMethodName, EventObject eventObject) throws InvocationTargetException {
        Object key = PxEventSupport.toKey(proxyId);
        if (this.idToListeners_.containsKey(key)) {
            Vector listeners = (Vector)this.idToListeners_.get(key);
            Enumeration list = listeners.elements();
            while (list.hasMoreElements()) {
                Object listener = list.nextElement();
                try {
                    Class<?> interfaze = Class.forName(listenerInterfaceName);
                    Method listenerMethod = interfaze.getMethod(listenerMethodName, eventObject.getClass());
                    listenerMethod.invoke(listener, eventObject);
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "ClassNotFoundException while firing event", (Throwable)e);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
                catch (NoSuchMethodException e) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "NoSuchMethodException while firing event", (Throwable)e);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
                catch (IllegalAccessException e) {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "IllegalAccessException while firing event", (Throwable)e);
                    }
                    throw new ExtendedIllegalStateException(10);
                }
            }
        }
    }

    public void removeAll(long proxyId) {
        Object key = PxEventSupport.toKey(proxyId);
        if (this.idToListeners_.containsKey(key)) {
            Vector listeners = (Vector)this.idToListeners_.get(key);
            listeners.removeAllElements();
            this.idToListeners_.remove(key);
        }
    }

    public boolean removeListener(long proxyId, EventListener listener) {
        boolean last = true;
        Object key = PxEventSupport.toKey(proxyId);
        if (this.idToListeners_.containsKey(key)) {
            Vector listeners = (Vector)this.idToListeners_.get(key);
            listeners.removeElement(listener);
            Class<?> listenerClass = listener.getClass();
            Enumeration list = listeners.elements();
            while (list.hasMoreElements() && last) {
                if (!list.nextElement().getClass().equals(listenerClass)) continue;
                last = false;
            }
        } else {
            last = false;
        }
        return last;
    }

    private static Object toKey(long proxyId) {
        return proxyId;
    }
}

