/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLArray;
import com.ibm.as400.access.SQLBigint;
import com.ibm.as400.access.SQLBinary;
import com.ibm.as400.access.SQLBlob;
import com.ibm.as400.access.SQLBlobLocator;
import com.ibm.as400.access.SQLBoolean;
import com.ibm.as400.access.SQLChar;
import com.ibm.as400.access.SQLCharForBitData;
import com.ibm.as400.access.SQLClob;
import com.ibm.as400.access.SQLClobLocator;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDBClob;
import com.ibm.as400.access.SQLDBClobLocator;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDatalink;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLDecFloat16;
import com.ibm.as400.access.SQLDecFloat34;
import com.ibm.as400.access.SQLDecimal;
import com.ibm.as400.access.SQLDecimal2;
import com.ibm.as400.access.SQLDouble;
import com.ibm.as400.access.SQLGraphic;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.SQLLongVarchar;
import com.ibm.as400.access.SQLLongVarcharForBitData;
import com.ibm.as400.access.SQLLongVargraphic;
import com.ibm.as400.access.SQLNChar;
import com.ibm.as400.access.SQLNClob;
import com.ibm.as400.access.SQLNClobLocator;
import com.ibm.as400.access.SQLNVarchar;
import com.ibm.as400.access.SQLNumeric;
import com.ibm.as400.access.SQLNumeric2;
import com.ibm.as400.access.SQLReal;
import com.ibm.as400.access.SQLRowID;
import com.ibm.as400.access.SQLSmallint;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import com.ibm.as400.access.SQLVarbinary;
import com.ibm.as400.access.SQLVarchar;
import com.ibm.as400.access.SQLVarcharForBitData;
import com.ibm.as400.access.SQLVargraphic;
import com.ibm.as400.access.SQLXMLLocator;
import com.ibm.as400.access.Trace;
import java.math.BigDecimal;
import java.sql.SQLException;

class SQLDataFactory {
    SQLDataFactory() {
    }

    static String convertScientificNotation(String scientificNotation, SQLConversionSettings settings) {
        int e;
        if (settings != null && settings.getDecimalSeparator().equals(",")) {
            scientificNotation = scientificNotation.replace(',', '.');
        }
        if ((e = scientificNotation.indexOf(69)) < 0) {
            return scientificNotation;
        }
        String tempValue = scientificNotation.substring(e + 1);
        if (tempValue.startsWith("+")) {
            tempValue = tempValue.substring(1);
        }
        int exponent = Integer.parseInt(tempValue);
        boolean sign = scientificNotation.charAt(0) != '-';
        Object mantissa = scientificNotation.substring(sign ? 0 : 1, e);
        int index = ((String)mantissa).indexOf(46);
        if (index == -1) {
            mantissa = (String)mantissa + ".0";
            index = ((String)mantissa).indexOf(46);
        }
        StringBuffer buffer = new StringBuffer();
        if (exponent >= 0) {
            int length;
            int newLocation = index + exponent;
            buffer.append(((String)mantissa).substring(0, index));
            buffer.append(((String)mantissa).substring(index + 1));
            mantissa = buffer.toString();
            for (length = ((String)mantissa).length(); length < newLocation; ++length) {
                buffer.append("0");
            }
            if (length > newLocation) {
                Object temp = buffer.toString().substring(0, newLocation);
                temp = (String)temp + ".";
                temp = (String)temp + buffer.toString().substring(newLocation);
                buffer = new StringBuffer((String)temp);
            } else {
                buffer.append(".0");
            }
        } else if (-exponent - index > 0) {
            buffer.append("0.");
            for (int i = 0; i < -exponent - index; ++i) {
                buffer.append("0");
            }
            buffer.append(((String)mantissa).substring(0, index));
            buffer.append(((String)mantissa).substring(index + 1));
        } else {
            Object temp = ((String)mantissa).substring(0, index);
            temp = (String)temp + ((String)mantissa).substring(index + 1);
            buffer.append(((String)temp).substring(0, index + exponent));
            buffer.append('.');
            buffer.append(((String)temp).substring(index + exponent));
        }
        String number = (sign ? "" : "-") + buffer.toString();
        return number;
    }

    static int getScale(Object value) {
        int scale = 0;
        String toString = value.toString();
        int point = toString.indexOf(46);
        if (point != -1) {
            scale = toString.length() - point - 1;
        }
        return scale;
    }

    static int getPrecision(Object value) {
        int precision = 0;
        if (value instanceof Boolean) {
            precision = 1;
        } else {
            String toString = value.toString();
            if (toString.charAt(0) == '-') {
                toString = toString.substring(1);
            }
            int length = toString.length();
            int startIndex = -1;
            int endIndex = length;
            int pointIndex = toString.indexOf(46);
            if (pointIndex >= 0) {
                while (toString.charAt(++startIndex) == '0') {
                }
                while (toString.charAt(--endIndex) == '0') {
                }
            } else {
                startIndex = 0;
                endIndex = length - 1;
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                if (!Character.isDigit(toString.charAt(i))) continue;
                ++precision;
            }
        }
        return precision;
    }

    static int getDecimalPrecision(Object value) {
        int precision = 0;
        if (value instanceof Boolean) {
            precision = 1;
        } else {
            String toString = value.toString();
            if (toString.charAt(0) == '-') {
                toString = toString.substring(1);
            }
            int length = toString.length();
            int startIndex = 0;
            int endIndex = length - 1;
            for (int i = startIndex; i <= endIndex; ++i) {
                if (!Character.isDigit(toString.charAt(i))) continue;
                ++precision;
            }
        }
        return precision;
    }

    static int[] getPrecisionForTruncation(BigDecimal value, int maxSize) {
        int length;
        int precision = 0;
        String toString = value.unscaledValue().toString();
        if (toString.charAt(0) == '-') {
            toString = toString.substring(1);
        }
        int endIndex = length = toString.length();
        while (toString.charAt(--endIndex) == '0' && endIndex > maxSize) {
        }
        int numberZeros = length - endIndex - 1;
        precision = endIndex == maxSize ? (toString.charAt(endIndex) == '0' ? endIndex : endIndex + 1) : endIndex + 1;
        int[] retVal = new int[]{precision, ++numberZeros};
        return retVal;
    }

    static SQLData newData(AS400JDBCConnection connection, int id, int nativeType, int length, int precision, int scale, int ccsid, boolean translateBinary, SQLConversionSettings settings, int lobMaxSize, int columnIndex, int dateFormat, int timeFormat, int compositeContentType, int xmlCharType) throws SQLException {
        if (Trace.traceJDBC_) {
            Trace.log(1, "SQLDataFactory.newData(nativeType=" + nativeType + ",length=" + length + ",precision=" + precision + ",scale=" + scale + ",ccsid=" + ccsid + ")");
        }
        switch (nativeType) {
            case 384: {
                if (compositeContentType == 0) {
                    dateFormat = 5;
                }
                return new SQLDate(settings, dateFormat);
            }
            case 388: {
                return new SQLTime(settings, timeFormat);
            }
            case 392: {
                return new SQLTimestamp(length, settings);
            }
            case 396: {
                return new SQLDatalink(length - 2, settings);
            }
            case 404: {
                return new SQLBlob(length - 4, settings);
            }
            case 408: {
                if (ccsid == 65535 && !translateBinary) {
                    return new SQLBlob(length - 4, settings);
                }
                return new SQLClob(length - 4, settings);
            }
            case 412: {
                SQLDBClob dbclob = new SQLDBClob(length - 4, settings);
                dbclob.setCcsid(ccsid);
                return dbclob;
            }
            case 448: {
                if (ccsid == 65535 && !translateBinary) {
                    return new SQLVarcharForBitData(length - 2, settings);
                }
                return new SQLVarchar(length - 2, settings);
            }
            case 456: {
                if (ccsid == 65535 && !translateBinary) {
                    return new SQLLongVarcharForBitData(length - 2, settings);
                }
                return new SQLLongVarchar(length - 2, settings);
            }
            case 452: {
                if (ccsid == 65535 && !translateBinary) {
                    return new SQLCharForBitData(length, settings);
                }
                return new SQLChar(length, settings);
            }
            case 464: {
                if (ccsid == 65535) {
                    return new SQLVargraphic((length - 2) / 2, settings, ccsid);
                }
                if (ccsid == 1200) {
                    return new SQLNVarchar(length - 2, settings);
                }
                return new SQLVargraphic(length - 2, settings, ccsid);
            }
            case 472: {
                return new SQLLongVargraphic(length - 2, settings, ccsid);
            }
            case 468: {
                if (ccsid == 65535) {
                    return new SQLGraphic(length / 2, settings, ccsid);
                }
                if (ccsid == 1200) {
                    return new SQLNChar(length, settings);
                }
                return new SQLGraphic(length, settings, ccsid);
            }
            case 480: {
                if (length == 4) {
                    return new SQLReal(settings);
                }
                return new SQLDouble(settings);
            }
            case 484: {
                if (settings != null && !settings.useBigDecimal()) {
                    return new SQLDecimal2(precision, scale, settings, connection.getVRM(), connection.getProperties());
                }
                return new SQLDecimal(precision, scale, settings, connection.getVRM(), connection.getProperties());
            }
            case 488: {
                if (settings != null && !settings.useBigDecimal()) {
                    return new SQLNumeric2(precision, scale, settings, connection.getVRM(), connection.getProperties());
                }
                return new SQLNumeric(precision, scale, settings, connection.getVRM(), connection.getProperties());
            }
            case 492: {
                return new SQLBigint(connection.getVRM(), settings);
            }
            case 496: {
                return new SQLInteger(scale, connection.getVRM(), settings);
            }
            case 500: {
                return new SQLSmallint(scale, connection.getVRM(), settings);
            }
            case 904: {
                return new SQLRowID(settings);
            }
            case 908: {
                return new SQLVarbinary(length - 2, settings);
            }
            case 912: {
                return new SQLBinary(length, settings);
            }
            case 960: {
                return new SQLBlobLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex);
            }
            case 964: {
                if (ccsid == 65535 && !translateBinary) {
                    return new SQLBlobLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex);
                }
                return new SQLClobLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex);
            }
            case 968: {
                if (ccsid == 1200) {
                    SQLNClobLocator nclob = new SQLNClobLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex);
                    return nclob;
                }
                SQLDBClobLocator dbclob = new SQLDBClobLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex);
                dbclob.setCcsid(ccsid);
                return dbclob;
            }
            case 996: {
                if (precision == 16) {
                    return new SQLDecFloat16(settings, connection.getVRM(), connection.getProperties());
                }
                return new SQLDecFloat34(settings, connection.getVRM(), connection.getProperties());
            }
            case 10000: {
                return new SQLArray(length, SQLDataFactory.newData(connection, id, compositeContentType, length, precision, scale, ccsid, translateBinary, settings, lobMaxSize, columnIndex, dateFormat, timeFormat, 0, 0), connection.getVRM());
            }
            case 988: 
            case 2452: {
                if (ccsid == 65535) {
                    xmlCharType = 2;
                }
                return new SQLXMLLocator(connection, id, lobMaxSize, settings, connection.getConverter(ccsid), columnIndex, xmlCharType);
            }
            case 2436: {
                return new SQLBoolean(connection.getVRM(), settings);
            }
        }
        JDError.throwSQLException("HY000", new IllegalArgumentException(Integer.toString(nativeType)));
        return null;
    }

    static SQLData newData(String nativeType, int length, int precision, int scale, int ccsid, SQLConversionSettings settings, int vrm, JDProperties properties) throws SQLException {
        if (properties == null) {
            properties = new JDProperties();
        }
        if (nativeType.equals("BINARY")) {
            if (vrm >= JDUtilities.vrm530) {
                return new SQLBinary(length, settings);
            }
            return new SQLCharForBitData(length, settings);
        }
        if (nativeType.equals("BIGINT")) {
            return new SQLBigint(vrm, settings);
        }
        if (nativeType.equals("BLOB")) {
            return new SQLBlob(length, settings);
        }
        if (nativeType.equals("BINARY LARGE OBJECT")) {
            return new SQLBlob(length, settings);
        }
        if (nativeType.equals("CHAR")) {
            if (ccsid == 65535 && !properties.getBoolean(28)) {
                return new SQLCharForBitData(length, settings);
            }
            return new SQLChar(length, settings);
        }
        if (nativeType.equals("CHARACTE")) {
            if (ccsid == 65535 && !properties.getBoolean(28)) {
                return new SQLCharForBitData(length, settings);
            }
            return new SQLChar(length, settings);
        }
        if (nativeType.equals("CHARACTER")) {
            if (ccsid == 65535 && !properties.getBoolean(28)) {
                return new SQLCharForBitData(length, settings);
            }
            return new SQLChar(length, settings);
        }
        if (nativeType.equals("CHARACTER VARYING")) {
            if (ccsid == 65535 && !properties.getBoolean(28)) {
                return new SQLVarcharForBitData(length, settings);
            }
            return new SQLVarchar(length, settings);
        }
        if (nativeType.equals("CLOB")) {
            return new SQLClob(length, settings);
        }
        if (nativeType.equals("CHARACTER LARGE OBJECT")) {
            return new SQLClob(length, settings);
        }
        if (nativeType.equals("DATALINK")) {
            return new SQLDatalink(length, settings);
        }
        if (nativeType.equals("DBCLOB")) {
            return new SQLDBClob(length, settings);
        }
        if (nativeType.equals("NCLOB")) {
            return new SQLNClob(length, settings);
        }
        if (nativeType.equals("DOUBLE-BYTE CHARACTER LARGE OBJECT")) {
            return new SQLDBClob(length, settings);
        }
        if (nativeType.equals("DATE")) {
            return new SQLDate(settings, -1);
        }
        if (nativeType.equals("DECIMAL")) {
            if (settings != null && !settings.useBigDecimal()) {
                return new SQLDecimal2(precision, scale, settings, vrm, properties);
            }
            return new SQLDecimal(precision, scale, settings, vrm, properties);
        }
        if (nativeType.equals("DECFLOAT")) {
            if (precision == 16) {
                return new SQLDecFloat16(settings, vrm, properties);
            }
            return new SQLDecFloat34(settings, vrm, properties);
        }
        if (nativeType.equals("DOUBLE")) {
            return new SQLDouble(settings);
        }
        if (nativeType.equals("DOUBLE P")) {
            return new SQLDouble(settings);
        }
        if (nativeType.equals("DOUBLE PRECISION")) {
            return new SQLDouble(settings);
        }
        if (nativeType.equals("FLOAT")) {
            if (length == 4) {
                return new SQLReal(settings);
            }
            return new SQLDouble(settings);
        }
        if (nativeType.equals("GRAPHIC") || nativeType.equals("NCHAR")) {
            return new SQLGraphic(length, settings, ccsid);
        }
        if (nativeType.equals("GRAPHIC VARYING")) {
            return new SQLVargraphic(length, settings, ccsid);
        }
        if (nativeType.equals("INTEGER")) {
            return new SQLInteger(vrm, settings);
        }
        if (nativeType.equals("NUMERIC")) {
            if (settings != null && !settings.useBigDecimal()) {
                return new SQLNumeric2(precision, scale, settings, vrm, properties);
            }
            return new SQLNumeric(precision, scale, settings, vrm, properties);
        }
        if (nativeType.equals("REAL")) {
            return new SQLReal(settings);
        }
        if (nativeType.equals("ROWID")) {
            return new SQLRowID(settings);
        }
        if (nativeType.equals("SMALLINT")) {
            return new SQLSmallint(vrm, settings);
        }
        if (nativeType.equals("TIME")) {
            return new SQLTime(settings, -1);
        }
        if (nativeType.equals("TIMESTAM")) {
            return new SQLTimestamp(length, settings);
        }
        if (nativeType.equals("TIMESTAMP")) {
            return new SQLTimestamp(length, settings);
        }
        if (nativeType.equals("TIMESTMP")) {
            return new SQLTimestamp(length, settings);
        }
        if (nativeType.equals("VARBINARY")) {
            if (vrm >= JDUtilities.vrm530) {
                return new SQLVarbinary(length, settings);
            }
            return new SQLVarcharForBitData(length, settings);
        }
        if (nativeType.equals("VARBIN")) {
            if (vrm >= JDUtilities.vrm530) {
                return new SQLVarbinary(length, settings);
            }
            return new SQLVarcharForBitData(length, settings);
        }
        if (nativeType.equals("BINARY VARYING")) {
            if (vrm >= JDUtilities.vrm530) {
                return new SQLVarbinary(length, settings);
            }
            return new SQLVarcharForBitData(length, settings);
        }
        if (nativeType.equals("VARCHAR")) {
            if (ccsid == 65535 && !properties.getBoolean(28)) {
                return new SQLVarcharForBitData(length, settings);
            }
            return new SQLVarchar(length, settings);
        }
        if (nativeType.equals("VARG")) {
            return new SQLVargraphic(length, settings, ccsid);
        }
        if (nativeType.equals("VARGRAPH")) {
            return new SQLVargraphic(length, settings, ccsid);
        }
        if (nativeType.equals("VARGRAPHIC") || nativeType.equals("NVARCHAR")) {
            return new SQLVargraphic(length, settings, ccsid);
        }
        if (nativeType.equals("ARRAY")) {
            return new SQLArray(length, SQLDataFactory.newData(nativeType, length, precision, scale, ccsid, settings, vrm, properties), vrm);
        }
        if (nativeType.equals("BOOLEAN")) {
            return new SQLBoolean(vrm, settings);
        }
        JDError.throwSQLException("HY000", new IllegalArgumentException(nativeType));
        return null;
    }

    public static BigDecimal truncatePrecision(BigDecimal bd, int precision) {
        boolean positive = bd.longValue() > 0L;
        StringBuffer buffer = new StringBuffer(positive ? "" : "-");
        buffer.append(bd.toString().substring(positive ? precision : precision + 1));
        return new BigDecimal(buffer.toString());
    }

    public static String truncateScale(String value, int scale) {
        int point = value.indexOf(46);
        if (point >= 0) {
            StringBuffer buffer = new StringBuffer(value);
            for (int i = 1; i <= scale; ++i) {
                buffer.append('0');
            }
            return buffer.toString().substring(0, point + scale + 1);
        }
        return value;
    }

    public static long getMaximumLong(int digits) {
        long value = 0L;
        for (int i = 0; i < digits; ++i) {
            value = value * 10L + 9L;
        }
        return value;
    }

    public static String getMaximumString(boolean positive, int precision, int scale) {
        int i;
        int leftDigits;
        StringBuffer sb = new StringBuffer();
        if (!positive) {
            sb.append("-");
        }
        if ((leftDigits = precision - scale) == 0) {
            sb.append("0");
        } else {
            for (i = 0; i < leftDigits; ++i) {
                sb.append("9");
            }
        }
        if (scale > 0) {
            sb.append(".");
            for (i = 0; i < scale; ++i) {
                sb.append("9");
            }
        }
        return sb.toString();
    }

    public static BigDecimal getMaximumBigDecimal(int precision, int scale) {
        if (precision <= 18) {
            return BigDecimal.valueOf(SQLDataFactory.getMaximumLong(precision), scale);
        }
        return new BigDecimal(SQLDataFactory.getMaximumString(true, precision, scale));
    }

    public static BigDecimal getMinimumBigDecimal(int precision, int scale) {
        if (precision <= 18) {
            return BigDecimal.valueOf(-SQLDataFactory.getMaximumLong(precision), scale);
        }
        return new BigDecimal(SQLDataFactory.getMaximumString(false, precision, scale));
    }
}

