/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.jdbcClient;

import com.ibm.as400.access.AS400JDBCSQLSyntaxErrorException;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.jdbcClient.ClientBlob;
import com.ibm.as400.access.jdbcClient.ClientClob;
import com.ibm.as400.access.jdbcClient.ReflectionUtil;
import com.ibm.as400.access.jdbcClient.StringFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.transaction.xa.XAException;

public class Main
implements Runnable {
    public static String[] knownDrivers = new String[]{"com.ibm.as400.access.AS400JDBCDriver", "com.ibm.db2.jdbc.app.DB2Driver", "com.ibm.jtopenlite.database.jdbc.JDBCDriver"};
    private static PrintStream defaultOutput = System.out;
    public static String usage = "Usage:  java -cp jt400.jar  com.ibm.as400.access.jdbcClient.Main <jdbcUrl> <userid> <password>\n        java -jar jt400.jar <jdbcUrl> <userid> <password>";
    public static String[] commandHelp = new String[]{"com.ibm.as400.access.jdbcClient.Main executes SQL commands using a JDBC connection.  ", "  This program is provided AS IS and formal support will NOT be provided.", "  This program should not be used in a production environment.", "", "Parameters are passed to a CALL procedure by using the following ", "CALL ... -- INPARM [p1]....    Calls the stored procedure with the specified parameters", "", "Using CL:  [as400 command] will use QSYS.QCMDEXEC to execute the as400 command ", "", "Besides SQL COMMANDS, the following COMMANDS and SUBCOMMANDS are available", "", "!USAGE                          Displays this information", "!HELP                           Displays this information", "!PREPARE [sql statement]        prepares an sql statement", "!EXECUTEQUERY                   Invokes executeQuery on the prepared statement", "!EXECUTEUPDATE                  Invokes executeUpdate on the prepared statement", "!SETPARM [index],[value]        Sets the parameter for the sql statement", "!SETPARMFROMVAR [index],[var]   Sets the parameter using a variable", "!SETRESULTSETTYPE [..]          Sets the results set type for prepare", "!SETRESULTSETCONCURRENCY [..]   ..", "!SETRESULTSETHOLDABILITY [..]   ..", "!REUSE STATEMENT [true|false]   Controls whethe the stmt object is reused", "!PROMPT [string]                Set the string to use for the prompt", "!ECHO [string]                  Echos the string", "!ECHOCOMMAND [true|false]       Should the input command be echod.", "!ECHOCOMMENTS [true|false]      Should the comments be echod.", "!PRINTSTACKTRACE [true|false]   Should the stack trace be printed for SQLExceptions.", "-- [string]                     Specifies a comment", "!SETQUERYTIMEOUT [number]       Sets the query timeout for subsequent statements", "!RESET CONNECTION PROPERTIES    Resets connection properties", "!ADD CONNECTION PROPERTY        Set properties to be used on subsequent connects", "!REUSE CONNECTION [true|false]  Should the connection be reused by connect to ", "!CONNECT TO URL [URL] [USERID=..] [PASSWORD=...]  Connect using the URL", "!CONNECT TO SCHEMA [schema]            Reconnect using the current URL to the specified schema", "!CONNECT RESET                  Closes the current connection", "!EXISTFILE                      Indicates if the specified file exists (on the client)", "!GC                             Force the Java garbage collector to run", "!OUTPUT FORMAT [xml | html]     Set the output format to include XML or HTML", "!SHOWMIXEDUX [true | false]     Set if mixed UX strings will be displayed", "!SET AUTOCOMMIT [true|false]    Sets the autocommit value", "!SET TRANSACTIONISOLATION [VALUE] Sets the autocommit value", "                                 Supported values are ", "                               TRANSACTION_READ_UNCOMMITTED", "                               TRANSACTION_READ_COMMITTED", "                               TRANSACTION_REPEATABLE_READ", "                               TRANSACTION_SERIALIZABLE", "!GETSERVERJOBNAME               Returns connection.getServerJobName", "!CLOSESTATEMENTRS [on|off]      Close statement and result set after execution of query default off", "!MEASUREEXECUTE [on|off]        Measure time to do execute", "!CHARACTERDETAILS [on|off]      Turn on to see entire character details -- default of off", "!MANUALFETCH [on|off]           Set if manual fetch operations should be used", "!RS.NEXT,!RS.FIRST, !RS.LAST, !RS.PREVIOUS, !RS.ABSOLUTE pos, !RS.RELATIVE pos, !RS.BEFOREFIRST, !RS.AFTERLAST", "                               Call rs.next,... for manually fetching", "!DMD.GETCOLUMNS catalog, schemaPattern, tableNamePattern, columnNamePattern ", "!DMD.GETTABLES catalog, schemaPattern, tableNamePattern, type1 | type2", "!DMD.GETINDEXINFO catalog, schema, table, booleanUnique, booleanApproximate ", "!DMD.GETSCHEMAS", "!HISTORY.CLEAR                    Clears the stored history", "!HISTORY.SHOW                     Shows the history of commands", "!SETCLITRACE [true|false]         Sets CLI tracing for native JDBC driver -- valid V5R5 and later", "!SETDB2TRACE [0|1|2|3|4]          Sets jdbc tracing for native JDBC driver  -- valid V5R5 and later", "!SYSTEMDEBUGGER                   Starts the system debugger (requires tes.jar on classpath)", "", "Parameters for prepared statements and callable statements may be specified in the following formats", "UX'....'                       Unicode string (in hexadecimal)", "X'....'                        Byte array (in hexademical)", "FILEBLOB=<filename>            A Blob retrieved from the named file", "FILECLOB=<filename>            A clob retrieved from the named file", "SAVEDPARM=<number>             A parameter from a previous CALL statement", "GEN_BYTE_ARRAY+<count>         A generated byte array of count bytes", "GEN_HEX_STRING+<count>         A generated hex string", "GEN_CHAR_ARRAY+<count>C<ccsid> A generated character string", "SQLARRAY[TYPE:e1:e2:...]       A JAVA.SQL.ARRAY type", "                               Types are String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray", "SQLARRAY[Time:e1 e2 ...]       A JAVA.SQL.ARRAY with time blank sep", "SQLARRAY[Timestamp:e1|e2 ...]  A JAVA.SQL.ARRAY with timestamp | sep", "", "The following prefixes are available", "!INVISIBLE:     The command and its results are not echoed", "!SILENT:        The exceptions and warnings from the command are not echoed", "!SILENTRS:      The result sets from the command are not echoed", "", "", "The following 'reflection' based commands are available", "!SETVAR [VARNAME] = [METHODCALL]  Sets a variable use a method.. i.e. ", "                                 SETVAR BLOB = RS.getBlob(1)", "!SETVAR [VARNAME] [PARAMETER SPECIFICATION] Sets a variable using a parameter specification", "!SETNEWVAR [VARNAME] = [CONSTRUCTORCALL]  Sets a variable by calling the contructor", "                                 SETNEWVAR DS = com.ibm.db2.jdbc.app.UDBDataSource()", "!SHOWVARMETHODS [VARNAME]         Shows the methods for a variable", "!CALLMETHOD [METHODCALL]          Calls a method on a variable", "  Hint:  To see a result set use !CALLMETHOD com.ibm.as400.access.jdbcClient.Main.dispResultSet(RS)", "  Hint:  To access an array use  !SETVAR LIST=java.util.Arrays.asList(ARRAYVARIABLE)", "", "!THREAD [COMMAND]                      Runs a command in its own thread.", "!THREADPERSIST [THREADNAME]            Create a thread that persist.", "!THREADEXEC [THREADNAME] [COMMAND]     Execute a command in a persistent thread.", "!REPEAT [NUMBER] [COMMAND]             Repeat a command a number of times.", "!EXIT_REPEAT_ON_EXCEPTION [false|true] Exit the repeat if an exception occurs. ", ""};
    String url_;
    String userid_;
    String password_;
    boolean prompt_ = true;
    String promptString_ = ">";
    boolean echoCommand_ = false;
    boolean printStackTrace_ = false;
    boolean exitRepeatOnException_ = false;
    boolean exceptionOccurred_ = false;
    int queryTimeout_ = 0;
    boolean measureExecute_ = false;
    boolean manualFetch_ = false;
    int resultSetType_ = 1003;
    int resultSetConcurrency_ = 1007;
    int resultSetHoldability_ = 1;
    boolean jdk16_ = false;
    private boolean hideWarnings_ = false;
    private boolean toolboxDriver_ = false;
    Connection connection_;
    Statement stmt_;
    private int manualResultSetNumCols_;
    private ResultSet manualResultSet_;
    private String[] manualResultSetColumnLabel_;
    private int showLobThreshold_ = 4096;
    private boolean characterDetails_ = false;
    private int stringSampleSize_ = 256;
    private boolean showMixedUX_;
    private int[] manualResultSetColType_;
    private boolean closeStatementRS_;
    private PreparedStatement pstmt_;
    private String[] savedStringParm_ = new String[256];
    private boolean echoComments_ = false;
    private String urlArgs_ = "";
    private boolean debug_ = false;
    private String conLabel_;
    private CallableStatement cstmt_;
    private String cstmtSql_;
    private Vector threads_ = new Vector();
    boolean html_ = false;
    boolean xml_ = false;
    private boolean silent_;
    private boolean silentrs_;
    private boolean useConnectionPool_ = false;
    private boolean reuseStatement_ = false;
    private Connection poolConnection = null;
    private String poolUserId = null;
    private String poolPassword = null;
    private String poolUrl = null;
    private Hashtable connectionPool = new Hashtable();
    private Hashtable variables = new Hashtable();
    private int conCount;
    private String conName = "CON";
    private Vector history = new Vector();
    String command_;
    PrintStream out_;
    private long startTime_;
    private long finishTime_;

    void initializeDefaults() {
        try {
            String debug = System.getProperty("com.ibm.as400.access.jdbcClient.debug");
            if (debug != null && (debug = debug.toUpperCase()).equals("TRUE")) {
                this.debug_ = true;
            }
        }
        catch (AccessControlException debug) {
            // empty catch block
        }
        try {
            String printStackTrace = System.getProperty("com.ibm.as400.access.jdbcClient.printStackTrace");
            if (printStackTrace != null && (printStackTrace = printStackTrace.toUpperCase()).equals("TRUE")) {
                this.printStackTrace_ = true;
            }
        }
        catch (AccessControlException printStackTrace) {
            // empty catch block
        }
        for (int i = 0; i < knownDrivers.length; ++i) {
            try {
                Class.forName(knownDrivers[i]);
                continue;
            }
            catch (Exception e) {
                if (!(this.debug_ | this.printStackTrace_)) continue;
                e.printStackTrace();
            }
        }
        this.jdk16_ = JVMInfo.isJDK16();
        this.addVariable("MAIN", this);
        String moreDrivers = null;
        try {
            moreDrivers = System.getProperty("com.ibm.as400.access.jdbcClient.drivers");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        while (moreDrivers != null) {
            String loadDriver = null;
            int colonIndex = moreDrivers.indexOf(":");
            if (colonIndex > 0) {
                loadDriver = moreDrivers.substring(0, colonIndex);
                if ((moreDrivers = moreDrivers.substring(colonIndex + 1).trim()).length() == 0) {
                    moreDrivers = null;
                }
            } else {
                loadDriver = moreDrivers;
                moreDrivers = null;
            }
            try {
                Class.forName(loadDriver);
            }
            catch (Exception e) {
                System.out.println("Exception " + e);
                if (!this.debug_ && !this.printStackTrace_) continue;
                e.printStackTrace();
            }
        }
    }

    public Main(String url, String userid, String password) throws SQLException {
        this.initializeDefaults();
        this.setUrl(url);
        this.userid_ = userid;
        this.password_ = password;
        try {
            this.connection_ = DriverManager.getConnection(this.url_, this.userid_, this.password_);
            this.addVariable("CON", this.connection_);
        }
        catch (SQLException ex) {
            System.out.println("Warning:  Exception '" + ex.toString() + "' connecting to " + this.url_ + " using " + this.userid_);
            if (this.printStackTrace_) {
                ex.printStackTrace(System.out);
            }
            System.out.println("CON is not defined");
            this.connection_ = null;
        }
    }

    Main() {
        this.initializeDefaults();
    }

    public static String readLine(BufferedReader input) throws Exception {
        String result = null;
        result = input.readLine();
        if (result != null && result.indexOf("\\u") >= 0) {
            int resultLen = result.length();
            StringBuffer sb = new StringBuffer();
            int startIndex = 0;
            int escapeIndex = result.indexOf("\\u", startIndex);
            while (escapeIndex >= 0) {
                sb.append(result.substring(startIndex, escapeIndex));
                if (escapeIndex + 6 <= resultLen) {
                    try {
                        sb.append(Main.getUnicodeCharacter(result, escapeIndex + 2));
                    }
                    catch (SQLException ioEx) {
                        throw new SQLException("Escape sequence '" + result.substring(escapeIndex, escapeIndex + 6) + "' invalid in " + result);
                    }
                } else {
                    throw new SQLException("Escape sequence '" + result.substring(escapeIndex) + "' invalid in " + result);
                }
                startIndex = escapeIndex + 6;
                escapeIndex = result.indexOf("\\u", startIndex);
            }
            sb.append(result.substring(startIndex));
            result = sb.toString();
        }
        return result;
    }

    private static char getUnicodeCharacter(String result, int index) throws SQLException {
        int c = 0;
        for (int i = 0; i < 4; ++i) {
            char digit = result.charAt(index + i);
            c = c * 16 + Main.hexValue(digit);
        }
        return (char)c;
    }

    private static int hexValue(char digit) throws SQLException {
        switch (digit) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return digit - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return 10 + digit - 97;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return 10 + digit - 65;
            }
        }
        throw new SQLException("invalid escape digit '" + digit + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int go(InputStream in, PrintStream printStreamForGo) {
        int rc = 0;
        boolean running = true;
        PrintStream savedPrintStream = defaultOutput;
        defaultOutput = printStreamForGo;
        try {
            String query;
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            if (this.prompt_) {
                printStreamForGo.print(this.promptString_);
            }
            try {
                query = Main.readLine(input);
                if (query == null) {
                    running = false;
                }
            }
            catch (SQLException sqlex) {
                printStreamForGo.println("Exception reading: " + sqlex.toString());
                if (this.printStackTrace_) {
                    sqlex.printStackTrace(printStreamForGo);
                }
                query = null;
            }
            while (running) {
                if (query != null) {
                    running = this.executeTopLevelCommand(query, printStreamForGo);
                }
                if (!running) continue;
                if (this.prompt_) {
                    printStreamForGo.print(this.promptString_);
                }
                try {
                    query = Main.readLine(input);
                    if (query != null) {
                        query = query.trim();
                        continue;
                    }
                    running = false;
                }
                catch (SQLException sqlex) {
                    printStreamForGo.println("Exception reading: " + sqlex.toString());
                    if (this.printStackTrace_) {
                        sqlex.printStackTrace(printStreamForGo);
                    }
                    query = null;
                }
            }
            if (this.connection_ != null) {
                this.connection_.close();
                this.cstmt_ = null;
                this.cstmtSql_ = "";
                this.variables.remove("CSTMT");
            }
            this.connection_ = null;
            this.variables.remove("CON");
        }
        catch (Exception e) {
            printStreamForGo.println("Outermost Exception " + e);
            if (this.printStackTrace_) {
                e.printStackTrace(printStreamForGo);
            }
        }
        catch (UnknownError jlu) {
            printStreamForGo.println("Outermost UnknownError " + jlu);
            if (this.printStackTrace_) {
                jlu.printStackTrace(printStreamForGo);
            }
        }
        finally {
            defaultOutput = savedPrintStream;
        }
        return rc;
    }

    public Main(Main originalMain, String command, PrintStream out) {
        this.inheritVariables(originalMain);
        this.command_ = command;
        this.out_ = out;
    }

    private void inheritVariables(Main originalMain) {
        this.variables = originalMain.variables;
        this.url_ = originalMain.url_;
        this.userid_ = originalMain.userid_;
        this.password_ = originalMain.password_;
        this.prompt_ = originalMain.prompt_;
        this.echoCommand_ = originalMain.echoCommand_;
        this.exitRepeatOnException_ = originalMain.exitRepeatOnException_;
        this.printStackTrace_ = originalMain.printStackTrace_;
        this.queryTimeout_ = originalMain.queryTimeout_;
        this.measureExecute_ = originalMain.measureExecute_;
        this.manualFetch_ = originalMain.manualFetch_;
        this.resultSetType_ = originalMain.resultSetType_;
        this.resultSetConcurrency_ = originalMain.resultSetConcurrency_;
        this.resultSetHoldability_ = originalMain.resultSetHoldability_;
        this.jdk16_ = originalMain.jdk16_;
        this.hideWarnings_ = originalMain.hideWarnings_;
        this.toolboxDriver_ = originalMain.toolboxDriver_;
        this.connection_ = originalMain.connection_;
        this.stmt_ = originalMain.stmt_;
        this.manualResultSetNumCols_ = originalMain.manualResultSetNumCols_;
        this.manualResultSet_ = originalMain.manualResultSet_;
        this.manualResultSetColumnLabel_ = originalMain.manualResultSetColumnLabel_;
        this.showLobThreshold_ = originalMain.showLobThreshold_;
        this.characterDetails_ = originalMain.characterDetails_;
        this.stringSampleSize_ = originalMain.stringSampleSize_;
        this.showMixedUX_ = originalMain.showMixedUX_;
        this.manualResultSetColType_ = originalMain.manualResultSetColType_;
        this.closeStatementRS_ = originalMain.closeStatementRS_;
        this.pstmt_ = originalMain.pstmt_;
        this.savedStringParm_ = originalMain.savedStringParm_;
        this.echoComments_ = originalMain.echoComments_;
        this.urlArgs_ = originalMain.urlArgs_;
        this.debug_ = originalMain.debug_;
        this.conLabel_ = originalMain.conLabel_;
        this.cstmt_ = originalMain.cstmt_;
        this.cstmtSql_ = originalMain.cstmtSql_;
        this.threads_ = originalMain.threads_;
        this.html_ = originalMain.html_;
        this.xml_ = originalMain.xml_;
        this.useConnectionPool_ = originalMain.useConnectionPool_;
        this.reuseStatement_ = originalMain.reuseStatement_;
        this.poolConnection = originalMain.poolConnection;
        this.poolUserId = originalMain.poolUserId;
        this.poolPassword = originalMain.poolPassword;
        this.poolUrl = originalMain.poolUrl;
        this.connectionPool = originalMain.connectionPool;
        this.conCount = originalMain.conCount;
        this.conName = originalMain.conName;
        this.silent_ = originalMain.silent_;
        this.silentrs_ = originalMain.silentrs_;
        this.history = originalMain.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        this.out_.println("Thread " + thisThread + " running " + this.command_);
        String upcaseCommand = this.command_.toUpperCase();
        if (upcaseCommand.startsWith("PERSIST")) {
            this.command_ = null;
            while (this.command_ == null) {
                Main main = this;
                synchronized (main) {
                    while (this.command_ == null) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            this.out_.println("Interrupted Exception : " + e);
                            if (!this.printStackTrace_) continue;
                            e.printStackTrace(this.out_);
                        }
                    }
                }
                upcaseCommand = this.command_.toUpperCase().trim();
                if (upcaseCommand.equals("QUIT") || upcaseCommand.equals("EXIT")) continue;
                this.out_.println("Thread " + thisThread + " running " + this.command_);
                this.executeTopLevelCommand(this.command_, this.out_);
                this.command_ = null;
            }
        } else {
            this.out_.println("Thread " + thisThread + " running " + this.command_);
            this.executeTopLevelCommand(this.command_, this.out_);
            this.out_.println("Thread " + thisThread + " ending");
        }
        this.out_.println("Thread " + thisThread + " ending");
    }

    public synchronized void setCommand(String command) {
        this.command_ = command;
        this.notify();
    }

    public void useConnectionPool(boolean value) {
        this.useConnectionPool_ = value;
    }

    public void setUrl(String newUrl) {
        this.url_ = newUrl;
        if (this.url_.indexOf(":as400:") > 0) {
            this.toolboxDriver_ = true;
        }
    }

    public void setUserId(String newUserId) {
        if (this.debug_) {
            this.out_.println("User ID set to " + newUserId);
        }
        this.userid_ = newUserId;
    }

    public void setPassword(String newpassword) {
        this.password_ = newpassword;
    }

    public String removeProperty(String url, String newProperties) {
        int equalsIndex = newProperties.indexOf("=");
        while (equalsIndex > 0) {
            int semicolonIndex;
            String property = newProperties.substring(0, equalsIndex).trim();
            int propertyIndex = ((String)url).indexOf(property);
            while (propertyIndex > 0) {
                semicolonIndex = ((String)url).indexOf(";", propertyIndex);
                url = semicolonIndex > 0 ? ((String)url).substring(0, propertyIndex).trim() + ((String)url).substring(semicolonIndex + 1).trim() : ((String)url).substring(0, propertyIndex).trim();
                propertyIndex = ((String)url).indexOf(property);
            }
            semicolonIndex = newProperties.indexOf(";", equalsIndex);
            newProperties = semicolonIndex > 0 ? newProperties.substring(semicolonIndex + 1) : "";
            equalsIndex = newProperties.indexOf("=");
        }
        return url;
    }

    public void setManualResultSetColType(ResultSetMetaData rsmd) throws SQLException {
        this.manualResultSetColType_ = new int[this.manualResultSetNumCols_ + 1];
        for (int i = 1; i <= this.manualResultSetNumCols_; ++i) {
            this.manualResultSetColType_[i] = rsmd.getColumnType(i);
        }
    }

    public Connection getPooledConnection(String thisConnectUserId, String thisConnectPassword, String connectUrl, PrintStream out1) throws SQLException {
        if (this.poolConnection != null && thisConnectUserId.equals(this.poolUserId) && thisConnectPassword.equals(this.poolPassword) && connectUrl.equals(this.poolUrl)) {
            this.connection_ = this.poolConnection;
            this.addVariable("CON", this.connection_);
        } else {
            String key;
            if (this.poolConnection != null) {
                key = this.poolUserId + "." + this.poolPassword + "." + this.poolUrl;
                this.connectionPool.put(key, this.poolConnection);
                if (this.debug_) {
                    out1.println("Added connection to pool for " + (String)key);
                }
            }
            key = thisConnectUserId + "." + thisConnectPassword + "." + connectUrl;
            this.connection_ = (Connection)this.connectionPool.get(key);
            if (this.connection_ != null) {
                this.addVariable("CON", this.connection_);
                if (this.debug_) {
                    out1.println("Retrieved connection from pool for " + key);
                }
                this.connectionPool.remove(key);
            } else {
                if (this.debug_) {
                    out1.println("Didn't retrieve connection from pool for " + key);
                }
                this.connection_ = thisConnectUserId.equals("null") && thisConnectPassword.equals("null") ? DriverManager.getConnection(connectUrl) : DriverManager.getConnection(connectUrl, thisConnectUserId, thisConnectPassword);
                this.addVariable("CON", this.connection_);
            }
            this.poolConnection = this.connection_;
            this.poolUserId = thisConnectUserId;
            this.poolPassword = thisConnectPassword;
            this.poolUrl = connectUrl;
        }
        return this.connection_;
    }

    void executeSqlQuery(String command, PrintStream out1) throws Exception {
        this.history.addElement(command);
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                try {
                    this.stmt_.close();
                    this.stmt_ = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.queryTimeout_ != 0) {
            this.stmt_.setQueryTimeout(this.queryTimeout_);
        }
        if (this.stmt_ != null) {
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            ResultSet rs = this.stmt_.executeQuery(command);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                out1.println("EXECUTE TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            SQLWarning warning = this.stmt_.getWarnings();
            if (this.manualFetch_) {
                ResultSetMetaData rsmd = rs.getMetaData();
                this.manualResultSetNumCols_ = rsmd.getColumnCount();
                this.setManualResultSetColType(rsmd);
                this.manualResultSet_ = rs;
                this.addVariable("RS", this.manualResultSet_);
                this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(out1, rs, rsmd, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
            } else {
                this.dispResultSet(out1, rs, false);
                if (warning != null && !this.silent_) {
                    Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
                }
                if (this.closeStatementRS_) {
                    rs.close();
                }
            }
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                out1.println("WITH FETCH TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
        } else {
            out1.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    public void executeCLCommand(String clCommand, PrintStream out1) throws Exception {
        this.history.addElement("CL: " + clCommand);
        int commandSize = clCommand.length();
        String clCommandSize155 = commandSize < 10 ? "000000000" + commandSize + ".00000" : (commandSize < 100 ? "00000000" + commandSize + ".00000" : (commandSize < 1000 ? "0000000" + commandSize + ".00000" : (commandSize < 10000 ? "000000" + commandSize + ".00000" : "00000" + commandSize + ".00000")));
        String command = "CALL QSYS.QCMDEXC('" + clCommand + "    ', " + clCommandSize155 + ")";
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                this.stmt_.close();
                this.stmt_ = null;
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.stmt_ != null) {
            SQLWarning warning;
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(command);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                out1.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((warning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
            }
        } else {
            out1.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeCallCommand(String command, PrintStream out1) throws Exception {
        this.history.addElement(command);
        if (this.connection_ != null) {
            block33: {
                ResultSet rs;
                int parmIndex = command.indexOf("-- INPARM");
                String parms = null;
                if (parmIndex > 0) {
                    parms = command.substring(parmIndex + 9).trim();
                    command = command.substring(0, parmIndex);
                }
                if (!command.equals(this.cstmtSql_)) {
                    this.cstmt_ = this.connection_.prepareCall(command, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                    this.cstmtSql_ = command;
                    this.addVariable("CSTMT", this.cstmt_);
                }
                ParameterMetaData pmd = this.cstmt_.getParameterMetaData();
                int parmCount = pmd.getParameterCount();
                for (int parm = 1; parm <= parmCount; ++parm) {
                    int mode = pmd.getParameterMode(parm);
                    if (mode == 4 || mode == 2) {
                        int type = pmd.getParameterType(parm);
                        switch (type) {
                            case -8: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case 16: 
                            case 2003: 
                            case 2004: {
                                this.cstmt_.registerOutParameter(parm, type);
                                break;
                            }
                            default: {
                                this.cstmt_.registerOutParameter(parm, 12);
                            }
                        }
                    }
                    if (mode != 1 && mode != 2) continue;
                    String thisParm = parms;
                    if (parms != null && (parmIndex = parms.indexOf(",")) >= 0) {
                        thisParm = parms.substring(0, parmIndex).trim();
                        parms = parms.substring(parmIndex + 1).trim();
                    }
                    if (thisParm != null) {
                        this.setParameter(this.cstmt_, thisParm, parm, out1);
                        continue;
                    }
                    out1.println("Warning:  thisParm is null");
                    out1.println("--INPARM not found but num param > 0 ");
                }
                boolean resultSetAvailable = this.cstmt_.execute();
                SQLWarning warning = this.cstmt_.getWarnings();
                if (warning != null) {
                    if (!this.silent_) {
                        Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
                    }
                    if (this.html_) {
                        out1.println("Statement was " + command);
                    }
                }
                block11: for (int parm = 1; parm <= parmCount; ++parm) {
                    int mode = pmd.getParameterMode(parm);
                    if (mode != 4 && mode != 2) continue;
                    int type = pmd.getParameterType(parm);
                    switch (type) {
                        case -8: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            out1.print("Parameter " + parm + " returned ");
                            byte[] bytes = this.cstmt_.getBytes(parm);
                            if (bytes == null) {
                                out1.println("null");
                                continue block11;
                            }
                            if (bytes.length < this.showLobThreshold_) {
                                out1.print("X'");
                                for (int i = 0; i < bytes.length; ++i) {
                                    int unsignedInt = 0xFF & bytes[i];
                                    if (unsignedInt < 16) {
                                        out1.print("0" + Integer.toHexString(unsignedInt));
                                        continue;
                                    }
                                    out1.print(Integer.toHexString(unsignedInt));
                                }
                                out1.println("'");
                                continue block11;
                            }
                            CRC32 checksum = new CRC32();
                            checksum.update(bytes);
                            out1.println("ARRAY[size=" + bytes.length + ",CRC32=" + checksum.getValue() + "]");
                            continue block11;
                        }
                        case 2003: {
                            out1.print("Parameter " + parm + " returned ARRAY ");
                            this.printArray(out1, this.cstmt_.getArray(parm));
                            out1.println();
                            continue block11;
                        }
                        case 16: {
                            out1.print("Parameter " + parm + " returned ");
                            boolean bool = this.cstmt_.getBoolean(parm);
                            if (this.cstmt_.wasNull()) {
                                out1.println("null");
                                continue block11;
                            }
                            if (bool) {
                                out1.println("true");
                                continue block11;
                            }
                            out1.println("false");
                            continue block11;
                        }
                        default: {
                            out1.print("Parameter " + parm + " returned ");
                            this.savedStringParm_[parm] = this.cstmt_.getString(parm);
                            this.printUnicodeString(out1, this.savedStringParm_[parm]);
                            out1.println();
                        }
                    }
                }
                if (resultSetAvailable && (rs = this.cstmt_.getResultSet()) != null) {
                    if (this.manualFetch_) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        this.manualResultSetNumCols_ = rsmd.getColumnCount();
                        this.setManualResultSetColType(rsmd);
                        this.manualResultSet_ = rs;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(out1, rs, rsmd, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                    } else {
                        this.dispResultSet(out1, rs, false);
                        if (this.closeStatementRS_) {
                            rs.close();
                            rs = null;
                        }
                    }
                    if (!this.manualFetch_) {
                        try {
                            while (this.cstmt_.getMoreResults()) {
                                out1.println("<<<< NEXT RESULT SET >>>>>>>");
                                rs = this.cstmt_.getResultSet();
                                this.dispResultSet(out1, rs, false);
                                if (!this.closeStatementRS_) continue;
                                rs.close();
                                rs = null;
                            }
                        }
                        catch (Exception e) {
                            String m = e.toString();
                            if (m.indexOf("implemented") >= 0) break block33;
                            throw e;
                        }
                    }
                }
            }
            if (!this.manualFetch_ && !this.closeStatementRS_) return;
        }
        out1.println("UNABLE to EXECUTE CALL because not connected");
    }

    public void executeSqlCommand(String command, PrintStream out1) throws Exception {
        if (this.connection_ != null) {
            SQLWarning warning;
            if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                if (this.stmt_ != null) {
                    try {
                        this.stmt_.close();
                        this.stmt_ = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                this.addVariable("STMT", this.stmt_);
            }
            if (this.queryTimeout_ != 0) {
                this.stmt_.setQueryTimeout(this.queryTimeout_);
            }
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(command);
            this.history.addElement(command);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                out1.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((warning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
            }
        } else {
            out1.println("UNABLE to EXECUTE because not connected");
        }
    }

    public void processException(SQLException ex, String command, PrintStream out1) {
        if (!this.silent_) {
            out1.println("\n*** SQLException caught ***");
            out1.println("Statement was " + command);
            Throwable t = ex;
            while (t != null) {
                if (t instanceof SQLException) {
                    int thisCode;
                    ex = t;
                    out1.println("SQLState: " + ex.getSQLState());
                    String exMessage = ex.getMessage();
                    exMessage = Main.cleanupMessage(exMessage);
                    out1.println("Message:  " + exMessage);
                    if (t instanceof AS400JDBCSQLSyntaxErrorException) {
                        AS400JDBCSQLSyntaxErrorException see = (AS400JDBCSQLSyntaxErrorException)t;
                        int locationOfSyntaxError = see.getLocationOfSyntaxError();
                        String sqlStatementText = see.getSqlStatementText();
                        out1.println("... Syntax error at " + locationOfSyntaxError + " in " + sqlStatementText);
                        if (locationOfSyntaxError > 0 && sqlStatementText != null) {
                            try {
                                out1.println("... " + sqlStatementText.substring(0, locationOfSyntaxError - 1) + "=====>" + sqlStatementText.substring(locationOfSyntaxError - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    out1.println("Vendor:   " + ex.getErrorCode());
                    if (this.debug_ || this.printStackTrace_) {
                        ex.printStackTrace(out1);
                    }
                    if ((thisCode = ex.getErrorCode()) == -104) {
                        out1.println("\nToken not valid found.  Use !HELP to see what you can do");
                    }
                    if ((t = ex.getNextException()) == null) {
                        try {
                            t = ex.getCause();
                        }
                        catch (Throwable throwable) {}
                    }
                } else if (t != null) {
                    out1.println("Throwable: " + t);
                    if (this.printStackTrace_) {
                        t.printStackTrace(out1);
                    }
                    try {
                        t = t.getCause();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (t != null) {
                    out1.println("Next exception:");
                    continue;
                }
                out1.println("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTopLevelCommand(String command, PrintStream printStreamForTopLevelCommand) {
        boolean returnCode = true;
        this.silent_ = false;
        this.silentrs_ = false;
        if ((command = command.trim()).toUpperCase().startsWith("!INVISIBLE:")) {
            this.silent_ = true;
            command = command.substring(11).trim();
        } else if (this.echoCommand_) {
            printStreamForTopLevelCommand.println(command);
            if (this.html_) {
                printStreamForTopLevelCommand.println("<BR>");
            }
        }
        if (command.toUpperCase().startsWith("!SILENT:")) {
            this.silent_ = true;
            command = command.substring(8).trim();
        }
        if (command.toUpperCase().startsWith("!SILENTRS:")) {
            this.silentrs_ = true;
            command = command.substring(10).trim();
        }
        try {
            String upcaseCommand = command.toUpperCase();
            if (upcaseCommand.startsWith("SELECT") || upcaseCommand.startsWith("VALUES") || upcaseCommand.startsWith("WITH ")) {
                this.executeSqlQuery(command, printStreamForTopLevelCommand);
            } else if (upcaseCommand.startsWith("CL:")) {
                String clCommand = command.substring(3).trim();
                this.executeCLCommand(clCommand, printStreamForTopLevelCommand);
            } else if (upcaseCommand.startsWith("!PROMPT")) {
                if (command.length() > 7) {
                    this.prompt_ = true;
                    this.promptString_ = command.substring(7).trim();
                } else {
                    this.prompt_ = false;
                }
            } else if (upcaseCommand.startsWith("!ECHO") && !upcaseCommand.startsWith("!ECHOCOMMAND") && !upcaseCommand.startsWith("!ECHOCOMMENTS") || upcaseCommand.startsWith("--") || upcaseCommand.startsWith("//") || upcaseCommand.startsWith("/*")) {
                this.history.addElement(command);
                if (this.echoComments_) {
                    printStreamForTopLevelCommand.println(command);
                    if (this.html_) {
                        printStreamForTopLevelCommand.println("<BR>");
                    }
                }
            } else if (upcaseCommand.equals("!QUIT") || upcaseCommand.equals("!EXIT") || upcaseCommand.equals("QUIT") || upcaseCommand.equals("EXIT")) {
                returnCode = false;
            } else if (command.length() > 0 && command.startsWith("!")) {
                command = command.substring(1);
                this.executeCommand(command, printStreamForTopLevelCommand);
            } else if (upcaseCommand.startsWith("CALL ")) {
                this.executeCallCommand(command, printStreamForTopLevelCommand);
            } else if (upcaseCommand.length() != 0) {
                this.executeSqlCommand(command, printStreamForTopLevelCommand);
            }
        }
        catch (SQLException ex) {
            this.exceptionOccurred_ = true;
            this.processException(ex, command, printStreamForTopLevelCommand);
        }
        catch (Exception e) {
            this.exceptionOccurred_ = true;
            printStreamForTopLevelCommand.println("\n*** exception caught *** " + e);
            printStreamForTopLevelCommand.println("Statement was " + command);
            if (this.printStackTrace_) {
                e.printStackTrace(printStreamForTopLevelCommand);
            }
        }
        catch (UnknownError jlu) {
            this.exceptionOccurred_ = true;
            printStreamForTopLevelCommand.println("\n*** java.lang.UnknownError caught ***" + jlu);
            printStreamForTopLevelCommand.println("Statement was " + command);
            if (this.printStackTrace_) {
                jlu.printStackTrace(printStreamForTopLevelCommand);
            }
        }
        finally {
            block49: {
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception e) {
                        printStreamForTopLevelCommand.println("Exception :" + e);
                        if (!this.printStackTrace_) break block49;
                        e.printStackTrace(printStreamForTopLevelCommand);
                    }
                }
            }
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeCommand(String command1, PrintStream printStreamForExecuteCommand) {
        boolean returnCode = true;
        this.silentrs_ = false;
        command1 = command1.trim();
        try {
            String upcaseCommand = command1.toUpperCase();
            if (upcaseCommand.startsWith("PREPARE")) {
                this.history.addElement("!" + command1);
                command1 = command1.substring(7).trim();
                if (this.pstmt_ != null && this.closeStatementRS_) {
                    this.pstmt_.close();
                }
                this.pstmt_ = this.connection_.prepareStatement(command1, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                SQLWarning warning = this.pstmt_.getWarnings();
                if (warning != null && !this.silent_) {
                    Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                }
                this.addVariable("PSTMT", this.pstmt_);
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETRESULTSETTYPE")) {
                this.history.addElement("!" + command1);
                command1 = command1.substring(16).trim();
                if (command1.indexOf("FORWARD_ONLY") >= 0) {
                    this.resultSetType_ = 1003;
                    return returnCode;
                } else if (command1.indexOf("SCROLL_INSENSITIVE") >= 0) {
                    this.resultSetType_ = 1004;
                    return returnCode;
                } else if (command1.indexOf("SCROLL_SENSITIVE") >= 0) {
                    this.resultSetType_ = 1005;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Value of '" + command1 + " not valid use");
                    printStreamForExecuteCommand.println("     FORWARD_ONLY, SCROLL_INSENSITIVE, or SCROLL_SENSITIVE");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETRESULTSETCONCURRENCY")) {
                this.history.addElement("!" + command1);
                command1 = command1.substring(15).trim();
                if (command1.indexOf("READ_ONLY") >= 0) {
                    this.resultSetConcurrency_ = 1007;
                    return returnCode;
                } else if (command1.indexOf("UPDATABLE") >= 0) {
                    this.resultSetConcurrency_ = 1008;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Value of '" + command1 + " not valid. Use");
                    printStreamForExecuteCommand.println(" READ_ONLY or UPDATABLE ");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETRESULTSETHOLDABILITY")) {
                this.history.addElement("!" + command1);
                command1 = command1.substring(15).trim();
                if (command1.indexOf("HOLD") >= 0) {
                    this.resultSetHoldability_ = 1;
                    return returnCode;
                } else if (command1.indexOf("CLOSE") >= 0) {
                    this.resultSetHoldability_ = 2;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Value of '" + command1 + " not valid. Use");
                    printStreamForExecuteCommand.println(" HOLD_CURSORS_OVER_COMMIT or CLOSE_CURSORS_AT_COMMIT");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("EXECUTEQUERY")) {
                this.history.addElement("!" + command1);
                if (this.pstmt_ != null) {
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    ResultSet rs = this.pstmt_.executeQuery();
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStreamForExecuteCommand.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if (this.manualFetch_) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        this.manualResultSetNumCols_ = rsmd.getColumnCount();
                        this.setManualResultSetColType(rsmd);
                        this.manualResultSet_ = rs;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStreamForExecuteCommand, rs, rsmd, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                        return returnCode;
                    } else {
                        this.dispResultSet(printStreamForExecuteCommand, rs, false);
                        SQLWarning warning = this.pstmt_.getWarnings();
                        if (warning != null && !this.silent_) {
                            Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                        }
                        if (!this.closeStatementRS_) return returnCode;
                        rs.close();
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("UNABLE to EXECUTE QUERY because prepared statement does not exist");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("EXECUTEUPDATE")) {
                this.history.addElement("!" + command1);
                if (this.pstmt_ != null) {
                    SQLWarning warning;
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.pstmt_.executeUpdate();
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStreamForExecuteCommand.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((warning = this.pstmt_.getWarnings()) == null || this.silent_) return returnCode;
                    Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("UNABLE to EXECUTE UPDATE because prepared statement does not exist");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETPARMFROMVAR")) {
                this.history.addElement("!" + command1);
                if (this.pstmt_ != null) {
                    int commaIndex = (command1 = command1.substring(14).trim()).indexOf(",");
                    if (commaIndex > 0) {
                        String indexString = command1.substring(0, commaIndex).trim();
                        int index = Integer.parseInt(indexString);
                        String parmString = command1.substring(commaIndex + 1).trim();
                        Object varObject = this.variables.get(parmString);
                        if (varObject != null) {
                            this.pstmt_.setObject(index, varObject);
                            SQLWarning warning = this.pstmt_.getWarnings();
                            if (warning == null || this.silent_) return returnCode;
                            Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                            return returnCode;
                        } else {
                            printStreamForExecuteCommand.println("Unable to find object for variable " + parmString);
                            this.showValidVariables(printStreamForExecuteCommand);
                        }
                        return returnCode;
                    } else {
                        printStreamForExecuteCommand.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("UNABLE to SETPARM because prepared statement does not exist");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETPARM")) {
                this.history.addElement("!" + command1);
                if (this.pstmt_ != null) {
                    int commaIndex = (command1 = command1.substring(7).trim()).indexOf(",");
                    if (commaIndex > 0) {
                        String indexString = command1.substring(0, commaIndex).trim();
                        int index = Integer.parseInt(indexString);
                        String parmString = command1.substring(commaIndex + 1).trim();
                        this.setParameter(this.pstmt_, parmString, index, printStreamForExecuteCommand);
                        return returnCode;
                    } else {
                        printStreamForExecuteCommand.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("UNABLE to SETPARM because prepared statement does not exist");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("ECHO") && !upcaseCommand.startsWith("ECHOCOMMAND") && !upcaseCommand.startsWith("ECHOCOMMENTS") || upcaseCommand.startsWith("--") || upcaseCommand.startsWith("//") || upcaseCommand.startsWith("/*")) {
                this.history.addElement("!" + command1);
                if (!this.echoComments_) return returnCode;
                printStreamForExecuteCommand.println(command1);
                if (!this.html_) return returnCode;
                printStreamForExecuteCommand.println("<BR>");
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETQUERYTIMEOUT")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(16).trim();
                try {
                    this.queryTimeout_ = Integer.parseInt(arg);
                    printStreamForExecuteCommand.println("-->Query timeout set to " + this.queryTimeout_);
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Unable to parse (" + arg + ")");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RESET CONNECTION PROPERTIES")) {
                this.history.addElement("!" + command1);
                this.urlArgs_ = "";
                return returnCode;
            }
            if (upcaseCommand.startsWith("ADD CONNECTION PROPERTY")) {
                this.history.addElement("!" + command1);
                String newProperty = command1.substring(23).trim();
                this.urlArgs_ = this.removeProperty(this.urlArgs_, newProperty);
                this.urlArgs_ = this.urlArgs_ + "; " + newProperty;
                return returnCode;
            }
            if (upcaseCommand.startsWith("CONNECT TO URL")) {
                this.history.addElement("!" + command1);
                if (this.connection_ != null && this.connection_ != this.poolConnection) {
                    this.connection_.close();
                    this.cstmt_ = null;
                    this.cstmtSql_ = "";
                    this.variables.remove("CSTMT");
                }
                String connectUrl = command1.substring(14).trim();
                String thisConnectUserId = null;
                String thisConnectPassword = null;
                int userIdIndex = connectUrl.indexOf("USERID=");
                if (userIdIndex > 0) {
                    int passwordIndex;
                    thisConnectUserId = connectUrl.substring(userIdIndex + 7).trim();
                    connectUrl = connectUrl.substring(0, userIdIndex).trim();
                    int spaceIndex = thisConnectUserId.indexOf(" ");
                    if (spaceIndex >= 0) {
                        thisConnectUserId = thisConnectUserId.substring(0, spaceIndex);
                    }
                    if ((passwordIndex = command1.indexOf("PASSWORD=")) > 0) {
                        thisConnectPassword = command1.substring(passwordIndex + 9).trim();
                        spaceIndex = thisConnectPassword.indexOf(" ");
                        if (spaceIndex > 0) {
                            thisConnectPassword = thisConnectPassword.substring(0, spaceIndex);
                        }
                        if (this.debug_) {
                            printStreamForExecuteCommand.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + connectUrl);
                        }
                        Driver iSeriesDriver = null;
                        try {
                            if (connectUrl.indexOf("jdbc:db2://") >= 0) {
                                if (this.debug_) {
                                    printStreamForExecuteCommand.println("Loading jcc driver");
                                }
                                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                                Driver currentDriver = DriverManager.getDriver(this.url_);
                                if (currentDriver.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2Driver")) {
                                    if (this.debug_) {
                                        printStreamForExecuteCommand.println("removing native driver");
                                    }
                                    iSeriesDriver = currentDriver;
                                    DriverManager.deregisterDriver(iSeriesDriver);
                                }
                            }
                            if (this.useConnectionPool_) {
                                this.connection_ = this.getPooledConnection(thisConnectUserId, thisConnectPassword, connectUrl, printStreamForExecuteCommand);
                            } else {
                                if (this.measureExecute_) {
                                    this.startTime_ = System.currentTimeMillis();
                                }
                                this.connection_ = DriverManager.getConnection(connectUrl, thisConnectUserId, thisConnectPassword);
                                if (this.measureExecute_) {
                                    this.finishTime_ = System.currentTimeMillis();
                                    printStreamForExecuteCommand.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                                }
                                this.addVariable("CON", this.connection_);
                                SQLWarning warning = this.connection_.getWarnings();
                                if (warning != null && !this.silent_) {
                                    Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                                }
                            }
                        }
                        catch (Exception e) {
                            printStreamForExecuteCommand.println("Exception " + e);
                            if (this.printStackTrace_) {
                                e.printStackTrace(printStreamForExecuteCommand);
                            }
                            thisConnectPassword = null;
                        }
                        if (iSeriesDriver != null) {
                            DriverManager.registerDriver(iSeriesDriver);
                        }
                        this.conLabel_ = this.conName;
                        if (this.conCount > 0) {
                            this.conLabel_ = this.conLabel_ + this.conCount;
                        }
                        ++this.conCount;
                    }
                }
                if (thisConnectPassword != null) return returnCode;
                printStreamForExecuteCommand.println("Usage:  CONNECT TO URL [URL] [USERID=XXXX] [PASSWORD=YYYY]");
                printStreamForExecuteCommand.println("  i.e.  CONNECT TO URL jdbc:db2:localhost USERID=MYUSER PASSWORD=XXXXX");
                printStreamForExecuteCommand.println("        CONNECT TO URL jdbc:db2://localhost/*LOCAL USERID=MYUSER PASSWORD=XXXXX");
                printStreamForExecuteCommand.println("        CONNECT TO URL jdbc:db2:SAMPLE\\;transaction isolation=serializable USERID=MYUSER PASSWORD=XXXXXXX");
                return returnCode;
            }
            if (upcaseCommand.startsWith("CONNECT TO SCHEMA")) {
                String connectUrl;
                String schema;
                this.history.addElement("!" + command1);
                if (this.connection_ != null) {
                    if (this.connection_ != this.poolConnection) {
                        this.connection_.close();
                        this.cstmt_ = null;
                        this.cstmtSql_ = "";
                        this.variables.remove("CSTMT");
                    }
                    this.connection_ = null;
                }
                if ((schema = command1.substring(17).trim()).length() > 0) {
                    int slashIndex = schema.indexOf(47);
                    if (slashIndex >= 0) {
                        int colonIndex = this.url_.indexOf(":");
                        colonIndex = this.url_.indexOf(":", colonIndex + 1);
                        String baseUrl = this.url_.substring(0, colonIndex + 1);
                        connectUrl = baseUrl + schema + this.urlArgs_;
                    } else {
                        int semicolonIndex = this.url_.indexOf(";");
                        connectUrl = semicolonIndex < 0 ? this.url_ + "/" + schema + this.urlArgs_ : this.url_.substring(0, semicolonIndex) + "/" + schema + this.url_.substring(semicolonIndex) + this.urlArgs_;
                    }
                } else {
                    connectUrl = this.url_ + this.urlArgs_;
                }
                int cleanIndex = connectUrl.indexOf(" ;");
                while (cleanIndex > 0) {
                    connectUrl = connectUrl.substring(0, cleanIndex) + connectUrl.substring(cleanIndex + 1);
                    cleanIndex = connectUrl.indexOf(" ;");
                }
                if (this.userid_ != null) {
                    if (this.debug_) {
                        printStreamForExecuteCommand.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + connectUrl);
                    }
                    if (this.useConnectionPool_) {
                        this.connection_ = this.getPooledConnection(this.userid_, this.password_, connectUrl, printStreamForExecuteCommand);
                    } else {
                        SQLWarning warning;
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        this.connection_ = DriverManager.getConnection(connectUrl, this.userid_, this.password_);
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            printStreamForExecuteCommand.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if ((warning = this.connection_.getWarnings()) != null && !this.silent_) {
                            Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                        }
                    }
                    this.addVariable("CON", this.connection_);
                } else {
                    if (this.debug_) {
                        printStreamForExecuteCommand.println("Connecting using default id and password to " + connectUrl);
                    }
                    if (this.useConnectionPool_) {
                        this.connection_ = this.getPooledConnection("null", "null", connectUrl, printStreamForExecuteCommand);
                    } else {
                        this.connection_ = DriverManager.getConnection(connectUrl);
                        SQLWarning warning = this.connection_.getWarnings();
                        if (warning != null && !this.silent_) {
                            Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                        }
                    }
                    this.addVariable("CON", this.connection_);
                }
                this.conLabel_ = this.conName;
                if (this.conCount > 0) {
                    this.conLabel_ = this.conLabel_ + this.conCount;
                }
                ++this.conCount;
                int semicolonIndex = schema.indexOf(59);
                if (semicolonIndex > 0) {
                    schema = schema.substring(0, semicolonIndex).trim();
                }
                if (schema.length() <= 0) return returnCode;
                int slashIndex = schema.lastIndexOf("/");
                if (slashIndex >= 0) {
                    schema = schema.substring(slashIndex + 1);
                }
                PreparedStatement pStmt = this.connection_.prepareStatement("SET CURRENT PATH " + schema + ", SYSTEM PATH");
                pStmt.execute();
                pStmt.close();
                return returnCode;
            }
            if (upcaseCommand.startsWith("CONNECT RESET")) {
                this.history.addElement("!" + command1);
                if (this.connection_ == null) return returnCode;
                if (this.connection_ != this.poolConnection) {
                    this.connection_.close();
                    this.cstmt_ = null;
                    this.cstmtSql_ = "";
                    this.variables.remove("CSTMT");
                }
                this.connection_ = null;
                this.variables.remove("CON");
                return returnCode;
            }
            if (upcaseCommand.startsWith("CHARACTERDETAILS")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(16).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.characterDetails_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.characterDetails_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.characterDetails_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.characterDetails_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for CHARACTERDETAILS");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("ECHOCOMMAND")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(11).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.echoCommand_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.echoCommand_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.echoCommand_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.echoCommand_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for ECHOCOMMAND");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("ECHOCOMMENTS")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(12).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.echoComments_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.echoComments_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.echoComments_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.echoComments_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for ECHOCOMMENTS");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("EXIT_REPEAT_ON_EXCEPTION") || upcaseCommand.startsWith("EXIT REPEAT ON EXCEPTION")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(24).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.exitRepeatOnException_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.exitRepeatOnException_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.exitRepeatOnException_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.exitRepeatOnException_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for EXIT REPEAT ON EXCEPTION");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("PRINTSTACKTRACE")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(15).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.printStackTrace_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.printStackTrace_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.printStackTrace_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.printStackTrace_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for PRINTSTACKTRACE");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("CLOSESTATEMENTRS")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(16).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.closeStatementRS_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.closeStatementRS_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.closeStatementRS_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.closeStatementRS_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for closeStatementRS");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("MEASUREEXECUTE")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(14).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.measureExecute_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.measureExecute_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.measureExecute_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.measureExecute_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for measureExecute");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("EXISTFILE")) {
                this.history.addElement("!" + command1);
                String filename = command1.substring(9).trim();
                try {
                    File testFile = new File(filename);
                    if (testFile.exists()) {
                        printStreamForExecuteCommand.println("EXISTFILE " + filename + ": YES");
                        return returnCode;
                    }
                    printStreamForExecuteCommand.println("EXISTFILE " + filename + ": NO");
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("GC")) {
                this.history.addElement("!" + command1);
                this.startTime_ = System.currentTimeMillis();
                System.gc();
                this.finishTime_ = System.currentTimeMillis();
                printStreamForExecuteCommand.println("GC ran in " + (this.finishTime_ - this.startTime_) + " milliseconds");
                return returnCode;
            }
            if (upcaseCommand.startsWith("OUTPUT FORMAT ")) {
                this.history.addElement("!" + command1);
                String format = command1.substring(14).trim().toUpperCase();
                if (format.equals("XML")) {
                    this.xml_ = true;
                    this.html_ = false;
                    return returnCode;
                } else if (format.equals("HTML")) {
                    this.html_ = true;
                    this.xml_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Error.  Did not recognize output format '" + format + "'");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SHOWMIXEDUX ")) {
                this.history.addElement("!" + command1);
                String format = command1.substring(11).trim().toUpperCase();
                if (format.equals("TRUE")) {
                    this.showMixedUX_ = true;
                    return returnCode;
                } else if (format.equals("FALSE")) {
                    this.showMixedUX_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Error.  Did not recognize SHOWMIXEDUX value  '" + format + "'");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("QUIT") || upcaseCommand.startsWith("EXIT")) {
                returnCode = false;
                return returnCode;
            }
            if (upcaseCommand.startsWith("SET AUTOCOMMIT")) {
                this.history.addElement("!" + command1);
                String setting = command1.substring(14).trim();
                if (setting.startsWith("true")) {
                    this.connection_.setAutoCommit(true);
                    return returnCode;
                } else if (setting.startsWith("false")) {
                    this.connection_.setAutoCommit(false);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("SET AUTOCOMMIT:  Didn't understand \"" + setting + "\"");
                    printStreamForExecuteCommand.println("  Usage:  SET AUTOCOMMIT true");
                    printStreamForExecuteCommand.println("          SET AUTOCOMMIT false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("REUSE CONNECTION")) {
                this.history.addElement("!" + command1);
                String setting = command1.substring(16).trim();
                if (setting.startsWith("true")) {
                    this.useConnectionPool_ = true;
                    return returnCode;
                } else if (setting.startsWith("false")) {
                    this.useConnectionPool_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("REUSE CONNECTION:  Didn't understand \"" + setting + "\"");
                    printStreamForExecuteCommand.println("  Usage:  REUSE CONNECTION true");
                    printStreamForExecuteCommand.println("          REUSE CONNECTION false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("REUSE STATEMENT")) {
                this.history.addElement("!" + command1);
                String setting = command1.substring(16).trim();
                if (setting.startsWith("true")) {
                    this.reuseStatement_ = true;
                    return returnCode;
                } else if (setting.startsWith("false")) {
                    this.reuseStatement_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("REUSE STATEMENT:  Didn't understand \"" + setting + "\"");
                    printStreamForExecuteCommand.println("  Usage:  REUSE STATEMENT true");
                    printStreamForExecuteCommand.println("          REUSE STATEMENT false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETCLITRACE")) {
                this.history.addElement("!" + command1);
                boolean b = false;
                boolean ok = false;
                String setting = command1.substring(11).trim();
                if (setting.startsWith("true")) {
                    b = true;
                    ok = true;
                } else if (setting.startsWith("false")) {
                    b = false;
                    ok = true;
                }
                if (ok) {
                    try {
                        Class<?> traceClass = Class.forName("com.ibm.db2.jdbc.app.T");
                        Class[] argClasses = new Class[]{Boolean.TYPE};
                        Method method = traceClass.getMethod("setCliTrace", argClasses);
                        Object[] args = new Object[]{b};
                        method.invoke(null, args);
                        return returnCode;
                    }
                    catch (Exception e) {
                        printStreamForExecuteCommand.println("Exception while setting cli trace");
                        printStreamForExecuteCommand.println("Exception " + e);
                        if (!this.printStackTrace_) return returnCode;
                        e.printStackTrace(printStreamForExecuteCommand);
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("SETCLITRACE:  Didn't understand \"" + setting + "\"");
                    printStreamForExecuteCommand.println("  Usage:  SETCLITRACE true");
                    printStreamForExecuteCommand.println("          SETCLITRACE false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETDB2TRACE")) {
                this.history.addElement("!" + command1);
                try {
                    String setting = command1.substring(11).trim();
                    Class<?> traceClass = Class.forName("com.ibm.db2.jdbc.app.T");
                    Class[] argClasses = new Class[]{Integer.TYPE};
                    Method method = traceClass.getMethod("setDb2Trace", argClasses);
                    Object[] args = new Object[]{setting.startsWith("true") ? Integer.valueOf(3) : (setting.startsWith("false") ? Integer.valueOf(0) : Integer.valueOf(setting))};
                    method.invoke(null, args);
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Exception while setting cli trace");
                    printStreamForExecuteCommand.println("Exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SYSTEMDEBUGGER")) {
                this.history.addElement("!" + command1);
                try {
                    Class<?> utilClass = Class.forName("com.ibm.iseries.debug.util.Util");
                    Class[] argClasses = new Class[]{};
                    Method method = utilClass.getMethod("registerApp", argClasses);
                    Object[] args = new Object[]{};
                    method.invoke(null, args);
                    Class<?> debugClass = Class.forName("utilities.Debug");
                    Class[] mainArgsClasses = new Class[1];
                    args = new Object[1];
                    String[] mainArg = new String[]{"-u", this.getUser(), "-s", this.getSystem(), "-j", this.getServerJobName()};
                    args[0] = mainArg;
                    mainArgsClasses[0] = mainArg.getClass();
                    Method mainMethod = debugClass.getMethod("main", mainArgsClasses);
                    mainMethod.invoke(null, args);
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Exception starting  SYSTEMDEBUGGER");
                    printStreamForExecuteCommand.println("Exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SET TRANSACTIONISOLATION")) {
                this.history.addElement("!" + command1);
                String setting = command1.substring(24).trim();
                if (setting.startsWith("TRANSACTION_READ_UNCOMMITTED")) {
                    this.connection_.setTransactionIsolation(1);
                    return returnCode;
                } else if (setting.startsWith("TRANSACTION_READ_COMMITTED")) {
                    this.connection_.setTransactionIsolation(2);
                    return returnCode;
                } else if (setting.startsWith("TRANSACTION_REPEATABLE_READ")) {
                    this.connection_.setTransactionIsolation(4);
                    return returnCode;
                } else if (setting.startsWith("TRANSACTION_SERIALIZABLE")) {
                    this.connection_.setTransactionIsolation(8);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("SET TRANSACTIONISOLATION:  Didn't understand \"" + setting + "\"");
                    printStreamForExecuteCommand.println("  Usage:  SET TRANSACTIONISOLATION TRANSACTION_READ_UNCOMMITTED");
                    printStreamForExecuteCommand.println("          SET TRANSACTIONISOLATION TRANSACTION_READ_COMMITTED");
                    printStreamForExecuteCommand.println("          SET TRANSACTIONISOLATION TRANSACTION_REPEATABLE_READ");
                    printStreamForExecuteCommand.println("          SET TRANSACTIONISOLATION TRANSACTION_SERIALIZABLE");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("USAGE") || upcaseCommand.startsWith("HELP")) {
                for (int u = 0; u < commandHelp.length; ++u) {
                    printStreamForExecuteCommand.println(commandHelp[u]);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("GETSERVERJOBNAME")) {
                this.history.addElement("!" + command1);
                String jobName = this.getServerJobName();
                printStreamForExecuteCommand.println("getServerJobName returned " + jobName);
                return returnCode;
            }
            if (upcaseCommand.startsWith("DMD.GETCOLUMNS")) {
                this.history.addElement("!" + command1);
                try {
                    String catalog = null;
                    String schemaPattern = null;
                    String tableNamePattern = null;
                    String columnNamePattern = null;
                    DatabaseMetaData dmd = this.connection_.getMetaData();
                    String args = command1.substring(14).trim();
                    int commaIndex = args.indexOf(",");
                    if (commaIndex > 0) {
                        catalog = args.substring(0, commaIndex).trim();
                        if (catalog.equals("null")) {
                            catalog = null;
                        }
                        if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                            schemaPattern = args.substring(0, commaIndex).trim();
                            if (schemaPattern.equals("null")) {
                                schemaPattern = null;
                            }
                            if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                                tableNamePattern = args.substring(0, commaIndex).trim();
                                if (tableNamePattern.equals("null")) {
                                    tableNamePattern = null;
                                }
                                if ((columnNamePattern = args.substring(commaIndex + 1).trim()).equals("null")) {
                                    columnNamePattern = null;
                                }
                            }
                        }
                    }
                    printStreamForExecuteCommand.println("Calling dmd.getColumns(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + columnNamePattern + ")");
                    ResultSet rs = dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
                    if (rs == null) return returnCode;
                    this.dispResultSet(printStreamForExecuteCommand, rs, false);
                    rs.close();
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("databaseMetaData.getColumns failed with exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("DMD.GETTABLES")) {
                this.history.addElement("!" + command1);
                try {
                    String catalog = null;
                    String schemaPattern = null;
                    String tableNamePattern = null;
                    String typePattern = null;
                    String[] types = null;
                    DatabaseMetaData dmd = this.connection_.getMetaData();
                    String args = command1.substring(14).trim();
                    int commaIndex = args.indexOf(",");
                    if (commaIndex > 0) {
                        catalog = args.substring(0, commaIndex).trim();
                        if (catalog.equals("null")) {
                            catalog = null;
                        }
                        if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                            schemaPattern = args.substring(0, commaIndex).trim();
                            if (schemaPattern.equals("null")) {
                                schemaPattern = null;
                            }
                            if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                                tableNamePattern = args.substring(0, commaIndex).trim();
                                if (tableNamePattern.equals("null")) {
                                    tableNamePattern = null;
                                }
                                if ((typePattern = args.substring(commaIndex + 1).trim()).equals("null")) {
                                    typePattern = null;
                                } else {
                                    Vector<String> vectorList = new Vector<String>();
                                    int barIndex = typePattern.indexOf(124);
                                    while (barIndex > 0) {
                                        String thisType = typePattern.substring(0, barIndex);
                                        vectorList.add(thisType);
                                        typePattern = typePattern.substring(1 + barIndex);
                                        barIndex = typePattern.indexOf(124);
                                    }
                                    vectorList.add(typePattern);
                                    int size = vectorList.size();
                                    types = new String[size];
                                    for (int i = 0; i < size; ++i) {
                                        types[i] = (String)vectorList.elementAt(i);
                                    }
                                }
                            }
                        }
                    }
                    printStreamForExecuteCommand.println("Calling dmd.getTables(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + typePattern + "=" + StringFormatUtil.stringArrayContents(types) + ")");
                    ResultSet rs = dmd.getTables(catalog, schemaPattern, tableNamePattern, types);
                    if (rs == null) return returnCode;
                    this.dispResultSet(printStreamForExecuteCommand, rs, false);
                    rs.close();
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("databaseMetaData.getTables failed with exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("DMD.GETINDEXINFO")) {
                this.history.addElement("!" + command1);
                try {
                    String catalog = null;
                    String schema = null;
                    String table = null;
                    boolean booleanUnique = false;
                    boolean booleanApproximate = false;
                    DatabaseMetaData dmd = this.connection_.getMetaData();
                    String args = command1.substring(16).trim();
                    int commaIndex = args.indexOf(",");
                    if (commaIndex > 0) {
                        catalog = args.substring(0, commaIndex).trim();
                        if (catalog.equals("null")) {
                            catalog = null;
                        }
                        if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                            schema = args.substring(0, commaIndex).trim();
                            if (schema.equals("null")) {
                                schema = null;
                            }
                            if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                                table = args.substring(0, commaIndex).trim();
                                if (table.equals("null")) {
                                    table = null;
                                }
                                if ((commaIndex = (args = args.substring(commaIndex + 1)).indexOf(",")) > 0) {
                                    String unique = args.substring(0, commaIndex).trim();
                                    booleanUnique = unique.equalsIgnoreCase("true");
                                    String approximate = args = args.substring(commaIndex + 1);
                                    booleanApproximate = approximate.equalsIgnoreCase("true");
                                }
                            }
                        }
                    }
                    printStreamForExecuteCommand.println("Calling dmd.getIndexInfo(" + catalog + ", " + schema + ", " + table + ", " + booleanUnique + "," + booleanApproximate + ")");
                    ResultSet rs = dmd.getIndexInfo(catalog, schema, table, booleanUnique, booleanApproximate);
                    if (rs == null) return returnCode;
                    this.dispResultSet(printStreamForExecuteCommand, rs, false);
                    rs.close();
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("databaseMetaData.getIndexInfo failed with exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("DMD.GETSCHEMAS")) {
                this.history.addElement("!" + command1);
                try {
                    DatabaseMetaData dmd = this.connection_.getMetaData();
                    printStreamForExecuteCommand.println("Calling dmd.getSchemas()");
                    ResultSet rs = dmd.getSchemas();
                    if (rs == null) return returnCode;
                    this.dispResultSet(printStreamForExecuteCommand, rs, false);
                    rs.close();
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("databaseMetaData.getSchemas failed with exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("HISTORY.CLEAR")) {
                this.history.clear();
                return returnCode;
            }
            if (upcaseCommand.startsWith("HISTORY.SHOW")) {
                Enumeration enumeration = this.history.elements();
                while (enumeration.hasMoreElements()) {
                    String info = (String)enumeration.nextElement();
                    printStreamForExecuteCommand.println(info);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("MANUALFETCH")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(11).trim().toUpperCase();
                if (arg.equals("TRUE")) {
                    this.manualFetch_ = true;
                    return returnCode;
                } else if (arg.equals("ON")) {
                    this.manualFetch_ = true;
                    return returnCode;
                } else if (arg.equals("FALSE")) {
                    this.manualFetch_ = false;
                    return returnCode;
                } else if (arg.equals("OFF")) {
                    this.manualFetch_ = false;
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Invalid arg '" + arg + "' for MANUALFETCH");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.NEXT")) {
                this.history.addElement("!" + command1);
                boolean ok = this.manualResultSet_.next();
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.next returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.FIRST")) {
                this.history.addElement("!" + command1);
                boolean ok = this.manualResultSet_.first();
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.first returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.BEFOREFIRST")) {
                this.history.addElement("!" + command1);
                this.manualResultSet_.beforeFirst();
                printStreamForExecuteCommand.println("rs.beforeFirst called");
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.AFTERLAST")) {
                this.history.addElement("!" + command1);
                this.manualResultSet_.afterLast();
                printStreamForExecuteCommand.println("rs.afterLast called");
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.LAST")) {
                this.history.addElement("!" + command1);
                boolean ok = this.manualResultSet_.last();
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.last returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.PREVIOUS")) {
                this.history.addElement("!" + command1);
                boolean ok = this.manualResultSet_.previous();
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.previous returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.ABSOLUTE")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(11).trim().toUpperCase();
                int pos = Integer.parseInt(arg);
                boolean ok = this.manualResultSet_.absolute(pos);
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.absolute returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("RS.RELATIVE")) {
                this.history.addElement("!" + command1);
                String arg = command1.substring(11).trim().toUpperCase();
                int pos = Integer.parseInt(arg);
                boolean ok = this.manualResultSet_.relative(pos);
                if (ok) {
                    Main.dispRow(printStreamForExecuteCommand, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("rs.relative returned false");
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETVAR")) {
                this.history.addElement("!" + command1);
                try {
                    String left = command1.substring(6).trim();
                    int equalsIndex = left.indexOf("=");
                    if (equalsIndex > 0) {
                        String variableName = left.substring(0, equalsIndex).trim();
                        Object variable = this.callMethod(left = left.substring(equalsIndex + 1), printStreamForExecuteCommand);
                        if (variable != null) {
                            this.addVariable(variableName, variable);
                            printStreamForExecuteCommand.println(variableName + "=" + variable.toString());
                            return returnCode;
                        } else {
                            printStreamForExecuteCommand.println("ERROR:  Method not found or output is null");
                        }
                        return returnCode;
                    }
                    int spaceIndex = left.indexOf(" ");
                    if (spaceIndex > 0) {
                        String variableName = left.substring(0, spaceIndex).trim();
                        Object variable = this.getParameterObject(left = left.substring(spaceIndex + 1), printStreamForExecuteCommand);
                        if (variable != null) {
                            this.addVariable(variableName, variable);
                            printStreamForExecuteCommand.println(variableName + "=" + variable.toString());
                            return returnCode;
                        } else {
                            printStreamForExecuteCommand.println("ERROR:  Unable to get parameter ");
                        }
                        return returnCode;
                    }
                    printStreamForExecuteCommand.println("ERROR:  '=' or ' ' not found after SETVAR [VAR]");
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SETNEWVAR")) {
                this.history.addElement("!" + command1);
                try {
                    String left = command1.substring(9).trim();
                    int equalsIndex = left.indexOf("=");
                    if (equalsIndex > 0) {
                        String variableName = left.substring(0, equalsIndex).trim();
                        Object variable = this.callNewMethod(left = left.substring(equalsIndex + 1), printStreamForExecuteCommand);
                        if (variable != null) {
                            this.addVariable(variableName, variable);
                            printStreamForExecuteCommand.println(variableName + "=" + variable.toString());
                            return returnCode;
                        } else {
                            printStreamForExecuteCommand.println("ERROR:  Method not found or output is null");
                        }
                        return returnCode;
                    }
                    printStreamForExecuteCommand.println("line missing =");
                    return returnCode;
                }
                catch (Exception e) {
                    printStreamForExecuteCommand.println("Exception " + e);
                    if (!this.printStackTrace_) return returnCode;
                    e.printStackTrace(printStreamForExecuteCommand);
                }
                return returnCode;
            }
            if (upcaseCommand.startsWith("SHOWVARMETHODS")) {
                this.history.addElement("!" + command1);
                String left = command1.substring(14).trim();
                this.showMethods(left, printStreamForExecuteCommand);
                return returnCode;
            } else if (upcaseCommand.startsWith("THREAD ")) {
                this.history.addElement("!" + command1);
                String newcommand = command1.substring(7).trim();
                printStreamForExecuteCommand.println("Starting thread for " + newcommand);
                Main runnable = new Main(this, newcommand, printStreamForExecuteCommand);
                Thread t = new Thread(runnable);
                t.start();
                this.threads_.add(t);
                return returnCode;
            } else if (upcaseCommand.startsWith("THREADPERSIST ")) {
                this.history.addElement("!" + command1);
                String threadName = command1.substring(14).trim();
                printStreamForExecuteCommand.println("Starting runnable " + threadName);
                String newcommand = "PERSIST";
                Main runnable = new Main(this, newcommand, printStreamForExecuteCommand);
                this.variables.put(threadName, runnable);
                Thread t = new Thread(runnable);
                t.setName(threadName);
                t.setDaemon(true);
                t.start();
                printStreamForExecuteCommand.println("Started thread " + threadName + "-T");
                this.variables.put(threadName + "-T", t);
                return returnCode;
            } else if (upcaseCommand.startsWith("THREADEXEC ")) {
                this.history.addElement("!" + command1);
                String remaining = command1.substring(11).trim();
                int spaceIndex = remaining.indexOf(32);
                if (spaceIndex > 0) {
                    String threadName = remaining.substring(0, spaceIndex);
                    String threadCommand = remaining.substring(spaceIndex + 1);
                    Main runnable = (Main)this.variables.get(threadName);
                    if (runnable != null) {
                        runnable.setCommand(threadCommand);
                        return returnCode;
                    } else {
                        printStreamForExecuteCommand.println("ERROR: Unable to find thread " + threadName);
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("ERROR:  THREADEXEC: no space after thread name");
                }
                return returnCode;
            } else if (upcaseCommand.startsWith("REPEAT ")) {
                this.history.addElement("!" + command1);
                String left = command1.substring(7).trim();
                int spaceIndex = left.indexOf(" ");
                if (spaceIndex > 0) {
                    int repeatCount = Integer.parseInt(left.substring(0, spaceIndex));
                    if (repeatCount > 0) {
                        String newCommand = left.substring(spaceIndex).trim();
                        int beginCount = repeatCount;
                        int iteration = 1;
                        while (repeatCount > 0) {
                            printStreamForExecuteCommand.println("Iteration " + iteration + " of " + beginCount);
                            ++iteration;
                            this.exceptionOccurred_ = false;
                            this.executeTopLevelCommand(newCommand, printStreamForExecuteCommand);
                            --repeatCount;
                            if (!this.exitRepeatOnException_ || !this.exceptionOccurred_) continue;
                            repeatCount = 0;
                        }
                        return returnCode;
                    } else {
                        printStreamForExecuteCommand.println("Error.. invalid repeat count " + left.substring(0, spaceIndex));
                    }
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("Error.  No count for repeat");
                }
                return returnCode;
            } else if (upcaseCommand.startsWith("CALLMETHOD")) {
                this.history.addElement("!" + command1);
                String left = command1.substring(10).trim();
                Object obj = this.callMethod(left, printStreamForExecuteCommand);
                printStreamForExecuteCommand.println("Call returned " + obj);
                if (obj != null && obj instanceof InputStream) {
                    printStreamForExecuteCommand.println("InputStream[ ");
                    InputStream is = (InputStream)obj;
                    int val = is.read();
                    while (val > 0) {
                        printStreamForExecuteCommand.print(" " + Integer.toHexString(val));
                        val = is.read();
                    }
                    printStreamForExecuteCommand.println("]");
                }
                if (obj == null || !obj.getClass().isArray()) return returnCode;
                int arrayLength = Array.getLength(obj);
                printStreamForExecuteCommand.println("  .. Array of size " + arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    Object obj2 = Array.get(obj, i);
                    if (obj2 instanceof DriverPropertyInfo) {
                        DriverPropertyInfo info = (DriverPropertyInfo)obj2;
                        printStreamForExecuteCommand.println("[" + i + "]=" + info.name + " " + info.value + " " + info.description);
                        continue;
                    }
                    if (obj2 instanceof Byte) {
                        int value = 0xFF & ((Byte)obj2).intValue();
                        printStreamForExecuteCommand.println("[" + i + "]=0x" + Integer.toHexString(value) + " a[" + StringFormatUtil.asciiChar(value) + "] e[" + StringFormatUtil.ebcdicChar(value) + "]");
                        continue;
                    }
                    printStreamForExecuteCommand.println("[" + i + "][" + obj2.getClass().getName() + "]=" + obj2);
                }
                return returnCode;
            } else {
                if (upcaseCommand.length() == 0) return returnCode;
                if (this.connection_ != null) {
                    SQLWarning warning;
                    if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                        if (this.stmt_ != null) {
                            this.stmt_.close();
                            this.stmt_ = null;
                        }
                        this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                        this.addVariable("STMT", this.stmt_);
                    }
                    if (this.queryTimeout_ != 0) {
                        this.stmt_.setQueryTimeout(this.queryTimeout_);
                    }
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.stmt_.executeUpdate(command1);
                    this.history.addElement(command1);
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        printStreamForExecuteCommand.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((warning = this.stmt_.getWarnings()) == null || this.silent_) return returnCode;
                    Main.dispWarning(printStreamForExecuteCommand, warning, this.hideWarnings_, this.html_);
                    return returnCode;
                } else {
                    printStreamForExecuteCommand.println("UNABLE to EXECUTE because not connected");
                }
            }
            return returnCode;
        }
        catch (SQLException ex) {
            this.exceptionOccurred_ = true;
            if (this.silent_) return returnCode;
            this.processException(ex, command1, printStreamForExecuteCommand);
            return returnCode;
        }
        catch (Exception e) {
            this.exceptionOccurred_ = true;
            printStreamForExecuteCommand.println("\n*** exception caught *** " + e);
            printStreamForExecuteCommand.println("Statement was " + command1);
            if (!this.printStackTrace_) return returnCode;
            e.printStackTrace(printStreamForExecuteCommand);
            return returnCode;
        }
        catch (UnknownError jlu) {
            this.exceptionOccurred_ = true;
            printStreamForExecuteCommand.println("\n*** java.lang.UnknownError caught ***" + jlu);
            printStreamForExecuteCommand.println("Statement was " + command1);
            if (!this.printStackTrace_) return returnCode;
            jlu.printStackTrace(printStreamForExecuteCommand);
            return returnCode;
        }
        finally {
            block354: {
                if (this.stmt_ != null) {
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                    }
                    catch (Exception e) {
                        printStreamForExecuteCommand.println("Exception " + e);
                        if (!this.printStackTrace_) break block354;
                        e.printStackTrace(printStreamForExecuteCommand);
                    }
                }
            }
        }
    }

    private String getSystem() throws SQLException {
        String system = "";
        String url = this.connection_.getMetaData().getURL();
        if (url.startsWith("jdbc:as400:")) {
            system = url.substring(11);
            int semicolon = system.indexOf(59);
            if (semicolon > 0) {
                system = system.substring(0, semicolon).replace('/', ' ').trim();
            }
        } else if (url.startsWith("jdbc:db2:")) {
            system = "localhost";
        }
        return system;
    }

    private String getUser() throws Exception {
        return this.connection_.getMetaData().getUserName();
    }

    private String getServerJobName() {
        Object jobName;
        try {
            jobName = ReflectionUtil.callMethod_S(this.connection_, "getServerJobName");
        }
        catch (NoSuchMethodException nsme) {
            try {
                DatabaseMetaData dmd = this.connection_.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("Toolbox") >= 0 || driverName.indexOf("jtopenlite") >= 0) {
                    try {
                        jobName = ReflectionUtil.callMethod_S(this.connection_, "getServerJobIdentifier");
                        if (((String)jobName).length() >= 26) {
                            jobName = ((String)jobName).substring(20).trim() + "/" + ((String)jobName).substring(10, 20).trim() + "/" + ((String)jobName).substring(0, 10).trim();
                        }
                    }
                    catch (Exception e) {
                        return "server jobname is not available";
                    }
                }
                return "getServerJobName:3 failed with exception " + nsme + " for driver " + driverName;
            }
            catch (Exception e) {
                return "getServerJobName:2 failed with 2 exceptions " + nsme + ":" + e;
            }
        }
        catch (Exception e) {
            return "getServerJobName:1 failed with exception " + e;
        }
        return jobName;
    }

    private Object callMethod(String left, PrintStream printStreamForCallMethod) {
        try {
            boolean methodFound = false;
            StringBuffer possibleErrors = new StringBuffer();
            Object variable = null;
            int paramIndex = left.indexOf("(");
            if (paramIndex > 0) {
                int dotIndex = left.lastIndexOf(".", paramIndex);
                if (dotIndex > 0) {
                    String callVariable = left.substring(0, dotIndex).trim();
                    Object callObject = this.variables.get(callVariable);
                    Class<?> callClass = null;
                    left = left.substring(dotIndex + 1).trim();
                    paramIndex = left.indexOf("(");
                    String methodName = left.substring(0, paramIndex).trim();
                    left = left.substring(paramIndex + 1);
                    if (callObject == null) {
                        try {
                            callClass = Class.forName(callVariable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (callObject != null || callClass != null) {
                        if (paramIndex > 0) {
                            Method[] methods = callObject != null ? callObject.getClass().getMethods() : (callClass != null ? callClass.getMethods() : new Method[]{});
                            boolean anyMethodFound = false;
                            for (int m = 0; !methodFound && m < methods.length && variable == null; ++m) {
                                int p = 0;
                                int methodParameterCount = 0;
                                if (!methods[m].getName().equals(methodName)) continue;
                                Class<?>[] parameterTypes = methods[m].getParameterTypes();
                                String argsLeft = left;
                                Object[] parameters = new Object[parameterTypes.length];
                                methodFound = true;
                                anyMethodFound = true;
                                methodParameterCount = parameterTypes.length;
                                Object methodParameters = "";
                                for (p = 0; p < parameterTypes.length; ++p) {
                                    Object[] a;
                                    int arrayCount;
                                    int len;
                                    String arrayString;
                                    int argStartIndex = 0;
                                    int argEndIndex = 0;
                                    int nextArgIndex = 0;
                                    if (argsLeft.length() > 1 && (argsLeft.charAt(0) == '\"' || argsLeft.charAt(0) == '\'')) {
                                        argStartIndex = 1;
                                        argEndIndex = argsLeft.indexOf(argsLeft.charAt(0), 1);
                                        if (argEndIndex > 0) {
                                            if (argsLeft.charAt(argEndIndex + 1) == ',' || argsLeft.charAt(argEndIndex + 1) == ')') {
                                                nextArgIndex = argEndIndex + 2;
                                            } else {
                                                possibleErrors.append("[,)] does not follow #" + argsLeft.charAt(0) + "#\n");
                                                argEndIndex = -1;
                                            }
                                        }
                                    } else {
                                        argEndIndex = argsLeft.indexOf(",");
                                        if (argEndIndex < 0) {
                                            argEndIndex = argsLeft.indexOf(")");
                                        }
                                        if (argEndIndex >= 0) {
                                            nextArgIndex = argEndIndex + 1;
                                        }
                                    }
                                    if (argEndIndex < 0) {
                                        methodFound = false;
                                        possibleErrors.append("Unable to find arg with remaining args " + argsLeft + "\n");
                                        possibleErrors.append("Number of parameters is " + parameterTypes.length + "\n");
                                        methodFound = false;
                                        continue;
                                    }
                                    if (argStartIndex > argEndIndex) continue;
                                    String arg = argsLeft.substring(argStartIndex, argEndIndex).trim();
                                    argsLeft = argsLeft.substring(nextArgIndex);
                                    Object argObject = this.variables.get(arg);
                                    if (argObject != null) {
                                        parameters[p] = argObject;
                                        continue;
                                    }
                                    String parameterTypeName = parameterTypes[p].getName();
                                    methodParameters = (String)methodParameters + parameterTypeName + " ";
                                    if (arg.equals("null")) {
                                        parameters[p] = null;
                                        continue;
                                    }
                                    if (parameterTypeName.equals("java.lang.String") || parameterTypeName.equals("java.lang.Object")) {
                                        parameters[p] = arg;
                                        continue;
                                    }
                                    if (parameterTypeName.equals("char")) {
                                        if (arg.length() == 1) {
                                            parameters[p] = Character.valueOf(arg.charAt(0));
                                            continue;
                                        }
                                        possibleErrors.append("Could not parse " + arg + " as char\n");
                                        methodFound = false;
                                        continue;
                                    }
                                    if (parameterTypeName.equals("boolean")) {
                                        try {
                                            parameters[p] = Boolean.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as integer\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("short")) {
                                        try {
                                            parameters[p] = Short.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as short\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("int")) {
                                        try {
                                            parameters[p] = Integer.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as integer\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("long")) {
                                        try {
                                            parameters[p] = Long.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as long\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("float")) {
                                        try {
                                            parameters[p] = Float.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as float\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("double")) {
                                        try {
                                            parameters[p] = Double.valueOf(arg);
                                        }
                                        catch (Exception e) {
                                            possibleErrors.append("Could not parse " + arg + " as double\n");
                                            methodFound = false;
                                        }
                                        continue;
                                    }
                                    if (parameterTypeName.equals("[Ljava.lang.String;")) {
                                        if (arg.charAt(0) == '[') {
                                            arrayString = arg.substring(1);
                                            len = arrayString.length();
                                            arrayCount = 1;
                                            for (int i = 0; i < len; ++i) {
                                                if (arrayString.charAt(i) != '+') continue;
                                                ++arrayCount;
                                            }
                                            parameters[p] = a = new String[arrayCount];
                                            int arrayIndex = 0;
                                            int startIndex = 0;
                                            int endIndex = arrayString.indexOf(43, startIndex);
                                            if (endIndex < 0) {
                                                endIndex = arrayString.indexOf(93, startIndex);
                                            }
                                            while (endIndex > 0) {
                                                if (arrayIndex < arrayCount) {
                                                    a[arrayIndex] = arrayString.substring(startIndex, endIndex);
                                                    ++arrayIndex;
                                                }
                                                if ((startIndex = endIndex + 1) >= len) {
                                                    endIndex = -1;
                                                    continue;
                                                }
                                                endIndex = arrayString.indexOf(43, startIndex);
                                                if (endIndex >= 0) continue;
                                                endIndex = arrayString.indexOf(93, startIndex);
                                            }
                                            continue;
                                        }
                                        possibleErrors.append("Could not parse " + arg + " as String array .. try [A+B+C]\n");
                                        methodFound = false;
                                        continue;
                                    }
                                    if (parameterTypeName.equals("[I")) {
                                        if (arg.charAt(0) == '[') {
                                            arrayString = arg.substring(1);
                                            len = arrayString.length();
                                            arrayCount = 1;
                                            for (int i = 0; i < len; ++i) {
                                                if (arrayString.charAt(i) != '+') continue;
                                                ++arrayCount;
                                            }
                                            parameters[p] = a = (Object[])new int[arrayCount];
                                            String piece = "";
                                            try {
                                                int arrayIndex = 0;
                                                int startIndex = 0;
                                                int endIndex = arrayString.indexOf(43, startIndex);
                                                if (endIndex < 0) {
                                                    endIndex = arrayString.indexOf(93, startIndex);
                                                }
                                                while (endIndex > 0) {
                                                    if (arrayIndex < arrayCount) {
                                                        a[arrayIndex] = (String)Integer.parseInt(arrayString.substring(startIndex, endIndex));
                                                        ++arrayIndex;
                                                    }
                                                    if ((startIndex = endIndex + 1) >= len) {
                                                        endIndex = -1;
                                                        continue;
                                                    }
                                                    endIndex = arrayString.indexOf(43, startIndex);
                                                    if (endIndex >= 0) continue;
                                                    endIndex = arrayString.indexOf(93, startIndex);
                                                }
                                                continue;
                                            }
                                            catch (Exception e) {
                                                possibleErrors.append("Exception " + e + " piece = " + piece + "\n");
                                                possibleErrors.append("Could not parse " + arg + " as Integer.. try [1+2+3]\n");
                                                methodFound = false;
                                                continue;
                                            }
                                        }
                                        possibleErrors.append("Could not parse " + arg + " as Integer.. try [1+2+3]\n");
                                        methodFound = false;
                                        continue;
                                    }
                                    possibleErrors.append("Did not handle parameter with class " + parameterTypeName + "\n");
                                    methodFound = false;
                                }
                                if (methodFound) {
                                    if (p == methodParameterCount) {
                                        if (argsLeft.trim().equals(")") || argsLeft.trim().length() == 0) {
                                            try {
                                                methods[m].setAccessible(true);
                                                variable = methods[m].invoke(callObject, parameters);
                                            }
                                            catch (Exception e) {
                                                Throwable nextException;
                                                if (e instanceof InvocationTargetException && (nextException = e.getCause()) != null && nextException instanceof Exception) {
                                                    e = (Exception)nextException;
                                                }
                                                if (e instanceof XAException) {
                                                    possibleErrors.append("XAException:" + e.toString() + " code=" + this.getXACodeInfo((XAException)e) + "\n");
                                                }
                                                possibleErrors.append("Exception " + e + "\n");
                                                if (this.printStackTrace_) {
                                                    Main.printStackTraceToStringBuffer(e, possibleErrors);
                                                }
                                                possibleErrors.append("Calling method " + methodName + " with " + (String)methodParameters + " failed\n");
                                                methodFound = false;
                                            }
                                            continue;
                                        }
                                        possibleErrors.append("Not calling method " + methodName + " with " + (String)methodParameters + " because argsLeft = " + argsLeft + "\n");
                                        methodFound = false;
                                        continue;
                                    }
                                    possibleErrors.append("Not calling method " + methodName + " with " + (String)methodParameters + " because parsed parameter count = " + p + "\n");
                                    continue;
                                }
                                possibleErrors.append("Method not found " + methodName + "\n");
                            }
                            if (!anyMethodFound) {
                                possibleErrors.append("ERROR:  Method not found " + methodName + "\n");
                            }
                        } else {
                            possibleErrors.append("ERROR:  could find ( in " + left + "\n");
                        }
                    } else {
                        printStreamForCallMethod.println("ERROR:  could not find variable or class " + callVariable);
                        this.showValidVariables(printStreamForCallMethod);
                    }
                } else {
                    possibleErrors.append("ERROR:  could find . in " + left);
                }
            } else {
                possibleErrors.append("ERROR:  could find ( in " + left);
            }
            if (!methodFound) {
                printStreamForCallMethod.println("No matching method found, possible errors are the following:\n" + possibleErrors.toString());
            }
            return variable;
        }
        catch (Exception e) {
            this.exceptionOccurred_ = true;
            printStreamForCallMethod.println("Unexpected exception");
            printStreamForCallMethod.println("Exception " + e);
            if (this.printStackTrace_) {
                e.printStackTrace(printStreamForCallMethod);
            }
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.exceptionOccurred_ = true;
            printStreamForCallMethod.println("NoClassDefFoundError " + ncdfe);
            if (this.printStackTrace_) {
                ncdfe.printStackTrace(printStreamForCallMethod);
            }
            return null;
        }
    }

    private String getXACodeInfo(XAException e) {
        int code = e.errorCode;
        switch (code) {
            case 7: {
                return "XA_HEURCOM : The transaction branch has been heuristically committed.";
            }
            case 8: {
                return "XA_HEURHAZ : The transaction branch may have been heuristically completed.";
            }
            case 5: {
                return "XA_HEURMIX : The transaction branch has been heuristically committed and rolled back.";
            }
            case 6: {
                return "XA_HEURRB : The transaction branch has been heuristically rolled back.";
            }
            case 9: {
                return "XA_NOMIGRATE : Resumption must occur where the suspension occurred.";
            }
            case 101: {
                return "XA_RBCOMMFAIL : Indicates that the rollback was caused by a communication failure.";
            }
            case 102: {
                return "XA_RBDEADLOCK : A deadlock was detected.";
            }
            case 103: {
                return "XA_RBINTEGRITY : A condition that violates the integrity of the resource was detected.";
            }
            case 104: {
                return "XA_RBOTHER : The resource manager rolled back the transaction branch for a reason not on this list.";
            }
            case 105: {
                return "XA_RBPROTO : A protocol error occurred in the resource manager.";
            }
            case 100: {
                return "XA_RBROLLBACK : Indicates that the rollback was caused by an unspecified reason.";
            }
            case 106: {
                return "XA_RBTIMEOUT : A transaction branch took too long.";
            }
            case 107: {
                return "XA_RBTRANSIENT : May retry the transaction branch.";
            }
            case 3: {
                return "XA_RDONLY : The transaction branch was read-only and has been committed.";
            }
            case 4: {
                return "XA_RETRY : Routine returned with no effect and may be reissued.";
            }
            case -2: {
                return "XAER_ASYNC : There is an asynchronous operation already outstanding.";
            }
            case -8: {
                return "XAER_DUPID : The XID already exists.";
            }
            case -5: {
                return "XAER_INVAL : Invalid arguments were given.";
            }
            case -4: {
                return "XAER_NOTA : The XID is not valid.";
            }
            case -9: {
                return "XAER_OUTSIDE : The resource manager is doing work outside a global transaction.";
            }
            case -6: {
                return "XAER_PROTO : Routine was invoked in an improper context.";
            }
            case -3: {
                return "XAER_RMERR : A resource manager error has occurred in the transaction branch.";
            }
            case -7: {
                return "XAER_RMFAIL : Resource manager is unavailable.";
            }
        }
        return "" + code;
    }

    public static void printStackTraceToStringBuffer(Throwable e, StringBuffer sb) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String exception = stringWriter.toString();
        sb.append(exception);
    }

    private Object callNewMethod(String left, PrintStream printStreamForCallNewMethod) {
        try {
            StringBuffer possibleErrors = new StringBuffer();
            boolean methodFound = false;
            Object variable = null;
            int paramIndex = left.indexOf("(");
            if (paramIndex > 0) {
                String newClassName = left.substring(0, paramIndex).trim();
                Class<?> newClass = null;
                left = left.substring(paramIndex + 1);
                try {
                    newClass = Class.forName(newClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (newClass != null) {
                    Constructor<?>[] constructors = newClass.getConstructors();
                    for (int m = 0; !methodFound && m < constructors.length && variable == null; ++m) {
                        Class<?>[] parameterTypes = constructors[m].getParameterTypes();
                        String argsLeft = left;
                        Object[] parameters = new Object[parameterTypes.length];
                        methodFound = true;
                        Object methodParameters = "(";
                        for (int p = 0; p < parameterTypes.length; ++p) {
                            Object[] a;
                            int arrayCount;
                            int len;
                            String arrayString;
                            int argStartIndex = 0;
                            int argEndIndex = 0;
                            int nextArgIndex = 0;
                            if (argsLeft.length() > 1 && argsLeft.charAt(0) == '\"') {
                                argStartIndex = 1;
                                argEndIndex = argsLeft.indexOf(34, 1);
                                if (argEndIndex > 0) {
                                    if (argsLeft.charAt(argEndIndex + 1) == ',' || argsLeft.charAt(argEndIndex + 1) == ')') {
                                        nextArgIndex = argEndIndex + 2;
                                    } else {
                                        possibleErrors.append("[,)] does not follow \n");
                                        argEndIndex = -1;
                                    }
                                }
                            } else {
                                argEndIndex = argsLeft.indexOf(",");
                                if (argEndIndex < 0) {
                                    argEndIndex = argsLeft.indexOf(")");
                                }
                                if (argEndIndex >= 0) {
                                    nextArgIndex = argEndIndex + 1;
                                }
                            }
                            if (argEndIndex < 0) {
                                methodFound = false;
                                possibleErrors.append("Unable to find arg in " + argsLeft + "\n");
                                continue;
                            }
                            String arg = argsLeft.substring(argStartIndex, argEndIndex).trim();
                            argsLeft = argsLeft.substring(nextArgIndex);
                            String parameterTypeName = parameterTypes[p].getName();
                            if (p > 0) {
                                methodParameters = (String)methodParameters + ",";
                            }
                            methodParameters = (String)methodParameters + parameterTypeName;
                            Object argObject = this.variables.get(arg);
                            if (argObject != null) {
                                parameters[p] = argObject;
                                continue;
                            }
                            if (arg.equals("null")) {
                                parameters[p] = null;
                                continue;
                            }
                            if (parameterTypeName.equals("java.lang.String")) {
                                parameters[p] = arg;
                                continue;
                            }
                            if (parameterTypeName.equals("int")) {
                                try {
                                    parameters[p] = Integer.valueOf(arg);
                                }
                                catch (Exception e) {
                                    possibleErrors.append("Could not parse " + arg + " as integer\n");
                                    methodFound = false;
                                }
                                continue;
                            }
                            if (parameterTypeName.equals("boolean")) {
                                try {
                                    parameters[p] = Boolean.valueOf(arg);
                                }
                                catch (Exception e) {
                                    possibleErrors.append("Could not parse " + arg + " as integer\n");
                                    methodFound = false;
                                }
                                continue;
                            }
                            if (parameterTypeName.equals("long")) {
                                try {
                                    parameters[p] = Long.valueOf(arg);
                                }
                                catch (Exception e) {
                                    possibleErrors.append("Could not parse " + arg + " as long\n");
                                    methodFound = false;
                                }
                                continue;
                            }
                            if (parameterTypeName.equals("[Ljava.lang.String;")) {
                                if (arg.charAt(0) == '[') {
                                    arrayString = arg.substring(1);
                                    len = arrayString.length();
                                    arrayCount = 1;
                                    for (int i = 0; i < len; ++i) {
                                        if (arrayString.charAt(i) != '+') continue;
                                        ++arrayCount;
                                    }
                                    parameters[p] = a = new String[arrayCount];
                                    int arrayIndex = 0;
                                    int startIndex = 0;
                                    int endIndex = arrayString.indexOf(43, startIndex);
                                    if (endIndex < 0) {
                                        endIndex = arrayString.indexOf(93, startIndex);
                                    }
                                    while (endIndex > 0) {
                                        if (arrayIndex < arrayCount) {
                                            a[arrayIndex] = arrayString.substring(startIndex, endIndex);
                                            ++arrayIndex;
                                        }
                                        if ((startIndex = endIndex + 1) >= len) {
                                            endIndex = -1;
                                            continue;
                                        }
                                        endIndex = arrayString.indexOf(43, startIndex);
                                        if (endIndex >= 0) continue;
                                        endIndex = arrayString.indexOf(93, startIndex);
                                    }
                                    continue;
                                }
                                possibleErrors.append("Could not parse " + arg + " as String array .. try [A+B+C]\n");
                                methodFound = false;
                                continue;
                            }
                            if (parameterTypeName.equals("[I")) {
                                if (arg.charAt(0) == '[') {
                                    arrayString = arg.substring(1);
                                    len = arrayString.length();
                                    arrayCount = 1;
                                    for (int i = 0; i < len; ++i) {
                                        if (arrayString.charAt(i) != '+') continue;
                                        ++arrayCount;
                                    }
                                    parameters[p] = a = (Object[])new int[arrayCount];
                                    String piece = "";
                                    try {
                                        int arrayIndex = 0;
                                        int startIndex = 0;
                                        int endIndex = arrayString.indexOf(43, startIndex);
                                        if (endIndex < 0) {
                                            endIndex = arrayString.indexOf(93, startIndex);
                                        }
                                        while (endIndex > 0) {
                                            if (arrayIndex < arrayCount) {
                                                a[arrayIndex] = (String)Integer.parseInt(arrayString.substring(startIndex, endIndex));
                                                ++arrayIndex;
                                            }
                                            if ((startIndex = endIndex + 1) >= len) {
                                                endIndex = -1;
                                                continue;
                                            }
                                            endIndex = arrayString.indexOf(43, startIndex);
                                            if (endIndex >= 0) continue;
                                            endIndex = arrayString.indexOf(93, startIndex);
                                        }
                                        continue;
                                    }
                                    catch (Exception e) {
                                        possibleErrors.append("Exception " + e + " piece = " + piece + "\n");
                                        possibleErrors.append("Could not parse " + arg + " as Integer.. try [1+2+3]\n");
                                        methodFound = false;
                                        continue;
                                    }
                                }
                                possibleErrors.append("Could not parse " + arg + " as Integer.. try [1+2+3\n]");
                                methodFound = false;
                                continue;
                            }
                            possibleErrors.append("Did not handle parameter with class " + parameterTypeName);
                            methodFound = false;
                        }
                        methodParameters = (String)methodParameters + ")";
                        if (!methodFound) continue;
                        if (argsLeft.trim().equals(")") || argsLeft.trim().length() == 0) {
                            try {
                                variable = constructors[m].newInstance(parameters);
                                methodFound = true;
                            }
                            catch (Exception e) {
                                possibleErrors.append("Exception " + e + "\n");
                                if (this.printStackTrace_) {
                                    Main.printStackTraceToStringBuffer(e, possibleErrors);
                                }
                                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                                    possibleErrors.append("..Caused by " + t + "\n");
                                    if (!this.printStackTrace_) continue;
                                    Main.printStackTraceToStringBuffer(t, possibleErrors);
                                }
                                possibleErrors.append("Creating object  with " + (String)methodParameters + " failed\n");
                                methodFound = false;
                            }
                            continue;
                        }
                        possibleErrors.append("Not calling constructor  with " + (String)methodParameters + " because argsLeft = " + argsLeft + "\n");
                        methodFound = false;
                    }
                } else {
                    possibleErrors.append("ERROR:  could not find variable or class " + newClassName + "\n");
                }
            } else {
                possibleErrors.append("ERROR:  could find ( in " + left + "\n");
            }
            if (!methodFound) {
                printStreamForCallNewMethod.println("Unable to call method: Possible errors are the following\n" + possibleErrors.toString());
            }
            return variable;
        }
        catch (Exception e) {
            printStreamForCallNewMethod.println("Unexpected exception");
            printStreamForCallNewMethod.println("Exception " + e);
            if (this.printStackTrace_) {
                e.printStackTrace(printStreamForCallNewMethod);
            }
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            printStreamForCallNewMethod.println("NoClassDefFoundError " + ncdfe);
            if (this.printStackTrace_) {
                ncdfe.printStackTrace(printStreamForCallNewMethod);
            }
            return null;
        }
    }

    private void showValidVariables(PrintStream out1) {
        out1.println("Valid variables are the following");
        Enumeration keys = this.variables.keys();
        while (keys.hasMoreElements()) {
            out1.println(keys.nextElement());
        }
    }

    private void showMethods(String left, PrintStream out1) {
        String callVariable = left.trim();
        Object callObject = this.variables.get(callVariable);
        Class<?> callClass = null;
        if (callObject == null) {
            try {
                callClass = Class.forName(callVariable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (callObject != null || callClass != null) {
            Object methodInfo;
            Method[] methods = callObject != null ? callObject.getClass().getMethods() : (callClass != null ? callClass.getMethods() : new Method[]{});
            Vector<Object> methodVector = new Vector<Object>();
            for (int m = 0; m < methods.length; ++m) {
                Class<?> returnType = methods[m].getReturnType();
                methodInfo = methods[m].getName();
                Object returnClause = returnType != null ? " @RETURNS " + returnType.getName() : " @RETURNS void";
                Class<?>[] parameterTypes = methods[m].getParameterTypes();
                methodInfo = (String)methodInfo + "(";
                for (int p = 0; p < parameterTypes.length; ++p) {
                    String parameterTypeName = parameterTypes[p].getName();
                    if (p > 0) {
                        methodInfo = (String)methodInfo + ",";
                    }
                    methodInfo = (String)methodInfo + parameterTypeName;
                }
                methodInfo = (String)methodInfo + ")" + (String)returnClause;
                methodVector.addElement(methodInfo);
            }
            Collections.sort(methodVector);
            Enumeration vectorEnum = methodVector.elements();
            while (vectorEnum.hasMoreElements()) {
                methodInfo = (String)vectorEnum.nextElement();
                int returnsIndex = ((String)methodInfo).indexOf(" @RETURNS ");
                if (returnsIndex > 0) {
                    out1.println(((String)methodInfo).substring(returnsIndex + 10) + " " + ((String)methodInfo).substring(0, returnsIndex));
                    continue;
                }
                out1.println((String)methodInfo);
            }
        } else {
            out1.println("Could not find variable " + callVariable);
            this.showValidVariables(out1);
        }
    }

    private static String[] dispColumnHeadings(PrintStream out1, ResultSet rs, ResultSetMetaData rsmd, boolean trim, int numCols, boolean html, boolean xml, boolean showMixedUX, boolean silent) throws SQLException {
        StringBuffer output = new StringBuffer();
        if (html) {
            output.append("<table border>\n");
        }
        String[] columnLabel = new String[numCols + 1];
        for (int i = 1; i <= numCols; ++i) {
            columnLabel[i] = rsmd.getColumnLabel(i);
            if (html) {
                output.append("<th>" + columnLabel[i].replace('_', ' '));
                continue;
            }
            if (xml) continue;
            if (i > 1) {
                output.append(",");
            }
            Main.appendUnicodeString(output, columnLabel[i], 65535, 65535, true, showMixedUX);
        }
        if (html) {
            output.append("<tr>\n");
        }
        if (xml) {
            output.append("<table>");
            if (!silent) {
                out1.println(output.toString());
            }
        } else {
            output.append("");
            if (!silent) {
                out1.println(output.toString());
            }
        }
        return columnLabel;
    }

    private static void dispRow(PrintStream out1, ResultSet rs, boolean trim, int numCols, int[] colType, String[] columnLabel, String[] format, boolean xml, boolean html, int showLobThreshold, int stringSampleSize, boolean characterDetails, boolean showMixedUX, boolean silent) throws SQLException {
        StringBuffer output = new StringBuffer();
        if (xml) {
            output.append("<row>\n");
        }
        for (int i = 1; i <= numCols; ++i) {
            if (html) {
                output.append("<td>");
            } else if (xml) {
                output.append("   <" + columnLabel[i] + ">");
            } else if (i > 1) {
                output.append(",");
            }
            switch (colType[i]) {
                case 2004: {
                    Blob blob = rs.getBlob(i);
                    if (blob != null && blob.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2BlobLocator")) {
                        try {
                            int loc = ReflectionUtil.callMethod_I(blob, "getLocator");
                            output.append("L#" + loc + ":");
                        }
                        catch (Exception loc) {
                            // empty catch block
                        }
                    }
                }
                case -8: 
                case -4: 
                case -3: 
                case -2: {
                    byte[] bytes = rs.getBytes(i);
                    if (bytes == null) {
                        output.append(rs.getString(i));
                        break;
                    }
                    if (bytes.length < showLobThreshold) {
                        for (int j = 0; j < bytes.length; ++j) {
                            int showInt = bytes[j] & 0xFF;
                            if (showInt >= 16) {
                                output.append(Integer.toHexString(showInt));
                                continue;
                            }
                            output.append("0" + Integer.toHexString(showInt));
                        }
                        break;
                    }
                    CRC32 checksum = new CRC32();
                    checksum.update(bytes);
                    output.append("ARRAY[size=" + bytes.length + ",CRC32=" + checksum.getValue() + "]");
                    break;
                }
                case 16: {
                    boolean bool = rs.getBoolean(i);
                    if (rs.wasNull()) {
                        output.append("null");
                        break;
                    }
                    if (bool) {
                        output.append("true");
                        break;
                    }
                    output.append("false");
                    break;
                }
                default: {
                    String outString = rs.getString(i);
                    if (trim && outString != null) {
                        outString = outString.trim();
                    }
                    if (format != null && i - 1 < format.length && format[i - 1] != null) {
                        outString = Main.formatString(outString, format[i - 1]);
                    }
                    Main.appendUnicodeString(output, outString, showLobThreshold, stringSampleSize, characterDetails, showMixedUX);
                }
            }
            if (!xml) continue;
            output.append("</" + columnLabel[i] + ">\n");
        }
        if (html) {
            if (!silent) {
                out1.println(output.toString() + "<tr>");
            }
        } else if (xml) {
            if (!silent) {
                out1.println(output.toString() + "</row>");
            }
        } else if (!silent) {
            out1.println(output.toString());
        }
    }

    private static String stripTS(String s) {
        s = s.replace(' ', '-');
        int i = (s = s.replace(':', '.')).indexOf(".000000");
        if (i > 0) {
            s = s.substring(0, i);
        }
        return s;
    }

    private static String formatString(String outString, String format) {
        if (format != null) {
            int replaceIndex = format.indexOf("{STUFF}");
            if (replaceIndex > 0) {
                return Main.formatString(outString, format.substring(0, replaceIndex)) + outString + Main.formatString(outString, format.substring(replaceIndex + 7));
            }
            if (replaceIndex == 0) {
                return outString + Main.formatString(outString, format.substring(replaceIndex + 7));
            }
            replaceIndex = format.indexOf("{STRIPPEDTS}");
            if (replaceIndex > 0) {
                return Main.formatString(outString, format.substring(0, replaceIndex)) + Main.stripTS(outString) + Main.formatString(outString, format.substring(replaceIndex + 12));
            }
            if (replaceIndex == 0) {
                return Main.stripTS(outString) + Main.formatString(outString, format.substring(replaceIndex + 12));
            }
            replaceIndex = format.indexOf("{PART");
            if (replaceIndex >= 0) {
                int endBrace = format.indexOf("}", replaceIndex);
                int length = endBrace - replaceIndex + 1;
                int number = format.charAt(replaceIndex + 5) - 48;
                String separator = format.substring(replaceIndex + 9, endBrace);
                String part = Main.getNthItem(outString, separator, number);
                if (replaceIndex > 0) {
                    return Main.formatString(outString, format.substring(0, replaceIndex)) + part + Main.formatString(outString, format.substring(replaceIndex + length));
                }
                return part + Main.formatString(outString, format.substring(replaceIndex + length));
            }
            return format;
        }
        return outString;
    }

    private static String getNthItem(String outString, String separator, int number) {
        String rest = outString;
        int separatorLength = separator.length();
        int separatorIndex = rest.indexOf(separator);
        int count = 1;
        while (separatorIndex > 0) {
            if (count == number) {
                return rest.substring(0, separatorIndex);
            }
            rest = rest.substring(separatorIndex + separatorLength);
            separatorIndex = rest.indexOf(separator);
            ++count;
        }
        return rest;
    }

    public static void dispResultSet(ResultSet rs) throws SQLException {
        Main.dispResultSet(defaultOutput, rs, false, null, false, false, 16384, 16384, true, true, false, false);
    }

    void dispResultSet(PrintStream out1, ResultSet rs, boolean trim) throws SQLException {
        Main.dispResultSet(out1, rs, trim, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.hideWarnings_, this.silentrs_);
    }

    static void dispResultSet(PrintStream out1, ResultSet rs, boolean trim, String[] format, boolean xml, boolean html, int showLobThreshold, int stringSampleSize, boolean characterDetails, boolean showMixedUX, boolean hideWarnings, boolean silent) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        String[] columnLabel = Main.dispColumnHeadings(out1, rs, rsmd, trim, numCols, xml, html, showMixedUX, silent);
        int[] colType = new int[numCols + 1];
        for (int i = 1; i <= numCols; ++i) {
            colType[i] = rsmd.getColumnType(i);
        }
        boolean more = rs.next();
        while (more) {
            Main.dispRow(out1, rs, trim, numCols, colType, columnLabel, format, xml, html, showLobThreshold, stringSampleSize, characterDetails, showMixedUX, silent);
            SQLWarning warning = rs.getWarnings();
            if (!silent && warning != null) {
                Main.dispWarning(out1, warning, hideWarnings, html);
            }
            more = rs.next();
        }
        if (!silent) {
            if (html) {
                out1.println("</table>");
            }
            if (xml) {
                out1.println("</table>");
            }
        }
    }

    private static void dispWarning(PrintStream out1, SQLWarning warning, boolean hideWarnings, boolean html) {
        if (hideWarnings) {
            return;
        }
        if (warning != null) {
            out1.println("\n *** Warning ***\n");
            if (html) {
                out1.println("<br>");
            }
            while (warning != null) {
                out1.println("SQLState: " + warning.getSQLState());
                if (html) {
                    out1.println("<br>");
                }
                out1.println("Message:  " + Main.cleanupMessage(warning.getMessage()));
                if (html) {
                    out1.println("<br>");
                }
                out1.println("Vendor:   " + warning.getErrorCode());
                if (html) {
                    out1.println("<br>");
                }
                out1.println("");
                if (html) {
                    out1.println("<br>");
                }
                warning = warning.getNextWarning();
            }
        }
    }

    private static String cleanupMessage(String message) {
        boolean invalidCharacter = false;
        char[] chars = message.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= ' ' && chars[i] <= '~') continue;
            invalidCharacter = true;
            chars[i] = 42;
        }
        if (!invalidCharacter) {
            return message;
        }
        return new String(chars);
    }

    private void printArray(PrintStream out1, java.sql.Array outArray) throws SQLException {
        if (outArray == null) {
            out1.print("nullArray");
        } else {
            Object[] array = (Object[])outArray.getArray();
            if (array == null) {
                out1.print("XXXX_null_returned_from_outArray.getArray");
            } else {
                String componentTypeName = array.getClass().getComponentType().getName();
                out1.print(componentTypeName + "[" + array.length + "]=[");
                for (int i = 0; i < array.length; ++i) {
                    long length;
                    if (i > 0) {
                        out1.print(",");
                    }
                    if (array[i] == null) {
                        out1.print("null");
                        continue;
                    }
                    if (componentTypeName.equals("[B")) {
                        out1.print(StringFormatUtil.dumpBytes((byte[])array[i]));
                        continue;
                    }
                    if (array[i] instanceof Blob) {
                        Blob blob = (Blob)array[i];
                        length = blob.length();
                        out1.print(StringFormatUtil.dumpBytes(blob.getBytes(1L, (int)length)));
                        continue;
                    }
                    if (array[i] instanceof Clob) {
                        Clob clob = (Clob)array[i];
                        length = clob.length();
                        this.printUnicodeString(out1, clob.getSubString(1L, (int)length));
                        continue;
                    }
                    if (array[i] instanceof String) {
                        this.printUnicodeString(out1, (String)array[i]);
                        continue;
                    }
                    out1.print(array[i].toString());
                }
                out1.print("]");
            }
        }
    }

    private void printUnicodeString(PrintStream out1, String outString) {
        int length;
        if (outString != null && (length = outString.length()) > this.showLobThreshold_) {
            out1.print("CHARARRAY[size=" + length + ",CRC32=" + Main.getCRC32(outString) + "]->");
            if (!this.characterDetails_) {
                outString = outString.substring(0, this.stringSampleSize_);
            }
        }
        if (outString != null) {
            int i;
            char[] chars = outString.toCharArray();
            boolean nonAsciiFound = false;
            for (i = 0; !nonAsciiFound && i < chars.length; ++i) {
                if (chars[i] == '\r' || chars[i] == '\n' || chars[i] == '\t' || chars[i] < '\u007f' && chars[i] >= ' ') continue;
                nonAsciiFound = true;
            }
            if (!nonAsciiFound) {
                out1.print(outString);
            } else if (this.showMixedUX_) {
                this.showMixedUXOutput(out1, chars);
            } else {
                out1.print("U'");
                for (i = 0; i < chars.length; ++i) {
                    int showInt = chars[i] & 0xFFFF;
                    if (showInt > 65280 && showInt < 65375 || showInt == 12288) {
                        if (showInt == 12288) {
                            out1.print("| ");
                            continue;
                        }
                        out1.print('|');
                        out1.print((char)(showInt - 65248));
                        continue;
                    }
                    String showString = Integer.toHexString(showInt);
                    if (showInt >= 4096) {
                        out1.print(showString);
                        continue;
                    }
                    if (showInt >= 256) {
                        out1.print("0" + showString);
                        continue;
                    }
                    if (showInt >= 16) {
                        out1.print("00" + showString);
                        continue;
                    }
                    out1.print("000" + showString);
                }
                out1.print("'");
            }
        } else {
            out1.print(outString);
        }
    }

    private static void appendUnicodeString(StringBuffer sb, String outString, int showLobThreshold, int stringSampleSize, boolean characterDetails, boolean showMixedUX) {
        int length;
        if (outString != null && (length = outString.length()) > showLobThreshold) {
            sb.append("CHARARRAY[size=" + length + ",CRC32=" + Main.getCRC32(outString) + "]->");
            if (!characterDetails) {
                outString = outString.substring(0, stringSampleSize);
            }
        }
        if (outString != null) {
            int i;
            char[] chars = outString.toCharArray();
            boolean nonAsciiFound = false;
            for (i = 0; !nonAsciiFound && i < chars.length; ++i) {
                if (chars[i] == '\r' || chars[i] == '\n' || chars[i] == '\t' || chars[i] < '\u007f' && chars[i] >= ' ') continue;
                nonAsciiFound = true;
            }
            if (!nonAsciiFound) {
                sb.append(outString);
            } else if (showMixedUX) {
                Main.appendMixedUXOutput(sb, chars);
            } else {
                sb.append("U'");
                for (i = 0; i < chars.length; ++i) {
                    int showInt = chars[i] & 0xFFFF;
                    if (showInt > 65280 && showInt < 65375 || showInt == 12288) {
                        if (showInt == 12288) {
                            sb.append("| ");
                            continue;
                        }
                        sb.append('|');
                        sb.append((char)(showInt - 65248));
                        continue;
                    }
                    String showString = Integer.toHexString(showInt);
                    if (showInt >= 4096) {
                        sb.append(showString);
                        continue;
                    }
                    if (showInt >= 256) {
                        sb.append("0" + showString);
                        continue;
                    }
                    if (showInt >= 16) {
                        sb.append("00" + showString);
                        continue;
                    }
                    sb.append("000" + showString);
                }
                sb.append("'");
            }
        } else {
            sb.append(outString);
        }
    }

    public void showMixedUXOutput(PrintStream out1, char[] chars) {
        boolean inUX = false;
        for (int i = 0; i < chars.length; ++i) {
            int showInt = chars[i] & 0xFFFF;
            if (showInt == 10 || showInt >= 32 && showInt < 127) {
                if (inUX) {
                    out1.print("''");
                    inUX = false;
                }
                out1.print(chars[i]);
                continue;
            }
            if (!inUX) {
                inUX = true;
                out1.print("UX''");
            }
            String showString = Integer.toHexString(showInt);
            if (showInt >= 4096) {
                out1.print(showString);
                continue;
            }
            if (showInt >= 256) {
                out1.print("0" + showString);
                continue;
            }
            if (showInt >= 16) {
                out1.print("00" + showString);
                continue;
            }
            out1.print("000" + showString);
        }
        if (inUX) {
            out1.print("''");
        }
    }

    public static void appendMixedUXOutput(StringBuffer sb, char[] chars) {
        boolean inUX = false;
        for (int i = 0; i < chars.length; ++i) {
            int showInt = chars[i] & 0xFFFF;
            if (showInt == 10 || showInt >= 32 && showInt < 127) {
                if (inUX) {
                    sb.append("''");
                    inUX = false;
                }
                sb.append(chars[i]);
                continue;
            }
            if (!inUX) {
                inUX = true;
                sb.append("UX''");
            }
            String showString = Integer.toHexString(showInt);
            if (showInt >= 4096) {
                sb.append(showString);
                continue;
            }
            if (showInt >= 256) {
                sb.append("0" + showString);
                continue;
            }
            if (showInt >= 16) {
                sb.append("00" + showString);
                continue;
            }
            sb.append("000" + showString);
        }
        if (inUX) {
            sb.append("''");
        }
    }

    public Object getParameterObject(String thisParm, PrintStream printStreamForParameterObject) {
        if (thisParm.indexOf("UX'") == 0) {
            String stuffString;
            block24: {
                int len = thisParm.length();
                if ((thisParm = thisParm.substring(3, len - 1)).indexOf("null") >= 0) {
                    return null;
                }
                stuffString = null;
                try {
                    char[] stuff = new char[(len -= 4) / 4];
                    for (int i = 0; i < stuff.length; ++i) {
                        String piece = thisParm.substring(i * 4, i * 4 + 4);
                        stuff[i] = (char)Integer.parseInt(piece, 16);
                    }
                    stuffString = new String(stuff);
                }
                catch (Exception e) {
                    printStreamForParameterObject.println("Processing of " + thisParm + " failed");
                    printStreamForParameterObject.println("Exception " + e);
                    if (!this.printStackTrace_) break block24;
                    e.printStackTrace(printStreamForParameterObject);
                }
            }
            return stuffString;
        }
        if (thisParm.indexOf("X'") == 0) {
            byte[] stuff;
            block25: {
                int len = thisParm.length();
                if ((thisParm = thisParm.substring(2, len - 1)).indexOf("null") >= 0) {
                    return null;
                }
                stuff = null;
                try {
                    stuff = new byte[(len -= 3) / 2];
                    for (int i = 0; i < stuff.length; ++i) {
                        String piece = thisParm.substring(i * 2, i * 2 + 2);
                        stuff[i] = (byte)Integer.parseInt(piece, 16);
                    }
                }
                catch (Exception e) {
                    printStreamForParameterObject.println("Processing of " + thisParm + " failed");
                    printStreamForParameterObject.println("Exception " + e);
                    if (!this.printStackTrace_) break block25;
                    e.printStackTrace(printStreamForParameterObject);
                }
            }
            return stuff;
        }
        if (thisParm.indexOf("FILEBLOB=") == 0) {
            ClientBlob blob;
            block26: {
                blob = null;
                try {
                    String filename = thisParm.substring(9).trim();
                    byte[] stuff = null;
                    File file = new File(filename);
                    int length = (int)file.length();
                    stuff = new byte[length];
                    FileInputStream inputStream = new FileInputStream(filename);
                    inputStream.read(stuff);
                    inputStream.close();
                    blob = new ClientBlob(stuff);
                }
                catch (Exception e) {
                    printStreamForParameterObject.println("Processing of " + thisParm + " failed because of " + e);
                    printStreamForParameterObject.println("Exception " + e);
                    if (!this.printStackTrace_) break block26;
                    e.printStackTrace(printStreamForParameterObject);
                }
            }
            return blob;
        }
        if (thisParm.indexOf("FILECLOB=") == 0) {
            ClientClob clob;
            block27: {
                clob = null;
                try {
                    String filename = thisParm.substring(9).trim();
                    char[] stuff = null;
                    File file = new File(filename);
                    int length = (int)file.length();
                    stuff = new char[length];
                    BufferedReader reader = new BufferedReader(new FileReader(filename));
                    reader.read(stuff, 0, length);
                    clob = new ClientClob(new String(stuff));
                }
                catch (Exception e) {
                    printStreamForParameterObject.println("Processing of " + thisParm + " failed because of " + e);
                    printStreamForParameterObject.println("Exception " + e);
                    if (!this.printStackTrace_) break block27;
                    e.printStackTrace(printStreamForParameterObject);
                }
            }
            return clob;
        }
        if (thisParm.indexOf("SAVEDPARM=") == 0) {
            printStreamForParameterObject.println("ERROR:  SAVEDPARM not supported yet");
        } else if (thisParm.indexOf("SQLARRAY[") == 0) {
            printStreamForParameterObject.println("ERROR:  SQLARRAY not supported yet");
        } else {
            if (thisParm.indexOf("GEN_BYTE_ARRAY+") == 0) {
                return this.getGenByteArrayParm(thisParm, printStreamForParameterObject);
            }
            if (thisParm.indexOf("GEN_HEX_STRING+") == 0) {
                printStreamForParameterObject.println("ERROR:  GEN_HEX_STRING+ not supported yet");
            } else if (thisParm.indexOf("GEN_CHAR_ARRAY+") == 0) {
                printStreamForParameterObject.println("ERROR:  GEN_CHAR_ARRAY+ not supported yet");
            }
        }
        return thisParm;
    }

    public void setParameter(PreparedStatement cstmt, String thisParm, int parm, PrintStream printStreamForSetParameter) throws SQLException {
        if (thisParm.indexOf("UX'") == 0) {
            this.handleUnicodeStringParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("X'") == 0) {
            this.handleByteArrayParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("FILEBLOB=") == 0) {
            this.handleFileBlobParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("FILECLOB=") == 0) {
            this.handleFileClobParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("SAVEDPARM=") == 0) {
            this.handleSavedParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("SQLARRAY[") == 0) {
            this.handleSqlarrayParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("GEN_BYTE_ARRAY+") == 0) {
            this.handleGenByteArrayParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("GEN_HEX_STRING+") == 0) {
            this.handleGenHexStringParm(cstmt, thisParm, parm, printStreamForSetParameter);
        } else if (thisParm.indexOf("GEN_CHAR_ARRAY+") == 0) {
            int specifiedLength;
            String stuffString;
            block31: {
                stuffString = null;
                specifiedLength = -1;
                try {
                    String specifiedLengthString = null;
                    String charSetString = null;
                    int charSet = -1;
                    int indexC = -1;
                    String chopped = thisParm.substring(15).trim();
                    indexC = chopped.indexOf("C");
                    specifiedLengthString = chopped.substring(0, indexC);
                    charSetString = chopped.substring(indexC + 1).trim();
                    specifiedLength = Integer.parseInt(specifiedLengthString);
                    charSet = Integer.parseInt(charSetString);
                    char[] chars37 = new char[]{'a', 'b', 'c', 'd'};
                    char[] chars1208 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] chars13488 = new char[]{'\u3055', '\u31ff', '\u3066'};
                    char[] chars1200 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] chars835 = new char[]{'\u5e03', '\u5f17', '\u672b', '\u5378', '\u59cb', '\u8679', '\u500c', '\u89f4', '\u9853', '\u8271', '\u8f44', '\u977e', '\u52f1'};
                    char[] baseChars = new char[specifiedLength];
                    char[] stuff = new char[specifiedLength];
                    switch (charSet) {
                        case 37: {
                            baseChars = chars37;
                            break;
                        }
                        case 835: {
                            baseChars = chars835;
                            break;
                        }
                        case 1200: {
                            baseChars = chars1200;
                            break;
                        }
                        case 1208: {
                            baseChars = chars1208;
                            break;
                        }
                        case 13488: {
                            baseChars = chars13488;
                        }
                    }
                    for (int i = 0; i < specifiedLength; ++i) {
                        stuff[i] = baseChars[i % baseChars.length];
                    }
                    stuffString = new String(stuff);
                }
                catch (Exception e) {
                    printStreamForSetParameter.println("Processing of " + thisParm + " failed");
                    printStreamForSetParameter.println("Exception " + e);
                    if (!this.printStackTrace_) break block31;
                    e.printStackTrace(printStreamForSetParameter);
                }
            }
            cstmt.setString(parm, stuffString);
            printStreamForSetParameter.println("CHARARRAY[size=" + specifiedLength + ",CRC32=" + Main.getCRC32(stuffString) + ",CRC32xor1=" + this.getCRC32xor1(stuffString) + "]");
            SQLWarning warning = cstmt.getWarnings();
            if (warning != null && !this.silent_) {
                Main.dispWarning(printStreamForSetParameter, warning, this.hideWarnings_, this.html_);
            }
        } else {
            if (thisParm.indexOf("'") == 0) {
                int lastQuote = thisParm.indexOf("'", 1);
                thisParm = lastQuote > 0 ? thisParm.substring(1, lastQuote) : thisParm.substring(1);
            }
            cstmt.setString(parm, thisParm);
            SQLWarning warning = cstmt.getWarnings();
            if (warning != null && !this.silent_) {
                Main.dispWarning(printStreamForSetParameter, warning, this.hideWarnings_, this.html_);
            }
        }
    }

    static String getCRC32(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        byte[] byteArray = new byte[2 * length];
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            byteArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byteArray[2 * i + 1] = (byte)(c & 0xFF);
        }
        CRC32 checksum = new CRC32();
        checksum.update(byteArray);
        return "" + checksum.getValue();
    }

    String getCRC32xor1(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        byte[] byteArray = new byte[2 * length];
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            byteArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byteArray[2 * i + 1] = byteArray[2 * i] == -40 ? (byte)(c & 0xFF) : (byte)((c ^ '\u0001') & 0xFF);
        }
        CRC32 checksum = new CRC32();
        checksum.update(byteArray);
        return "" + checksum.getValue();
    }

    void handleUnicodeStringParm(PreparedStatement cstmt1, String thisParm, int parm, PrintStream out1) throws SQLException {
        String stuffString = (String)this.getParameterObject(thisParm, out1);
        cstmt1.setString(parm, stuffString);
        SQLWarning warning = cstmt1.getWarnings();
        if (warning != null && !this.silent_) {
            Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
        }
    }

    void handleByteArrayParm(PreparedStatement cstmt1, String thisParm, int parm, PrintStream out1) throws SQLException {
        byte[] stuff = (byte[])this.getParameterObject(thisParm, out1);
        cstmt1.setBytes(parm, stuff);
        SQLWarning warning = cstmt1.getWarnings();
        if (warning != null && !this.silent_) {
            Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
        }
    }

    byte[] getGenByteArrayParm(String thisParm, PrintStream out1) {
        byte[] stuff;
        block3: {
            stuff = null;
            try {
                String lengthString = thisParm.substring(15);
                int length = Integer.parseInt(lengthString);
                stuff = new byte[length];
                for (int i = 0; i < length; ++i) {
                    stuff[i] = (byte)(i & 0xFF);
                }
            }
            catch (Exception e) {
                out1.println("Processing of " + thisParm + " failed");
                out1.println("Exception " + e);
                if (!this.printStackTrace_) break block3;
                e.printStackTrace(out1);
            }
        }
        return stuff;
    }

    void handleGenByteArrayParm(PreparedStatement cstmt1, String thisParm, int parm, PrintStream out1) throws SQLException {
        byte[] stuff = this.getGenByteArrayParm(thisParm, out1);
        cstmt1.setBytes(parm, stuff);
        CRC32 checksum = new CRC32();
        checksum.update(stuff);
        out1.println("GEN_BYTE_ARRAY generated array of size = " + stuff.length + " with checksum of " + checksum.getValue());
    }

    void handleSavedParm(PreparedStatement cstmt1, String thisParm, int parm, PrintStream out1) throws SQLException {
        int number;
        block3: {
            number = 0;
            try {
                String parmNumber = thisParm.substring(10);
                number = Integer.parseInt(parmNumber);
            }
            catch (Exception e) {
                out1.println("Processing of " + thisParm + " failed");
                out1.println("Exception " + e);
                if (!this.printStackTrace_) break block3;
                e.printStackTrace(out1);
            }
        }
        cstmt1.setString(parm, this.savedStringParm_[number]);
        out1.println("SAVEDPARM set(" + parm + "," + this.savedStringParm_[number] + " from saved " + number);
        SQLWarning warning = cstmt1.getWarnings();
        if (warning != null && !this.silent_) {
            Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
        }
    }

    static void appendDigit(StringBuffer buffer, int digit) {
        switch (digit) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 1: {
                buffer.append('1');
                break;
            }
            case 2: {
                buffer.append('2');
                break;
            }
            case 3: {
                buffer.append('3');
                break;
            }
            case 4: {
                buffer.append('4');
                break;
            }
            case 5: {
                buffer.append('5');
                break;
            }
            case 6: {
                buffer.append('6');
                break;
            }
            case 7: {
                buffer.append('7');
                break;
            }
            case 8: {
                buffer.append('8');
                break;
            }
            case 9: {
                buffer.append('9');
                break;
            }
            case 10: {
                buffer.append('a');
                break;
            }
            case 11: {
                buffer.append('b');
                break;
            }
            case 12: {
                buffer.append('c');
                break;
            }
            case 13: {
                buffer.append('d');
                break;
            }
            case 14: {
                buffer.append('e');
                break;
            }
            case 15: {
                buffer.append('f');
            }
        }
    }

    void handleGenHexStringParm(PreparedStatement cstmt1, String thisParm, int parm, PrintStream out1) throws SQLException {
        StringBuffer stuff = null;
        byte[] bytes = null;
        try {
            String lengthString = thisParm.substring(15);
            int length = Integer.parseInt(lengthString);
            stuff = new StringBuffer(2 * length);
            bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)(i & 0xFF);
                Main.appendDigit(stuff, (i & 0xF0) >> 4);
                Main.appendDigit(stuff, i & 0xF);
            }
        }
        catch (Exception e) {
            out1.println("Processing of " + thisParm + " failed");
            out1.println("Exception " + e);
            if (this.printStackTrace_) {
                e.printStackTrace(out1);
            }
            throw new SQLException("Unable to set HexString parameter");
        }
        cstmt1.setString(parm, stuff.toString());
        CRC32 checksum = new CRC32();
        checksum.update(bytes);
        out1.println("GEN_BYTE_ARRAY generated array of size = " + bytes.length + " with checksum of " + checksum.getValue());
        SQLWarning warning = cstmt1.getWarnings();
        if (warning != null && !this.silent_) {
            Main.dispWarning(out1, warning, this.hideWarnings_, this.html_);
        }
    }

    void handleFileBlobParm(PreparedStatement cstmt, String thisParm, int parm, PrintStream out) throws SQLException {
        Blob blob = (Blob)this.getParameterObject(thisParm, out);
        cstmt.setBlob(parm, blob);
    }

    void handleFileClobParm(PreparedStatement cstmt, String thisParm, int parm, PrintStream out) throws SQLException {
        Clob clob = (Clob)this.getParameterObject(thisParm, out);
        cstmt.setClob(parm, clob);
    }

    public java.sql.Array makeArray(Object parameter, String arrayType) throws Exception {
        Object[] objectArray = new Object[]{};
        Class[] argTypes = new Class[]{"".getClass(), objectArray.getClass()};
        java.sql.Array arrayParameter = (java.sql.Array)ReflectionUtil.callMethod_O(this.connection_, "createArrayOf", argTypes, arrayType, parameter);
        return arrayParameter;
    }

    void handleSqlarrayParm(PreparedStatement cstmt, String thisParm, int parm, PrintStream out) throws SQLException {
        block62: {
            try {
                String left = thisParm.substring(9).trim();
                int colonIndex = left.indexOf(":");
                boolean emptyArray = false;
                if (colonIndex == -1 && (colonIndex = left.indexOf("]")) > 0) {
                    emptyArray = true;
                }
                if (colonIndex > 0) {
                    String typename = left.substring(0, colonIndex);
                    left = emptyArray ? left.substring(colonIndex) : left.substring(colonIndex + 1);
                    Vector<String> parameterVector = new Vector<String>();
                    String arraySep = ":";
                    if (typename.equals("Time")) {
                        arraySep = " ";
                    }
                    if (typename.equals("Timestamp")) {
                        arraySep = "|";
                    }
                    colonIndex = left.indexOf(arraySep);
                    while (colonIndex >= 0) {
                        String piece = left.substring(0, colonIndex);
                        parameterVector.addElement(piece);
                        left = left.substring(colonIndex + 1);
                        colonIndex = left.indexOf(arraySep);
                    }
                    int braceIndex = left.indexOf("]");
                    if (braceIndex >= 0) {
                        if (!emptyArray) {
                            parameterVector.addElement(left.substring(0, braceIndex));
                        }
                        int arrayCardinality = parameterVector.size();
                        String validTypes = "String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:boolean:long:float:double:byteArray";
                        if (typename.equals("String")) {
                            String[] parameter = new String[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                if ("null".equals(s)) {
                                    parameter[i] = null;
                                    continue;
                                }
                                if (s.indexOf("UX'") == 0) {
                                    int len = s.length();
                                    char[] stuff = new char[(len -= 4) / 4];
                                    for (int j = 0; j < stuff.length; ++j) {
                                        String piece = s.substring(3 + j * 4, 3 + j * 4 + 4);
                                        stuff[j] = (char)Integer.parseInt(piece, 16);
                                    }
                                    parameter[i] = new String(stuff);
                                    continue;
                                }
                                parameter[i] = s;
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "VARCHAR"));
                            break block62;
                        }
                        if (typename.equals("Clob")) {
                            Clob[] parameter = new Clob[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : new ClientClob(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "CLOB"));
                            break block62;
                        }
                        if (typename.equals("BigDecimal")) {
                            BigDecimal[] parameter = new BigDecimal[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : new BigDecimal(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "DECIMAL"));
                            break block62;
                        }
                        if (typename.equals("Date")) {
                            Date[] parameter = new Date[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Date.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "DATE"));
                            break block62;
                        }
                        if (typename.equals("Time")) {
                            Time[] parameter = new Time[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Time.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "TIME"));
                            break block62;
                        }
                        if (typename.equals("Timestamp")) {
                            Timestamp[] parameter = new Timestamp[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Timestamp.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "TIMESTAMP"));
                            break block62;
                        }
                        if (typename.equals("Integer")) {
                            Integer[] parameter = new Integer[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Integer.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "INTEGER"));
                            break block62;
                        }
                        if (typename.equals("int")) {
                            int[] parameter = new int[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? 0 : Integer.parseInt(s);
                            }
                            Integer[] newParameter = new Integer[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = parameter[i];
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "INTEGER"));
                            break block62;
                        }
                        if (typename.equals("Short")) {
                            Short[] parameter = new Short[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Short.valueOf((short)Integer.parseInt(s));
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "SMALLINT"));
                            break block62;
                        }
                        if (typename.equals("short")) {
                            short[] parameter = new short[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? (short)0 : (short)Integer.parseInt(s);
                            }
                            Short[] newParameter = new Short[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = parameter[i];
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "SMALLINT"));
                            break block62;
                        }
                        if (typename.equals("boolean") || typename.equals("Boolean")) {
                            boolean[] parameter = new boolean[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? false : Boolean.parseBoolean(s);
                            }
                            Boolean[] newParameter = new Boolean[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = parameter[i];
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "BOOLEAN"));
                            break block62;
                        }
                        if (typename.equals("Long")) {
                            Long[] parameter = new Long[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Long.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "BIGINT"));
                            break block62;
                        }
                        if (typename.equals("long")) {
                            long[] parameter = new long[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? 0L : Long.parseLong(s);
                            }
                            Long[] newParameter = new Long[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = parameter[i];
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "BIGINT"));
                            break block62;
                        }
                        if (typename.equals("Float")) {
                            Float[] parameter = new Float[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Float.valueOf((float)Double.parseDouble(s));
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "REAL"));
                            break block62;
                        }
                        if (typename.equals("float")) {
                            float[] parameter = new float[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? 0.0f : (float)Double.parseDouble(s);
                            }
                            Float[] newParameter = new Float[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = Float.valueOf(parameter[i]);
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "REAL"));
                            break block62;
                        }
                        if (typename.equals("Double")) {
                            Double[] parameter = new Double[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? null : Double.valueOf(s);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "DOUBLE"));
                            break block62;
                        }
                        if (typename.equals("double")) {
                            double[] parameter = new double[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                parameter[i] = "null".equals(s) ? 0.0 : Double.parseDouble(s);
                            }
                            Double[] newParameter = new Double[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                newParameter[i] = parameter[i];
                            }
                            cstmt.setArray(parm, this.makeArray(newParameter, "DOUBLE"));
                            break block62;
                        }
                        if (typename.equals("byteArray")) {
                            byte[][] parameter = new byte[arrayCardinality][];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                if ("null".equals(s)) {
                                    parameter[i] = null;
                                    continue;
                                }
                                byte[] stuff = new byte[s.length() / 2];
                                for (int j = 0; j < stuff.length; ++j) {
                                    String piece = s.substring(j * 2, j * 2 + 2);
                                    stuff[j] = (byte)Integer.parseInt(piece, 16);
                                }
                                parameter[i] = stuff;
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "BINARY"));
                            break block62;
                        }
                        if (typename.equals("Blob")) {
                            Blob[] parameter = new Blob[arrayCardinality];
                            for (int i = 0; i < arrayCardinality; ++i) {
                                String s = (String)parameterVector.get(i);
                                if ("null".equals(s)) {
                                    parameter[i] = null;
                                    continue;
                                }
                                byte[] stuff = new byte[s.length() / 2];
                                for (int j = 0; j < stuff.length; ++j) {
                                    String piece = s.substring(j * 2, j * 2 + 2);
                                    stuff[j] = (byte)Integer.parseInt(piece, 16);
                                }
                                parameter[i] = new ClientBlob(stuff);
                            }
                            cstmt.setArray(parm, this.makeArray(parameter, "BLOB"));
                            break block62;
                        }
                        if (typename.equalsIgnoreCase("null")) {
                            cstmt.setObject(parm, null);
                            break block62;
                        }
                        throw new Exception("Type [" + typename + "] not valid: valid types=" + validTypes);
                    }
                    throw new Exception("Unable to find ending brace for SQLARRAY[TYPE:e1:e2:...]");
                }
                throw new Exception("TYPE not found for SQLARRAY[TYPE:e1:e2:...]");
            }
            catch (Exception e) {
                out.println("Processing of ARRAYPARAMETER '" + thisParm + "' failed because of " + e);
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                out.println("Exception " + e);
                if (!this.printStackTrace_) break block62;
                e.printStackTrace(out);
            }
        }
    }

    void addVariable(String var, Object value) {
        this.variables.put(var, value);
        if (var.equals("CON")) {
            this.connection_ = (Connection)value;
        } else if (var.equals("STMT")) {
            this.stmt_ = (Statement)value;
        } else if (var.equals("PSTMT")) {
            this.pstmt_ = (PreparedStatement)value;
        } else if (var.equals("CSTMT")) {
            this.cstmt_ = (CallableStatement)value;
        } else if (var.equals("RS")) {
            this.manualResultSet_ = (ResultSet)value;
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(usage);
            System.exit(1);
        } else {
            try {
                Main main = args.length == 1 ? new Main(args[0], null, null) : (args.length == 2 ? new Main(args[0], args[1], null) : new Main(args[0], args[1], args[2]));
                int rc = main.go(System.in, System.out);
                System.exit(rc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

