/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class PcmlMessageLog {
    private static OutputStream m_outputStream;
    private static StringBuffer m_cp37Table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void main(String[] args) throws IOException {
        FileOutputStream logStream = null;
        try {
            PcmlMessageLog.setTraceEnabled(true);
            Trace.setTraceErrorOn(true);
            PcmlMessageLog.logError("This is a test error to the console");
            PcmlMessageLog.traceOut("Message to stdout");
            PcmlMessageLog.traceErr("Message to stderr");
            PcmlMessageLog.traceOut("Test dump of byte array: " + PcmlMessageLog.toHexString(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}));
            Trace.log(7, "Test dump of byte array: " + PcmlMessageLog.toHexString(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}));
            byte[] bytes = new byte[256];
            for (int b = -128; b < 127; b = (int)((byte)(b + 1))) {
                bytes[b - -128] = b;
            }
            bytes[255] = 127;
            PcmlMessageLog.dumpBytes(bytes);
            PcmlMessageLog.setLogFileName("pcml.log");
            PcmlMessageLog.logError("This is a test error to pcml.log");
            logStream = new FileOutputStream("user.log");
            PcmlMessageLog.setLogStream(logStream);
            PcmlMessageLog.logError("This is a test error to user.log with throwable", new IllegalArgumentException("test exception"));
            PcmlMessageLog.setLogFileName(null);
            PcmlMessageLog.logError("This is a test error back to the console");
            PcmlMessageLog.setTraceEnabled(false);
            Trace.log(7, "Message to stdout should not be sent");
            Trace.setTraceErrorOn(false);
            Trace.log(2, "Message to stderr should not be sent");
            System.out.println("Test complete!");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (logStream != null) {
                try {
                    logStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private PcmlMessageLog() {
    }

    public static void setLogFileName(String fileName) throws IOException {
        Trace.setFileName(fileName);
    }

    public static String getLogFileName() {
        return Trace.getFileName();
    }

    public static void setLogStream(OutputStream stream) {
        PrintWriter logTarget = null;
        if (stream != null) {
            m_outputStream = stream;
            logTarget = new PrintWriter(stream, true);
        } else {
            m_outputStream = System.err;
            logTarget = new PrintWriter(System.err, true);
        }
        try {
            Trace.setPrintWriter(logTarget);
        }
        catch (IOException e) {
            Trace.log(2, e);
        }
    }

    public static OutputStream getLogStream() {
        return m_outputStream;
    }

    public static void logError(Object errorData) {
        Trace.log(2, errorData.toString());
    }

    public static void logError(Object errorData, Throwable t) {
        Trace.log(2, errorData.toString(), t);
    }

    public static void printStackTrace(Throwable t) {
        PrintWriter logTarget = Trace.getPrintWriter();
        logTarget.println("Stack trace:");
        t.printStackTrace(logTarget);
    }

    public static void setTraceEnabled(boolean enabled) {
        Trace.setTracePCMLOn(enabled);
        if (enabled) {
            Trace.setTraceOn(enabled);
        }
    }

    public static boolean isTraceEnabled() {
        return Trace.isTracePCMLOn();
    }

    public static void traceOut(Object data) {
    }

    public static void traceErr(Object data) {
    }

    static void traceParameter(String program, String parmName, byte[] bytes) {
        if (Trace.isTracePCMLOn()) {
            Trace.log(7, program + "\t  " + parmName);
            PcmlMessageLog.dumpBytes(bytes);
        }
    }

    private static void dumpBytes(byte[] ba) {
        int offset;
        if (ba == null || ba.length == 0) {
            return;
        }
        int arrayLength = ba.length;
        StringBuffer cp37Str = new StringBuffer();
        StringBuffer byteString = new StringBuffer();
        for (offset = 0; offset < arrayLength; offset += 4) {
            if (offset % 32 == 0) {
                if (offset == 0) {
                    Trace.log(7, "Offset : 0....... 4....... 8....... C....... 0....... 4....... 8....... C.......   0...4...8...C...0...4...8...C...");
                } else {
                    byteString.append(" *");
                    byteString.append(cp37Str.toString());
                    byteString.append("*");
                    Trace.log(7, byteString.toString());
                    cp37Str.setLength(0);
                    byteString.setLength(0);
                }
                Object offStr = "      " + Integer.toHexString(offset);
                offStr = ((String)offStr).substring(((String)offStr).length() - 6);
                byteString.append((String)offStr);
                byteString.append(" : ");
            }
            byteString.append(PcmlMessageLog.toHexString(ba, offset, 4));
            byteString.append(" ");
            cp37Str.append(PcmlMessageLog.toCP37String(ba, offset, 4));
        }
        if (offset > 0) {
            for (int b = arrayLength; b < offset; ++b) {
                byteString.append("  ");
                cp37Str.append(" ");
            }
            while (offset % 32 != 0) {
                byteString.append("         ");
                cp37Str.append("    ");
                offset += 4;
            }
            byteString.append(" *");
            byteString.append(cp37Str.toString());
            byteString.append("*");
            Trace.log(7, byteString.toString());
            byteString.setLength(0);
            cp37Str.setLength(0);
        }
    }

    private static String toCP37String(byte[] ba, int index, int length) {
        if (ba == null || ba.length == 0 || index < 0 || index >= ba.length) {
            return "";
        }
        int arrayLength = ba.length;
        int endIndex = index + length <= arrayLength ? index + length - 1 : arrayLength - 1;
        StringBuffer cp37String = new StringBuffer(endIndex - index + 1);
        for (int b = index; b <= endIndex; ++b) {
            if (ba[b] < 0) {
                cp37String.append(m_cp37Table.charAt(256 + ba[b]));
                continue;
            }
            cp37String.append(m_cp37Table.charAt(ba[b]));
        }
        return cp37String.toString();
    }

    static String toHexString(byte[] ba) {
        if (ba == null) {
            return "";
        }
        return PcmlMessageLog.toHexString(ba, 0, ba.length);
    }

    static String toHexString(byte[] ba, int index, int length) {
        if (ba == null || ba.length == 0 || index < 0 || index >= ba.length) {
            return "";
        }
        int arrayLength = ba.length;
        int endIndex = index + length <= arrayLength ? index + length - 1 : arrayLength - 1;
        StringBuffer hexString = new StringBuffer((endIndex - index + 1) * 2);
        for (int b = index; b <= endIndex; ++b) {
            hexString.append(Trace.toHexString(ba[b]));
        }
        return hexString.toString();
    }

    static {
        m_cp37Table = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            m_cp37Table.append('.');
        }
        m_cp37Table.setCharAt(64, ' ');
        m_cp37Table.setCharAt(75, '.');
        m_cp37Table.setCharAt(76, '<');
        m_cp37Table.setCharAt(77, '(');
        m_cp37Table.setCharAt(78, '+');
        m_cp37Table.setCharAt(80, '&');
        m_cp37Table.setCharAt(90, '!');
        m_cp37Table.setCharAt(91, '$');
        m_cp37Table.setCharAt(92, '*');
        m_cp37Table.setCharAt(93, ')');
        m_cp37Table.setCharAt(94, ';');
        m_cp37Table.setCharAt(96, '-');
        m_cp37Table.setCharAt(97, '/');
        m_cp37Table.setCharAt(106, '|');
        m_cp37Table.setCharAt(107, ',');
        m_cp37Table.setCharAt(108, '%');
        m_cp37Table.setCharAt(109, '_');
        m_cp37Table.setCharAt(110, '>');
        m_cp37Table.setCharAt(111, '?');
        m_cp37Table.setCharAt(121, '`');
        m_cp37Table.setCharAt(122, ':');
        m_cp37Table.setCharAt(123, '#');
        m_cp37Table.setCharAt(124, '@');
        m_cp37Table.setCharAt(125, '\'');
        m_cp37Table.setCharAt(126, '=');
        m_cp37Table.setCharAt(127, '\"');
        m_cp37Table.setCharAt(129, 'a');
        m_cp37Table.setCharAt(130, 'b');
        m_cp37Table.setCharAt(131, 'c');
        m_cp37Table.setCharAt(132, 'd');
        m_cp37Table.setCharAt(133, 'e');
        m_cp37Table.setCharAt(134, 'f');
        m_cp37Table.setCharAt(135, 'g');
        m_cp37Table.setCharAt(136, 'h');
        m_cp37Table.setCharAt(137, 'i');
        m_cp37Table.setCharAt(145, 'j');
        m_cp37Table.setCharAt(146, 'k');
        m_cp37Table.setCharAt(147, 'l');
        m_cp37Table.setCharAt(148, 'm');
        m_cp37Table.setCharAt(149, 'n');
        m_cp37Table.setCharAt(150, 'o');
        m_cp37Table.setCharAt(151, 'p');
        m_cp37Table.setCharAt(152, 'q');
        m_cp37Table.setCharAt(153, 'r');
        m_cp37Table.setCharAt(162, 's');
        m_cp37Table.setCharAt(163, 't');
        m_cp37Table.setCharAt(164, 'u');
        m_cp37Table.setCharAt(165, 'v');
        m_cp37Table.setCharAt(166, 'w');
        m_cp37Table.setCharAt(167, 'x');
        m_cp37Table.setCharAt(168, 'y');
        m_cp37Table.setCharAt(169, 'z');
        m_cp37Table.setCharAt(193, 'A');
        m_cp37Table.setCharAt(194, 'B');
        m_cp37Table.setCharAt(195, 'C');
        m_cp37Table.setCharAt(196, 'D');
        m_cp37Table.setCharAt(197, 'E');
        m_cp37Table.setCharAt(198, 'F');
        m_cp37Table.setCharAt(199, 'G');
        m_cp37Table.setCharAt(200, 'H');
        m_cp37Table.setCharAt(201, 'I');
        m_cp37Table.setCharAt(209, 'J');
        m_cp37Table.setCharAt(210, 'K');
        m_cp37Table.setCharAt(211, 'L');
        m_cp37Table.setCharAt(212, 'M');
        m_cp37Table.setCharAt(213, 'N');
        m_cp37Table.setCharAt(214, 'O');
        m_cp37Table.setCharAt(215, 'P');
        m_cp37Table.setCharAt(216, 'Q');
        m_cp37Table.setCharAt(217, 'R');
        m_cp37Table.setCharAt(226, 'S');
        m_cp37Table.setCharAt(227, 'T');
        m_cp37Table.setCharAt(228, 'U');
        m_cp37Table.setCharAt(229, 'V');
        m_cp37Table.setCharAt(230, 'W');
        m_cp37Table.setCharAt(231, 'X');
        m_cp37Table.setCharAt(232, 'Y');
        m_cp37Table.setCharAt(233, 'Z');
        m_cp37Table.setCharAt(240, '0');
        m_cp37Table.setCharAt(241, '1');
        m_cp37Table.setCharAt(242, '2');
        m_cp37Table.setCharAt(243, '3');
        m_cp37Table.setCharAt(244, '4');
        m_cp37Table.setCharAt(245, '5');
        m_cp37Table.setCharAt(246, '6');
        m_cp37Table.setCharAt(247, '7');
        m_cp37Table.setCharAt(248, '8');
        m_cp37Table.setCharAt(249, '9');
    }
}

