/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.KeyedDataQueue;
import com.ibm.as400.access.KeyedDataQueueEntry;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400DataQueueService;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400DataQueueConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400DataQueueConsumer.class);
    private final Jt400DataQueueService queueService;

    public Jt400DataQueueConsumer(Jt400Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.queueService = new Jt400DataQueueService(endpoint);
    }

    @Override
    public Jt400Endpoint getEndpoint() {
        return (Jt400Endpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        Exchange exchange = this.receive(this.getEndpoint().getReadTimeout());
        if (exchange != null) {
            this.getProcessor().process(exchange);
            return 1;
        }
        return 0;
    }

    @Override
    protected void doStart() throws Exception {
        this.queueService.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.queueService.stop();
    }

    @Deprecated
    public Exchange receive() {
        return this.receive(-1L);
    }

    @Deprecated
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    public Exchange receive(long timeout) {
        BaseDataQueue queue = this.queueService.getDataQueue();
        try {
            if (this.getEndpoint().isKeyed()) {
                return this.receive((KeyedDataQueue)queue, timeout);
            }
            return this.receive((DataQueue)queue, timeout);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), e);
        }
    }

    private Exchange receive(DataQueue queue, long timeout) throws Exception {
        DataQueueEntry entry;
        if (timeout >= 0L) {
            int seconds = (int)timeout / 1000;
            LOG.trace("Reading from data queue: {} with {} seconds timeout", (Object)queue.getName(), (Object)seconds);
            entry = queue.read(seconds);
        } else {
            LOG.trace("Reading from data queue: {} with no timeout", (Object)queue.getName());
            entry = queue.read(-1);
        }
        Exchange exchange = this.getEndpoint().createExchange();
        if (entry != null) {
            exchange.getIn().setHeader("SENDER_INFORMATION", entry.getSenderInformation());
            if (this.getEndpoint().getFormat() == Jt400Configuration.Format.binary) {
                exchange.getIn().setBody(entry.getData());
            } else {
                exchange.getIn().setBody(entry.getString());
            }
            return exchange;
        }
        return null;
    }

    private Exchange receive(KeyedDataQueue queue, long timeout) throws Exception {
        KeyedDataQueueEntry entry;
        String key = this.getEndpoint().getSearchKey();
        String searchType = this.getEndpoint().getSearchType().name();
        if (timeout >= 0L) {
            int seconds = (int)timeout / 1000;
            LOG.trace("Reading from data queue: {} with {} seconds timeout", (Object)queue.getName(), (Object)seconds);
            entry = queue.read(key, seconds, searchType);
        } else {
            LOG.trace("Reading from data queue: {} with no timeout", (Object)queue.getName());
            entry = queue.read(key, -1, searchType);
        }
        Exchange exchange = this.createExchange(true);
        if (entry != null) {
            exchange.getIn().setHeader("SENDER_INFORMATION", entry.getSenderInformation());
            if (this.getEndpoint().getFormat() == Jt400Configuration.Format.binary) {
                exchange.getIn().setBody(entry.getData());
                exchange.getIn().setHeader("KEY", entry.getKey());
            } else {
                exchange.getIn().setBody(entry.getString());
                exchange.getIn().setHeader("KEY", entry.getKeyString());
            }
            return exchange;
        }
        return null;
    }
}

