/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.BaseDataQueue;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.KeyedDataQueue;
import org.apache.camel.Exchange;
import org.apache.camel.component.jt400.Jt400Configuration;
import org.apache.camel.component.jt400.Jt400DataQueueService;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.support.DefaultProducer;

public class Jt400DataQueueProducer
extends DefaultProducer {
    private final Jt400Endpoint endpoint;

    protected Jt400DataQueueProducer(Jt400Endpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        try (Jt400DataQueueService queueService = new Jt400DataQueueService(this.endpoint);){
            queueService.start();
            BaseDataQueue queue = queueService.getDataQueue();
            if (this.endpoint.isKeyed()) {
                this.process((KeyedDataQueue)queue, exchange);
            } else {
                this.process((DataQueue)queue, exchange);
            }
        }
    }

    private void process(DataQueue queue, Exchange exchange) throws Exception {
        if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
            queue.write(exchange.getIn().getBody(byte[].class));
        } else {
            queue.write(exchange.getIn().getBody(String.class));
        }
    }

    private void process(KeyedDataQueue queue, Exchange exchange) throws Exception {
        if (this.endpoint.getFormat() == Jt400Configuration.Format.binary) {
            queue.write(exchange.getIn().getHeader("KEY", byte[].class), exchange.getIn().getBody(byte[].class));
        } else {
            queue.write(exchange.getIn().getHeader("KEY", String.class), exchange.getIn().getBody(String.class));
        }
    }
}

