/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageQueue;
import java.io.IOException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.jt400.Jt400Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jt400MsgQueueService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400MsgQueueService.class);
    private final Jt400Endpoint endpoint;
    private MessageQueue queue;

    Jt400MsgQueueService(Jt400Endpoint endpoint) {
        ObjectHelper.notNull(endpoint, "endpoint", this);
        this.endpoint = endpoint;
    }

    @Override
    public void start() {
        if (this.queue == null) {
            AS400 system = this.endpoint.getSystem();
            this.queue = new MessageQueue(system, this.endpoint.getObjectPath());
        }
        if (!this.queue.getSystem().isConnected(2)) {
            LOG.debug("Connecting to {}", (Object)this.endpoint);
            try {
                this.queue.getSystem().connectService(2);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.queue != null) {
            LOG.debug("Releasing connection to {}", (Object)this.endpoint);
            AS400 system = this.queue.getSystem();
            this.queue = null;
            this.endpoint.releaseSystem(system);
        }
    }

    public MessageQueue getMsgQueue() {
        return this.queue;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }
}

