/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BidiFlag;
import com.ibm.as400.access.BidiFlagSet;
import com.ibm.as400.access.BidiText;
import com.ibm.as400.access.BidiTransform;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.sql.SQLException;

public class AS400BidiTransform {
    static final int ST1 = 1;
    static final int ST2 = 2;
    static final int ST3 = 3;
    static final int ST4 = 4;
    static final int ST5 = 5;
    static final int ST6 = 6;
    static final int ST7 = 7;
    static final int ST8 = 8;
    static final int ST9 = 9;
    static final int ST10 = 10;
    static final int ST11 = 11;
    static final int ST12 = 12;
    static final int ST13 = 13;
    static final int ST14 = 14;
    private static final int[][] CCSID_TABLE = new int[][]{{420, 4}, {424, 4}, {425, 5}, {856, 5}, {862, 4}, {864, 5}, {867, 4}, {916, 5}, {1046, 5}, {1089, 5}, {1255, 5}, {1256, 5}, {5012, 5}, {5351, 5}, {5352, 5}, {8612, 5}, {8616, 10}, {9238, 5}, {12708, 7}, {12712, 10}, {13488, 10}, {16804, 4}, {17248, 5}, {61952, 10}, {62208, 4}, {62209, 10}, {62210, 4}, {62211, 5}, {62212, 10}, {62213, 5}, {62214, 5}, {62215, 4}, {62216, 6}, {62217, 8}, {62218, 4}, {62219, 11}, {62220, 6}, {62221, 6}, {62222, 6}, {62223, 6}, {62224, 6}, {62225, 6}, {62226, 6}, {62227, 6}, {62228, 6}, {62229, 8}, {62230, 8}, {62231, 8}, {62232, 8}, {62233, 8}, {62234, 9}, {62235, 6}, {62236, 10}, {62237, 8}, {62238, 10}, {62239, 10}, {62240, 11}, {62241, 11}, {62242, 11}, {62243, 11}, {62244, 11}, {62245, 10}, {62251, 6}};
    private static final int CCSID_MAX = CCSID_TABLE.length - 1;
    private static final BidiFlagSet[] FLAG_SET = new BidiFlagSet[12];
    private static final BidiFlagSet NORMAL_FLAG_SET = AS400BidiTransform.initFlagSet(0);
    private int as400Ccsid_;
    private int as400Type_;
    private int javaType_;
    private BidiTransform bdxJ2A_ = new BidiTransform();
    private BidiTransform bdxA2J_;
    private BidiTransform lastTransform_ = this.bdxA2J_ = new BidiTransform();

    public AS400BidiTransform(int as400Ccsid) {
        this.bdxA2J_.flags = new BidiFlagSet(NORMAL_FLAG_SET);
        this.setAS400Ccsid(as400Ccsid);
        this.setJavaStringType(0);
    }

    public static boolean isBidiCcsid(int ccsid) {
        switch (ccsid) {
            case 420: 
            case 424: 
            case 425: 
            case 856: 
            case 862: 
            case 864: 
            case 867: 
            case 916: 
            case 1046: 
            case 1089: 
            case 1255: 
            case 1256: 
            case 5012: 
            case 5351: 
            case 5352: 
            case 8612: 
            case 8616: 
            case 9238: 
            case 12708: 
            case 12712: 
            case 13488: 
            case 16804: 
            case 17248: 
            case 61952: 
            case 62208: 
            case 62209: 
            case 62210: 
            case 62211: 
            case 62212: 
            case 62213: 
            case 62214: 
            case 62215: 
            case 62216: 
            case 62217: 
            case 62218: 
            case 62219: 
            case 62220: 
            case 62221: 
            case 62222: 
            case 62223: 
            case 62224: 
            case 62225: 
            case 62226: 
            case 62227: 
            case 62228: 
            case 62229: 
            case 62230: 
            case 62231: 
            case 62232: 
            case 62233: 
            case 62234: 
            case 62235: 
            case 62236: 
            case 62237: 
            case 62238: 
            case 62239: 
            case 62240: 
            case 62241: 
            case 62242: 
            case 62243: 
            case 62244: 
            case 62245: 
            case 62251: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVisual(int ccsid) {
        int st = AS400BidiTransform.getStringType(ccsid);
        return st == 4 || st == 7 || st == 8 || st == 9;
    }

    public void setAS400Ccsid(int as400Ccsid) {
        this.as400Ccsid_ = as400Ccsid;
        this.setAS400StringType(AS400BidiTransform.getStringType(as400Ccsid));
    }

    public int getAS400Ccsid() {
        return this.as400Ccsid_;
    }

    public void setAS400StringType(int as400Type) {
        this.as400Type_ = as400Type;
        if (FLAG_SET[as400Type] == null) {
            AS400BidiTransform.FLAG_SET[as400Type] = AS400BidiTransform.initFlagSet(as400Type);
        }
        this.bdxJ2A_.flags = FLAG_SET[as400Type];
    }

    public int getAS400StringType() {
        return this.as400Type_;
    }

    public void setJavaStringType(int javaType) {
        this.javaType_ = javaType;
        this.bdxA2J_.flags = AS400BidiTransform.initFlagSet(javaType);
    }

    public int getJavaStringType() {
        return this.javaType_;
    }

    public void setBidiConversionProperties(BidiConversionProperties properties) {
        this.setJavaStringType(properties.getBidiStringType());
        properties.copyOptionsTo(this.bdxJ2A_);
        properties.copyOptionsTo(this.bdxA2J_);
        if (properties.isBidiRemoveMarksOnImplicitToVisual()) {
            this.bdxJ2A_.removeMarkers = true;
            this.bdxA2J_.removeMarkers = false;
        }
    }

    public BidiConversionProperties getBidiConversionProperties() {
        boolean removeMarksOnJ2A = this.bdxJ2A_.removeMarkers && !this.bdxA2J_.removeMarkers;
        return new BidiConversionProperties(this.getJavaStringType(), this.lastTransform_, removeMarksOnJ2A);
    }

    public String toJavaLayout(String as400Text) {
        this.lastTransform_ = this.bdxA2J_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return as400Text;
        }
        BidiText src = new BidiText(this.bdxJ2A_.flags, as400Text);
        return src.transform(this.bdxA2J_).toString();
    }

    public char[] toJavaLayout(char[] as400Text) {
        this.lastTransform_ = this.bdxA2J_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return as400Text;
        }
        BidiText src = new BidiText(this.bdxJ2A_.flags, as400Text);
        return src.transform((BidiTransform)this.bdxA2J_).data;
    }

    public String toAS400Layout(String javaText) {
        this.lastTransform_ = this.bdxJ2A_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return javaText;
        }
        BidiText src = new BidiText(this.bdxA2J_.flags, javaText);
        return src.transform(this.bdxJ2A_).toString();
    }

    public char[] toAS400Layout(char[] javaText) {
        this.lastTransform_ = this.bdxJ2A_;
        if (this.as400Type_ == -1 || this.javaType_ == -1 || this.javaType_ == this.as400Type_) {
            return javaText;
        }
        BidiText src = new BidiText(this.bdxA2J_.flags, javaText);
        return src.transform((BidiTransform)this.bdxJ2A_).data;
    }

    public static int getStringType(int ccsid) {
        int low = 0;
        int high = CCSID_MAX;
        while (low < high) {
            int mid = low + high >>> 1;
            if (ccsid < CCSID_TABLE[mid][0]) {
                high = mid - 1;
                continue;
            }
            if (ccsid > CCSID_TABLE[mid][0]) {
                low = mid + 1;
                continue;
            }
            return CCSID_TABLE[mid][1];
        }
        if (low == high && ccsid == CCSID_TABLE[low][0]) {
            return CCSID_TABLE[low][1];
        }
        return 0;
    }

    static int getStringTypeM(int ccsid) {
        if (ccsid == 13488 || ccsid == 1200) {
            return 5;
        }
        return AS400BidiTransform.getStringType(ccsid);
    }

    public static int getStringTypeX(int ccsid, AS400 as400) {
        if (as400 == null) {
            return AS400BidiTransform.getStringType(ccsid);
        }
        if (ccsid == 13488 || ccsid == 1200) {
            boolean v5r1 = false;
            try {
                v5r1 = as400.getVersion() == 5 && as400.getRelease() == 1;
            }
            catch (AS400SecurityException aS400SecurityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (AS400BidiTransform.isBidiCcsid(as400.getCcsid()) && !v5r1) {
                return 10;
            }
            return 5;
        }
        return AS400BidiTransform.getStringType(ccsid);
    }

    private static BidiFlagSet initFlagSet(int stringType) {
        switch (stringType) {
            case 4: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_NO);
            }
            case 5: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 6: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 7: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_NO);
            }
            case 8: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_NO);
            }
            case 9: {
                return new BidiFlagSet(BidiFlag.TYPE_VISUAL, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_RTL, BidiFlag.TEXT_SHAPED, BidiFlag.SWAP_YES);
            }
            case 10: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
            case 11: {
                return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_CONTEXT_RTL, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
            }
        }
        return new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.NUMERALS_NOMINAL, BidiFlag.ORIENTATION_LTR, BidiFlag.TEXT_NOMINAL, BidiFlag.SWAP_YES);
    }

    public static String bidiTransform(String str, int inFormat, int outFormat) {
        BidiFlagSet flagsOut;
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation from " + inFormat + " to " + outFormat + ", string: " + str);
        }
        if (inFormat == outFormat) {
            return str;
        }
        if (inFormat == -1 || outFormat == -1) {
            return str;
        }
        BidiTransform bdx = new BidiTransform();
        BidiFlagSet flagsIn = AS400BidiTransform.initFlagSet(inFormat);
        bdx.flags = flagsOut = AS400BidiTransform.initFlagSet(outFormat);
        bdx.removeMarkers = true;
        BidiText textIn = new BidiText(flagsIn, str);
        BidiText textOut = textIn.transform(bdx);
        String strOut = textOut.toString();
        return strOut;
    }

    public static String SQL_statement_reordering(String value_, int inFormat, int outFormat) {
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation from " + inFormat + " to " + outFormat + " of SQL statement: " + (String)value_);
        }
        if (inFormat == outFormat) {
            return value_;
        }
        if (inFormat == -1 || outFormat == -1) {
            return value_;
        }
        boolean into = false;
        int i = 0;
        int start = 0;
        int end = 0;
        while (i < ((String)value_).length()) {
            String str;
            if (into && (((String)value_).charAt(i) == '\n' || ((String)value_).charAt(i) == '\r')) {
                end = i;
                str = ((String)value_).substring(start, end);
                str = AS400BidiTransform.bidiTransform(str, inFormat, outFormat);
                value_ = ((String)value_).substring(0, start) + str + ((String)value_).substring(end);
                start = i + 1;
            }
            if (((String)value_).charAt(i) == '\'') {
                if (into) {
                    if (i + 1 < ((String)value_).length() && ((String)value_).charAt(i + 1) == '\'') {
                        i += 2;
                        continue;
                    }
                    end = i;
                    str = ((String)value_).substring(start, end);
                    str = AS400BidiTransform.bidiTransform(str, inFormat, outFormat);
                    value_ = ((String)value_).substring(0, start) + str + ((String)value_).substring(end);
                    end = 0;
                    start = 0;
                    into = false;
                } else {
                    into = true;
                    start = i + 1;
                }
            }
            ++i;
        }
        return value_;
    }

    public static String meta_data_reordering(String value_, int inFormat, int outFormat) {
        if (Trace.traceOn_) {
            Trace.log(5, "Bidi layout transformation of SQL meta-data: " + (String)value_);
        }
        if (inFormat == outFormat) {
            return value_;
        }
        if (inFormat == -1 || outFormat == -1) {
            return value_;
        }
        boolean into = false;
        int start = 0;
        int end = 0;
        for (int i = 0; i < ((String)value_).length(); ++i) {
            if (((String)value_).charAt(i) != '\"') continue;
            if (into) {
                end = i;
                String str = ((String)value_).substring(start, end);
                str = AS400BidiTransform.bidiTransform(str, inFormat, outFormat);
                value_ = ((String)value_).substring(0, start) + str + ((String)value_).substring(end);
                end = 0;
                start = 0;
                into = false;
                continue;
            }
            into = true;
            start = i + 1;
        }
        return value_;
    }

    static String convertSQLToHostCCSID(String value_, AS400JDBCConnection connection) throws SQLException {
        int host_bidi_format;
        if (connection == null || value_ == null) {
            return value_;
        }
        JDProperties prop = connection.getProperties();
        int bidi_format = prop.getInt(42);
        if (connection.getSystem() != null) {
            int host_ccsid = connection.getSystem().getCcsid();
            host_bidi_format = AS400BidiTransform.getStringType(host_ccsid);
        } else {
            host_bidi_format = 4;
        }
        int package_ccsid = connection.getProperties().getInt(51);
        int package_bidi_format = AS400BidiTransform.getStringTypeX(package_ccsid, connection.getSystem());
        if (bidi_format != -1 && host_bidi_format != -1) {
            if (prop.getString(60).equalsIgnoreCase("true")) {
                value_ = AS400BidiTransform.meta_data_reordering(value_, bidi_format, host_bidi_format);
            }
            value_ = AS400BidiTransform.SQL_statement_reordering(value_, bidi_format, package_bidi_format);
        }
        return value_;
    }

    static String convertDataFromHostCCSID(String value_, AS400JDBCConnection connection, int host_ccsid) throws SQLException {
        if (connection == null || value_ == null) {
            return value_;
        }
        JDProperties prop = connection.getProperties();
        int bidi_format = prop.getInt(42);
        int host_bidi_format = AS400BidiTransform.getStringTypeX(host_ccsid, connection.getSystem());
        if (host_bidi_format == 0) {
            if (connection.getSystem() != null) {
                host_ccsid = connection.getSystem().getCcsid();
                host_bidi_format = AS400BidiTransform.getStringType(host_ccsid);
            } else {
                host_bidi_format = 4;
            }
        }
        if (bidi_format != 0 && host_bidi_format != 0) {
            value_ = AS400BidiTransform.bidiTransform(value_, host_bidi_format, bidi_format);
        }
        return value_;
    }
}

