/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Certificate;
import com.ibm.as400.access.AS400CertificateAttribute;
import com.ibm.as400.access.AS400CertificateEvent;
import com.ibm.as400.access.AS400CertificateListener;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class AS400CertificateUtil
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400CertificateUtil";
    static final long serialVersionUID = 4L;
    public static final int DEFAULT_BUFFER_SIZE = 128;
    public static final int MAX_BUFFER_SIZE = 16384;
    public static final int MIN_BUFFER_SIZE = 8;
    String ifsPathName_;
    String libName_;
    String objectName_;
    String objectType_;
    String usrSpaceName_;
    AS400 system_ = null;
    transient boolean connected_ = false;
    transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    transient Vector certListeners_ = new Vector();
    transient VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    String[] as400AttrS_;
    byte[][] as400AttrB_;
    int nextCertificateToReturn_ = 0;
    int nextCertificateOffset_ = -1;
    int numberCertificatesFound_ = 0;
    transient AS400CertificateUtilImpl impl_ = null;
    static final int EXTENDED_IO_EXCP = 1;
    static final int ILLEGAL_ARG_EXCP = 2;
    static final int ACCESS_EXCP = 3;
    static final int DOES_NOT_EXIST_EXCP = 4;
    static final int INTERNAL_ERR_EXCP = 5;
    static final int SUCCESS = 0;
    private String info_;

    public AS400CertificateUtil() {
    }

    public AS400CertificateUtil(AS400 system, String path) {
        this.system_ = system;
        if (null == this.system_) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.ifsPathName_ = path;
        QSYSObjectPathName ifs = new QSYSObjectPathName(path);
        this.libName_ = ifs.getLibraryName();
        this.objectName_ = ifs.getObjectName();
        this.objectType_ = ifs.getObjectType();
        if (null == this.libName_ || null == this.objectName_) {
            throw new ExtendedIllegalArgumentException("path", 3);
        }
    }

    public abstract void addCertificate(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void addAS400CertificateListener(AS400CertificateListener listener) {
        this.certListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.addVetoableChangeListener(l);
    }

    public abstract void deleteCertificate(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public abstract void deleteCertificateByHandle(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public AS400Certificate[] getCertificates(String userSpaceName, int firstCertificateToReturn, int buffSize) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        this.setAS400UserSpaceName(userSpaceName);
        if (firstCertificateToReturn < 0) {
            throw new ExtendedIllegalArgumentException("firstCertificateToReturn (" + firstCertificateToReturn + ")", 4);
        }
        if (buffSize < 8 || buffSize > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + buffSize + ")", 4);
        }
        int rc = this.impl_.callgetCertificates(this.usrSpaceName_, buffSize *= 1024, firstCertificateToReturn, -1);
        if (rc != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, rc);
        }
        if (this.impl_.certificates_ == null) {
            throw new ExtendedIOException("userSpaceName (" + userSpaceName + ")", 40);
        }
        this.nextCertificateToReturn_ = this.impl_.certificates_.length + firstCertificateToReturn;
        this.numberCertificatesFound_ = this.impl_.numberCertificatesFound_;
        this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public byte[] getCertificateHandle(byte[] certificate) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int rc;
        if (null == certificate) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((rc = this.impl_.callgetHandle(certificate, certificate.length)) != 0) {
            int exception = rc / 1000;
            int msgNumber = rc % 1000;
            this.impl_.cpfError_ = null == this.impl_.cpfError_ || 0 == this.impl_.cpfError_.length() ? this.ifsPathName_ : this.impl_.cpfError_.trim() + ": " + this.ifsPathName_;
            switch (exception) {
                case 1: {
                    throw new ExtendedIOException(this.impl_.cpfError_, msgNumber);
                }
            }
            throw new ExtendedIOException(this.impl_.cpfError_, 42);
        }
        return this.impl_.handle_;
    }

    public AS400Certificate[] getFirstCertificates(String userSpaceName, int buffSize) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        this.setAS400UserSpaceName(userSpaceName);
        if (buffSize < 8 || buffSize > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + buffSize + ")", 4);
        }
        int rc = this.impl_.callgetCertificates(this.usrSpaceName_, buffSize *= 1024, 0, -1);
        if (rc != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, rc);
        }
        if (this.impl_.certificates_ == null) {
            throw new ExtendedIOException("userSpaceName (" + userSpaceName + ")", 40);
        }
        this.nextCertificateToReturn_ = this.impl_.certificates_.length;
        this.numberCertificatesFound_ = this.impl_.numberCertificatesFound_;
        this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public String getName() {
        if (this.ifsPathName_ == null) {
            return "";
        }
        return this.objectName_;
    }

    public AS400Certificate[] getNextCertificates(int buffSize) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        if (null == this.usrSpaceName_ || -1 == this.nextCertificateOffset_) {
            throw new ExtendedIOException(16);
        }
        if (0 > this.nextCertificateToReturn_) {
            return null;
        }
        if (buffSize < 8 || buffSize > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + buffSize + ")", 4);
        }
        int rc = this.impl_.callgetCertificates(this.usrSpaceName_, buffSize *= 1024, this.nextCertificateToReturn_, this.nextCertificateOffset_);
        if (rc != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, rc);
        }
        if (this.nextCertificateToReturn_ < this.numberCertificatesFound_) {
            if (this.impl_.certificates_ == null) {
                throw new ExtendedIOException("userSpaceName_ (" + this.usrSpaceName_ + ")", 40);
            }
            this.nextCertificateToReturn_ += this.impl_.certificates_.length;
            this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        }
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public String getObjectInfo() {
        return this.info_;
    }

    public String getPath() {
        if (this.ifsPathName_ == null) {
            return "";
        }
        return this.ifsPathName_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public abstract int listCertificates(AS400CertificateAttribute[] var1, String var2) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void removeAS400CertificateListener(AS400CertificateListener l) {
        this.certListeners_.removeElement(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetos_.removeVetoableChangeListener(l);
    }

    public void setObjectInfo(String information) {
        this.info_ = information;
    }

    public abstract void setPath(String var1) throws PropertyVetoException;

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.system_ == null) {
            this.system_ = system;
        } else {
            if (this.isConnected()) {
                Trace.log(2, "Parameter 'system' is not changed (Connected=true).");
                throw new ExtendedIllegalStateException("system", 5);
            }
            AS400 old = this.system_;
            this.vetos_.fireVetoableChange("system", old, system);
            this.system_ = system;
            this.changes_.firePropertyChange("system", old, system);
        }
    }

    void throwException(String cpfError, String objectName, int rc) throws AS400SecurityException, ExtendedIllegalArgumentException, ExtendedIOException, ObjectDoesNotExistException, InternalErrorException {
        int exception = rc / 1000;
        int msgNumber = rc % 1000;
        cpfError = null == cpfError || 0 == ((String)cpfError).length() ? objectName : ((String)cpfError).trim() + ": " + objectName;
        switch (exception) {
            case 1: {
                throw new ExtendedIOException((String)cpfError, msgNumber);
            }
            case 2: {
                throw new ExtendedIllegalArgumentException((String)cpfError, msgNumber);
            }
            case 3: {
                throw new AS400SecurityException((String)cpfError, msgNumber);
            }
            case 4: {
                throw new ObjectDoesNotExistException((String)cpfError, msgNumber);
            }
            case 5: {
                throw new InternalErrorException((String)cpfError, msgNumber);
            }
        }
        throw new ExtendedIOException((String)cpfError, 25);
    }

    void setAS400UserSpaceName(String userSpaceName) {
        if (userSpaceName == null) {
            Trace.log(2, "Parameter 'userSpaceName' is null.");
            throw new NullPointerException("userSpaceName");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(userSpaceName, "USRSPC");
        String uSpaceLib = ifs.getLibraryName();
        String uSpaceName = ifs.getObjectName();
        this.usrSpaceName_ = uSpaceName + "          ";
        this.usrSpaceName_ = this.usrSpaceName_.substring(0, 10) + uSpaceLib + "          ";
        this.usrSpaceName_ = this.usrSpaceName_.substring(0, 20);
        this.usrSpaceName_ = this.usrSpaceName_.toUpperCase();
    }

    String getAS400UserSpaceName(String userSpaceName) {
        if (userSpaceName == null) {
            Trace.log(2, "Parameter 'userSpaceName' is null.");
            throw new NullPointerException("userSpaceName");
        }
        QSYSObjectPathName ifs = new QSYSObjectPathName(userSpaceName, "USRSPC");
        String uSpaceLib = ifs.getLibraryName();
        String uSpaceName = ifs.getObjectName();
        Object as400usrSpaceName = uSpaceName + "          ";
        as400usrSpaceName = ((String)as400usrSpaceName).substring(0, 10) + uSpaceLib + "          ";
        as400usrSpaceName = ((String)as400usrSpaceName).substring(0, 20);
        as400usrSpaceName = ((String)as400usrSpaceName).toUpperCase();
        return as400usrSpaceName;
    }

    boolean[] setSearchAttributes(AS400CertificateAttribute[] attributes) throws ExtendedIllegalArgumentException {
        int i;
        boolean badAttr = false;
        boolean dupAttr = false;
        boolean[] alreadyFound = new boolean[7];
        this.as400AttrS_ = new String[6];
        this.as400AttrB_ = new byte[1][0];
        if (null == attributes) {
            return alreadyFound;
        }
        for (i = 0; i < attributes.length; ++i) {
            if (null == attributes[i]) continue;
            if (2 == attributes[i].getAttributeType()) {
                if (alreadyFound[0]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[0] = true;
                this.as400AttrS_[0] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (7 == attributes[i].getAttributeType()) {
                if (alreadyFound[1]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[1] = true;
                this.as400AttrS_[1] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (6 == attributes[i].getAttributeType()) {
                if (alreadyFound[2]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[2] = true;
                this.as400AttrS_[2] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (4 == attributes[i].getAttributeType()) {
                if (alreadyFound[3]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[3] = true;
                this.as400AttrS_[3] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (5 == attributes[i].getAttributeType()) {
                if (alreadyFound[4]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[4] = true;
                this.as400AttrS_[4] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (3 == attributes[i].getAttributeType()) {
                if (alreadyFound[5]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[5] = true;
                this.as400AttrS_[5] = (String)attributes[i].getAttributeValue();
                continue;
            }
            if (1 == attributes[i].getAttributeType()) {
                if (alreadyFound[6]) {
                    dupAttr = true;
                    break;
                }
                alreadyFound[6] = true;
                this.as400AttrB_[0] = (byte[])attributes[i].getAttributeValue();
                continue;
            }
            badAttr = true;
            break;
        }
        if (dupAttr || badAttr) {
            throw new ExtendedIllegalArgumentException("AS400CertificateAttribute (" + Integer.toString(i) + ")", 2);
        }
        return alreadyFound;
    }

    abstract void connect() throws IOException;

    boolean isConnected() {
        return this.connected_;
    }

    void fireAdd() {
        Vector targets = (Vector)this.certListeners_.clone();
        AS400CertificateEvent event = new AS400CertificateEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CertificateListener target = (AS400CertificateListener)targets.elementAt(i);
            target.added(event);
        }
    }

    void fireDelete() {
        Vector targets = (Vector)this.certListeners_.clone();
        AS400CertificateEvent event = new AS400CertificateEvent(this, 1);
        for (int i = 0; i < targets.size(); ++i) {
            AS400CertificateListener target = (AS400CertificateListener)targets.elementAt(i);
            target.deleted(event);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.connected_ = false;
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.certListeners_ = new Vector();
        this.nextCertificateToReturn_ = 0;
        this.nextCertificateOffset_ = -1;
        this.numberCertificatesFound_ = 0;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

