/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionHandle;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.AS400JDBCDataSource;
import com.ibm.as400.access.AS400JDBCManagedConnectionPoolDataSource;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.EventLog;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDConnectionPoolKey;
import com.ibm.as400.access.JDConnectionPoolManager;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PasswordVault;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.ToolboxWrapper;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class AS400JDBCManagedDataSource
extends ToolboxWrapper
implements DataSource,
Referenceable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    static final String copyright = "Copyright (C) 2005-2010 International Business Machines Corporation and others.";
    private static final boolean DEBUG = false;
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String DESCRIPTION = "description";
    private static final String SERVER_NAME = "serverName";
    private static final String USER = "user";
    private static final String KEY_RING_NAME = "key ring name";
    private static final String PASSWORD = "pw";
    private static final String KEY_RING_PASSWORD = "key ring password";
    private static final String SECURE = "secure";
    private static final String SAVE_PASSWORD = "savepw";
    private static final String PLAIN_TEXT_PASSWORD = "pwd";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String TOOLBOX_DRIVER = "jdbc:as400:";
    private static final int MAX_THRESHOLD = 0x1000000;
    private static final String SOCKET_KEEP_ALIVE = "soKeepAlive";
    private static final String SOCKET_RECEIVE_BUFFER_SIZE = "soReceiveBufferSize";
    private static final String SOCKET_SEND_BUFFER_SIZE = "soSendBufferSize";
    private static final String SOCKET_LINGER = "soLinger";
    private static final String SOCKET_TIMEOUT = "soTimeout";
    private static final String SOCKET_TCP_NO_DELAY = "soTCPNoDelay";
    private transient AS400 as400_;
    private String dataSourceName_;
    private String description_;
    private char[] serialPWBytes_;
    private int pwHashcode_;
    private String serialServerName_;
    private String serialUserName_;
    private String serialKeyRingName_;
    private boolean isSecure_;
    private char[] serialKeyRingPWBytes_;
    private boolean savePasswordWhenSerialized_;
    private JDProperties properties_ = new JDProperties();
    private SocketProperties sockProps_ = new SocketProperties();
    private transient PrintWriter writer_;
    transient EventLog log_;
    private transient AS400JDBCManagedConnectionPoolDataSource cpds_;
    private boolean dataSourceNameSpecified_;
    private transient JDConnectionPoolManager poolManager_;
    private transient boolean poolManagerInitialized_;
    private transient JDConnectionPoolKey defaultConnectionPoolKey_;
    private transient boolean connectionKeyNeedsUpdate_ = true;
    private transient boolean inUse_;
    public static final int MAX_STORAGE_LIMIT = 2147352578;
    static final int TRACE_CLIENT = 1;
    public static final int SERVER_TRACE_START_DATABASE_MONITOR = 2;
    public static final int SERVER_TRACE_DEBUG_SERVER_JOB = 4;
    public static final int SERVER_TRACE_SAVE_SERVER_JOBLOG = 8;
    public static final int SERVER_TRACE_TRACE_SERVER_JOB = 16;
    public static final int SERVER_TRACE_SAVE_SQL_INFORMATION = 32;

    public AS400JDBCManagedDataSource() {
        this.initializeTransient();
    }

    public AS400JDBCManagedDataSource(String serverName) {
        this();
        this.setServerName(serverName);
    }

    public AS400JDBCManagedDataSource(String serverName, String user, String password) {
        this();
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    public AS400JDBCManagedDataSource(String serverName, String user, char[] password) {
        this();
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    public AS400JDBCManagedDataSource(String serverName, String user, String password, String keyRingName, String keyRingPassword) {
        this();
        this.setSecure(true);
        this.as400_ = new SecureAS400(this.as400_);
        this.setServerName(serverName);
        this.setUser(user);
        this.setPassword(password);
    }

    AS400JDBCManagedDataSource(Reference reference) {
        String prmpt;
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        Properties properties = new Properties();
        if (((String)reference.get(SECURE).getContent()).equalsIgnoreCase(TRUE_)) {
            this.isSecure_ = true;
            this.as400_ = new SecureAS400();
        } else {
            this.isSecure_ = false;
            this.as400_ = new AS400();
        }
        boolean isConnectionPoolDataSource = this instanceof AS400JDBCManagedConnectionPoolDataSource;
        Enumeration<RefAddr> list = reference.getAll();
        while (list.hasMoreElements()) {
            StringRefAddr refAddr = (StringRefAddr)list.nextElement();
            String property = refAddr.getType();
            String value = (String)reference.get(property).getContent();
            if (property.equals(DATASOURCE_NAME)) {
                this.setDataSourceName(value);
                continue;
            }
            if (property.equals(DESCRIPTION)) {
                this.setDescription(value);
                continue;
            }
            if (property.equals(SERVER_NAME)) {
                this.setServerName(value);
                continue;
            }
            if (property.equals(USER)) {
                this.setUser(value);
                properties.put(property, value);
                continue;
            }
            if (property.equals(PLAIN_TEXT_PASSWORD)) {
                this.setPassword(value);
                continue;
            }
            if (property.equals(PASSWORD)) {
                if (reference.get(PLAIN_TEXT_PASSWORD) != null) {
                    this.setPassword((String)reference.get(PLAIN_TEXT_PASSWORD).getContent());
                    continue;
                }
                if (value == null) continue;
                this.serialPWBytes_ = value.toCharArray();
                char[] passwordChars = AS400JDBCDataSource.xpwDeconfuseToChar(this.serialPWBytes_);
                this.pwHashcode_ = CredentialVault.getHashCode(passwordChars);
                this.as400_.setPassword(passwordChars);
                CredentialVault.clearArray(passwordChars);
                continue;
            }
            if (property.equals(SAVE_PASSWORD)) {
                this.savePasswordWhenSerialized_ = value.equals(TRUE_);
                continue;
            }
            if (property.equals(KEY_RING_NAME) || property.equals(KEY_RING_PASSWORD)) continue;
            if (property.equals(SOCKET_KEEP_ALIVE)) {
                this.sockProps_.setKeepAlive(value.equals(TRUE_));
                continue;
            }
            if (property.equals(SOCKET_RECEIVE_BUFFER_SIZE)) {
                this.sockProps_.setReceiveBufferSize(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_SEND_BUFFER_SIZE)) {
                this.sockProps_.setSendBufferSize(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_LINGER)) {
                this.sockProps_.setSoLinger(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_TIMEOUT)) {
                this.sockProps_.setSoTimeout(Integer.parseInt(value));
                continue;
            }
            if (property.equals(SOCKET_TCP_NO_DELAY)) {
                this.sockProps_.setTcpNoDelay(value.equals(TRUE_));
                continue;
            }
            if (isConnectionPoolDataSource && AS400JDBCManagedConnectionPoolDataSource.isConnectionPoolProperty(property)) continue;
            properties.put(property, value);
        }
        this.properties_ = new JDProperties(properties, null, null, null);
        if (this.sockProps_.isAnyOptionSet()) {
            this.as400_.setSocketProperties(this.sockProps_);
        }
        if ((prmpt = this.properties_.getString(18)) != null && prmpt.equalsIgnoreCase(FALSE_)) {
            this.setPrompt(false);
        } else if (prmpt != null && prmpt.equalsIgnoreCase(TRUE_)) {
            this.setPrompt(true);
        }
    }

    public boolean checkPoolHealth(boolean logStatistics) {
        if (this.poolManager_ == null) {
            this.logWarning("Connection pool does not exist");
            return false;
        }
        return this.poolManager_.checkHealth(logStatistics);
    }

    final AS400JDBCConnection createPhysicalConnection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "createPhysicalConnection()");
        }
        if (this.cpds_ != null && this.cpds_ != this) {
            return this.cpds_.createPhysicalConnection();
        }
        AS400 as400Object = null;
        as400Object = this.isSecure_ || this.isSecure() ? new SecureAS400(this.as400_) : new AS400(this.as400_);
        if (this.sockProps_.isAnyOptionSet()) {
            as400Object.setSocketProperties(this.sockProps_);
        }
        return this.createPhysicalConnection(as400Object);
    }

    final AS400JDBCConnection createPhysicalConnection(String user, char[] password) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "createPhysicalConnection(" + user + ",*****)");
        }
        if (user == null) {
            throw new NullPointerException(USER);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (this.cpds_ != null && this.cpds_ != this) {
            return this.cpds_.createPhysicalConnection(user, password);
        }
        AS400 as400Object = null;
        as400Object = this.isSecure_ || this.isSecure() ? new SecureAS400(this.as400_) : new AS400(this.as400_);
        try {
            as400Object.setUserId(user);
            as400Object.setPassword(password);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!this.isPrompt()) {
                as400Object.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (this.sockProps_.isAnyOptionSet()) {
            as400Object.setSocketProperties(this.sockProps_);
        }
        return this.createPhysicalConnection(as400Object);
    }

    private AS400JDBCConnection createPhysicalConnection(AS400 as400) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "createPhysicalConnection(as400)");
        }
        AS400JDBCConnection connection = this.properties_.getInt(93) == 1 ? new AS400JDBCConnectionRedirect() : new AS400JDBCConnectionImpl();
        connection.setProperties(new JDDataSourceURL("jdbc:as400://" + as400.getSystemName()), this.properties_, as400);
        if (JDTrace.isTraceOn() || this.log_ != null) {
            this.logInformation(ResourceBundleLoader.getText("AS400_JDBC_DS_CONN_CREATED"));
        }
        return connection;
    }

    public Object clone() {
        try {
            AS400JDBCManagedDataSource clone = (AS400JDBCManagedDataSource)super.clone();
            clone.properties_ = (JDProperties)this.properties_.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, e);
            throw new UnsupportedOperationException("clone()");
        }
    }

    public void closePool() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "closePool()");
        }
        if (this.poolManager_ != null) {
            this.poolManager_.closePool();
        } else if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "closePool() poolManager_ is null");
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "closePool() exit");
        }
    }

    public String getAccess() {
        return this.properties_.getString(0);
    }

    public int getBehaviorOverride() {
        return this.properties_.getInt(50);
    }

    public int getBidiStringType() {
        String value = this.properties_.getString(42);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getBlockCriteria() {
        return this.properties_.getInt(2);
    }

    public int getBlockSize() {
        return this.properties_.getInt(1);
    }

    public String getCharacterTruncation() {
        return this.properties_.getString(91);
    }

    public int getConcurrentAccessResolution() {
        return this.properties_.getInt(79);
    }

    @Override
    public Connection getConnection() throws SQLException {
        ToolboxWrapper connection;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConnection()");
        }
        if (this.dataSourceNameSpecified_ || this instanceof AS400JDBCManagedConnectionPoolDataSource) {
            connection = this.getConnectionFromPool(null, null);
            if (connection == null) {
                connection = this.createPhysicalConnection();
            }
        } else {
            if (JDTrace.isTraceOn() || this.log_ != null) {
                this.logWarning("No datasource name was specified, so connections will not be pooled");
            }
            connection = this.createPhysicalConnection();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConnection() returning " + connection.getClass().toString() + "(" + connection.hashCode() + "):" + (Connection)((Object)connection));
        }
        return connection;
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (password != null) {
            char[] passwordChars = password.toCharArray();
            Connection c = this.getConnection(user, passwordChars);
            CredentialVault.clearArray(passwordChars);
            return c;
        }
        return this.getConnection(user, (char[])null);
    }

    public Connection getConnection(String user, char[] password) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConnection(" + user + ",*********)");
        }
        if (user == null) {
            throw new NullPointerException(USER);
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        ToolboxWrapper connection = null;
        if (this.dataSourceNameSpecified_ || this instanceof AS400JDBCManagedConnectionPoolDataSource) {
            JDConnectionPoolKey key = new JDConnectionPoolKey(user, CredentialVault.getHashCode(password));
            connection = this.getConnectionFromPool(key, password);
            if (connection == null) {
                connection = this.createPhysicalConnection(user, password);
            }
        } else {
            if (JDTrace.isTraceOn() || this.log_ != null) {
                this.logWarning("No datasource name was specified, so connections will not be pooled");
            }
            connection = this.createPhysicalConnection(user, password);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConnection() returning " + connection.getClass().toString() + "(" + connection.hashCode() + "):" + (Connection)((Object)connection));
        }
        return connection;
    }

    private final AS400JDBCConnectionHandle getConnectionFromPool(JDConnectionPoolKey key, char[] password) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConnectionFromPool(key,password) ");
        }
        AS400JDBCConnectionHandle connection = null;
        if (this.serialUserName_ == null || this.pwHashcode_ == 0) {
            if (key != null) {
                this.serialUserName_ = key.getUser();
            }
            if (password != null) {
                this.pwHashcode_ = CredentialVault.getHashCode(password);
            }
        }
        if (!this.poolManagerInitialized_) {
            this.initializeConnectionPool();
        }
        if ((connection = this.poolManager_.getConnection(key, password)) == null && (JDTrace.isTraceOn() || this.log_ != null)) {
            this.logWarning("Connection pool is at or near capacity, so returning a non-pooled connection");
        }
        if (JDTrace.isTraceOn()) {
            if (connection == null) {
                JDTrace.logInformation(this, "getConnectionFromPool() returning null");
            } else {
                JDTrace.logInformation(this, "getConnectionFromPool() returning " + connection.getClass().toString() + "(" + connection.hashCode() + ") :" + connection);
            }
        }
        return connection;
    }

    final JDConnectionPoolKey getConnectionPoolKey() {
        if (this.connectionKeyNeedsUpdate_) {
            if (this.defaultConnectionPoolKey_ == null) {
                this.defaultConnectionPoolKey_ = new JDConnectionPoolKey(this.serialUserName_, this.pwHashcode_);
            } else {
                this.defaultConnectionPoolKey_.update(this.serialUserName_, this.pwHashcode_);
            }
        }
        this.connectionKeyNeedsUpdate_ = false;
        return this.defaultConnectionPoolKey_;
    }

    public String getCursorSensitivity() {
        return this.properties_.getString(49);
    }

    public String getDatabaseName() {
        return this.properties_.getString(47);
    }

    public String getDataSourceName() {
        return this.dataSourceName_ == null ? "" : this.dataSourceName_;
    }

    public String getDateFormat() {
        return this.properties_.getString(3);
    }

    public String getDateSeparator() {
        return this.properties_.getString(4);
    }

    public String getDecfloatRoundingMode() {
        return this.properties_.getString(74);
    }

    public String getDecimalDataErrors() {
        return this.properties_.getString(86);
    }

    public String getDecimalSeparator() {
        return this.properties_.getString(5);
    }

    public String getIgnoreWarnings() {
        return this.properties_.getString(77);
    }

    public String getDescription() {
        return this.description_ == null ? "" : this.description_;
    }

    public String getDescribeOption() {
        return this.properties_.getString(85);
    }

    public String getDriver() {
        return this.properties_.getString(41);
    }

    public String getErrors() {
        return this.properties_.getString(6);
    }

    public String getLibraries() {
        return this.properties_.getString(8);
    }

    public int getLobThreshold() {
        return this.properties_.getInt(31);
    }

    @Override
    public int getLoginTimeout() {
        return this.properties_.getInt(58);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.writer_;
    }

    public int getMetaDataSource() {
        return this.properties_.getInt(72);
    }

    public int getMetadataSource() {
        return this.getMetaDataSource();
    }

    public String getNaming() {
        return this.properties_.getString(9);
    }

    public String getNumericRangeError() {
        return this.properties_.getString(90);
    }

    public String getPackage() {
        return this.properties_.getString(10);
    }

    public String getPackageCriteria() {
        return this.properties_.getString(30);
    }

    public String getPackageError() {
        return this.properties_.getString(14);
    }

    public String getPackageLibrary() {
        return this.properties_.getString(15);
    }

    final char[] getPWBytes() {
        return this.serialPWBytes_;
    }

    public String getProxyServer() {
        return this.properties_.getString(34);
    }

    public int getQueryOptimizeGoal() {
        return this.properties_.getInt(66);
    }

    public String getQueryReplaceTruncatedParameter() {
        return this.properties_.getString(89);
    }

    public String getQueryTimeoutMechanism() {
        return this.properties_.getString(84);
    }

    public int getQueryStorageLimit() {
        return this.properties_.getInt(73);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.ibm.as400.access.AS400JDBCObjectFactory", null);
        DriverPropertyInfo[] propertyList = this.properties_.getInfo();
        for (int i = 0; i < propertyList.length; ++i) {
            if (propertyList[i].value == null) continue;
            ref.add(new StringRefAddr(propertyList[i].name, propertyList[i].value));
        }
        if (this.sockProps_.keepAliveSet_) {
            ref.add(new StringRefAddr(SOCKET_KEEP_ALIVE, this.sockProps_.keepAlive_ ? TRUE_ : FALSE_));
        }
        if (this.sockProps_.receiveBufferSizeSet_) {
            ref.add(new StringRefAddr(SOCKET_RECEIVE_BUFFER_SIZE, Integer.toString(this.sockProps_.receiveBufferSize_)));
        }
        if (this.sockProps_.sendBufferSizeSet_) {
            ref.add(new StringRefAddr(SOCKET_SEND_BUFFER_SIZE, Integer.toString(this.sockProps_.sendBufferSize_)));
        }
        if (this.sockProps_.soLingerSet_) {
            ref.add(new StringRefAddr(SOCKET_LINGER, Integer.toString(this.sockProps_.soLinger_)));
        }
        if (this.sockProps_.soTimeoutSet_) {
            ref.add(new StringRefAddr(SOCKET_TIMEOUT, Integer.toString(this.sockProps_.soTimeout_)));
        }
        if (this.sockProps_.tcpNoDelaySet_) {
            ref.add(new StringRefAddr(SOCKET_TCP_NO_DELAY, this.sockProps_.tcpNoDelay_ ? TRUE_ : FALSE_));
        }
        if (this.dataSourceName_ != null) {
            ref.add(new StringRefAddr(DATASOURCE_NAME, this.dataSourceName_));
        }
        if (this.description_ != null) {
            ref.add(new StringRefAddr(DESCRIPTION, this.description_));
        }
        ref.add(new StringRefAddr(SERVER_NAME, this.getServerName()));
        ref.add(new StringRefAddr(USER, this.getUser()));
        if (this.savePasswordWhenSerialized_) {
            if (this.serialPWBytes_ != null) {
                ref.add(new StringRefAddr(PASSWORD, new String(this.serialPWBytes_)));
            } else {
                ref.add(new StringRefAddr(PASSWORD, null));
            }
        }
        ref.add(new StringRefAddr(SAVE_PASSWORD, this.savePasswordWhenSerialized_ ? TRUE_ : FALSE_));
        return ref;
    }

    public String getRemarks() {
        return this.properties_.getString(19);
    }

    public String getSecondaryUrl() {
        return this.properties_.getString(35);
    }

    public String getSecondaryURL() {
        return this.getSecondaryUrl();
    }

    public String getServerName() {
        return this.as400_.getSystemName();
    }

    public int getServerTraceCategories() {
        return this.properties_.getInt(46);
    }

    public int getServerTrace() {
        return this.getServerTraceCategories();
    }

    public long getSocketTimeout() {
        return this.getSoTimeout();
    }

    public String getSort() {
        return this.properties_.getString(20);
    }

    public String getSortLanguage() {
        return this.properties_.getString(21);
    }

    public String getSortTable() {
        return this.properties_.getString(22);
    }

    public String getSortWeight() {
        return this.properties_.getString(23);
    }

    public String getTimeFormat() {
        return this.properties_.getString(24);
    }

    public String getTimeSeparator() {
        return this.properties_.getString(25);
    }

    public String getTimestampFormat() {
        return this.properties_.getString(87);
    }

    public String getTransactionIsolation() {
        return this.properties_.getString(27);
    }

    public int getPortNumber() {
        return this.properties_.getInt(92);
    }

    public String getQaqqiniLibrary() {
        return this.properties_.getString(57);
    }

    public String getQaqqinilib() {
        return this.getQaqqiniLibrary();
    }

    public int getEnableClientAffinitiesList() {
        return this.properties_.getInt(93);
    }

    public void setEnableClientAffinitiesList(int setting) {
        String property = "enableClientAffinitiesList";
        this.properties_.setString(93, "" + setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getAffinityFailbackInterval() {
        return this.properties_.getInt(99);
    }

    public void setAffinityFailbackInterval(int setting) {
        String property = "affinityFailbackInterval";
        this.properties_.setString(99, "" + setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public String getClientRerouteAlternateServerName() {
        return this.properties_.getString(94);
    }

    public void setClientRerouteAlternateServerName(String alternateServerName) {
        String property = "clientRerouteAlternateServerName";
        if (alternateServerName == null) {
            throw new NullPointerException(property);
        }
        this.properties_.setString(94, alternateServerName);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + alternateServerName);
        }
    }

    public String getClientRerouteAlternatePortNumber() {
        return this.properties_.getString(95);
    }

    public void setClientRerouteAlternatePortNumber(String alternatePortNumber) {
        String property = "clientRerouteAlternatePortNumber";
        if (alternatePortNumber == null) {
            throw new NullPointerException(property);
        }
        this.properties_.setString(95, alternatePortNumber);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + alternatePortNumber);
        }
    }

    public int getMaxRetriesForClientReroute() {
        return this.properties_.getInt(96);
    }

    public void setMaxRetriesForClientReroute(int setting) {
        String property = "maxRetriesForClientReroute";
        this.properties_.setString(96, "" + setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getRetryIntervalForClientReroute() {
        return this.properties_.getInt(97);
    }

    public void setRetryIntervalForClientReroute(int setting) {
        String property = "retryIntervalForClientReroute";
        this.properties_.setString(97, "" + setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public void setEnableSeamlessFailover(int setting) {
        String property = "enableSeamlessFailover ";
        this.properties_.setString(98, "" + setting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public int getEnableSeamlessFailover() {
        return this.properties_.getInt(98);
    }

    public String getUser() {
        return this.as400_.getUserId();
    }

    public int getXALooselyCoupledSupport() {
        return this.properties_.getInt(70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeConnectionPool() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "initializeConnectionPool");
        }
        this.logWarning("initializeConnectionPool");
        if (!this.dataSourceNameSpecified_ && !(this instanceof AS400JDBCManagedConnectionPoolDataSource)) {
            this.logWarning("No datasource name was specified, so connections will not be pooled");
            return;
        }
        AS400JDBCManagedDataSource aS400JDBCManagedDataSource = this;
        synchronized (aS400JDBCManagedDataSource) {
            this.inUse_ = true;
        }
        try {
            if (this.poolManager_ == null) {
                if (this instanceof AS400JDBCManagedConnectionPoolDataSource) {
                    this.cpds_ = (AS400JDBCManagedConnectionPoolDataSource)this;
                    this.dataSourceNameSpecified_ = true;
                } else {
                    InitialContext ctx = new InitialContext();
                    this.cpds_ = (AS400JDBCManagedConnectionPoolDataSource)ctx.lookup(this.dataSourceName_);
                    if (this.cpds_ == null) {
                        this.logError("Data source name is not bound in JNDI: " + this.dataSourceName_);
                        JDError.throwSQLException((Object)this, "HY010", "Data source name is not bound in JNDI: " + this.dataSourceName_);
                    }
                }
                this.getConnectionPoolKey();
                this.poolManager_ = new JDConnectionPoolManager(this, this.cpds_);
            }
        }
        catch (NamingException ne) {
            JDError.throwSQLException((Object)this, "HY010", ne);
        }
        this.poolManagerInitialized_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initializeTransient() {
        this.poolManager_ = null;
        this.poolManagerInitialized_ = false;
        this.defaultConnectionPoolKey_ = null;
        this.connectionKeyNeedsUpdate_ = true;
        this.as400_ = this.isSecure_ ? new SecureAS400() : new AS400();
        if (this.sockProps_.isAnyOptionSet()) {
            this.as400_.setSocketProperties(this.sockProps_);
        }
        if (this.serialServerName_ != null) {
            this.setServerName(this.serialServerName_);
        }
        if (this.serialUserName_ != null) {
            this.setUser(this.serialUserName_);
            if (this.serialPWBytes_ != null && this.serialPWBytes_.length > 0) {
                char[] passwordChars = AS400JDBCDataSource.xpwDeconfuseToChar(this.serialPWBytes_);
                this.as400_.setPassword(passwordChars);
                CredentialVault.clearArray(passwordChars);
            }
        }
        try {
            if (this.properties_ != null && !this.isPrompt()) {
                this.as400_.setGuiAvailable(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        AS400JDBCManagedDataSource aS400JDBCManagedDataSource = this;
        synchronized (aS400JDBCManagedDataSource) {
            this.inUse_ = false;
        }
    }

    public void invalidate(String user, String password) {
        this.invalidate(user, password == null ? null : AS400JDBCDataSource.xpwConfuse(password));
    }

    private final void invalidate(String user, char[] pwBytes) {
        int hash = pwBytes == null ? 0 : CredentialVault.getHashCode(AS400JDBCDataSource.xpwDeconfuseToChar(pwBytes));
        JDConnectionPoolKey key = new JDConnectionPoolKey(user, hash);
        if (this.poolManager_ != null) {
            this.poolManager_.invalidate(key);
        }
    }

    public boolean isAutoCommit() {
        return this.properties_.getBoolean(76);
    }

    public boolean isAutocommitException() {
        return this.properties_.getBoolean(75);
    }

    public boolean isBidiImplicitReordering() {
        return this.properties_.getBoolean(60);
    }

    public boolean isBidiNumericOrdering() {
        return this.properties_.getBoolean(61);
    }

    public boolean isBigDecimal() {
        return this.properties_.getBoolean(37);
    }

    public boolean isCursorHold() {
        return this.properties_.getBoolean(39);
    }

    public boolean isDataCompression() {
        return this.properties_.getBoolean(36);
    }

    public boolean isDataTruncation() {
        return this.properties_.getBoolean(33);
    }

    public boolean isExtendedDynamic() {
        return this.properties_.getBoolean(7);
    }

    public boolean isExtendedMetaData() {
        return this.properties_.getBoolean(48);
    }

    public boolean isExtendedMetadata() {
        return this.isExtendedMetaData();
    }

    public boolean isFullOpen() {
        return this.properties_.getBoolean(45);
    }

    public boolean isHoldInputLocators() {
        return this.properties_.getBoolean(62);
    }

    public boolean isHoldStatements() {
        return this.properties_.getBoolean(63);
    }

    private final synchronized boolean isInUse() {
        return this.inUse_;
    }

    public boolean isJvm16Synchronize() {
        return this.properties_.getBoolean(80);
    }

    public boolean isLazyClose() {
        return this.properties_.getBoolean(40);
    }

    public boolean isPackageAdd() {
        return this.properties_.getBoolean(11);
    }

    public boolean isPackageCache() {
        return this.properties_.getBoolean(12);
    }

    public boolean isPackageClear() {
        return false;
    }

    public boolean isPrefetch() {
        return this.properties_.getBoolean(17);
    }

    public boolean isPrompt() {
        return this.properties_.getBoolean(18);
    }

    public boolean isRollbackCursorHold() {
        return this.properties_.getBoolean(64);
    }

    public boolean isSavePasswordWhenSerialized() {
        return this.savePasswordWhenSerialized_;
    }

    public boolean isSecure() {
        return this.properties_.getBoolean(32);
    }

    public boolean isSecureCurrentUser() {
        return this.properties_.getBoolean(78);
    }

    public boolean isThreadUsed() {
        return this.properties_.getBoolean(38);
    }

    public boolean isTrace() {
        return this.properties_.getBoolean(26);
    }

    public boolean isTranslateBinary() {
        return this.properties_.getBoolean(28);
    }

    public boolean isTranslateBoolean() {
        return this.properties_.getBoolean(71);
    }

    public boolean isTrueAutoCommit() {
        return this.properties_.getBoolean(59);
    }

    public boolean isTrueAutocommit() {
        return this.isTrueAutoCommit();
    }

    void logProperty(String property, String value) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "log2", property, value);
        }
    }

    final void logDiagnostic(String text) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, text);
            if (this.log_ != null) {
                this.log_.log(text);
            }
        }
    }

    final void logError(String text) {
        String msg = "ERROR: " + text;
        JDTrace.logInformation(this, msg);
        if (this.log_ != null) {
            this.log_.log(msg);
        }
    }

    final void logException(String text, Exception e) {
        JDTrace.logException(this, text, e);
        if (this.log_ != null) {
            this.log_.log(text, e);
        }
    }

    final void logInformation(String text) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, text);
            if (this.log_ != null) {
                this.log_.log(text);
            }
        }
    }

    final void logWarning(String text) {
        String msg = "WARNING: " + text;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, msg);
        }
        if (this.log_ != null) {
            this.log_.log(msg);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void setAccess(String access) {
        String property = "access";
        if (access == null) {
            throw new NullPointerException("access");
        }
        this.validateProperty("access", access, 0);
        this.properties_.setString(0, access);
    }

    public void setAutoCommit(boolean value) {
        if (value) {
            this.properties_.setString(76, TRUE_);
        } else {
            this.properties_.setString(76, FALSE_);
        }
    }

    public void setAutocommitException(boolean value) {
        if (value) {
            this.properties_.setString(75, TRUE_);
        } else {
            this.properties_.setString(75, FALSE_);
        }
    }

    public void setTrueAutoCommit(boolean value) {
        if (value) {
            this.properties_.setString(59, TRUE_);
        } else {
            this.properties_.setString(59, FALSE_);
        }
    }

    public void setTrueAutocommit(boolean value) {
        this.setTrueAutoCommit(value);
    }

    public void setBehaviorOverride(int behaviors) {
        this.properties_.setString(50, Integer.toString(behaviors));
    }

    public void setBidiStringType(int bidiStringType) {
        String property = "bidiStringType";
        this.validateProperty("bidiStringType", Integer.toString(bidiStringType), 42);
        this.properties_.setString(42, Integer.toString(bidiStringType));
    }

    public void setBidiImplicitReordering(boolean value) {
        if (value) {
            this.properties_.setString(60, TRUE_);
        } else {
            this.properties_.setString(60, FALSE_);
        }
    }

    public void setBidiNumericOrdering(boolean value) {
        if (value) {
            this.properties_.setString(61, TRUE_);
        } else {
            this.properties_.setString(61, FALSE_);
        }
    }

    public void setBigDecimal(boolean value) {
        if (value) {
            this.properties_.setString(37, TRUE_);
        } else {
            this.properties_.setString(37, FALSE_);
        }
    }

    public void setBlockCriteria(int blockCriteria) {
        String property = "blockCriteria";
        this.validateProperty("blockCriteria", Integer.toString(blockCriteria), 2);
        this.properties_.setString(2, Integer.toString(blockCriteria));
    }

    public void setBlockSize(int blockSize) {
        String property = "blockSize";
        this.validateProperty("blockSize", Integer.toString(blockSize), 1);
        this.properties_.setString(1, Integer.toString(blockSize));
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "blockSize: " + blockSize);
            if (blockSize == 0) {
                Exception setLocation = new Exception("Set Location");
                JDTrace.logException(this, "setBlockSize", setLocation);
            }
        }
    }

    public void setCharacterTruncation(String setting) {
        String property = "characterTruncation";
        String oldSetting = this.getCharacterTruncation();
        String newSetting = setting;
        this.validateProperty(property, newSetting, 91);
        this.properties_.setString(91, newSetting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) {
        String property = "concurrentAccessResolution";
        this.validateProperty(property, Integer.toString(concurrentAccessResolution), 79);
        this.properties_.setString(79, Integer.toString(concurrentAccessResolution));
    }

    public void setCursorSensitivity(String cursorSensitivity) {
        String property = "cursorSensitivity";
        this.validateProperty("cursorSensitivity", cursorSensitivity, 49);
        this.properties_.setString(49, cursorSensitivity);
    }

    public void setCursorHold(boolean cursorHold) {
        if (cursorHold) {
            this.properties_.setString(39, TRUE_);
        } else {
            this.properties_.setString(39, FALSE_);
        }
    }

    public void setDatabaseName(String databaseName) {
        String property = "databaseName";
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException("databaseName", 5);
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        this.properties_.setString(47, databaseName);
        this.connectionKeyNeedsUpdate_ = true;
    }

    public void setDataCompression(boolean compression) {
        if (compression) {
            this.properties_.setString(36, TRUE_);
        } else {
            this.properties_.setString(36, FALSE_);
        }
    }

    public void setDataSourceName(String dataSourceName) {
        String property = DATASOURCE_NAME;
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(DATASOURCE_NAME, 5);
        }
        if (dataSourceName == null) {
            throw new NullPointerException(DATASOURCE_NAME);
        }
        this.dataSourceName_ = dataSourceName;
        this.dataSourceNameSpecified_ = true;
        this.logProperty(DATASOURCE_NAME, this.dataSourceName_);
    }

    public void setDataTruncation(boolean truncation) {
        if (truncation) {
            this.properties_.setString(33, TRUE_);
        } else {
            this.properties_.setString(33, FALSE_);
        }
    }

    public void setDateFormat(String dateFormat) {
        String property = "dateFormat";
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        this.validateProperty("dateFormat", dateFormat, 3);
        this.properties_.setString(3, dateFormat);
    }

    public void setDateSeparator(String dateSeparator) {
        String property = "dateSeparator";
        if (dateSeparator == null) {
            throw new NullPointerException("dateSeparator");
        }
        this.validateProperty("dateSeparator", dateSeparator, 4);
        this.properties_.setString(4, dateSeparator);
    }

    public void setDecfloatRoundingMode(String decfloatRoundingMode) {
        String property = "decfloatRoundingMode";
        if (decfloatRoundingMode == null) {
            throw new NullPointerException(property);
        }
        this.validateProperty(property, decfloatRoundingMode, 74);
        this.getDecfloatRoundingMode();
        this.properties_.setString(74, decfloatRoundingMode);
    }

    public void setDecimalDataErrors(String setting) {
        String property = "decimalDataErrors";
        if (setting == null) {
            throw new NullPointerException("decimalDataErrors");
        }
        this.validateProperty("decimalDataErrors", setting, 86);
        this.properties_.setString(86, setting);
    }

    public void setDecimalSeparator(String decimalSeparator) {
        String property = "decimalSeparator";
        if (decimalSeparator == null) {
            throw new NullPointerException("decimalSeparator");
        }
        this.validateProperty("decimalSeparator", decimalSeparator, 5);
        this.properties_.setString(5, decimalSeparator);
    }

    public void setDescribeOption(String option) {
        String property = "describeOption";
        if (option == null) {
            throw new NullPointerException("describeOption");
        }
        this.validateProperty("describeOption", option, 85);
        this.properties_.setString(85, option);
    }

    public void setIgnoreWarnings(String ignoreWarnings) {
        String property = "ignoreWarnings";
        if (ignoreWarnings == null) {
            throw new NullPointerException(property);
        }
        this.properties_.setString(77, ignoreWarnings);
    }

    public void setDescription(String description) {
        String property = DESCRIPTION;
        if (description == null) {
            throw new NullPointerException(DESCRIPTION);
        }
        this.description_ = description;
        this.logProperty(DESCRIPTION, this.description_);
    }

    public void setSort(String sort) {
        String property = "sort";
        if (sort == null) {
            throw new NullPointerException("sort");
        }
        if (sort.equals("job")) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "sort: " + this.getSort() + " (warning: " + this.getSort() + " will be used since sort=job is not valid)");
            }
            return;
        }
        this.validateProperty("sort", sort, 20);
        this.properties_.setString(20, sort);
    }

    public void setErrors(String errors) {
        String property = "errors";
        if (errors == null) {
            throw new NullPointerException("errors");
        }
        this.validateProperty("errors", errors, 6);
        this.properties_.setString(6, errors);
    }

    public void setExtendedDynamic(boolean extendedDynamic) {
        if (extendedDynamic) {
            this.properties_.setString(7, TRUE_);
        } else {
            this.properties_.setString(7, FALSE_);
        }
    }

    public void setExtendedMetaData(boolean extendedMetaData) {
        if (extendedMetaData) {
            this.properties_.setString(48, TRUE_);
        } else {
            this.properties_.setString(48, FALSE_);
        }
    }

    public void setExtendedMetadata(boolean extendedMetaData) {
        this.setExtendedMetaData(extendedMetaData);
    }

    public void setFullOpen(boolean fullOpen) {
        if (fullOpen) {
            this.properties_.setString(45, TRUE_);
        } else {
            this.properties_.setString(45, FALSE_);
        }
    }

    public void setHoldInputLocators(boolean hold) {
        if (hold) {
            this.properties_.setString(62, TRUE_);
        } else {
            this.properties_.setString(62, FALSE_);
        }
    }

    public void setHoldStatements(boolean hold) {
        if (hold) {
            this.properties_.setString(63, TRUE_);
        } else {
            this.properties_.setString(63, FALSE_);
        }
    }

    public void setJvm16Synchronize(boolean value) {
        if (value) {
            this.properties_.setString(80, TRUE_);
        } else {
            this.properties_.setString(80, FALSE_);
        }
    }

    public void setLazyClose(boolean lazyClose) {
        if (lazyClose) {
            this.properties_.setString(40, TRUE_);
        } else {
            this.properties_.setString(40, FALSE_);
        }
    }

    public void setLibraries(String libraries) {
        String property = "libraries";
        if (libraries == null) {
            throw new NullPointerException("libraries");
        }
        this.properties_.setString(8, libraries);
    }

    public void setLobThreshold(int threshold) {
        String property = "threshold";
        if (threshold < 0 || threshold > 0x1000000) {
            throw new ExtendedIllegalArgumentException("threshold", 4);
        }
        this.properties_.setString(31, Integer.toString(threshold));
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.properties_.setString(58, Integer.toString(timeout));
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.writer_ = writer;
        this.logProperty("logWriter", this.writer_ == null ? "null" : this.writer_.toString());
        this.log_ = writer == null ? null : new EventLog(writer);
    }

    public void setMetaDataSource(int mds) {
        Integer newValue = mds;
        this.properties_.setString(72, newValue.toString());
    }

    public void setMetadataSource(int mds) {
        this.setMetaDataSource(mds);
    }

    public void setNaming(String naming) {
        String property = "naming";
        if (naming == null) {
            throw new NullPointerException("naming");
        }
        this.validateProperty("naming", naming, 9);
        this.properties_.setString(9, naming);
    }

    public void setPackage(String packageName) {
        String property = "packageName";
        if (packageName == null) {
            throw new NullPointerException("packageName");
        }
        this.properties_.setString(10, packageName);
    }

    public void setPackageAdd(boolean add) {
        if (add) {
            this.properties_.setString(11, TRUE_);
        } else {
            this.properties_.setString(11, FALSE_);
        }
    }

    public void setPackageCache(boolean cache) {
        if (cache) {
            this.properties_.setString(12, TRUE_);
        } else {
            this.properties_.setString(12, FALSE_);
        }
    }

    public void setPackageClear(boolean clear) {
    }

    public void setPackageCriteria(String packageCriteria) {
        String property = "packageCriteria";
        if (packageCriteria == null) {
            throw new NullPointerException("packageCriteria");
        }
        this.validateProperty("packageCriteria", packageCriteria, 30);
        this.properties_.setString(30, packageCriteria);
    }

    public void setPackageError(String packageError) {
        String property = "packageError";
        if (packageError == null) {
            throw new NullPointerException("packageError");
        }
        this.validateProperty("packageError", packageError, 14);
        this.properties_.setString(14, packageError);
    }

    public void setPackageLibrary(String packageLibrary) {
        String property = "packageLibrary";
        if (packageLibrary == null) {
            throw new NullPointerException("packageLibrary");
        }
        this.properties_.setString(15, packageLibrary);
    }

    public void setPassword(String password) {
        String property = "password";
        if (password == null) {
            throw new NullPointerException("password");
        }
        char[] passwordChars = password.toCharArray();
        this.setPassword(passwordChars);
    }

    public void setPassword(char[] password) {
        String property = "password";
        if (password == null) {
            throw new NullPointerException("password");
        }
        char[] newSerialPWBytes = AS400JDBCDataSource.xpwConfuse(password);
        if (!Arrays.equals(newSerialPWBytes, this.serialPWBytes_)) {
            this.as400_.setPassword(password);
            this.invalidate(this.getUser(), this.serialPWBytes_);
            this.serialPWBytes_ = newSerialPWBytes;
            this.pwHashcode_ = PasswordVault.getHashCode(password);
            this.connectionKeyNeedsUpdate_ = true;
        }
        this.logInformation(ResourceBundleLoader.getText("AS400_JDBC_DS_PASSWORD_SET"));
        this.logProperty("password", "***");
    }

    public void setPrefetch(boolean prefetch) {
        if (prefetch) {
            this.properties_.setString(17, TRUE_);
        } else {
            this.properties_.setString(17, FALSE_);
        }
    }

    public void setPrompt(boolean prompt) {
        if (prompt) {
            this.properties_.setString(18, TRUE_);
        } else {
            this.properties_.setString(18, FALSE_);
        }
        try {
            this.as400_.setGuiAvailable(prompt);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setProperties(String propertiesString) {
        propertiesString = "jdbc:as400://dummyhost;" + (String)propertiesString;
        JDDataSourceURL dsURL = new JDDataSourceURL((String)propertiesString);
        Properties properties = dsURL.getProperties();
        this.setProperties(properties);
    }

    public void setProperties(Properties newProperties) {
        if (JDProperties.isTraceSet(newProperties, null) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(newProperties, null) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(newProperties, null) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(newProperties, null) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        Enumeration<Object> e = newProperties.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = newProperties.getProperty(propertyName);
            int propIndex = JDProperties.getPropertyIndex(propertyName);
            if (propIndex == 47) {
                this.setDatabaseName(propertyValue);
                continue;
            }
            if (propIndex == 29) {
                this.setUser(propertyValue);
                continue;
            }
            if (propIndex == 16) {
                char[] clearPassword = this.properties_.getClearPassword();
                this.setPassword(clearPassword);
                CredentialVault.clearArray(clearPassword);
                continue;
            }
            if (propIndex == 32) {
                this.setSecure(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == 67) {
                this.setKeepAlive(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == 68) {
                this.setReceiveBufferSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propIndex == 69) {
                this.setSendBufferSize(Integer.parseInt(propertyValue));
                continue;
            }
            if (propIndex == 18) {
                this.setPrompt(propertyValue.equals(TRUE_));
                continue;
            }
            if (propIndex == -1) continue;
            this.properties_.setString(propIndex, propertyValue);
        }
    }

    public void setProxyServer(String proxyServer) {
        String property = "proxyServer";
        if (proxyServer == null) {
            throw new NullPointerException("proxyServer");
        }
        this.properties_.setString(34, proxyServer);
    }

    public void setQueryOptimizeGoal(int goal) {
        String property = "queryOptimizeGoal";
        this.validateProperty(property, Integer.toString(goal), 66);
        this.properties_.setString(66, Integer.toString(goal));
    }

    public void setQueryReplaceTruncatedParameter(String value) {
        String property = "queryReplaceTruncatedParameter";
        String newOption = value;
        this.validateProperty(property, newOption, 89);
        this.properties_.setString(89, newOption);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + value);
        }
    }

    public void setQueryTimeoutMechanism(String timeoutMechanism) {
        String property = "queryTimeoutMechanism";
        String newOption = timeoutMechanism;
        this.validateProperty(property, newOption, 84);
        this.properties_.setString(84, newOption);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + timeoutMechanism);
        }
    }

    public void setQueryStorageLimit(int limit) {
        String property = "queryStorageLimit";
        if (limit < -1 || limit > 2147352578) {
            throw new ExtendedIllegalArgumentException(property, 4);
        }
        this.properties_.setString(73, Integer.toString(limit));
    }

    public void setRemarks(String remarks) {
        String property = "remarks";
        if (remarks == null) {
            throw new NullPointerException("remarks");
        }
        this.validateProperty("remarks", remarks, 19);
        this.properties_.setString(19, remarks);
    }

    public void setRollbackCursorHold(boolean hold) {
        if (hold) {
            this.properties_.setString(64, TRUE_);
        } else {
            this.properties_.setString(64, FALSE_);
        }
    }

    public void setSecondaryUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        this.properties_.setString(35, url);
    }

    public void setSecondaryURL(String url) {
        this.setSecondaryUrl(url);
    }

    public void setSecure(boolean secure) {
        if (!secure && this.isSecure_) {
            throw new ExtendedIllegalStateException(SECURE, 5);
        }
        this.isSecure_ = secure;
        if (secure) {
            this.properties_.setString(32, TRUE_);
        } else {
            this.properties_.setString(32, FALSE_);
        }
    }

    public void setSecureCurrentUser(boolean secureCurrentUser) {
        if (secureCurrentUser) {
            this.properties_.setString(78, TRUE_);
        } else {
            this.properties_.setString(78, FALSE_);
        }
    }

    public void setServerName(String serverName) {
        String property = SERVER_NAME;
        if (this.isInUse()) {
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(SERVER_NAME, 5);
        }
        if (serverName == null) {
            throw new NullPointerException(SERVER_NAME);
        }
        this.serialServerName_ = serverName;
        try {
            this.as400_.setSystemName(serverName);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.connectionKeyNeedsUpdate_ = true;
        this.logProperty(SERVER_NAME, this.as400_.getSystemName());
    }

    public void setServerTraceCategories(int traceCategories) {
        this.properties_.setString(46, Integer.toString(traceCategories));
    }

    public void setServerTrace(int traceCategories) {
        this.setServerTraceCategories(traceCategories);
    }

    public void setDriver(String driver) {
        String property = "driver";
        if (driver == null) {
            throw new NullPointerException("driver");
        }
        this.validateProperty("driver", driver, 41);
        this.properties_.setString(41, driver);
    }

    public void setSavePasswordWhenSerialized(boolean savePassword) {
        String property = "savePasswordWhenSerialized";
        this.savePasswordWhenSerialized_ = savePassword;
        this.logProperty("savePasswordWhenSerialized", String.valueOf(this.savePasswordWhenSerialized_));
    }

    public void setSocketTimeout(int milliseconds) {
        this.setSoTimeout(milliseconds);
    }

    public void setSortLanguage(String language) {
        if (language == null) {
            throw new NullPointerException("language");
        }
        this.properties_.setString(21, language);
    }

    public void setSortTable(String table) {
        if (table == null) {
            throw new NullPointerException("table");
        }
        this.properties_.setString(22, table);
    }

    public void setSortWeight(String sortWeight) {
        String property = "sortWeight";
        if (sortWeight == null) {
            throw new NullPointerException("sortWeight");
        }
        this.validateProperty("sortWeight", sortWeight, 23);
        this.properties_.setString(23, sortWeight);
    }

    public void setThreadUsed(boolean threadUsed) {
        if (threadUsed) {
            this.properties_.setString(38, TRUE_);
        } else {
            this.properties_.setString(38, FALSE_);
        }
    }

    public void setTimeFormat(String timeFormat) {
        String property = "timeFormat";
        if (timeFormat == null) {
            throw new NullPointerException("timeFormat");
        }
        this.validateProperty("timeFormat", timeFormat, 24);
        this.properties_.setString(24, timeFormat);
    }

    public void setTimeSeparator(String timeSeparator) {
        String property = "timeSeparator";
        if (timeSeparator == null) {
            throw new NullPointerException("timeSeparator");
        }
        this.validateProperty("timeSeparator", timeSeparator, 25);
        this.properties_.setString(25, timeSeparator);
    }

    public void setTimestampFormat(String timestampFormat) {
        String property = "timestampFormat";
        if (timestampFormat == null) {
            throw new NullPointerException("timestampFormat");
        }
        this.validateProperty("timestampFormat", timestampFormat, 87);
        this.properties_.setString(87, timestampFormat);
    }

    public void setTrace(boolean trace) {
        if (trace) {
            this.properties_.setString(26, TRUE_);
        } else {
            this.properties_.setString(26, FALSE_);
        }
        if (trace) {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else {
            JDTrace.setTraceOn(false);
        }
    }

    public void setTransactionIsolation(String transactionIsolation) {
        String property = "transactionIsolation";
        if (transactionIsolation == null) {
            throw new NullPointerException("transactionIsolation");
        }
        this.validateProperty("transactionIsolation", transactionIsolation, 27);
        this.properties_.setString(27, transactionIsolation);
    }

    public void setTranslateBinary(boolean translate) {
        if (translate) {
            this.properties_.setString(28, TRUE_);
        } else {
            this.properties_.setString(28, FALSE_);
        }
    }

    public void setTranslateBoolean(boolean translate) {
        if (translate) {
            this.properties_.setString(71, TRUE_);
        } else {
            this.properties_.setString(71, FALSE_);
        }
    }

    public void setUser(String user) {
        String property = USER;
        if (this.isInUse()) {
            if (user != null && user.equals(this.serialUserName_)) {
                return;
            }
            this.logError("Data source is already in use");
            throw new ExtendedIllegalStateException(USER, 5);
        }
        this.serialUserName_ = user;
        this.properties_.setString(29, user);
        try {
            this.as400_.setUserId(user);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.connectionKeyNeedsUpdate_ = true;
    }

    public void setXALooselyCoupledSupport(int lcs) {
        String property = "xaLooselyCoupledSupport";
        this.validateProperty(property, Integer.toString(lcs), 70);
        this.properties_.setString(70, Integer.toString(lcs));
    }

    public boolean isKeepAlive() {
        return this.sockProps_.isKeepAlive();
    }

    public int getReceiveBufferSize() {
        return this.sockProps_.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return this.sockProps_.getSendBufferSize();
    }

    public long getSoLinger() {
        return 1000 * this.sockProps_.getSoLinger();
    }

    public long getSoTimeout() {
        return this.sockProps_.getSoTimeout();
    }

    public boolean isTcpNoDelay() {
        return this.sockProps_.isTcpNoDelay();
    }

    public void setKeepAlive(boolean keepAlive) {
        this.sockProps_.setKeepAlive(keepAlive);
        this.logProperty("keepAlive", String.valueOf(keepAlive));
    }

    public void setNumericRangeError(String setting) {
        String property = "translateHex";
        String oldSetting = this.getNumericRangeError();
        String newSetting = setting;
        this.validateProperty(property, newSetting, 90);
        this.properties_.setString(90, newSetting);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, property + ": " + setting);
        }
    }

    public void setReceiveBufferSize(int size) {
        this.sockProps_.setReceiveBufferSize(size);
        this.logProperty("receiveBufferSize", Integer.toString(size));
    }

    public void setSendBufferSize(int size) {
        this.sockProps_.setSendBufferSize(size);
        this.logProperty("sendBufferSize", Integer.toString(size));
    }

    public void setSoLinger(long milliseconds) {
        String property = SOCKET_LINGER;
        if (milliseconds > Integer.MAX_VALUE) {
            throw new ExtendedIllegalArgumentException(SOCKET_LINGER, 4);
        }
        this.sockProps_.setSoLinger((int)(milliseconds / 1000L));
        this.logProperty(SOCKET_LINGER, Long.toString(milliseconds));
    }

    public void setSoTimeout(long milliseconds) {
        String property = SOCKET_TIMEOUT;
        if (milliseconds > Integer.MAX_VALUE) {
            throw new ExtendedIllegalArgumentException(SOCKET_TIMEOUT, 4);
        }
        this.sockProps_.setSoTimeout((int)milliseconds);
        this.logProperty(SOCKET_TIMEOUT, Long.toString(milliseconds));
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.sockProps_.setTcpNoDelay(noDelay);
        this.logProperty("tcpNoDelay", String.valueOf(noDelay));
    }

    public int getPackageCCSID() {
        return this.properties_.getInt(51);
    }

    public int getPackageCcsid() {
        return this.getPackageCCSID();
    }

    public void setPackageCCSID(int ccsid) {
        String property = "packageCCSID";
        this.validateProperty("packageCCSID", Integer.toString(ccsid), 51);
        this.properties_.setString(51, Integer.toString(ccsid));
    }

    public void setPackageCcsid(int ccsid) {
        this.setPackageCCSID(ccsid);
    }

    public void setPortNumber(int portNumber) {
        String property = "portNumber";
        this.validateProperty("portNumber", Integer.toString(portNumber), 92);
        this.properties_.setString(92, Integer.toString(portNumber));
    }

    public int getMinimumDivideScale() {
        return this.properties_.getInt(52);
    }

    public int getMaximumBlockedInputRows() {
        return this.properties_.getInt(83);
    }

    public int getMaximumPrecision() {
        return this.properties_.getInt(53);
    }

    public int getMaximumScale() {
        return this.properties_.getInt(54);
    }

    public void setMinimumDivideScale(int scale) {
        String property = "minimumDivideScale";
        this.validateProperty("minimumDivideScale", Integer.toString(scale), 52);
        this.properties_.setString(52, Integer.toString(scale));
    }

    public void setMaximumBlockedInputRows(int maximumBlockedInputRows) {
        String property = "maximumBlockedInputRows";
        this.validateProperty("maximumBlockedInputRows", Integer.toString(maximumBlockedInputRows), 83);
        this.properties_.setString(53, Integer.toString(maximumBlockedInputRows));
    }

    public void setMaximumPrecision(int precision) {
        String property = "maximumPrecision";
        this.validateProperty("maximumPrecision", Integer.toString(precision), 53);
        this.properties_.setString(53, Integer.toString(precision));
    }

    public void setMaximumScale(int scale) {
        String property = "maximumScale";
        this.validateProperty("maximumScale", Integer.toString(scale), 54);
        this.properties_.setString(54, Integer.toString(scale));
    }

    public String getTranslateHex() {
        return this.properties_.getString(55);
    }

    public void setTranslateHex(String parseOption) {
        String property = "translateHex";
        this.validateProperty("translateHex", parseOption, 55);
        this.properties_.setString(55, parseOption);
    }

    public boolean isUseBlockUpdate() {
        return this.properties_.getBoolean(82);
    }

    public boolean isUseDrdaMetadataVersion() {
        return this.properties_.getBoolean(88);
    }

    public void setUseBlockUpdate(boolean option) {
        if (option) {
            this.properties_.setString(82, TRUE_);
        } else {
            this.properties_.setString(82, FALSE_);
        }
    }

    public void setUseDrdaMetadataVersion(boolean option) {
        if (option) {
            this.properties_.setString(88, TRUE_);
        } else {
            this.properties_.setString(88, FALSE_);
        }
    }

    public String getVariableFieldCompression() {
        return this.properties_.getString(65);
    }

    public void setVariableFieldCompression(String option) {
        String property = "variableFieldCompression";
        this.validateProperty("variableFieldCompression", option, 65);
        this.properties_.setString(65, option);
    }

    public void setQaqqiniLibrary(String libraryName) {
        String property = "qaqqiniLibrary";
        if (libraryName == null) {
            throw new NullPointerException("qaqqiniLibrary");
        }
        this.properties_.setString(57, libraryName);
    }

    public void setQaqqinilib(String libraryName) {
        this.setQaqqiniLibrary(libraryName);
    }

    public String getToolboxTraceCategory() {
        return this.properties_.getString(56);
    }

    public String getToolboxTrace() {
        return this.getToolboxTraceCategory();
    }

    public void setToolboxTraceCategory(String traceCategory) {
        String property = "toolboxTrace";
        this.validateProperty("toolboxTrace", traceCategory, 56);
        this.properties_.setString(56, traceCategory);
    }

    public void setToolboxTrace(String traceCategory) {
        this.setToolboxTraceCategory(traceCategory);
    }

    private final void validateProperty(String property, String value, int index) {
        if (value.length() != 0) {
            DriverPropertyInfo[] info = this.properties_.getInfo();
            String[] choices = info[index].choices;
            if (index == 51) {
                try {
                    int ccsid = Integer.valueOf(value);
                    if (ccsid < 1) {
                        throw new ExtendedIllegalArgumentException(property, 2);
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    throw new ExtendedIllegalArgumentException(property, 2);
                }
            }
            boolean notValid = true;
            int current = 0;
            while (notValid && current < choices.length) {
                if (value.equalsIgnoreCase(choices[current])) {
                    notValid = false;
                    continue;
                }
                ++current;
            }
            if (notValid) {
                throw new ExtendedIllegalArgumentException(property, 2);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this.savePasswordWhenSerialized_) {
            this.serialPWBytes_ = null;
            this.pwHashcode_ = 0;
        }
        out.defaultWriteObject();
    }

    public String toString() {
        return this.getDataSourceName();
    }

    private static final char[] xencode(char[] adder, char[] mask, char[] bytes) {
        int i;
        if (bytes == null) {
            return null;
        }
        int length = bytes.length;
        char[] buf = new char[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(bytes[i] + adder[i % 9]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(buf[i] ^ mask[i % 7]);
        }
        return buf;
    }

    private static final char[] xdecode(char[] adder, char[] mask, char[] bytes) {
        int i;
        int length = bytes.length;
        char[] buf = new char[length];
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(mask[i % 7] ^ bytes[i]);
        }
        for (i = 0; i < length; ++i) {
            buf[i] = (char)(buf[i] - adder[i % 9]);
        }
        return buf;
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCManagedDataSource", "javax.sql.DataSource"};
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

