/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400EndJobDS;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class AS400NoThreadServer
extends AS400Server {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400ImplRemote system_;
    private int service_;
    private String jobString_;
    private SocketContainer socket_;
    private InputStream inStream_;
    private OutputStream outStream_;
    private Hashtable replyStreams_;
    private Hashtable instanceReplyStreams_ = new Hashtable();
    private DataStream exchangeAttrReply_ = null;
    private Vector replyList_ = new Vector(5);
    private Vector discardList_ = new Vector();
    private AtomicInteger lastCorrelationId_ = new AtomicInteger();
    private final Lock thisLock = new ReentrantLock();
    private boolean closed_ = false;

    AS400NoThreadServer(AS400ImplRemote system, int service, SocketContainer socket, String jobString) throws IOException {
        this.system_ = system;
        this.service_ = service;
        this.jobString_ = jobString;
        this.socket_ = socket;
        this.connectionID_ = this.socket_.hashCode();
        this.inStream_ = socket.getInputStream();
        this.outStream_ = socket.getOutputStream();
        this.replyStreams_ = AS400Server.replyStreamsHashTables[service];
    }

    @Override
    int getService() {
        return this.service_;
    }

    @Override
    String getJobString() {
        return this.jobString_;
    }

    void setJobString(String jobString) {
        this.jobString_ = jobString;
    }

    @Override
    boolean isConnected() {
        return !this.closed_;
    }

    @Override
    public DataStream getExchangeAttrReply() {
        return this.exchangeAttrReply_;
    }

    @Override
    public synchronized DataStream sendExchangeAttrRequest(DataStream req) throws IOException {
        if (this.exchangeAttrReply_ == null) {
            this.exchangeAttrReply_ = this.sendAndReceive(req);
        }
        return this.exchangeAttrReply_;
    }

    @Override
    void addInstanceReplyStream(DataStream replyStream) {
        this.instanceReplyStreams_.put(replyStream, replyStream);
    }

    @Override
    void clearInstanceReplyStreams() {
        this.instanceReplyStreams_.clear();
    }

    @Override
    public DataStream sendAndReceive(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and receive(): ...");
        }
        int correlationID = this.send(requestStream);
        return this.receive(correlationID);
    }

    @Override
    void sendAndDiscardReply(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        int correlationID = this.send(requestStream);
        this.discardList_.addElement(correlationID);
    }

    @Override
    final void sendAndDiscardReply(DataStream requestStream, int correlationID) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        this.send(requestStream, correlationID);
        this.discardList_.addElement(correlationID);
    }

    @Override
    int send(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            requestStream.setConnectionID(this.connectionID_);
        }
        int correlationID = this.newCorrelationId();
        requestStream.setCorrelation(correlationID);
        requestStream.write(this.outStream_);
        return correlationID;
    }

    @Override
    int newCorrelationId() {
        return this.lastCorrelationId_.incrementAndGet();
    }

    @Override
    void send(DataStream requestStream, int correlationId) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            requestStream.setConnectionID(this.connectionID_);
        }
        requestStream.setCorrelation(correlationId);
        requestStream.write(this.outStream_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DataStream receive(int correlationId) throws IOException {
        try {
            this.thisLock.lock();
            if (Trace.traceOn_) {
                Trace.log(1, "AS400Server receive");
            }
            DataStream reply = null;
            do {
                if (!this.replyList_.isEmpty()) {
                    for (int i = 0; i < this.replyList_.size(); ++i) {
                        DataStream nextReply = (DataStream)this.replyList_.elementAt(i);
                        if (nextReply.getCorrelation() != correlationId) continue;
                        this.replyList_.removeElementAt(i);
                        reply = nextReply;
                        break;
                    }
                }
                if (reply == null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "run(): wait for reply...");
                    }
                    DataStream ds = null;
                    ds = this.service_ != 5 ? ClientAccessDataStream.construct(this.inStream_, this.instanceReplyStreams_, this.replyStreams_, this.system_, this.connectionID_) : DDMDataStream.construct(this.inStream_, this.replyStreams_, this.system_, this.connectionID_);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "run(): reply received..." + ds.toString());
                    }
                    boolean keepDataStream = true;
                    int correlation = ds.getCorrelation();
                    for (int i = 0; i < this.discardList_.size(); ++i) {
                        if ((Integer)this.discardList_.elementAt(i) != correlation) continue;
                        this.discardList_.removeElementAt(i);
                        keepDataStream = false;
                        break;
                    }
                    if (!keepDataStream) continue;
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "adding reply...", correlation);
                    }
                    this.replyList_.addElement(ds);
                    continue;
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "received(): valid reply received...", correlationId);
            } while (reply == null);
            DataStream dataStream = reply;
            return dataStream;
        }
        finally {
            this.thisLock.unlock();
        }
    }

    @Override
    void forceDisconnect() {
        this.closed_ = true;
        if (this.service_ == 4 || this.service_ == 2 || this.service_ == 6) {
            AS400EndJobDS endjob = new AS400EndJobDS(AS400Server.getServerId(this.service_));
            try {
                endjob.write(this.outStream_);
            }
            catch (IOException e) {
                Trace.log(2, "Send end job data stream failed.", (Throwable)e);
            }
        }
        try {
            this.socket_.close();
        }
        catch (IOException e) {
            Trace.log(2, "Socket close failed.", (Throwable)e);
        }
    }

    @Override
    int getSoTimeout() throws SocketException {
        return this.socket_.getSoTimeout();
    }

    @Override
    void setSoTimeout(int timeout) throws SocketException {
        this.socket_.setSoTimeout(timeout);
    }
}

