/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400EndJobDS;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClassDecoupler;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Hashtable;

final class AS400ThreadedServer
extends AS400Server
implements Runnable {
    private static int threadCount_ = 0;
    private AS400ImplRemote system_;
    private int service_;
    private String jobString_;
    private boolean disconnecting_ = false;
    private SocketContainer socket_;
    private InputStream inStream_;
    private OutputStream outStream_;
    private Hashtable replyStreams_;
    private Hashtable instanceReplyStreams_ = new Hashtable();
    private Thread readDaemon_ = null;
    private IOException readDaemonException_ = null;
    private RuntimeException unlikelyException_ = null;
    private DataStream exchangeAttrReply_ = null;
    private final ReplyList replyList_ = new ReplyList();
    private final DiscardList discardList_ = new DiscardList();
    private int lastCorrelationId_ = 0;
    private final CorrelationIdLock correlationIdLock_ = new CorrelationIdLock();
    private final ReceiveLock receiveLock_ = new ReceiveLock();

    AS400ThreadedServer(AS400ImplRemote system, int service, SocketContainer socket, String jobString) throws IOException {
        this.system_ = system;
        this.service_ = service;
        this.jobString_ = jobString;
        this.socket_ = socket;
        this.connectionID_ = this.socket_.hashCode();
        this.inStream_ = this.socket_.getInputStream();
        this.outStream_ = this.socket_.getOutputStream();
        this.replyStreams_ = AS400Server.replyStreamsHashTables[service];
        this.discardList_.setReplyList(this.replyList_);
        this.replyList_.setDiscardList(this.discardList_);
        Object jobID = jobString != null && jobString.length() != 0 ? jobString : AS400.getServerName(service) + "/" + ++threadCount_;
        this.readDaemon_ = new Thread((Runnable)this, "AS400 Read Daemon [system:" + system.getSystemName() + ";job:" + (String)jobID + "]");
        this.readDaemon_.setDaemon(true);
        this.readDaemon_.start();
    }

    @Override
    final void addInstanceReplyStream(DataStream replyStream) {
        this.instanceReplyStreams_.put(replyStream, replyStream);
    }

    @Override
    final void clearInstanceReplyStreams() {
        this.instanceReplyStreams_.clear();
    }

    @Override
    final void forceDisconnect() {
        this.disconnecting_ = true;
        if (this.readDaemonException_ == null) {
            this.readDaemonException_ = new ConnectionDroppedException(4);
        }
        if (this.service_ == 4 || this.service_ == 2 || this.service_ == 6) {
            AS400EndJobDS endjob = new AS400EndJobDS(AS400Server.getServerId(this.service_));
            if (Trace.traceOn_) {
                endjob.setConnectionID(this.connectionID_);
            }
            try {
                endjob.write(this.outStream_);
            }
            catch (IOException e) {
                Trace.log(2, "Send end job data stream failed:", (Throwable)e);
            }
        }
        Trace.log(3, "forceDisconnect calling readDaemon_.interrupt");
        this.readDaemon_.interrupt();
        try {
            this.socket_.close();
        }
        catch (IOException e) {
            Trace.log(2, "Socket close failed:", (Throwable)e);
        }
        try {
            this.readDaemon_.join();
        }
        catch (InterruptedException e) {
            Trace.log(2, "Thread join failed:", (Throwable)e);
        }
    }

    @Override
    public final DataStream getExchangeAttrReply() {
        return this.exchangeAttrReply_;
    }

    @Override
    final String getJobString() {
        return this.jobString_;
    }

    @Override
    final int getService() {
        return this.service_;
    }

    @Override
    final boolean isConnected() {
        return this.readDaemonException_ == null && this.unlikelyException_ == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final int newCorrelationId() {
        CorrelationIdLock correlationIdLock = this.correlationIdLock_;
        synchronized (correlationIdLock) {
            if (++this.lastCorrelationId_ == 0) {
                this.lastCorrelationId_ = 1;
            }
            return this.lastCorrelationId_;
        }
    }

    @Override
    final DataStream receive(int correlationId) throws IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "AS400Server.receive");
        }
        ReceiveLock receiveLock = this.receiveLock_;
        synchronized (receiveLock) {
            while (true) {
                if (this.readDaemonException_ != null) {
                    Trace.log(2, "receive(): Read daemon exception:", (Throwable)this.readDaemonException_);
                    throw this.readDaemonException_;
                }
                if (this.unlikelyException_ != null) {
                    Trace.log(2, "receive(): Read daemon exception:", (Throwable)this.unlikelyException_);
                    throw this.unlikelyException_;
                }
                DataStream ds = this.replyList_.remove(correlationId);
                if (ds != null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "receive(): Valid reply found:", correlationId);
                    }
                    if (DBDSPool.monitor && ds instanceof DBReplyRequestedDS) {
                        ((DBReplyRequestedDS)ds).setAllocatedLocation();
                    }
                    return ds;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "receive(): Reply not found. Waiting...");
                }
                this.receiveLock_.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.readDaemonException_ == null && this.unlikelyException_ == null) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Waiting for reply...");
                }
                DataStream reply = null;
                reply = this.service_ != 5 ? ClientAccessDataStream.construct(this.inStream_, this.instanceReplyStreams_, this.replyStreams_, this.system_, this.connectionID_) : ClassDecoupler.constructDDMDataStream(this.inStream_, this.replyStreams_, this.system_, this.connectionID_);
                int correlation = reply.getCorrelation();
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Adding reply:", correlation);
                }
                this.replyList_.add(reply);
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads.");
                }
                ReceiveLock receiveLock = this.receiveLock_;
                synchronized (receiveLock) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified.");
            }
            catch (IOException e) {
                if (Trace.traceOn_) {
                    if (this.disconnecting_ && e instanceof SocketException) {
                        Trace.log(1, "run(): Caught SocketException during disconnect:", (Throwable)e);
                    } else {
                        Trace.log(2, "run(): Caught IOException:", (Throwable)e);
                    }
                }
                if (this.readDaemonException_ == null) {
                    this.readDaemonException_ = e;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads after IOException.");
                }
                ReceiveLock receiveLock = this.receiveLock_;
                synchronized (receiveLock) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified after IOException.");
            }
            catch (RuntimeException e) {
                if (Trace.traceOn_) {
                    Trace.log(2, "run(): Caught RuntimeException:", (Throwable)e);
                }
                if (this.unlikelyException_ == null) {
                    this.unlikelyException_ = e;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads after RuntimeException.");
                }
                ReceiveLock receiveLock = this.receiveLock_;
                synchronized (receiveLock) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified after RuntimeException.");
            }
        }
    }

    @Override
    final int send(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            requestStream.setConnectionID(this.connectionID_);
        }
        if (this.readDaemonException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.readDaemonException_);
            throw this.readDaemonException_;
        }
        if (this.unlikelyException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.unlikelyException_);
            throw this.unlikelyException_;
        }
        int correlationID = this.newCorrelationId();
        requestStream.setCorrelation(correlationID);
        requestStream.write(this.outStream_);
        return correlationID;
    }

    @Override
    final void send(DataStream requestStream, int correlationId) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            requestStream.setConnectionID(this.connectionID_);
        }
        if (this.readDaemonException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.readDaemonException_);
            throw this.readDaemonException_;
        }
        if (this.unlikelyException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.unlikelyException_);
            throw this.unlikelyException_;
        }
        requestStream.setCorrelation(correlationId);
        requestStream.write(this.outStream_);
    }

    @Override
    final void sendAndDiscardReply(DataStream requestStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        int correlationID = this.send(requestStream);
        this.discardList_.add(correlationID);
    }

    @Override
    final void sendAndDiscardReply(DataStream requestStream, int correlationID) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        this.send(requestStream, correlationID);
        this.discardList_.add(correlationID);
    }

    @Override
    public final DataStream sendAndReceive(DataStream requestStream) throws IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and receive(): ...");
        }
        int correlationID = this.send(requestStream);
        return this.receive(correlationID);
    }

    @Override
    public final synchronized DataStream sendExchangeAttrRequest(DataStream req) throws IOException, InterruptedException {
        if (this.exchangeAttrReply_ == null) {
            this.exchangeAttrReply_ = this.sendAndReceive(req);
        }
        return this.exchangeAttrReply_;
    }

    @Override
    int getSoTimeout() throws SocketException {
        return this.socket_.getSoTimeout();
    }

    @Override
    void setSoTimeout(int timeout) throws SocketException {
        this.socket_.setSoTimeout(timeout);
    }

    private class ReceiveLock {
        private ReceiveLock() {
        }
    }

    private class CorrelationIdLock {
        private CorrelationIdLock() {
        }
    }

    private static final class DiscardList {
        int[] ids_ = new int[8];
        final Object idsLock_ = new Object();
        private ReplyList replyList_;

        private DiscardList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add(int correlation) {
            DataStream ds = this.replyList_.remove(correlation);
            if (ds != null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "DiscardList: Discarded datastream:", correlation);
                }
                ClassDecoupler.freeDBReplyStream(ds);
                ds = null;
                return;
            }
            Object object = this.idsLock_;
            synchronized (object) {
                int max = this.ids_.length;
                for (int i = 0; i < max; ++i) {
                    if (this.ids_[i] != 0) continue;
                    this.ids_[i] = correlation;
                    return;
                }
                int[] newIds = new int[max * 2];
                System.arraycopy(this.ids_, 0, newIds, 0, max);
                newIds[max] = correlation;
                this.ids_ = newIds;
            }
        }

        final boolean remove(int correlation) {
            int max = this.ids_.length;
            for (int i = 0; i < max; ++i) {
                if (this.ids_[i] != correlation) continue;
                this.ids_[i] = 0;
                return true;
            }
            return false;
        }

        void setReplyList(ReplyList replyList) {
            this.replyList_ = replyList;
        }
    }

    private static final class ReplyList {
        final DataStreamCollection[] streams_ = new DataStreamCollection[16];
        private DiscardList discardList_;

        private ReplyList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add(DataStream ds) {
            int id = ds.getCorrelation();
            if (this.discardList_.remove(id)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "ReplyList: Discarded datastream:", id);
                }
                ClassDecoupler.freeDBReplyStream(ds);
                ds = null;
                return;
            }
            int hash = ds.getCorrelation() % 16;
            DataStreamCollection coll = this.streams_[hash];
            if (coll == null) {
                this.streams_[hash] = new DataStreamCollection(ds);
                return;
            }
            DataStreamCollection dataStreamCollection = coll;
            synchronized (dataStreamCollection) {
                DataStream[] chain = coll.chain_;
                int max = chain.length;
                for (int i = 0; i < max; ++i) {
                    if (chain[i] != null) continue;
                    chain[i] = ds;
                    return;
                }
                DataStream[] newChain = new DataStream[max * 2];
                System.arraycopy(chain, 0, newChain, 0, max);
                newChain[max] = ds;
                coll.chain_ = newChain;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final DataStream remove(int correlation) {
            int hash = correlation % 16;
            DataStreamCollection coll = this.streams_[hash];
            if (coll == null) {
                return null;
            }
            DataStreamCollection dataStreamCollection = coll;
            synchronized (dataStreamCollection) {
                DataStream[] chain = coll.chain_;
                for (int i = 0; i < chain.length; ++i) {
                    if (chain[i] == null || chain[i].getCorrelation() != correlation) continue;
                    DataStream ds = chain[i];
                    if (i + 1 < chain.length) {
                        System.arraycopy(chain, i + 1, chain, i, chain.length - i - 1);
                    }
                    chain[chain.length - 1] = null;
                    return ds;
                }
                return null;
            }
        }

        void setDiscardList(DiscardList discardList) {
            this.discardList_ = discardList;
        }
    }

    private static final class DataStreamCollection {
        DataStream[] chain_;

        DataStreamCollection(DataStream ds) {
            this.chain_ = new DataStream[]{ds};
        }
    }
}

