/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.Serializable;
import java.util.Vector;

public class CharacterFieldDescription
extends FieldDescription
implements VariableLengthFieldDescription,
Serializable {
    static final long serialVersionUID = 4L;
    String ccsid_ = "";
    private int variableLength_;
    private boolean isVariableLength_;

    public CharacterFieldDescription() {
    }

    public CharacterFieldDescription(AS400Text dataType, String name) {
        super(dataType, name);
    }

    public CharacterFieldDescription(AS400Text dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
    }

    public String getCCSID() {
        return this.ccsid_;
    }

    @Override
    String[] getDDSDescription() {
        Vector<Object> v = new Vector<Object>();
        StringBuffer desc = new StringBuffer(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        String len = String.valueOf(this.length_);
        int numSpaces = 5 - len.length();
        for (int i = 0; i < numSpaces; ++i) {
            desc.append(' ');
        }
        desc.append(len);
        desc.append("A");
        desc.append("  ");
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (!this.ccsid_.equals("")) {
            v.addElement("CCSID(" + this.ccsid_ + ") ");
        }
        if (this.isVariableLength_) {
            if (this.variableLength_ > 0) {
                v.addElement("VARLEN(" + Integer.toString(this.variableLength_) + ") ");
            } else {
                v.addElement("VARLEN ");
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT('" + this.defaultValue_.toString() + "') ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public int getVARLEN() {
        return this.variableLength_;
    }

    @Override
    public boolean isVariableLength() {
        return this.isVariableLength_;
    }

    public void setCCSID(String ccsid) {
        if (ccsid == null) {
            throw new NullPointerException("ccsid");
        }
        this.ccsid_ = ccsid;
    }

    public void setDataType(AS400Text dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getByteLength();
    }

    public void setDFT(String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    @Override
    public void setVariableLength(boolean value) {
        this.isVariableLength_ = value;
        if (!value) {
            this.variableLength_ = 0;
        }
    }

    public void setVARLEN(int varLen) {
        if (varLen < 0) {
            throw new ExtendedIllegalArgumentException("varLen (" + String.valueOf(varLen) + ")", 2);
        }
        this.variableLength_ = varLen;
        this.isVariableLength_ = true;
    }
}

