/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.NLSTableDownload;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class GenerateConverterTable {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    private static final int MAX_SURROGATE_LENGTH = 2000;
    private static final int MAX_TO_EBCDIC_LENGTH = 20000;
    static AS400 sys = null;
    static Connection connection_ = null;
    static boolean compress_ = true;
    static boolean codePointPerLine_ = false;
    static boolean ascii_ = false;
    static boolean bidi_ = false;
    static boolean showOffsets_ = false;
    static boolean useJdbc_ = false;
    private static final char repSig = '\uffff';
    private static final char cic_ = '\uffff';
    private static final char rampSig = '\ufffe';
    private static final char ric_ = '\ufffe';
    private static final char hbSig = '\u0000';
    private static final char pad = '\u0000';
    static int numRepeats;
    static int numRamps;
    static int hbRepeats;
    static int charRepeats;

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: java com.ibm.as400.access.GenerateConverterTable system uid pwd [-nocompress] [-ascii] [-bidi] [-showOffsets] [-codePointPerLine] [-useJdbc] ccsid [ccsid2] [ccsid3] [ccsid4] ...");
            System.exit(0);
        }
        try {
            sys = new AS400(args[0], args[1], args[2]);
            sys.connectService(6);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        int start = 3;
        if (args[start].equals("-nocompress")) {
            compress_ = false;
            ++start;
        }
        if (args[start].equals("-ascii")) {
            ascii_ = true;
            ++start;
        }
        if (args[start].equals("-bidi")) {
            bidi_ = true;
            ++start;
        }
        if (args[start].equals("-showOffsets")) {
            showOffsets_ = true;
            ++start;
        }
        if (args[start].equals("-codePointPerLine")) {
            codePointPerLine_ = true;
            ++start;
        }
        if (args[start].equals("-useJdbc")) {
            useJdbc_ = true;
            try {
                Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                connection_ = DriverManager.getConnection("jdbc:as400:" + args[0], args[1], args[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            ++start;
        }
        for (int i = start; i < args.length; ++i) {
            GenerateConverterTable.go(Integer.parseInt(args[i]));
        }
    }

    static String formattedChar(char x) {
        int num = 0xFFFF & x;
        Object s = "\\u";
        if (num < 16) {
            s = (String)s + "0";
        }
        if (num < 256) {
            s = (String)s + "0";
        }
        if (num < 4096) {
            s = (String)s + "0";
        }
        s = (String)s + Integer.toHexString(num).toUpperCase();
        return s;
    }

    static void go(int ccsid) {
        String fName;
        char[] tableToUnicode = new char[]{};
        char[] tableToUnicodeSpaces = new char[]{};
        char[] tableToEbcdic = new char[]{};
        char[][] surrogateTable = null;
        char[][] tripletTable = null;
        char[][] quadTable = null;
        boolean ebcdicIsDBCS = false;
        int doubleByteFormat = 2;
        int originalCcsid = ccsid;
        try {
            block131: {
                if (useJdbc_) {
                    if (ConvTable.isMixedCCSID(originalCcsid)) {
                        GenerateConverterTable.go(1000000 + ccsid);
                        GenerateConverterTable.go(2000000 + ccsid);
                        return;
                    }
                    Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                    try {
                        ebcdicIsDBCS = ccsid > 2000000 ? true : (ccsid > 1000000 ? false : GenerateConverterTable.jdbcIsDBCS(connection_, ccsid));
                        if (ebcdicIsDBCS) {
                            tableToUnicodeSpaces = GenerateConverterTable.jdbcToUnicodeSpacesDBCS(connection_, ccsid);
                            tableToEbcdic = GenerateConverterTable.jdbcToEbcdicDBCS(connection_, ccsid);
                            break block131;
                        }
                        tableToUnicode = GenerateConverterTable.jdbcToUnicode(connection_, ccsid);
                        tableToEbcdic = GenerateConverterTable.jdbcToEbcdic(connection_, ccsid);
                    }
                    catch (Exception e) {
                        System.out.println("Error downloading table using JDBC ");
                        e.printStackTrace(System.out);
                        System.exit(1);
                    }
                } else {
                    AS400ImplRemote impl = (AS400ImplRemote)sys.getImpl();
                    NLSTableDownload down = new NLSTableDownload(impl);
                    down.connect();
                    if (ccsid == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving " + ccsid + "->61952 table...");
                        tableToUnicode = down.download(ccsid, 61952, 1);
                    } else if (ccsid == 1376) {
                        tableToUnicode = null;
                    } else if (ccsid == 1371) {
                        tableToUnicode = null;
                        doubleByteFormat = 3;
                    } else {
                        System.out.println("Retrieving " + ccsid + "->13488 table...");
                        tableToUnicode = down.download(ccsid, 13488, 1);
                    }
                    if (tableToUnicode == null || tableToUnicode.length == 0) {
                        String reason = "";
                        reason = tableToUnicode == null ? "tableToUnicode is null" : "tableToUnicode.length is 0";
                        if (ccsid == 1175) {
                            System.out.println("Aborting since CCSD 1175 failed to download");
                            throw new Exception("Aborting since CCSD 1175 failed to download");
                        }
                        System.out.println(ccsid + " must be double-byte because download failed (" + reason + "). Performing secondary retrieve of " + ccsid + "->1200 table...");
                        ebcdicIsDBCS = true;
                        down.disconnect();
                        down.connect();
                        tableToUnicode = down.download(ccsid, 1200, doubleByteFormat);
                    }
                    down.disconnect();
                    down.connect();
                    if (ccsid == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving 61952->" + ccsid + " table...");
                        tableToEbcdic = down.download(61952, ccsid, 2);
                    } else {
                        System.out.println("Retrieving 1200->" + ccsid + " table...");
                        tableToEbcdic = down.download(1200, ccsid, 2);
                    }
                }
            }
            System.out.println("  Size: " + tableToUnicode.length + " or " + tableToUnicodeSpaces.length);
            if (tableToUnicode.length > 65536 || tableToUnicodeSpaces.length > 131072) {
                int next;
                System.out.println("Size is > 65536 or 131072.  Fixing table");
                int from = 0;
                char[] newTable = new char[65536];
                int lastFrom = 0;
                int lastTo = 0;
                boolean hasSpaces = false;
                int tableLength = tableToUnicode.length;
                if (tableLength > 0) {
                    for (next = 0; from < tableLength && next < 65536; ++next) {
                        int c = 0xFFFF & tableToUnicode[from];
                        while (c >= 65024 && c <= 65039) {
                            c = 0xFFFF & tableToUnicode[++from];
                        }
                        if (next > 60586 && next <= 60624) {
                            System.out.println("Next=0x" + Integer.toHexString(next) + " to=" + Integer.toHexString(c));
                        }
                        int nextchar = 0;
                        if (from + 1 < tableToUnicode.length) {
                            nextchar = 0xFFFF & tableToUnicode[from + 1];
                        }
                        if (c >= 55296 && c <= 57343 || nextchar >= 65024 && nextchar <= 65039 || nextchar == 12442 && c != 12441 || c != 65533 && nextchar == 768 || c != 4093 && c != 768 && nextchar == 769 || c == 741 && nextchar == 745 || c == 745 && nextchar == 741) {
                            newTable[next] = 55296;
                            lastFrom = next;
                            lastTo = 55296;
                            if (surrogateTable == null) {
                                surrogateTable = new char[65536][];
                            }
                            char[] pair = new char[2];
                            surrogateTable[next] = pair;
                            pair[0] = (char)(0xFFFF & tableToUnicode[from]);
                            pair[1] = (char)(0xFFFF & tableToUnicode[from + 1]);
                            from += 2;
                            continue;
                        }
                        newTable[next] = (char)c;
                        if (c != 65533) {
                            lastFrom = next;
                            lastTo = c;
                        }
                        ++from;
                    }
                } else {
                    tableLength = tableToUnicodeSpaces.length;
                    while (from < tableLength && next < 65536) {
                        int c0 = 0;
                        int c1 = 0;
                        int c2 = 0;
                        int c3 = 0;
                        int c4 = 0;
                        int characterCount = 0;
                        c0 = 0xFFFF & tableToUnicodeSpaces[from];
                        if (ccsid != 2001371) {
                            while (c0 >= 65024 && c0 <= 65039) {
                                c0 = 0xFFFF & tableToUnicodeSpaces[++from];
                            }
                        }
                        if ((c1 = 0xFFFF & tableToUnicodeSpaces[from + 1]) == 12288) {
                            characterCount = 1;
                        } else {
                            c2 = 0xFFFF & tableToUnicodeSpaces[from + 2];
                            if (c2 == 12288) {
                                characterCount = 2;
                            } else {
                                c3 = 0xFFFF & tableToUnicodeSpaces[from + 3];
                                if (c3 == 12288) {
                                    characterCount = 3;
                                } else {
                                    c4 = 0xFFFF & tableToUnicodeSpaces[from + 4];
                                    if (c4 == 12288) {
                                        characterCount = 4;
                                    } else {
                                        throw new Exception("Character count is too large for from=0x" + Integer.toHexString(from));
                                    }
                                }
                            }
                        }
                        if (characterCount == 1) {
                            newTable[next] = (char)c0;
                            from += 2;
                        } else if (characterCount == 2) {
                            newTable[next] = 55296;
                            if (surrogateTable == null) {
                                surrogateTable = new char[65536][];
                            }
                            char[] pair = new char[2];
                            surrogateTable[next] = pair;
                            pair[0] = (char)(0xFFFF & c0);
                            pair[1] = (char)(0xFFFF & c1);
                            from += 3;
                        } else if (characterCount == 3) {
                            newTable[next] = 55297;
                            if (tripletTable == null) {
                                tripletTable = new char[65536][];
                            }
                            char[] triple = new char[3];
                            tripletTable[next] = triple;
                            triple[0] = (char)(0xFFFF & c0);
                            triple[1] = (char)(0xFFFF & c1);
                            triple[2] = (char)(0xFFFF & c2);
                            from += 4;
                        } else if (characterCount == 4) {
                            newTable[next] = 55298;
                            if (quadTable == null) {
                                quadTable = new char[65536][];
                            }
                            char[] quad = new char[4];
                            quadTable[next] = quad;
                            quad[0] = (char)(0xFFFF & c0);
                            quad[1] = (char)(0xFFFF & c1);
                            quad[2] = (char)(0xFFFF & c2);
                            quad[3] = (char)(0xFFFF & c3);
                            from += 5;
                        } else {
                            throw new Exception("Character count is invalid " + characterCount);
                        }
                        ++next;
                    }
                    while (next < 65536) {
                        newTable[next] = 65533;
                        ++next;
                    }
                }
                tableToUnicode = newTable;
            } else if (tableToUnicode.length == 0) {
                int len = tableToUnicodeSpaces.length / 2;
                tableToUnicode = new char[len];
                for (int i = 0; i < len; ++i) {
                    tableToUnicode[i] = tableToUnicodeSpaces[i * 2];
                }
            }
            System.out.println("  Size: " + tableToEbcdic.length);
            if (doubleByteFormat == 3) {
                char[] newTableToEbcdic = new char[65536];
                byte[] oldTableToEbcdic = new byte[tableToEbcdic.length * 2];
                for (int i = 0; i < tableToEbcdic.length; ++i) {
                    oldTableToEbcdic[2 * i] = (byte)(0xFF & tableToEbcdic[i] >> 8);
                    oldTableToEbcdic[2 * i + 1] = (byte)(tableToEbcdic[i] & 0xFF);
                }
                boolean singleByte = true;
                int newTableOffset = 0;
                for (int i = 0; i < oldTableToEbcdic.length; ++i) {
                    int b = 0xFF & oldTableToEbcdic[i];
                    while (i > 15 && i < oldTableToEbcdic.length && (b == 14 || b == 15)) {
                        if (b == 14) {
                            singleByte = false;
                            ++i;
                        } else {
                            singleByte = true;
                            ++i;
                        }
                        if (i >= oldTableToEbcdic.length) continue;
                        b = 0xFF & oldTableToEbcdic[i];
                    }
                    if (i >= oldTableToEbcdic.length) continue;
                    if (singleByte) {
                        if (newTableOffset >= newTableToEbcdic.length) continue;
                        newTableToEbcdic[newTableOffset] = (char)b;
                        ++newTableOffset;
                        continue;
                    }
                    if (++i >= oldTableToEbcdic.length) continue;
                    int c = 0xFF & oldTableToEbcdic[i];
                    if (newTableOffset >= newTableToEbcdic.length) continue;
                    if (newTableOffset == 1073) {
                        newTableToEbcdic[newTableOffset] = (char)((b << 8) + c);
                        ++newTableOffset;
                        continue;
                    }
                    newTableToEbcdic[newTableOffset] = (char)((b << 8) + c);
                    ++newTableOffset;
                }
                while (newTableOffset < newTableToEbcdic.length) {
                    newTableToEbcdic[newTableOffset] = 65278;
                    ++newTableOffset;
                }
                tableToEbcdic = newTableToEbcdic;
            }
            sys.disconnectAllServices();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (ccsid == 290) {
            tableToUnicode[225] = 8364;
            char toEbcdic = tableToEbcdic[4182];
            tableToEbcdic[4182] = toEbcdic = (char)(0xE100 | toEbcdic & 0xFF);
        }
        GenerateConverterTable.verifyRoundTrip(tableToUnicode, tableToEbcdic, ebcdicIsDBCS, ccsid, surrogateTable, tripletTable, quadTable);
        System.out.println("****************************************");
        System.out.println("Verify round 2 ");
        System.out.println("****************************************");
        GenerateConverterTable.verifyRoundTrip(tableToUnicode, tableToEbcdic, ebcdicIsDBCS, ccsid, surrogateTable, tripletTable, quadTable);
        if (ebcdicIsDBCS && compress_) {
            System.out.println("Compressing " + ccsid + "->13488 conversion table...");
            char[] arr = GenerateConverterTable.compress(tableToUnicode);
            System.out.println("Old compression length: " + arr.length + " characters.");
            char[] temparr = GenerateConverterTable.compressBetter(tableToUnicode);
            System.out.println("New compression length: " + temparr.length + " characters.");
            if (temparr.length > arr.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            arr = GenerateConverterTable.decompressBetter(temparr);
            if (arr.length != tableToUnicode.length) {
                int c;
                System.out.println("Verification failed, lengths not equal: " + arr.length + " != " + tableToUnicode.length);
                for (c = 0; c < arr.length && arr[c] == tableToUnicode[c]; ++c) {
                }
                System.out.println("First mismatch at index " + c + ": " + arr[c] + " != " + tableToUnicode[c]);
            } else {
                boolean bad = false;
                for (int c = 0; c < arr.length; ++c) {
                    if (arr[c] == tableToUnicode[c]) continue;
                    bad = true;
                    System.out.println(c + ": " + Integer.toHexString(arr[c]) + " != " + Integer.toHexString(tableToUnicode[c]));
                }
                if (bad) {
                    System.out.println("Mismatches found in table.");
                } else {
                    tableToUnicode = temparr;
                    System.out.println("Table verified.");
                }
            }
        }
        int fileCcsid = ccsid;
        if (doubleByteFormat == 3) {
            fileCcsid = ccsid + 1100000;
            System.out.println("Create file using " + fileCcsid + " since MIXED CCSID ");
        }
        StringBuffer surrogateInitStringBuffer = new StringBuffer();
        try {
            char[] triplet;
            fName = "ConvTable" + fileCcsid + ".java";
            FileWriter f = new FileWriter(fName);
            GenerateConverterTable.writeHeader(f, fileCcsid, sys.getSystemName());
            if (ascii_) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableAsciiMap\n{\n");
            } else if (bidi_) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableBidiMap\n{\n");
            } else if (ebcdicIsDBCS) {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableDoubleMap\n{\n");
            } else {
                f.write("class ConvTable" + fileCcsid + " extends ConvTableSingleMap\n{\n");
            }
            f.write("  private static char[] toUnicodeArray_;  \n");
            f.write("  private static final String copyright = \"Copyright (C) 1997-2016 International Business Machines Corporation and others.\";\n");
            f.write("  // toUnicode_ length is " + tableToUnicode.length + "\n");
            f.write("  private static final String toUnicode_ = \n");
            System.out.print("Writing table for conversion from " + ccsid + " to 13488... to " + fName + "\n");
            GenerateConverterTable.writeTable(f, tableToUnicode, 0, tableToUnicode.length);
            f.write("\n");
            f.write("\n");
            int surrogateLength = 0;
            if (surrogateTable != null) {
                int i;
                f.write("\n");
                for (int i2 = 0; i2 < surrogateTable.length; ++i2) {
                    char[] pair = surrogateTable[i2];
                    if (pair == null) continue;
                    ++surrogateLength;
                }
                int surrogateCount = 0;
                char[][] compressedSurrogateTable = new char[surrogateLength][];
                for (i = 0; i < surrogateTable.length; ++i) {
                    char[] pair = surrogateTable[i];
                    if (pair == null) continue;
                    triplet = new char[]{(char)i, pair[0], pair[1]};
                    compressedSurrogateTable[surrogateCount] = triplet;
                    ++surrogateCount;
                }
                f.write("  // Number of surrogateMappings is " + surrogateLength + "\n");
                if (surrogateLength < 2000) {
                    f.write("  private static final char[][] toUnicodeSurrogateMappings = { \n");
                    System.out.print("Writing surrogate table for conversion from " + ccsid + " to 1200... to " + fName + "\n");
                    for (i = 0; i < compressedSurrogateTable.length; ++i) {
                        char[] triplet2 = compressedSurrogateTable[i];
                        if (triplet2 == null) continue;
                        f.write("{'" + GenerateConverterTable.formattedChar(triplet2[0]) + "','" + GenerateConverterTable.formattedChar(triplet2[1]) + "','" + GenerateConverterTable.formattedChar(triplet2[2]) + "'},\n");
                    }
                    f.write("};\n");
                    f.write("\n");
                    f.write("\n");
                } else {
                    f.write("  private static char[][] toUnicodeSurrogateMappings = new char[" + surrogateLength + "][];\n");
                    for (int startIndex = 0; startIndex < surrogateLength; startIndex += 2000) {
                        f.write("  private static void initToUnicodeSurrogateMappings" + startIndex + "() { \n");
                        f.write("  char[][] toUnicodeSurrogateMappingsPiece = {\n");
                        for (int i3 = 0; i3 < 2000 && i3 + startIndex < surrogateLength; ++i3) {
                            triplet = compressedSurrogateTable[startIndex + i3];
                            if (triplet == null) continue;
                            f.write("    {'" + GenerateConverterTable.formattedChar(triplet[0]) + "','" + GenerateConverterTable.formattedChar(triplet[1]) + "','" + GenerateConverterTable.formattedChar(triplet[2]) + "'},\n");
                        }
                        f.write("  };\n");
                        f.write("    for (int j = 0; j < toUnicodeSurrogateMappingsPiece.length ; j++) {\n");
                        f.write("      toUnicodeSurrogateMappings[" + startIndex + "+j]= new char[3];\n");
                        f.write("      toUnicodeSurrogateMappings[" + startIndex + "+j][0] = toUnicodeSurrogateMappingsPiece[j][0];\n");
                        f.write("      toUnicodeSurrogateMappings[" + startIndex + "+j][1] = toUnicodeSurrogateMappingsPiece[j][1];\n");
                        f.write("      toUnicodeSurrogateMappings[" + startIndex + "+j][2] = toUnicodeSurrogateMappingsPiece[j][2];\n");
                        f.write("    }\n");
                        f.write("  }\n");
                        f.write("\n");
                        surrogateInitStringBuffer.append("   initToUnicodeSurrogateMappings" + startIndex + "();\n");
                    }
                }
            }
            int tripletLength = 0;
            if (tripletTable != null) {
                int i;
                f.write("\n");
                for (int i4 = 0; i4 < tripletTable.length; ++i4) {
                    char[] pair = tripletTable[i4];
                    if (pair == null) continue;
                    ++tripletLength;
                }
                int tripletCount = 0;
                char[][] compressedTripletTable = new char[tripletLength][];
                for (i = 0; i < tripletTable.length; ++i) {
                    triplet = tripletTable[i];
                    if (triplet == null) continue;
                    char[] entry = new char[]{(char)i, triplet[0], triplet[1], triplet[2]};
                    compressedTripletTable[tripletCount] = entry;
                    ++tripletCount;
                }
                f.write("  // Number of tripletMappings is " + tripletLength + "\n");
                if (tripletLength < 2000) {
                    f.write("  private static final char[][] toUnicodeTripletMappings = { \n");
                    System.out.print("Writing triplet table for conversion from " + ccsid + " to 13488... to " + fName + "\n");
                    for (i = 0; i < compressedTripletTable.length; ++i) {
                        char[] entry = compressedTripletTable[i];
                        if (entry == null) continue;
                        f.write("{'" + GenerateConverterTable.formattedChar(entry[0]) + "','" + GenerateConverterTable.formattedChar(entry[1]) + "','" + GenerateConverterTable.formattedChar(entry[2]) + "','" + GenerateConverterTable.formattedChar(entry[3]) + "'},\n");
                    }
                    f.write("};\n");
                    f.write("\n");
                    f.write("\n");
                } else {
                    f.write("  private static char[][] toUnicodeTripletMappings = new char[" + tripletLength + "][];\n");
                    for (int startIndex = 0; startIndex < tripletLength; startIndex += 2000) {
                        f.write("  private static void initToUnicodeTripletMappings" + startIndex + "() { \n");
                        f.write("  char[][] toUnicodeTripletMappingsPiece = {\n");
                        for (int i5 = 0; i5 < 2000 && i5 + startIndex < tripletLength; ++i5) {
                            char[] entry = compressedTripletTable[startIndex + i5];
                            if (entry == null) continue;
                            f.write("    {'" + GenerateConverterTable.formattedChar(entry[0]) + "','" + GenerateConverterTable.formattedChar(entry[1]) + "','" + GenerateConverterTable.formattedChar(entry[2]) + "','" + GenerateConverterTable.formattedChar(entry[3]) + "'},\n");
                        }
                        f.write("  };\n");
                        f.write("    for (int j = 0; j < toUnicodeTripletMappingsPiece.length ; j++) {\n");
                        f.write("      toUnicodeTripletMappings[" + startIndex + "+j]= new char[3];\n");
                        f.write("      toUnicodeTripletMappings[" + startIndex + "+j][0] = toUnicodeTripletMappingsPiece[j][0];\n");
                        f.write("      toUnicodeTripletMappings[" + startIndex + "+j][1] = toUnicodeTripletMappingsPiece[j][1];\n");
                        f.write("      toUnicodeTripletMappings[" + startIndex + "+j][2] = toUnicodeTripletMappingsPiece[j][2];\n");
                        f.write("    }\n");
                        f.write("  }\n");
                        f.write("\n");
                        surrogateInitStringBuffer.append("   initToUnicodeTripletMappings" + startIndex + "();\n");
                    }
                }
            }
            int quadLength = 0;
            if (quadTable != null) {
                int i;
                f.write("\n");
                for (int i6 = 0; i6 < quadTable.length; ++i6) {
                    char[] pair = quadTable[i6];
                    if (pair == null) continue;
                    ++quadLength;
                }
                int quadCount = 0;
                char[][] compressedquadTable = new char[quadLength][];
                for (i = 0; i < quadTable.length; ++i) {
                    char[] quad = quadTable[i];
                    if (quad == null) continue;
                    char[] entry = new char[]{(char)i, quad[0], quad[1], quad[2], quad[3]};
                    compressedquadTable[quadCount] = entry;
                    ++quadCount;
                }
                f.write("  // Number of quadMappings is " + quadLength + "\n");
                if (quadLength < 2000) {
                    f.write("  private static final char[][] toUnicodeQuadMappings = { \n");
                    System.out.print("Writing quad table for conversion from " + ccsid + " to 1200... to " + fName + "\n");
                    for (i = 0; i < compressedquadTable.length; ++i) {
                        char[] entry = compressedquadTable[i];
                        if (entry == null) continue;
                        f.write("{'" + GenerateConverterTable.formattedChar(entry[0]) + "','" + GenerateConverterTable.formattedChar(entry[1]) + "','" + GenerateConverterTable.formattedChar(entry[2]) + "','" + GenerateConverterTable.formattedChar(entry[3]) + "','" + GenerateConverterTable.formattedChar(entry[4]) + "'},\n");
                    }
                    f.write("};\n");
                    f.write("\n");
                    f.write("\n");
                } else {
                    f.write("  private static char[][] toUnicodeQuadMappings = new char[" + quadLength + "][];\n");
                    for (int startIndex = 0; startIndex < quadLength; startIndex += 2000) {
                        f.write("  private static void initToUnicodeQuadMappings" + startIndex + "() { \n");
                        f.write("  char[][] toUnicodeQuadMappingsPiece = {\n");
                        for (int i7 = 0; i7 < 2000 && i7 + startIndex < quadLength; ++i7) {
                            char[] entry = compressedquadTable[startIndex + i7];
                            if (entry == null) continue;
                            f.write("    {'" + GenerateConverterTable.formattedChar(entry[0]) + "','" + GenerateConverterTable.formattedChar(entry[1]) + "','" + GenerateConverterTable.formattedChar(entry[2]) + "','" + GenerateConverterTable.formattedChar(entry[3]) + "','" + GenerateConverterTable.formattedChar(entry[4]) + "'},\n");
                        }
                        f.write("  };\n");
                        f.write("    for (int j = 0; j < toUnicodeQuadMappingsPiece.length ; j++) {\n");
                        f.write("      toUnicodeQuadMappings[" + startIndex + "+j]= new char[3];\n");
                        f.write("      toUnicodeQuadMappings[" + startIndex + "+j][0] = toUnicodeQuadMappingsPiece[j][0];\n");
                        f.write("      toUnicodeQuadMappings[" + startIndex + "+j][1] = toUnicodeQuadMappingsPiece[j][1];\n");
                        f.write("      toUnicodeQuadMappings[" + startIndex + "+j][2] = toUnicodeQuadMappingsPiece[j][2];\n");
                        f.write("      toUnicodeQuadMappings[" + startIndex + "+j][3] = toUnicodeQuadMappingsPiece[j][3];\n");
                        f.write("    }\n");
                        f.write("  }\n");
                        f.write("\n");
                        surrogateInitStringBuffer.append("   initToUnicodeQuadMappings" + startIndex + "();\n");
                    }
                }
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (compress_) {
            System.out.println("Compressing 13488->" + ccsid + " conversion table...");
            char[] arr = GenerateConverterTable.compress(tableToEbcdic);
            System.out.println("Old compression length: " + arr.length + " characters.");
            char[] temparr = GenerateConverterTable.compressBetter(tableToEbcdic);
            System.out.println("New compression length: " + temparr.length + " characters.");
            if (temparr.length > arr.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            arr = GenerateConverterTable.decompressBetter(temparr);
            if (arr.length != tableToEbcdic.length) {
                int c;
                System.out.println("Verification failed, lengths not equal: " + arr.length + " != " + tableToEbcdic.length);
                for (c = 0; c < arr.length && arr[c] == tableToEbcdic[c]; ++c) {
                }
                System.out.println("First mismatch at index " + c + ": " + arr[c] + " != " + tableToEbcdic[c]);
                tableToEbcdic = temparr;
            } else {
                boolean bad = false;
                for (int c = 0; c < arr.length; ++c) {
                    if (arr[c] == tableToEbcdic[c]) continue;
                    bad = true;
                    System.out.println(c + ": " + Integer.toHexString(arr[c]) + " != " + Integer.toHexString(tableToEbcdic[c]));
                }
                if (bad) {
                    System.out.println("Mismatches found in table.");
                } else {
                    tableToEbcdic = temparr;
                    System.out.println("Table verified.");
                }
            }
        }
        try {
            fName = "ConvTable" + fileCcsid + ".java";
            FileWriter f = new FileWriter(fName, true);
            System.out.print("Writing table for conversion from 13488 to " + ccsid + "... to " + fName + "\n");
            f.write("  private static char[] fromUnicodeArray_; \n");
            f.write("  // fromUnicode length = " + tableToEbcdic.length + "\n");
            if (tableToEbcdic.length < 20000) {
                f.write("  private static final String fromUnicode_ = \n");
                GenerateConverterTable.writeTable(f, tableToEbcdic, 0, tableToEbcdic.length);
                f.write("\n");
            } else {
                int oneFourth = tableToEbcdic.length / 4;
                f.write("  private static final String fromUnicode0_ = \n");
                GenerateConverterTable.writeTable(f, tableToEbcdic, 0, oneFourth);
                f.write("\n");
                f.write("  private static final String fromUnicode1_ = \n");
                GenerateConverterTable.writeTable(f, tableToEbcdic, oneFourth, oneFourth);
                f.write("\n");
                f.write("  private static final String fromUnicode2_ = \n");
                GenerateConverterTable.writeTable(f, tableToEbcdic, 2 * oneFourth, oneFourth);
                f.write("\n");
                f.write("  private static final String fromUnicode3_ = \n");
                GenerateConverterTable.writeTable(f, tableToEbcdic, 3 * oneFourth, tableToEbcdic.length - 3 * oneFourth);
                f.write("\n");
            }
            f.write("  static {\n");
            f.write("    toUnicodeArray_ = toUnicode_.toCharArray();\n");
            if (tableToEbcdic.length < 20000) {
                f.write("    fromUnicodeArray_ = fromUnicode_.toCharArray();\n");
            } else {
                f.write("    StringBuffer sb = new StringBuffer(); \n");
                f.write("    sb.append(fromUnicode0_); \n");
                f.write("    sb.append(fromUnicode1_); \n");
                f.write("    sb.append(fromUnicode2_); \n");
                f.write("    sb.append(fromUnicode3_); \n");
                f.write("    fromUnicodeArray_ = sb.toString().toCharArray();\n");
            }
            f.write(surrogateInitStringBuffer.toString());
            f.write("  }\n");
            f.write("\n  ConvTable" + fileCcsid + "()\n  {\n");
            f.write("    super(" + fileCcsid + ", ");
            f.write("toUnicodeArray_, ");
            if (surrogateTable != null) {
                f.write("fromUnicodeArray_,");
                if (quadTable != null) {
                    f.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings,toUnicodeQuadMappings);\n");
                } else if (tripletTable != null) {
                    f.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings);\n");
                } else {
                    f.write("toUnicodeSurrogateMappings,null);\n");
                }
            } else {
                f.write("fromUnicodeArray_);\n");
            }
            f.write("  }\n\n");
            f.write("\n  ConvTable" + fileCcsid + "(int ccsid)\n  {\n");
            f.write("    super(ccsid, ");
            f.write("toUnicodeArray_, ");
            if (surrogateTable != null) {
                f.write("fromUnicodeArray_,");
                if (quadTable != null) {
                    f.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings,toUnicodeQuadMappings);\n");
                } else if (tripletTable != null) {
                    f.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings);\n");
                } else {
                    f.write("toUnicodeSurrogateMappings,null);\n");
                }
            } else {
                f.write("fromUnicodeArray_);\n");
            }
            f.write("  }\n}\n");
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print("Done.\n");
    }

    private static void writeTable(FileWriter f, char[] table, int start, int length) throws IOException {
        for (int i = start; i < start + length; i += 16) {
            if (showOffsets_) {
                f.write("/* " + Integer.toHexString(i) + " */ \"");
            } else {
                f.write("    \"");
            }
            for (int j = 0; j < 16 && i + j < start + length; ++j) {
                char num = table[i + j];
                if (num == '\b') {
                    f.write("\\b");
                } else if (num == '\t') {
                    f.write("\\t");
                } else if (num == '\n') {
                    f.write("\\n");
                } else if (num == '\f') {
                    f.write("\\f");
                } else if (num == '\r') {
                    f.write("\\r");
                } else if (num == '\"') {
                    f.write("\\\"");
                } else if (num == '\'') {
                    f.write("\\'");
                } else if (num == '\\') {
                    f.write("\\\\");
                } else {
                    Object s = "\\u";
                    if (num < '\u0010') {
                        s = (String)s + "0";
                    }
                    if (num < '\u0100') {
                        s = (String)s + "0";
                    }
                    if (num < '\u1000') {
                        s = (String)s + "0";
                    }
                    s = (String)s + Integer.toHexString(num).toUpperCase();
                    f.write((String)s);
                }
                if (!codePointPerLine_ || j >= 15) continue;
                if (showOffsets_) {
                    f.write("\" +\n/* " + Integer.toHexString(i + j + 1) + " */ \"");
                    continue;
                }
                f.write("\" +\n    \"");
            }
            if (i + 16 < start + length) {
                f.write("\" +\n");
                continue;
            }
            f.write("\";\n");
        }
    }

    private static boolean verifyRoundTrip(char[] tableToUnicode, char[] tableToEbcdic, boolean ebcdicIsDBCS, int ccsid, char[][] surrogateTable, char[][] tripletTable, char[][] quadTable) {
        int ebcdicChar;
        char[] unicodeChars;
        int i;
        int piece;
        String ebcdicPrefix = "X";
        if (ebcdicIsDBCS) {
            ebcdicPrefix = "GX";
        }
        if (!ebcdicIsDBCS && (piece = 0xFFFF & tableToEbcdic[13]) >> 8 != 63) {
            System.out.println("Fixing sub char in tableToEbcdic == sub was 0x" + Integer.toHexString(piece >> 8));
            piece = 0x3F00 | 0xFF & piece;
            tableToEbcdic[13] = (char)piece;
        }
        System.out.println("Checking round trip from EBCDIC for CCSID " + ccsid);
        boolean passed = true;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        char[] char1Buffer = new char[1];
        char[] char1Buffer2 = new char[1];
        for (i = 0; i < tableToUnicode.length; ++i) {
            int j;
            char[] unicodeChars2;
            int piece2;
            char1Buffer[0] = tableToUnicode[i];
            unicodeChars = char1Buffer[0] == '\ud800' && surrogateTable != null ? surrogateTable[i] : (char1Buffer[0] == '\ud801' && tripletTable != null ? tripletTable[i] : (char1Buffer[0] == '\ud802' && quadTable != null ? quadTable[i] : char1Buffer));
            if (unicodeChars[0] == '\ufffd') continue;
            ebcdicChar = 0;
            if (ebcdicIsDBCS) {
                if (unicodeChars.length == 1) {
                    ebcdicChar = 0xFFFF & tableToEbcdic[unicodeChars[0]];
                } else if (unicodeChars.length == 2) {
                    ebcdicChar = GenerateConverterTable.findEbcdicSurrogate(surrogateTable, unicodeChars);
                } else if (unicodeChars.length == 3) {
                    ebcdicChar = GenerateConverterTable.findEbcdicTriplet(tripletTable, unicodeChars);
                } else if (unicodeChars.length == 4) {
                    ebcdicChar = GenerateConverterTable.findEbcdicQuad(quadTable, unicodeChars);
                }
            } else {
                piece2 = 0xFFFF & tableToEbcdic[unicodeChars[0] / 2];
                ebcdicChar = unicodeChars[0] % 2 == 0 ? piece2 >> 8 : piece2 & 0xFF;
            }
            if (i == ebcdicChar) continue;
            if (unicodeChars[0] != '\u001a' && unicodeChars[0] != '\ud800' && unicodeChars[0] != '\ud801' && (ebcdicChar == 65278 || ebcdicChar == 63)) {
                sb1.append("Fixing up EBCDIC RoundTrip Failure " + ebcdicPrefix + "'" + Integer.toHexString(i) + "' -> UX'" + Integer.toHexString(unicodeChars[0]) + "' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "'\n");
                if (ebcdicIsDBCS) {
                    tableToEbcdic[unicodeChars[0]] = (char)i;
                } else {
                    piece2 = 0xFFFF & tableToEbcdic[unicodeChars[0] / 2];
                    piece2 = unicodeChars[0] % 2 == 0 ? i << 8 | piece2 & 0xFF : piece2 & 0xFF00 | i;
                    tableToEbcdic[unicodeChars[0] / 2] = (char)piece2;
                }
                passed = false;
                continue;
            }
            try {
                char1Buffer2[0] = tableToUnicode[ebcdicChar];
                unicodeChars2 = char1Buffer2[0] == '\ud800' ? surrogateTable[ebcdicChar] : (char1Buffer2[0] == '\ud801' ? tripletTable[ebcdicChar] : char1Buffer2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ERROR.. ArrayIndexOutOfBounds");
                System.out.println("ebcdicChar=0x" + Integer.toHexString(ebcdicChar));
                System.out.println("i=" + i);
                System.out.println("unicodeChar=0x" + Integer.toHexString(unicodeChars[0]));
                throw e;
            }
            boolean matches = true;
            if (unicodeChars2.length != unicodeChars.length) {
                matches = false;
            } else {
                for (j = 0; j < unicodeChars.length; ++j) {
                    if (unicodeChars[j] == unicodeChars2[j]) continue;
                    matches = false;
                }
            }
            if (matches) {
                sb2.append("Secondary EBCDIC mapping " + ebcdicPrefix + "'" + Integer.toHexString(i) + "' -> UX'");
                for (j = 0; j < unicodeChars.length; ++j) {
                    sb2.append(Integer.toHexString(unicodeChars[j]) + ".");
                }
                sb2.append("' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
                for (j = 0; j < unicodeChars2.length; ++j) {
                    sb2.append(Integer.toHexString(unicodeChars2[j]) + ".");
                }
                sb2.append("'\n");
                continue;
            }
            sb3.append("EBCDIC RoundTrip Failure 2 " + ebcdicPrefix + "'" + Integer.toHexString(i) + "' -> UX'");
            for (j = 0; j < unicodeChars.length; ++j) {
                sb3.append(Integer.toHexString(unicodeChars[j]) + ".");
            }
            sb3.append("' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
            for (j = 0; j < unicodeChars2.length; ++j) {
                sb3.append(Integer.toHexString(unicodeChars2[j]) + ".");
            }
            sb3.append("'\n");
            passed = false;
        }
        System.out.println(sb2);
        System.out.println(sb1);
        System.out.println(sb3);
        sb1.setLength(0);
        sb2.setLength(0);
        sb3.setLength(0);
        for (i = 0; i < tableToEbcdic.length; ++i) {
            int j;
            if (ebcdicIsDBCS) {
                ebcdicChar = 0xFFFF & tableToEbcdic[i];
            } else {
                int piece3 = 0xFFFF & tableToEbcdic[i / 2];
                ebcdicChar = i % 2 == 0 ? piece3 >> 8 : piece3 & 0xFF;
            }
            if (ebcdicChar == 65278 || ebcdicChar == 63) continue;
            char1Buffer[0] = tableToUnicode[ebcdicChar];
            unicodeChars = char1Buffer[0] == '\ud800' ? surrogateTable[ebcdicChar] : (char1Buffer[0] == '\ud801' ? tripletTable[ebcdicChar] : char1Buffer);
            if (i == unicodeChars[0]) continue;
            if (unicodeChars[0] == '\ufffd') {
                int j2;
                sb1.append("Unicode RoundTrip Failure UX'" + Integer.toHexString(i) + "' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
                for (j2 = 0; j2 < unicodeChars.length; ++j2) {
                    sb1.append(Integer.toHexString(unicodeChars[j2]) + ".");
                }
                sb1.append("'\n");
                if (tableToUnicode[ebcdicChar] == '\ufffd') {
                    tableToUnicode[ebcdicChar] = (char)i;
                    char1Buffer[0] = tableToUnicode[ebcdicChar];
                    unicodeChars = char1Buffer;
                    sb1.append("Fixed up ................ UX'" + Integer.toHexString(i) + "' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
                    for (j2 = 0; j2 < unicodeChars.length; ++j2) {
                        sb1.append(Integer.toHexString(unicodeChars[j2]) + ".");
                    }
                    sb1.append("'\n");
                }
                passed = false;
                continue;
            }
            int ebcdicChar2 = 0;
            if (ebcdicIsDBCS) {
                if (unicodeChars.length == 1) {
                    ebcdicChar2 = 0xFFFF & tableToEbcdic[unicodeChars[0]];
                } else if (unicodeChars.length == 2) {
                    ebcdicChar2 = GenerateConverterTable.findEbcdicSurrogate(surrogateTable, unicodeChars);
                } else if (unicodeChars.length == 3) {
                    ebcdicChar2 = GenerateConverterTable.findEbcdicTriplet(tripletTable, unicodeChars);
                }
            } else {
                int piece4 = 0xFFFF & tableToEbcdic[unicodeChars[0] / 2];
                ebcdicChar2 = unicodeChars[0] % 2 == 0 ? piece4 >> 8 : piece4 & 0xFF;
            }
            if (ebcdicChar2 == ebcdicChar) {
                sb2.append("Secondary Unicode mapping UX'" + Integer.toHexString(i) + "' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
                for (j = 0; j < unicodeChars.length; ++j) {
                    sb2.append(Integer.toHexString(unicodeChars[j]) + ".");
                }
                sb2.append("' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar2) + "'\n");
                continue;
            }
            sb3.append("Unicode RoundTrip Failure 2 UX'" + Integer.toHexString(i) + "' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar) + "' -> UX'");
            for (j = 0; j < unicodeChars.length; ++j) {
                sb3.append(Integer.toHexString(unicodeChars[j]) + ".");
            }
            sb3.append("' -> " + ebcdicPrefix + "'" + Integer.toHexString(ebcdicChar2) + "'\n");
            passed = false;
        }
        System.out.println(sb2);
        System.out.println(sb1);
        System.out.println(sb3);
        return passed;
    }

    private static int findEbcdicQuad(char[][] quadTable, char[] unicodeChars) {
        for (int i = 0; i < quadTable.length; ++i) {
            if (quadTable[i] == null || quadTable[i][0] != unicodeChars[0] || quadTable[i][1] != unicodeChars[1] || quadTable[i][2] != unicodeChars[2] || quadTable[i][3] != unicodeChars[3]) continue;
            return i;
        }
        return 0;
    }

    private static int findEbcdicTriplet(char[][] tripletTable, char[] unicodeChars) {
        for (int i = 0; i < tripletTable.length; ++i) {
            if (tripletTable[i] == null || tripletTable[i][0] != unicodeChars[0] || tripletTable[i][1] != unicodeChars[1] || tripletTable[i][2] != unicodeChars[2]) continue;
            return i;
        }
        return 0;
    }

    private static int findEbcdicSurrogate(char[][] surrogateTable, char[] unicodeChars) {
        for (int i = 0; i < surrogateTable.length; ++i) {
            if (surrogateTable[i] == null || surrogateTable[i][0] != unicodeChars[0] || surrogateTable[i][1] != unicodeChars[1]) continue;
            return i;
        }
        return 0;
    }

    static int repeatCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length && arr[index] == arr[index - 1]; ++index) {
        }
        return index - startingIndex;
    }

    static final int rampCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length && arr[index] == arr[index - 1] + '\u0001'; ++index) {
        }
        return index - startingIndex;
    }

    static int hbCheck(char[] arr, int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < arr.length; ++index) {
            if (GenerateConverterTable.repeatCheck(arr, index) > 6) {
                return index - startingIndex;
            }
            if (GenerateConverterTable.rampCheck(arr, index) > 6) {
                return index - startingIndex;
            }
            if ((arr[index] & 0xFF00) == (arr[index - 1] & 0xFF00)) continue;
            return index - startingIndex;
        }
        return index - startingIndex;
    }

    static char[] compressBetter(char[] arr) {
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            int repNum = GenerateConverterTable.repeatCheck(arr, i);
            if (repNum > 3) {
                ++numRepeats;
                buf.append('\uffff');
                buf.append((char)repNum);
                buf.append(arr[i]);
                i += repNum - 1;
                continue;
            }
            int rampNum = GenerateConverterTable.rampCheck(arr, i);
            if (rampNum > 3) {
                ++numRamps;
                buf.append('\ufffe');
                buf.append((char)rampNum);
                buf.append(arr[i]);
                i += rampNum - 1;
                continue;
            }
            int hbNum = GenerateConverterTable.hbCheck(arr, i);
            if (--hbNum >= 6) {
                ++hbRepeats;
                buf.append('\u0000');
                if ((0xFFFFFFFFL & (long)hbNum) % 2L == 1L) {
                    --hbNum;
                }
                buf.append((char)(hbNum / 2));
                buf.append(arr[i++]);
                for (int j = 0; j < hbNum / 2; ++j) {
                    char x = (char)((0xFF & arr[i + j * 2]) * 256 + (0xFF & arr[i + j * 2 + 1]));
                    buf.append(x);
                }
                i = i + hbNum - 1;
                continue;
            }
            buf.append(arr[i]);
            ++charRepeats;
            if (arr[i] != '\uffff' && arr[i] != '\ufffe' && arr[i] != '\u0000') continue;
            buf.append('\u0000');
        }
        System.out.println("Compression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return buf.toString().toCharArray();
    }

    static char[] decompressBetter(char[] arr) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            int j;
            if (arr[i] == '\uffff') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\uffff');
                    ++i;
                    continue;
                }
                ++numRepeats;
                int repNum = arr[i + 1];
                char repChar = arr[i + 2];
                for (j = 0; j < repNum; ++j) {
                    buf.append(repChar);
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\ufffe') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\ufffe');
                    ++i;
                    continue;
                }
                ++numRamps;
                int rampNum = arr[i + 1];
                char rampStart = arr[i + 2];
                for (j = 0; j < rampNum; ++j) {
                    buf.append((char)(j + rampStart));
                }
                i += 2;
                continue;
            }
            if (arr[i] == '\u0000') {
                if (arr[i + 1] == '\u0000') {
                    buf.append('\u0000');
                    ++i;
                    continue;
                }
                ++hbRepeats;
                int hbNum = 0xFFFF & arr[++i];
                char firstChar = arr[++i];
                char highByteMask = (char)(0xFF00 & firstChar);
                buf.append(firstChar);
                ++i;
                for (int j2 = 0; j2 < hbNum; ++j2) {
                    char both = arr[i + j2];
                    char c1 = (char)(highByteMask + ((0xFF00 & both) >>> 8));
                    char c2 = (char)(highByteMask + (0xFF & both));
                    buf.append(c1);
                    buf.append(c2);
                }
                i = i + hbNum - 1;
                continue;
            }
            buf.append(arr[i]);
            ++charRepeats;
        }
        System.out.println("Decompression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return buf.toString().toCharArray();
    }

    static char[] compress(char[] arr) {
        if (arr.length < 3) {
            return arr;
        }
        StringBuffer buf = new StringBuffer();
        char oldold = arr[0];
        char old = arr[1];
        int count = 0;
        boolean inCompression = false;
        boolean inRamp = false;
        for (int i = 2; i < arr.length; ++i) {
            if (!inCompression && !inRamp) {
                if (arr[i] == old && arr[i] == oldold) {
                    inCompression = true;
                    buf.append('\uffff');
                    buf.append(oldold);
                    count = 3;
                } else if (arr[i] == old + '\u0001' && arr[i] == oldold + 2) {
                    inRamp = true;
                    buf.append('\ufffe');
                    buf.append(oldold);
                } else if (oldold == '\uffff') {
                    buf.append('\uffff');
                } else if (oldold == '\ufffe') {
                    buf.append('\ufffe');
                } else {
                    buf.append(oldold);
                }
                oldold = old;
                old = arr[i];
                continue;
            }
            if (inCompression) {
                if (arr[i] == old && arr[i] == oldold) {
                    ++count;
                    oldold = old;
                    old = arr[i];
                    continue;
                }
                inCompression = false;
                int c = count;
                if (count == 8) {
                    c = 8;
                } else if (count == 9) {
                    c = 9;
                } else if (count == 10) {
                    c = 10;
                } else if (count == 12) {
                    c = 12;
                } else if (count == 13) {
                    c = 13;
                } else if (count == 34) {
                    c = 34;
                } else if (count == 39) {
                    c = 39;
                } else if (count == 92) {
                    c = 92;
                }
                buf.append((char)c);
                oldold = arr[i++];
                if (i < arr.length) {
                    old = arr[i];
                    continue;
                }
                old = '\u0000';
                continue;
            }
            if (arr[i] == old + '\u0001' && arr[i] == oldold + 2) {
                oldold = old;
                old = arr[i];
                continue;
            }
            inRamp = false;
            buf.append(old);
            oldold = arr[i++];
            old = arr[i];
        }
        if (inCompression) {
            int c = count;
            if (count == 8) {
                c = 8;
            } else if (count == 9) {
                c = 9;
            } else if (count == 10) {
                c = 10;
            } else if (count == 12) {
                c = 12;
            } else if (count == 13) {
                c = 13;
            } else if (count == 34) {
                c = 34;
            } else if (count == 39) {
                c = 39;
            } else if (count == 92) {
                c = 92;
            }
            buf.append((char)c);
        }
        if (inRamp) {
            buf.append(old);
        }
        return buf.toString().toCharArray();
    }

    static void writeHeader(FileWriter f, int ccsid, String system) throws Exception {
        int dotIndex = system.indexOf(46);
        if (dotIndex > 0) {
            system = system.substring(0, dotIndex);
        }
        Date currentDate = new Date();
        Class<Copyright> copyrightClass = Copyright.class;
        Field field = copyrightClass.getField("version");
        String jtopenVersion = (String)field.get(null);
        f.write("///////////////////////////////////////////////////////////////////////////////\n");
        f.write("//\n");
        f.write("// JTOpen (IBM Toolbox for Java - OSS version)\n");
        f.write("//\n");
        f.write("// Filename:  ConvTable" + ccsid + ".java\n");
        f.write("//\n");
        f.write("// The source code contained herein is licensed under the IBM Public License\n");
        f.write("// Version 1.0, which has been approved by the Open Source Initiative.\n");
        f.write("// Copyright (C) 1997-2016 International Business Machines Corporation and\n");
        f.write("// others.  All rights reserved.\n");
        f.write("//\n");
        f.write("// Generated " + currentDate + " from " + system + "\n");
        StringBuffer sb = new StringBuffer();
        if (!compress_) {
            sb.append(" -nocompress");
        }
        if (ascii_) {
            sb.append(" -ascii");
        }
        if (bidi_) {
            sb.append(" -bidi");
        }
        if (showOffsets_) {
            sb.append(" -showOffsets");
        }
        if (codePointPerLine_) {
            sb.append(" -codePointPerLine");
        }
        if (useJdbc_) {
            sb.append(" -useJdbc");
        }
        if (sb.length() > 0) {
            f.write("// Generation Options:" + sb.toString() + "\n");
        }
        f.write("// Using " + jtopenVersion + "\n");
        f.write("///////////////////////////////////////////////////////////////////////////////\n\n");
        f.write("package com.ibm.as400.access;\n\n");
    }

    static boolean jdbcIsDBCS(Connection connection, int ccsid) throws SQLException {
        boolean isDBCS;
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate("CREATE TABLE QTEMP.GENERATE" + ccsid + "(C1 VARCHAR(80) CCSID " + ccsid + ")");
            isDBCS = false;
        }
        catch (SQLException sqlex) {
            int sqlcode = sqlex.getErrorCode();
            if (sqlcode == -189) {
                stmt.executeUpdate("CREATE TABLE QTEMP.GENERATE" + ccsid + "(C1 VARGRAPHIC(80) CCSID " + ccsid + ")");
                isDBCS = true;
            }
            throw sqlex;
        }
        stmt.close();
        return isDBCS;
    }

    private static char[] jdbcToEbcdic(Connection connection, int ccsid) throws Exception {
        int i;
        if (ccsid > 1000000) {
            ccsid -= 1000000;
        }
        PreparedStatement ps = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + ccsid + ") as BLOB(1M)) from sysibm.sysdummy1");
        char[] allChar65536 = new char[65536];
        for (i = 0; i < 55296; ++i) {
            allChar65536[i] = (char)i;
        }
        for (i = 55296; i < 63744; ++i) {
            allChar65536[i] = 26;
        }
        for (i = 63744; i < 65536; ++i) {
            allChar65536[i] = (char)i;
        }
        Clob clob = ((AS400JDBCConnection)connection).createClob();
        clob.setString(1L, new String(allChar65536));
        ps.setClob(1, clob);
        ResultSet rs = ps.executeQuery();
        rs.next();
        byte[] byteAnswer = rs.getBytes(1);
        if (byteAnswer.length != 65536) {
            byteAnswer = GenerateConverterTable.removeDoubleByteEbcdic(byteAnswer);
        }
        rs.close();
        ps.close();
        char[] answer = new char[byteAnswer.length / 2];
        for (int i2 = 0; i2 < byteAnswer.length; i2 += 2) {
            answer[i2 / 2] = (char)(byteAnswer[i2] << 8 | 0xFF & byteAnswer[i2 + 1]);
        }
        return answer;
    }

    private static byte[] removeDoubleByteEbcdic(byte[] inBytes) throws Exception {
        byte[] outBytes = new byte[65536];
        System.arraycopy(inBytes, 0, outBytes, 0, 32);
        int toIndex = 32;
        boolean singleByte = true;
        for (int i = 32; i < inBytes.length; ++i) {
            byte b = inBytes[i];
            if (singleByte) {
                if (b == 14) {
                    singleByte = false;
                    continue;
                }
                if (b == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                if (toIndex >= outBytes.length) {
                    throw new Exception("ERROR:  toIndexInvalid");
                }
                outBytes[toIndex] = b;
                ++toIndex;
                continue;
            }
            if (b == 15) {
                singleByte = true;
                continue;
            }
            if (b == 14) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            if (toIndex >= outBytes.length) {
                throw new Exception("ERROR:  toIndexInvalid");
            }
            outBytes[toIndex] = 63;
            ++toIndex;
            ++i;
        }
        if (toIndex != 65536) {
            throw new Exception("To index is " + toIndex + " should be 65536");
        }
        return outBytes;
    }

    private static char[] removeSingleByteEbcdic(byte[] inBytes, boolean mixedCcsid) throws Exception {
        char[] outChars = new char[65536];
        boolean singleByte = false;
        if (mixedCcsid) {
            singleByte = true;
        }
        int toIndex = 0;
        for (int i = 0; i < inBytes.length; ++i) {
            byte b = inBytes[i];
            if (singleByte) {
                if (b == 14) {
                    singleByte = false;
                    continue;
                }
                if (b == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                outChars[toIndex] = 65278;
                ++toIndex;
                continue;
            }
            if (b == 15 && mixedCcsid) {
                singleByte = true;
                continue;
            }
            if (b == 14 && mixedCcsid) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            outChars[toIndex] = (char)(b << 8 | 0xFF & inBytes[i + 1]);
            ++toIndex;
            ++i;
        }
        if (toIndex != 65536) {
            throw new Exception("To index is " + toIndex + " should be 65536");
        }
        return outChars;
    }

    private static char[] removeSingleByteEbcdicAndSpaces(byte[] inBytes, boolean mixedCcsid) throws Exception {
        char[] outChars = new char[65536];
        boolean singleByte = false;
        if (mixedCcsid) {
            singleByte = true;
        }
        int toIndex = 0;
        for (int i = 0; i < inBytes.length; ++i) {
            byte b = inBytes[i];
            if (singleByte) {
                if (b == 14) {
                    singleByte = false;
                    continue;
                }
                if (b == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                outChars[toIndex] = 65278;
                ++toIndex;
                if (inBytes[i + 1] != 64) continue;
                ++i;
                continue;
            }
            if (b == 15 && mixedCcsid) {
                singleByte = true;
                if (inBytes[i + 1] != 64) continue;
                ++i;
                continue;
            }
            if (b == 14 && mixedCcsid) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            outChars[toIndex] = (char)(b << 8 | 0xFF & inBytes[i + 1]);
            ++toIndex;
            ++i;
        }
        if (toIndex != 65536) {
            throw new Exception("To index is " + toIndex + " should be 65536");
        }
        return outChars;
    }

    private static char[] jdbcToUnicode(Connection connection, int ccsid) throws SQLException {
        if (ccsid > 1000000) {
            ccsid -= 1000000;
        }
        PreparedStatement ps = connection.prepareStatement("select cast(CAST(CAST(? AS VARCHAR(256) FOR BIT DATA) AS VARCHAR(256) CCSID " + ccsid + ") as VARGRAPHIC(256) CCSID 1200) from sysibm.sysdummy1");
        byte[] all256 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            all256[i] = i == 14 ? 63 : (i == 15 ? 63 : (byte)i);
        }
        ps.setBytes(1, all256);
        ResultSet rs = ps.executeQuery();
        rs.next();
        String answer = rs.getString(1);
        rs.close();
        ps.close();
        char[] charAnswer = answer.toCharArray();
        charAnswer[14] = 14;
        charAnswer[15] = 15;
        return charAnswer;
    }

    private static char[] jdbcToEbcdicDBCS(Connection connection, int ccsid) throws Exception {
        char[] answer;
        char[] allChar65536;
        PreparedStatement ps;
        boolean mixedCcsid = false;
        if (ccsid > 2000000) {
            ccsid -= 2000000;
            mixedCcsid = true;
        }
        try {
            ps = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS DBCLOB(1M) CCSID " + ccsid + ") as BLOB(1M)) from sysibm.sysdummy1");
        }
        catch (SQLException sqlex) {
            String message = sqlex.toString();
            if (message.indexOf("SQL0189") >= 0) {
                ps = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + ccsid + ") as BLOB(1M)) from sysibm.sysdummy1");
            }
            throw sqlex;
        }
        if (ccsid != 1399) {
            int i;
            allChar65536 = new char[65536];
            for (i = 0; i < 55296; ++i) {
                allChar65536[i] = i <= 128 ? 26 : (char)i;
            }
            for (i = 55296; i < 57344; ++i) {
                allChar65536[i] = 65533;
            }
            for (i = 57344; i < 65536; ++i) {
                allChar65536[i] = i >= 65024 && i <= 65295 ? 65533 : (char)i;
            }
            Clob clob = ((AS400JDBCConnection)connection).createClob();
            clob.setString(1L, new String(allChar65536));
            ps.setClob(1, clob);
            ResultSet rs = ps.executeQuery();
            rs.next();
            byte[] byteAnswer = rs.getBytes(1);
            rs.close();
            ps.close();
            if (byteAnswer.length != 131072) {
                answer = GenerateConverterTable.removeSingleByteEbcdic(byteAnswer, mixedCcsid);
            } else {
                answer = new char[byteAnswer.length / 2];
                for (int i2 = 0; i2 < byteAnswer.length; i2 += 2) {
                    answer[i2 / 2] = (char)(byteAnswer[i2] << 8 | 0xFF & byteAnswer[i2 + 1]);
                }
            }
        } else {
            int i;
            allChar65536 = new char[131072];
            for (i = 0; i < 55296; ++i) {
                allChar65536[2 * i] = i <= 128 ? 26 : (char)i;
                allChar65536[2 * i + 1] = 32;
            }
            for (i = 55296; i < 57344; ++i) {
                allChar65536[2 * i] = 65533;
                allChar65536[2 * i + 1] = 32;
            }
            for (i = 57344; i < 65536; ++i) {
                allChar65536[2 * i] = i >= 65024 && i <= 65295 ? 65533 : (char)i;
                allChar65536[2 * i + 1] = 32;
            }
            Clob clob = ((AS400JDBCConnection)connection).createClob();
            clob.setString(1L, new String(allChar65536));
            ps.setClob(1, clob);
            ResultSet rs = ps.executeQuery();
            rs.next();
            byte[] byteAnswer = rs.getBytes(1);
            rs.close();
            ps.close();
            answer = GenerateConverterTable.removeSingleByteEbcdicAndSpaces(byteAnswer, mixedCcsid);
        }
        return answer;
    }

    private static char[] jdbcToUnicodeSpacesDBCS(Connection connection, int ccsid) throws SQLException {
        boolean mixed = false;
        int BLOCKSIZE = 1024;
        String sql = "select cast(INTERPRET(CAST(? AS CHAR(" + BLOCKSIZE * 4 + ") FOR BIT DATA) AS GRAPHIC(" + BLOCKSIZE * 2 + ") CCSID " + ccsid + ") as VARGRAPHIC(8200) CCSID 1200) from sysibm.sysdummy1";
        if (ccsid > 2000000) {
            mixed = true;
            sql = "select cast(CAST(CAST(? AS VARCHAR(16390) FOR BIT DATA) AS VARCHAR(16390) CCSID " + (ccsid -= 2000000) + ") as VARGRAPHIC(8200) CCSID 1200) from sysibm.sysdummy1";
        }
        PreparedStatement ps = connection.prepareStatement(sql);
        int OUTERLOOP = 65536 / BLOCKSIZE;
        byte[] piece8192 = mixed ? new byte[BLOCKSIZE * 4 + 2] : new byte[BLOCKSIZE * 4];
        int offset = 0;
        if (mixed) {
            piece8192[0] = 14;
            piece8192[BLOCKSIZE * 4 + 1] = 15;
            offset = 1;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < OUTERLOOP; ++i) {
            for (int j = 0; j < BLOCKSIZE; ++j) {
                int cp = i * BLOCKSIZE + j;
                if (mixed && (cp < 256 || cp / 256 == 14 || cp / 256 == 15 || cp % 256 == 14 || cp % 256 == 15)) {
                    cp = 65278;
                }
                piece8192[offset + 4 * j] = (byte)(cp / 256);
                piece8192[offset + 4 * j + 1] = (byte)cp;
                piece8192[offset + 4 * j + 2] = 64;
                piece8192[offset + 4 * j + 3] = 64;
            }
            if (offset == 1) {
                piece8192[BLOCKSIZE * 4 + 1] = 15;
            }
            ps.setBytes(1, piece8192);
            ResultSet rs = ps.executeQuery();
            rs.next();
            String answer = rs.getString(1);
            if (answer == null) {
                System.out.println("ERROR: got null processing block " + i + " of size " + BLOCKSIZE);
                System.out.println("INPUT BYTES: = " + GenerateConverterTable.dumpBytes(" ", piece8192));
            } else if (answer.length() != BLOCKSIZE) {
                // empty if block
            }
            sb.append(answer);
            rs.close();
        }
        ps.close();
        return sb.toString().toCharArray();
    }

    private static String dumpUnicodeString(String pad, String data) {
        StringBuffer sb = new StringBuffer();
        char[] charArray = data.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            sb.append(pad);
            int value = 0xFFFF & charArray[i];
            if (value < 16) {
                sb.append("0");
            }
            if (value < 256) {
                sb.append("0");
            }
            if (value < 4096) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(value));
        }
        return sb.toString();
    }

    private static String dumpBytes(String pad, byte[] block) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < block.length; ++i) {
            sb.append(pad);
            int value = 0xFF & block[i];
            if (value < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(value));
        }
        return sb.toString();
    }
}

