/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.FieldDescription;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;

public class PackedDecimalFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private int decimalPositions_;

    public PackedDecimalFieldDescription(AS400PackedDecimal dataType, String name) {
        super(dataType, name);
        this.length_ = dataType.getNumberOfDigits();
        this.decimalPositions_ = dataType.getNumberOfDecimalPositions();
    }

    public PackedDecimalFieldDescription() {
    }

    public PackedDecimalFieldDescription(AS400PackedDecimal dataType, String name, String ddsName) {
        super(dataType, name, ddsName);
        this.length_ = dataType.getNumberOfDigits();
        this.decimalPositions_ = dataType.getNumberOfDecimalPositions();
    }

    @Override
    String[] getDDSDescription() {
        Vector<Object> v = new Vector<Object>();
        StringBuffer desc = new StringBuffer(this.ddsName_);
        while (desc.length() < 10) {
            desc.append(" ");
        }
        if (!this.refFld_.equals("")) {
            desc.append("R");
        } else {
            desc.append(" ");
        }
        String len = String.valueOf(this.length_);
        int numSpaces = 5 - len.length();
        for (int i = 0; i < numSpaces; ++i) {
            desc.append(' ');
        }
        desc.append(len);
        desc.append("P");
        StringBuffer decPos = new StringBuffer(Integer.toString(this.decimalPositions_));
        if (decPos.length() == 1) {
            decPos.insert(0, " ");
        }
        desc.append(decPos.toString());
        desc.append("       ");
        v.addElement(desc.toString());
        String[] keywords = super.getFieldFunctions();
        if (keywords != null) {
            for (int i = 0; i < keywords.length; ++i) {
                v.addElement(keywords[i]);
            }
        }
        if (this.defaultValue_ != null) {
            v.addElement("DFT(" + this.defaultValue_.toString() + ") ");
        } else if (this.isDFTNull_) {
            v.addElement("DFT(*NULL) ");
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public int getDecimalPositions() {
        return this.decimalPositions_;
    }

    public void setDataType(AS400PackedDecimal dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = dataType;
        this.length_ = dataType.getNumberOfDigits();
        this.decimalPositions_ = dataType.getNumberOfDecimalPositions();
    }

    public void setDFT(BigDecimal defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = defaultValue;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }
}

