/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

class PermissionAccessRoot
extends PermissionAccess {
    public PermissionAccessRoot(AS400 system) {
        super(system);
    }

    @Override
    public void addUser(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall addUser = PermissionAccessRoot.getChgCommand(this.as400_, objName, permission, this.followSymbolicLinks_);
        if (!addUser.run()) {
            AS400Message[] msgList = addUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    protected final String expandQuotes(String objName) {
        return PermissionAccessRoot.expandQuotes0(objName);
    }

    static String expandQuotes0(String objName) {
        StringBuffer buf = new StringBuffer(objName);
        if (objName.indexOf(39) != -1 || objName.indexOf(34) != -1) {
            for (int i = objName.length() - 1; i >= 0; --i) {
                if (buf.charAt(i) == '\'') {
                    buf.insert(i, '\'');
                    continue;
                }
                if (buf.charAt(i) != '\"') continue;
                buf.insert(i, '\"');
            }
            buf.insert(0, '\"');
            buf.append('\"');
        }
        buf.insert(0, '\'');
        buf.append('\'');
        return buf.toString();
    }

    private static CommandCall getChgCommand(AS400 sys, String objName, UserPermission permission, boolean followSymbolicLinks) {
        RootPermission rootPermission = (RootPermission)permission;
        String userProfile = rootPermission.getUserID();
        String dataAuthority = rootPermission.getDataAuthority();
        boolean objMgt = rootPermission.isManagement();
        boolean objExist = rootPermission.isExistence();
        boolean objAlter = rootPermission.isAlter();
        boolean objRef = rootPermission.isReference();
        Object objAuthority = "";
        if (objMgt) {
            objAuthority = (String)objAuthority + "*OBJMGT ";
        }
        if (objExist) {
            objAuthority = (String)objAuthority + "*OBJEXIST ";
        }
        if (objAlter) {
            objAuthority = (String)objAuthority + "*OBJALTER ";
        }
        if (objRef) {
            objAuthority = (String)objAuthority + "*OBJREF";
        }
        if (!(objMgt || objExist || objAlter || objRef)) {
            objAuthority = "*NONE";
            if (dataAuthority.equals("*NONE")) {
                dataAuthority = "*EXCLUDE";
            }
        }
        String command = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(objName) + ") USER(" + userProfile + ") DTAAUT(" + dataAuthority + ") OBJAUT(" + (String)objAuthority + ")";
        if (!followSymbolicLinks) {
            command = command + " SYMLNK(*YES)";
        }
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    private static CommandCall getRmvCommand(AS400 sys, String objName, String userName, boolean followSymbolicLinks) {
        String dataAuthority = "*NONE";
        String objAuthority = "*NONE";
        String command = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(objName) + ") USER(" + userName + ") DTAAUT(" + dataAuthority + ") OBJAUT(" + objAuthority + ")";
        if (!followSymbolicLinks) {
            command = command + " SYMLNK(*YES)";
        }
        CommandCall cmd = new CommandCall(sys, command);
        return cmd;
    }

    @Override
    public UserPermission getUserPermission(Record userRecord) throws UnsupportedEncodingException {
        String profileName = ((String)userRecord.getField("profileName")).trim();
        String userOrGroup = ((String)userRecord.getField("userOrGroup")).trim();
        String dataAuthority = ((String)userRecord.getField("dataAuthority")).trim();
        String autListMgt = ((String)userRecord.getField("autListMgt")).trim();
        String objMgt = ((String)userRecord.getField("objMgt")).trim();
        String objExistence = ((String)userRecord.getField("objExistence")).trim();
        String objAlter = ((String)userRecord.getField("objAlter")).trim();
        String objRef = ((String)userRecord.getField("objRef")).trim();
        RootPermission permission = new RootPermission(profileName);
        permission.setGroupIndicator(this.getIntValue(userOrGroup));
        permission.setAuthorizationListManagement(this.getBooleanValue(autListMgt));
        permission.setManagement(this.getBooleanValue(objMgt));
        permission.setExistence(this.getBooleanValue(objExistence));
        permission.setAlter(this.getBooleanValue(objAlter));
        permission.setReference(this.getBooleanValue(objRef));
        if (dataAuthority.equalsIgnoreCase("*AUTL")) {
            permission.setDataAuthority("*EXCLUDE");
            permission.setFromAuthorizationList(true);
        } else {
            permission.setDataAuthority(dataAuthority);
        }
        return permission;
    }

    @Override
    public void removeUser(String objName, String userName) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall removeUser = PermissionAccessRoot.getRmvCommand(this.as400_, objName, userName, this.followSymbolicLinks_);
        if (!removeUser.run()) {
            AS400Message[] msgList = removeUser.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthority(String objName, UserPermission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall setAuthority = PermissionAccessRoot.getChgCommand(this.as400_, objName, permission, this.followSymbolicLinks_);
        if (!setAuthority.run()) {
            AS400Message[] msgList = setAuthority.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setAuthorizationList(String objName, String autList, String oldValue) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall setAUTL = new CommandCall(this.as400_);
        String cmd = "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(objName) + ") AUTL(" + autList + ")";
        if (!this.followSymbolicLinks_) {
            cmd = cmd + " SYMLNK(*YES)";
        }
        setAUTL.setCommand(cmd);
        if (!setAUTL.run()) {
            AS400Message[] msgList = setAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setFromAuthorizationList(String objName, boolean fromAutl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        CommandCall fromAUTL = new CommandCall(this.as400_);
        String cmd = fromAutl ? "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(objName) + ") USER(*PUBLIC) DTAAUT(*AUTL) OBJAUT(*NONE)" : "CHGAUT OBJ(" + PermissionAccessRoot.expandQuotes0(objName) + ") USER(*PUBLIC) DTAAUT(*EXCLUDE) OBJAUT(*NONE)";
        if (!this.followSymbolicLinks_) {
            cmd = cmd + " SYMLNK(*YES)";
        }
        fromAUTL.setCommand(cmd);
        if (!fromAUTL.run()) {
            AS400Message[] msgList = fromAUTL.getMessageList();
            throw new AS400Exception(msgList);
        }
    }

    @Override
    public synchronized void setSensitivity(String objName, int sensitivityLevel) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
    }
}

