/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class ResourceBundleLoader {
    private static final boolean DEBUG = false;
    private static MissingResourceException resourceException_;
    private static ResourceBundle coreResources_;
    private static ResourceBundle resources_;
    private static ResourceBundle resources2_;
    private static ResourceBundle systemValueResource_;
    private static String genericDescription_;

    private ResourceBundleLoader() {
    }

    static final String getCoreText(String textId) {
        if (coreResources_ == null) {
            throw resourceException_;
        }
        return coreResources_.getString(textId);
    }

    static final Icon getIcon(String fileName) {
        return ResourceBundleLoader.getIcon(fileName, null);
    }

    static final Icon getIcon(String fileName, String description) {
        ImageIcon icon = null;
        try {
            URL url;
            if (description == null) {
                if (genericDescription_ == null) {
                    genericDescription_ = ResourceBundleLoader.getText("PRODUCT_TITLE");
                }
                description = genericDescription_;
            }
            if ((url = ResourceBundleLoader.class.getResource((String)fileName)) == null) {
                fileName = "com" + File.separator + "ibm" + File.separator + "as400" + File.separator + "access" + File.separator + (String)fileName;
                icon = new ImageIcon((String)fileName, description);
            } else {
                icon = new ImageIcon(url, description);
            }
        }
        catch (Exception e) {
            Trace.log(2, "Icon " + (String)fileName + " not loaded: " + e.getMessage() + ".");
        }
        return icon;
    }

    static final String getSystemValueText(String textId) {
        if (systemValueResource_ == null) {
            throw resourceException_;
        }
        return systemValueResource_.getString(textId).trim();
    }

    static final String getSystemValueText(String textId, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.as400.access.SVMRI", locale);
        if (bundle != null) {
            return bundle.getString(textId);
        }
        if (systemValueResource_ == null) {
            throw resourceException_;
        }
        return systemValueResource_.getString(textId).trim();
    }

    static final String getText(String textId) {
        if (resources_ == null) {
            throw resourceException_;
        }
        try {
            return resources_.getString(textId);
        }
        catch (MissingResourceException e) {
            try {
                return ResourceBundleLoader.getCoreText(textId);
            }
            catch (MissingResourceException e2) {
                if (resources2_ == null) {
                    throw e;
                }
                return resources2_.getString(textId);
            }
        }
    }

    static String getText(String textId, Object value) {
        String text = ResourceBundleLoader.getText(textId);
        return ResourceBundleLoader.substitute(text, value);
    }

    static String getText(String textId, Object value0, Object value1) {
        String text = ResourceBundleLoader.getText(textId);
        return ResourceBundleLoader.substitute(text, new Object[]{value0, value1});
    }

    static String getText(String textId, Object[] values) {
        String text = ResourceBundleLoader.getText(textId);
        return ResourceBundleLoader.substitute(text, values);
    }

    static String substitute(String text, Object value) {
        return ResourceBundleLoader.substitute(text, new Object[]{value});
    }

    static String substitute(String text, Object value0, Object value1) {
        return ResourceBundleLoader.substitute(text, new Object[]{value0, value1});
    }

    static String substitute(String text, Object[] values) {
        String result = text;
        for (int i = 0; i < values.length; ++i) {
            String variable = "&" + i;
            int j = result.indexOf(variable);
            if (j < 0) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(result.substring(0, j));
            buffer.append(values[i].toString());
            buffer.append(result.substring(j + variable.length()));
            result = buffer.toString();
        }
        return result;
    }

    static {
        block6: {
            genericDescription_ = null;
            try {
                coreResources_ = ResourceBundle.getBundle("com.ibm.as400.access.CoreMRI");
            }
            catch (MissingResourceException e) {
                resourceException_ = e;
            }
            try {
                resources_ = ResourceBundle.getBundle("com.ibm.as400.access.MRI");
                systemValueResource_ = ResourceBundle.getBundle("com.ibm.as400.access.SVMRI");
            }
            catch (MissingResourceException e) {
                resourceException_ = e;
            }
            try {
                resources2_ = ResourceBundle.getBundle("com.ibm.as400.access.MRI2");
            }
            catch (MissingResourceException e) {
                if (!Trace.isTraceOn()) break block6;
                Trace.log(3, "MRI2 not found.  This is expected behavior when using the proxy jar file.");
            }
        }
    }
}

