/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.SystemValueUtility;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SystemValueGroup
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private String groupName_;
    private String groupDescription_;
    private Vector infos_;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;

    public SystemValueGroup() {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object.");
        }
        this.infos_ = new Vector();
    }

    public SystemValueGroup(AS400 system, String groupName, String groupDescription) {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object, system: " + system + ", group name: " + groupName);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (groupName == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (groupDescription == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        this.system_ = system;
        this.groupName_ = groupName;
        this.groupDescription_ = groupDescription;
        this.infos_ = new Vector();
    }

    public SystemValueGroup(AS400 system, String groupName, String groupDescription, String[] names) {
        this.system_ = null;
        this.groupName_ = null;
        this.groupDescription_ = null;
        this.infos_ = null;
        this.propertyChangeListeners_ = null;
        this.vetoableChangeListeners_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValueGroup object, system: " + system + ", group name: " + groupName);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (groupName == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (groupDescription == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        if (names == null) {
            Trace.log(2, "Parameter 'names' is null.");
            throw new NullPointerException("names");
        }
        this.system_ = system;
        this.groupName_ = groupName;
        this.groupDescription_ = groupDescription;
        this.infos_ = new Vector(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.add(names[i]);
        }
    }

    public SystemValueGroup(AS400 system, String groupName, String groupDescription, int group) {
        int vrm;
        block13: {
            this.system_ = null;
            this.groupName_ = null;
            this.groupDescription_ = null;
            this.infos_ = null;
            this.propertyChangeListeners_ = null;
            this.vetoableChangeListeners_ = null;
            if (Trace.traceOn_) {
                Trace.log(1, "Constructing SystemValueGroup object, system: " + system + ", group name: " + groupName + ", group:", group);
            }
            if (system == null) {
                Trace.log(2, "Parameter 'system' is null.");
                throw new NullPointerException("system");
            }
            if (groupName == null) {
                Trace.log(2, "Parameter 'groupName' is null.");
                throw new NullPointerException("groupName");
            }
            if (groupDescription == null) {
                Trace.log(2, "Parameter 'groupDescription' is null.");
                throw new NullPointerException("groupDescription");
            }
            if (group < 0 || group > 9) {
                Trace.log(2, "Value of parameter 'group' is not valid:", group);
                throw new ExtendedIllegalArgumentException("group", 2);
            }
            this.system_ = system;
            this.groupName_ = groupName;
            this.groupDescription_ = groupDescription;
            vrm = Integer.MAX_VALUE;
            try {
                vrm = system.getVRM();
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block13;
                Trace.log(4, "Couldn't retrieve VRM for system value group:", (Throwable)e);
            }
        }
        Vector groupInfos = SystemValueList.groups[group];
        int length = groupInfos.size();
        this.infos_ = new Vector(length);
        for (int i = 0; i < length; ++i) {
            SystemValueInfo info = (SystemValueInfo)groupInfos.elementAt(i);
            if (info.release_ > vrm) continue;
            this.infos_.addElement(info);
        }
        if (vrm <= 327936) {
            switch (group) {
                case 5: {
                    this.infos_.removeElement(SystemValueList.lookup("QFRCCVNRST"));
                    break;
                }
                case 7: {
                    this.infos_.addElement(SystemValueList.lookup("QFRCCVNRST"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding to system value group, name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo info = SystemValueList.lookup(name.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            if (!this.infos_.contains(info)) {
                this.infos_.addElement(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueGroup systemValueGroup = this;
        synchronized (systemValueGroup) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValueGroup systemValueGroup = this;
        synchronized (systemValueGroup) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if system value group contains, name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo info = SystemValueList.lookup(name.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            return this.infos_.contains(info);
        }
    }

    public String getGroupDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group description: " + this.groupDescription_);
        }
        return this.groupDescription_;
    }

    public String getGroupName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group name: " + this.groupName_);
        }
        return this.groupName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group names.");
        }
        Vector vector = this.infos_;
        synchronized (vector) {
            int length = this.infos_.size();
            String[] names = new String[length];
            for (int i = 0; i < length; ++i) {
                names[i] = ((SystemValueInfo)this.infos_.elementAt((int)i)).name_;
            }
            return names;
        }
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSystemValues() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system values, system: " + this.system_ + " group name: " + this.groupName_);
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to system before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        Vector systemValues = null;
        Vector vector = this.infos_;
        synchronized (vector) {
            systemValues = SystemValueUtility.retrieve(this.system_, this.infos_.elements(), this.groupName_, this.groupDescription_);
        }
        return SystemValueList.sort(systemValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(Vector systemValues) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing system values.");
        }
        if (systemValues == null) {
            Trace.log(2, "Parameter 'systemValues' is null.");
            throw new NullPointerException("systemValues");
        }
        Hashtable<AS400, Vector<SystemValue>> systemHash = null;
        Vector vector = systemValues;
        synchronized (vector) {
            int length = systemValues.size();
            if (Trace.traceOn_) {
                Trace.log(1, "Number of system values:", length);
            }
            if (length == 0) {
                return;
            }
            systemHash = new Hashtable<AS400, Vector<SystemValue>>(length);
            for (int i = 0; i < length; ++i) {
                try {
                    SystemValue systemValue = (SystemValue)systemValues.elementAt(i);
                    AS400 system = systemValue.getSystem();
                    Vector<SystemValue> sameSystemVals = (Vector<SystemValue>)systemHash.get(system);
                    if (sameSystemVals == null) {
                        sameSystemVals = new Vector<SystemValue>();
                        systemHash.put(system, sameSystemVals);
                    }
                    sameSystemVals.addElement(systemValue);
                    continue;
                }
                catch (ClassCastException e) {
                    Trace.log(2, "Type of element 'systemValues[" + i + "]' is not valid:", (Throwable)e);
                    throw new ExtendedIllegalArgumentException("systemValues[" + i + "]", 2);
                }
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Number of systems:", systemHash.size());
        }
        Enumeration list = systemHash.keys();
        while (list.hasMoreElements()) {
            SystemValue systemValue;
            int c;
            AS400 system = (AS400)list.nextElement();
            Vector systemSystemValues = (Vector)systemHash.get(system);
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing, system: " + system + ", number of values:", systemSystemValues.size());
            }
            Vector<SystemValueInfo> svInfos = new Vector<SystemValueInfo>();
            Vector<SystemValueInfo> naInfos = new Vector<SystemValueInfo>();
            Vector<SystemValue> svSystemValues = new Vector<SystemValue>();
            Vector<SystemValue> naSystemValues = new Vector<SystemValue>();
            for (int i = 0; i < systemSystemValues.size(); ++i) {
                SystemValue systemValue2 = (SystemValue)systemSystemValues.elementAt(i);
                SystemValueInfo info = systemValue2.info_;
                if (systemValue2.getGroup() == 8) {
                    naInfos.addElement(info);
                    naSystemValues.addElement(systemValue2);
                    continue;
                }
                svInfos.addElement(info);
                svSystemValues.addElement(systemValue2);
            }
            Vector svValues = new Vector();
            Vector naValues = new Vector();
            if (svInfos.size() > 0) {
                svValues = SystemValueUtility.retrieveFromSystem(system, svInfos, false);
            }
            if (naInfos.size() > 0) {
                naValues = SystemValueUtility.retrieveFromSystem(system, naInfos, true);
            }
            for (c = 0; c < svInfos.size(); ++c) {
                systemValue = (SystemValue)svSystemValues.elementAt(c);
                systemValue.value_ = svValues.elementAt(c);
            }
            for (c = 0; c < naInfos.size(); ++c) {
                systemValue = (SystemValue)naSystemValues.elementAt(c);
                systemValue.value_ = naValues.elementAt(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing from system value group, name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        SystemValueInfo info = SystemValueList.lookup(name.toUpperCase());
        Vector vector = this.infos_;
        synchronized (vector) {
            return this.infos_.removeElement(info);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setGroupDescription(String groupDescription) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value group description: " + groupDescription);
        }
        if (groupDescription == null) {
            Trace.log(2, "Parameter 'groupDescription' is null.");
            throw new NullPointerException("groupDescription");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.groupDescription_ = groupDescription;
        } else {
            String oldValue = this.groupDescription_;
            String newValue = groupDescription;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("groupDescription", oldValue, newValue);
            }
            this.groupDescription_ = groupDescription;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("groupDescription", oldValue, newValue);
            }
        }
    }

    public void setGroupName(String groupName) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value group name: " + groupName);
        }
        if (groupName == null) {
            Trace.log(2, "Parameter 'groupName' is null.");
            throw new NullPointerException("groupName");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.groupName_ = groupName;
        } else {
            String oldValue = this.groupName_;
            String newValue = groupName;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("groupName", oldValue, newValue);
            }
            this.groupName_ = groupName;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("groupName", oldValue, newValue);
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = newValue;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public String toString() {
        Object ret = "";
        if (this.groupName_ != null) {
            ret = (String)ret + this.groupName_ + " ";
        }
        ret = (String)ret + "{" + this.infos_.size() + "} ";
        if (this.groupDescription_ != null) {
            ret = (String)ret + this.groupDescription_ + " ";
        }
        if (this.system_ != null) {
            ret = (String)ret + this.system_ + " ";
        }
        ret = (String)ret + "[" + super.toString() + "]";
        return ret;
    }
}

