/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.OpenList;
import com.ibm.as400.access.list.SpooledFileListItem;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class SpooledFileOpenList
extends OpenList {
    static final long serialVersionUID = 17674018445884278L;
    private static final byte[] ALL = new byte[]{92, -63, -45, -45, 64, 64, 64, 64, 64, 64};
    public static final String FORMAT_0100 = "OSPL0100";
    public static final String FORMAT_0200 = "OSPL0200";
    public static final String FORMAT_0300 = "OSPL0300";
    public static final String FORMAT_0400 = "OSPL0400";
    public static final int JOB_NAME = 0;
    public static final int JOB_USER = 1;
    public static final int JOB_NUMBER = 2;
    public static final int NAME = 3;
    public static final int NUMBER = 4;
    public static final int STATUS = 5;
    public static final int DATE_OPENED = 6;
    public static final int TIME_OPENED = 7;
    public static final int SCHEDULE = 8;
    public static final int JOB_SYSTEM = 9;
    public static final int USER_DATA = 10;
    public static final int FORM_TYPE = 11;
    public static final int OUTPUT_QUEUE_NAME = 12;
    public static final int OUTPUT_QUEUE_LIBRARY = 13;
    public static final int ASP = 14;
    public static final int SIZE = 15;
    private static final int SIZE_MULTIPLIER = 16;
    public static final int TOTAL_PAGES = 17;
    public static final int COPIES_LEFT_TO_PRINT = 18;
    public static final int PRIORITY = 19;
    public static final int PRINTER_NAME = 20;
    public static final int PRINTER_ASSIGNED = 21;
    public static final int CURRENT_PAGE = 22;
    public static final int DEVICE_TYPE = 23;
    private int format_ = 3;
    private String filterJobName_ = "";
    private String filterJobUser_ = "";
    private String filterJobNumber_ = "";
    private String[] filterUsers_;
    private QSYSObjectPathName[] filterOutputQueues_;
    private String filterFormType_;
    private String filterUserData_;
    private String[] filterStatuses_;
    private String[] filterDevices_;
    private String filterJobSystemName_;
    private Date filterCreationDateStart_;
    private Date filterCreationDateEnd_;
    private Vector sortKeys_ = new Vector();

    public SpooledFileOpenList(AS400 system) {
        super(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing SpooledFileOpenList object.");
        }
    }

    public SpooledFileOpenList(AS400 system, String format) {
        this(system);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing SpooledFileOpenList object.");
        }
        this.setFormat(format);
    }

    public void addSortField(int field, boolean ascending) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Adding sort field, field: " + field + ", ascending: " + ascending);
        }
        if (field == 15) {
            this.addSortField(16, ascending);
        }
        this.sortKeys_.addElement(new int[]{field, ascending ? 241 : 242});
    }

    @Override
    protected byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pc;
        int ii;
        int ii2;
        int i;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening spooled file list.");
        }
        int vrm = this.system_.getVRM();
        CharConverter conv = new CharConverter(this.system_.getCcsid(), this.system_);
        int sortKeysSize = this.sortKeys_.size();
        byte[] sortInformation = new byte[4 + 12 * sortKeysSize];
        BinaryConverter.intToByteArray(sortKeysSize, sortInformation, 0);
        int validSortKeysSize = 0;
        for (int i2 = 0; i2 < sortKeysSize; ++i2) {
            int[] pair = (int[])this.sortKeys_.elementAt(i2);
            int field = pair[0];
            int fieldLength = this.findFieldLength(field, vrm);
            if (fieldLength > 0) {
                BinaryConverter.intToByteArray(this.findStartingPosition(field), sortInformation, 4 + validSortKeysSize * 12);
                BinaryConverter.intToByteArray(fieldLength, sortInformation, 8 + validSortKeysSize * 12);
                BinaryConverter.shortToByteArray(this.findDataType(field), sortInformation, 12 + validSortKeysSize * 12);
                sortInformation[14 + validSortKeysSize * 12] = (byte)pair[1];
                ++validSortKeysSize;
                continue;
            }
            Trace.log(4, "Sort key not valid, position: " + i2 + ", field: " + field);
        }
        if (validSortKeysSize != sortKeysSize) {
            byte[] oldValue = sortInformation;
            sortInformation = new byte[4 + 12 * validSortKeysSize];
            BinaryConverter.intToByteArray(validSortKeysSize, sortInformation, 0);
            System.arraycopy(oldValue, 4, sortInformation, 4, 12 * validSortKeysSize);
        }
        int filterInformationLength = 0;
        boolean useOSPF0200 = false;
        if (vrm < 328192 || this.filterJobSystemName_ == null && this.filterCreationDateStart_ == null && this.filterCreationDateEnd_ == null) {
            filterInformationLength = 92;
            if (this.filterUsers_ != null && this.filterUsers_.length > 1) {
                filterInformationLength += 12 * (this.filterUsers_.length - 1);
            }
            if (this.filterOutputQueues_ != null && this.filterOutputQueues_.length > 1) {
                filterInformationLength += 20 * (this.filterOutputQueues_.length - 1);
            }
            if (this.filterStatuses_ != null && this.filterStatuses_.length > 1) {
                filterInformationLength += 12 * (this.filterStatuses_.length - 1);
            }
            if (this.filterDevices_ != null && this.filterDevices_.length > 1) {
                filterInformationLength += 12 * (this.filterDevices_.length - 1);
            }
        } else {
            useOSPF0200 = true;
            filterInformationLength = 110;
            if (this.filterUsers_ != null) {
                filterInformationLength += 10 * this.filterUsers_.length;
            }
            if (this.filterOutputQueues_ != null) {
                filterInformationLength += 20 * this.filterOutputQueues_.length;
            }
            if (this.filterStatuses_ != null) {
                filterInformationLength += 10 * this.filterStatuses_.length;
            }
            if (this.filterDevices_ != null) {
                filterInformationLength += 10 * this.filterDevices_.length;
            }
        }
        byte[] filterInformation = new byte[filterInformationLength];
        int offset = 0;
        if (!useOSPF0200) {
            if (this.filterUsers_ == null || this.filterUsers_.length == 0) {
                BinaryConverter.intToByteArray(1, filterInformation, offset);
                System.arraycopy(ALL, 0, filterInformation, offset += 4, 10);
                offset += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterUsers_.length, filterInformation, offset);
                offset += 4;
                for (i = 0; i < this.filterUsers_.length; ++i) {
                    for (ii2 = 0; ii2 < 10; ++ii2) {
                        filterInformation[ii2 + offset] = 64;
                    }
                    conv.stringToByteArray(this.filterUsers_[i], filterInformation, offset, 10);
                    offset += 12;
                }
            }
            if (this.filterOutputQueues_ == null || this.filterOutputQueues_.length == 0) {
                BinaryConverter.intToByteArray(1, filterInformation, offset);
                System.arraycopy(ALL, 0, filterInformation, offset += 4, 10);
                offset += 10;
                for (ii = 0; ii < 10; ++ii) {
                    filterInformation[ii + offset] = 64;
                }
                offset += 10;
            } else {
                BinaryConverter.intToByteArray(this.filterOutputQueues_.length, filterInformation, offset);
                offset += 4;
                for (i = 0; i < this.filterOutputQueues_.length; ++i) {
                    for (ii2 = 0; ii2 < 20; ++ii2) {
                        filterInformation[ii2 + offset] = 64;
                    }
                    conv.stringToByteArray(this.filterOutputQueues_[i].getObjectName(), filterInformation, offset, 10);
                    conv.stringToByteArray(this.filterOutputQueues_[i].getLibraryName(), filterInformation, offset += 10, 10);
                    offset += 10;
                }
            }
            if (this.filterFormType_ == null) {
                System.arraycopy(ALL, 0, filterInformation, offset, 10);
            } else {
                for (ii = 0; ii < 10; ++ii) {
                    filterInformation[ii + offset] = 64;
                }
                conv.stringToByteArray(this.filterFormType_, filterInformation, offset, 10);
            }
            offset += 10;
            if (this.filterUserData_ == null) {
                System.arraycopy(ALL, 0, filterInformation, offset, 10);
            } else {
                for (ii = 0; ii < 10; ++ii) {
                    filterInformation[ii + offset] = 64;
                }
                conv.stringToByteArray(this.filterUserData_, filterInformation, offset, 10);
            }
            offset += 10;
            if (this.filterStatuses_ == null || this.filterStatuses_.length == 0) {
                BinaryConverter.intToByteArray(1, filterInformation, offset);
                System.arraycopy(ALL, 0, filterInformation, offset += 4, 10);
                offset += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterStatuses_.length, filterInformation, offset);
                offset += 4;
                for (i = 0; i < this.filterStatuses_.length; ++i) {
                    for (ii2 = 0; ii2 < 10; ++ii2) {
                        filterInformation[ii2 + offset] = 64;
                    }
                    conv.stringToByteArray(this.filterStatuses_[i], filterInformation, offset, 10);
                    offset += 12;
                }
            }
            if (this.filterDevices_ == null || this.filterDevices_.length == 0) {
                BinaryConverter.intToByteArray(1, filterInformation, offset);
                System.arraycopy(ALL, 0, filterInformation, offset += 4, 10);
                offset += 12;
            } else {
                BinaryConverter.intToByteArray(this.filterDevices_.length, filterInformation, offset);
                offset += 4;
                for (i = 0; i < this.filterDevices_.length; ++i) {
                    for (ii2 = 0; ii2 < 10; ++ii2) {
                        filterInformation[ii2 + offset] = 64;
                    }
                    conv.stringToByteArray(this.filterDevices_[i], filterInformation, offset, 10);
                    offset += 12;
                }
            }
        } else {
            for (ii = 52; ii < 106; ++ii) {
                filterInformation[ii] = 64;
            }
            for (ii = 110; ii < filterInformation.length; ++ii) {
                filterInformation[ii] = 64;
            }
            offset = 110;
            BinaryConverter.intToByteArray(106, filterInformation, 0);
            if (this.filterUsers_ != null && this.filterUsers_.length > 0) {
                BinaryConverter.intToByteArray(offset, filterInformation, 4);
                BinaryConverter.intToByteArray(this.filterUsers_.length, filterInformation, 8);
                for (i = 0; i < this.filterUsers_.length; ++i) {
                    conv.stringToByteArray(this.filterUsers_[i], filterInformation, offset, 10);
                    offset += 10;
                }
            }
            BinaryConverter.intToByteArray(10, filterInformation, 12);
            if (this.filterOutputQueues_ != null && this.filterOutputQueues_.length > 0) {
                BinaryConverter.intToByteArray(offset, filterInformation, 16);
                BinaryConverter.intToByteArray(this.filterOutputQueues_.length, filterInformation, 20);
                for (i = 0; i < this.filterOutputQueues_.length; ++i) {
                    conv.stringToByteArray(this.filterOutputQueues_[i].getObjectName(), filterInformation, offset, 10);
                    conv.stringToByteArray(this.filterOutputQueues_[i].getLibraryName(), filterInformation, offset += 10, 10);
                    offset += 10;
                }
            }
            BinaryConverter.intToByteArray(20, filterInformation, 24);
            if (this.filterStatuses_ != null && this.filterStatuses_.length > 0) {
                BinaryConverter.intToByteArray(offset, filterInformation, 28);
                BinaryConverter.intToByteArray(this.filterStatuses_.length, filterInformation, 32);
                for (i = 0; i < this.filterStatuses_.length; ++i) {
                    conv.stringToByteArray(this.filterStatuses_[i], filterInformation, offset, 10);
                    offset += 10;
                }
            }
            BinaryConverter.intToByteArray(10, filterInformation, 36);
            if (this.filterDevices_ != null && this.filterDevices_.length > 0) {
                BinaryConverter.intToByteArray(offset, filterInformation, 40);
                BinaryConverter.intToByteArray(this.filterDevices_.length, filterInformation, 44);
                for (i = 0; i < this.filterDevices_.length; ++i) {
                    conv.stringToByteArray(this.filterDevices_[i], filterInformation, offset, 10);
                    offset += 10;
                }
            }
            BinaryConverter.intToByteArray(10, filterInformation, 48);
            if (this.filterFormType_ == null) {
                System.arraycopy(ALL, 0, filterInformation, 52, 4);
            } else {
                conv.stringToByteArray(this.filterFormType_, filterInformation, 52, 10);
            }
            if (this.filterUserData_ == null) {
                System.arraycopy(ALL, 0, filterInformation, 62, 4);
            } else {
                conv.stringToByteArray(this.filterUserData_, filterInformation, 62, 10);
            }
            if (this.filterJobSystemName_ == null) {
                System.arraycopy(ALL, 0, filterInformation, 72, 4);
            } else {
                conv.stringToByteArray(this.filterJobSystemName_, filterInformation, 72, 8);
            }
            if (this.filterCreationDateStart_ == null && this.filterCreationDateEnd_ == null) {
                System.arraycopy(ALL, 0, filterInformation, 80, 4);
            } else if (this.filterCreationDateStart_ == null) {
                filterInformation[80] = 92;
                filterInformation[81] = -58;
                filterInformation[82] = -55;
                filterInformation[83] = -39;
                filterInformation[84] = -30;
                filterInformation[85] = -29;
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateEnd_, filterInformation, 93);
            } else if (this.filterCreationDateEnd_ == null) {
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateStart_, filterInformation, 80);
                filterInformation[93] = 92;
                filterInformation[94] = -45;
                filterInformation[95] = -63;
                filterInformation[96] = -30;
                filterInformation[97] = -29;
            } else {
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateStart_, filterInformation, 80);
                SpooledFileOpenList.formatOS400DateString(this.filterCreationDateEnd_, filterInformation, 93);
            }
        }
        byte[] qualifiedJobName = new byte[26];
        for (ii2 = 0; ii2 < 26; ++ii2) {
            qualifiedJobName[ii2] = 64;
        }
        conv.stringToByteArray(this.filterJobName_, qualifiedJobName, 0, 10);
        conv.stringToByteArray(this.filterJobUser_, qualifiedJobName, 10, 10);
        conv.stringToByteArray(this.filterJobNumber_, qualifiedJobName, 20, 6);
        byte[] formatBytes = new byte[]{-42, -30, -41, -45, -16, (byte)(0xF0 | this.format_), -16, -16};
        ProgramParameter[] parameters = new ProgramParameter[useOSPF0200 ? 10 : 9];
        parameters[0] = new ProgramParameter(0);
        parameters[1] = new ProgramParameter(new byte[]{0, 0, 0, 0});
        parameters[2] = new ProgramParameter(80);
        parameters[3] = new ProgramParameter(new byte[]{-1, -1, -1, -1});
        parameters[4] = new ProgramParameter(sortInformation);
        parameters[5] = new ProgramParameter(filterInformation);
        parameters[6] = new ProgramParameter(qualifiedJobName);
        parameters[7] = new ProgramParameter(formatBytes);
        parameters[8] = EMPTY_ERROR_CODE_PARM;
        if (useOSPF0200) {
            parameters[9] = new ProgramParameter(new byte[]{-42, -30, -41, -58, -16, -14, -16, -16});
        }
        if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLSPL.PGM", parameters)).run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        return parameters[2].getOutputData();
    }

    public void clearSortFields() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Clearing sort fields.");
        }
        this.sortKeys_.removeAllElements();
    }

    private final short findDataType(int field) {
        switch (field) {
            case 0: {
                return 4;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return (short)(this.format_ == 3 || this.format_ == 4 ? 0 : 4);
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 0;
            }
            case 16: {
                return 0;
            }
            case 17: {
                return 0;
            }
            case 18: {
                return 0;
            }
            case 19: {
                return 4;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 0;
            }
            case 23: {
                return 4;
            }
        }
        return 0;
    }

    private final int findFieldLength(int field, int vrm) {
        switch (field) {
            case 0: {
                return 10;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return this.format_ == 3 || this.format_ == 4 ? 4 : 10;
            }
            case 6: {
                return this.format_ != 1 || vrm >= 328192 ? 7 : 0;
            }
            case 7: {
                return this.format_ != 1 || vrm >= 328192 ? 6 : 0;
            }
            case 8: {
                return this.format_ == 3 || this.format_ == 4 ? 1 : 0;
            }
            case 9: {
                return this.format_ == 3 || this.format_ == 4 ? 10 : (vrm >= 328192 ? 8 : 0);
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return this.format_ == 3 || this.format_ == 4 ? 4 : 0;
            }
            case 15: {
                return this.format_ == 3 || this.format_ == 4 ? 4 : 0;
            }
            case 16: {
                return this.format_ == 3 || this.format_ == 4 ? 4 : 0;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return this.format_ == 3 || this.format_ == 4 ? 1 : 2;
            }
            case 20: {
                return this.format_ == 2 ? 10 : 0;
            }
            case 21: {
                return this.format_ == 2 ? 1 : 0;
            }
            case 22: {
                return this.format_ == 3 || this.format_ == 4 ? 0 : 4;
            }
            case 23: {
                return this.format_ == 3 || this.format_ == 4 ? 0 : 10;
            }
        }
        return 0;
    }

    private final int findStartingPosition(int field) {
        switch (field) {
            case 0: {
                return this.format_ == 3 || this.format_ == 4 ? 1 : 11;
            }
            case 1: {
                return this.format_ == 3 || this.format_ == 4 ? 11 : 21;
            }
            case 2: {
                return this.format_ == 3 || this.format_ == 4 ? 21 : 31;
            }
            case 3: {
                return this.format_ == 3 || this.format_ == 4 ? 27 : 1;
            }
            case 4: {
                return 37;
            }
            case 5: {
                return this.format_ == 3 || this.format_ == 4 ? 41 : 83;
            }
            case 6: {
                return this.format_ == 3 || this.format_ == 4 ? 45 : (this.format_ == 2 ? 161 : 169);
            }
            case 7: {
                return this.format_ == 3 || this.format_ == 4 ? 52 : (this.format_ == 2 ? 168 : 176);
            }
            case 8: {
                return 58;
            }
            case 9: {
                return this.format_ == 3 || this.format_ == 4 ? 59 : (this.format_ == 2 ? 193 : 161);
            }
            case 10: {
                return this.format_ == 3 || this.format_ == 4 ? 69 : 73;
            }
            case 11: {
                return this.format_ == 3 || this.format_ == 4 ? 79 : 93;
            }
            case 12: {
                return this.format_ == 3 || this.format_ == 4 ? 89 : 53;
            }
            case 13: {
                return this.format_ == 3 || this.format_ == 4 ? 99 : 63;
            }
            case 14: {
                return 109;
            }
            case 15: {
                return 113;
            }
            case 16: {
                return 117;
            }
            case 17: {
                return this.format_ == 3 || this.format_ == 4 ? 121 : 41;
            }
            case 18: {
                return this.format_ == 3 || this.format_ == 4 ? 125 : 49;
            }
            case 19: {
                return this.format_ == 3 || this.format_ == 4 ? 129 : 103;
            }
            case 20: {
                return 175;
            }
            case 21: {
                return 174;
            }
            case 22: {
                return 45;
            }
            case 23: {
                return 137;
            }
        }
        return 0;
    }

    private static final void formatOS400DateString(Date d, byte[] data, int offset) {
        Calendar cal = AS400Calendar.getGregorianInstance();
        cal.clear();
        cal.setTime(d);
        int year = cal.get(1);
        data[offset] = (byte)(year / 100 - 19 | 0xF0);
        int yy = year % 100;
        data[offset + 1] = (byte)(yy / 10 | 0xF0);
        data[offset + 2] = (byte)(yy % 10 | 0xF0);
        int month = cal.get(2) + 1;
        data[offset + 3] = (byte)(month / 10 | 0xF0);
        data[offset + 4] = (byte)(month % 10 | 0xF0);
        int day = cal.get(5);
        data[offset + 5] = (byte)(day / 10 | 0xF0);
        data[offset + 6] = (byte)(day % 10 | 0xF0);
        int hour = cal.get(11);
        data[offset + 7] = (byte)(hour / 10 | 0xF0);
        data[offset + 8] = (byte)(hour % 10 | 0xF0);
        int minute = cal.get(12);
        data[offset + 9] = (byte)(minute / 10 | 0xF0);
        data[offset + 10] = (byte)(minute % 10 | 0xF0);
        int second = cal.get(13);
        data[offset + 11] = (byte)(second / 10 | 0xF0);
        data[offset + 12] = (byte)(second % 10 | 0xF0);
    }

    @Override
    protected Object[] formatOutputData(byte[] data, int recordsReturned, int recordLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int vrm = this.system_.getVRM();
        CharConverter conv = new CharConverter(this.system_.getCcsid(), this.system_);
        Object[] sp = new SpooledFileListItem[recordsReturned];
        int offset = 0;
        for (int i = 0; i < recordsReturned; ++i) {
            String userData;
            int spooledFileNumber;
            if (this.format_ != 3 && this.format_ != 4) {
                String spooledFileName = conv.byteArrayToString(data, offset, 10).trim();
                String jobName = conv.byteArrayToString(data, offset + 10, 10).trim();
                String userName = conv.byteArrayToString(data, offset + 20, 10).trim();
                String jobNumber = conv.byteArrayToString(data, offset + 30, 6);
                spooledFileNumber = BinaryConverter.byteArrayToInt(data, offset + 36);
                int totalPages = BinaryConverter.byteArrayToInt(data, offset + 40);
                int currentPage = BinaryConverter.byteArrayToInt(data, offset + 44);
                int copiesLeftToPrint = BinaryConverter.byteArrayToInt(data, offset + 48);
                String outputQueueName = conv.byteArrayToString(data, offset + 52, 10).trim();
                String outputQueueLibraryName = conv.byteArrayToString(data, offset + 62, 10).trim();
                userData = conv.byteArrayToString(data, offset + 72, 10);
                String status = conv.byteArrayToString(data, offset + 82, 10).trim();
                String formType = conv.byteArrayToString(data, offset + 92, 10).trim();
                String priority = conv.byteArrayToString(data, offset + 102, 2).trim();
                byte[] internalJobIdentifier = new byte[16];
                System.arraycopy(data, offset + 104, internalJobIdentifier, 0, 16);
                byte[] internalSpooledFileIdentifier = new byte[16];
                System.arraycopy(data, offset + 120, internalSpooledFileIdentifier, 0, 16);
                String deviceType = conv.byteArrayToString(data, offset + 136, 10).trim();
                int offsetToExtension = BinaryConverter.byteArrayToInt(data, offset + 148);
                String jobSystemName = null;
                String dateSpooledFileWasOpened = null;
                String timeSpooledFileWasOpened = null;
                if (offsetToExtension > 0) {
                    jobSystemName = conv.byteArrayToString(data, offset + offsetToExtension, 8).trim();
                    dateSpooledFileWasOpened = conv.byteArrayToString(data, offset + offsetToExtension + 8, 7);
                    timeSpooledFileWasOpened = conv.byteArrayToString(data, offset + offsetToExtension + 15, 6);
                }
                if (this.format_ == 1) {
                    sp[i] = new SpooledFileListItem(spooledFileName, jobName, userName, jobNumber, spooledFileNumber, totalPages, currentPage, copiesLeftToPrint, outputQueueName, outputQueueLibraryName, userData, status, formType, priority, internalJobIdentifier, internalSpooledFileIdentifier, deviceType, jobSystemName, dateSpooledFileWasOpened, timeSpooledFileWasOpened);
                } else {
                    dateSpooledFileWasOpened = conv.byteArrayToString(data, offset + 160, 7);
                    timeSpooledFileWasOpened = conv.byteArrayToString(data, offset + 167, 6);
                    String printerAssigned = conv.byteArrayToString(data, offset + 173, 1);
                    String printerName = conv.byteArrayToString(data, offset + 174, 10).trim();
                    sp[i] = new SpooledFileListItem(spooledFileName, jobName, userName, jobNumber, spooledFileNumber, totalPages, currentPage, copiesLeftToPrint, outputQueueName, outputQueueLibraryName, userData, status, formType, priority, internalJobIdentifier, internalSpooledFileIdentifier, deviceType, jobSystemName, dateSpooledFileWasOpened, timeSpooledFileWasOpened, printerAssigned, printerName);
                }
            } else {
                String jobName = conv.byteArrayToString(data, offset, 10).trim();
                String userName = conv.byteArrayToString(data, offset + 10, 10).trim();
                String jobNumber = conv.byteArrayToString(data, offset + 20, 6);
                String spooledFileName = conv.byteArrayToString(data, offset + 26, 10).trim();
                spooledFileNumber = BinaryConverter.byteArrayToInt(data, offset + 36);
                int fileStatus = BinaryConverter.byteArrayToInt(data, offset + 40);
                String dateSpooledFileWasOpened = conv.byteArrayToString(data, offset + 44, 7);
                String timeSpooledFileWasOpened = conv.byteArrayToString(data, offset + 51, 6);
                String spooledFileSchedule = conv.byteArrayToString(data, offset + 57, 1);
                String jobSystemName = conv.byteArrayToString(data, offset + 58, 10).trim();
                userData = conv.byteArrayToString(data, offset + 68, 10);
                String spooledFileFormType = conv.byteArrayToString(data, offset + 78, 10).trim();
                String outputQueueName = conv.byteArrayToString(data, offset + 88, 10).trim();
                String outputQueueLibraryName = conv.byteArrayToString(data, offset + 98, 10).trim();
                int auxiliaryStoragePool = BinaryConverter.byteArrayToInt(data, offset + 108);
                int sizeOfSpooledFile = BinaryConverter.byteArrayToInt(data, offset + 112);
                int spooledFileSizeMultiplier = BinaryConverter.byteArrayToInt(data, offset + 116);
                int totalPages = BinaryConverter.byteArrayToInt(data, offset + 120);
                int copiesLeftToPrint = BinaryConverter.byteArrayToInt(data, offset + 124);
                String priority = conv.byteArrayToString(data, offset + 128, 1);
                int internetPrintProtocolJobIdentifier = 0;
                if (vrm >= 328448) {
                    internetPrintProtocolJobIdentifier = BinaryConverter.byteArrayToInt(data, offset + 132);
                }
                sp[i] = new SpooledFileListItem(jobName, userName, jobNumber, spooledFileName, spooledFileNumber, fileStatus, dateSpooledFileWasOpened, timeSpooledFileWasOpened, spooledFileSchedule, jobSystemName, userData, spooledFileFormType, outputQueueName, outputQueueLibraryName, auxiliaryStoragePool, sizeOfSpooledFile, spooledFileSizeMultiplier, totalPages, copiesLeftToPrint, priority, internetPrintProtocolJobIdentifier, this.format_ == 4);
            }
            offset += recordLength;
        }
        return sp;
    }

    @Override
    protected int getBestGuessReceiverSize(int number) {
        switch (this.format_) {
            case 1: {
                return 192 * number;
            }
            case 2: {
                return 224 * number;
            }
        }
        return 136 * number;
    }

    public Date getFilterCreationDateEnd() {
        return this.filterCreationDateEnd_;
    }

    public Date getFilterCreationDateStart() {
        return this.filterCreationDateStart_;
    }

    public String[] getFilterDevices() {
        return this.filterDevices_;
    }

    public String getFilterFormType() {
        return this.filterFormType_;
    }

    public String getFilterJobName() {
        return this.filterJobName_;
    }

    public String getFilterJobNumber() {
        return this.filterJobNumber_;
    }

    public String getFilterJobSystemName() {
        return this.filterJobSystemName_;
    }

    public String getFilterJobUser() {
        return this.filterJobUser_;
    }

    public String[] getFilterOutputQueues() {
        if (this.filterOutputQueues_ == null) {
            return null;
        }
        String[] returnValue = new String[this.filterOutputQueues_.length];
        for (int i = 0; i < this.filterOutputQueues_.length; ++i) {
            returnValue[i] = this.filterOutputQueues_[i].getPath();
        }
        return returnValue;
    }

    public String[] getFilterStatuses() {
        return this.filterStatuses_;
    }

    public String getFilterUserData() {
        return this.filterUserData_;
    }

    public String[] getFilterUsers() {
        return this.filterUsers_;
    }

    public String getFormat() {
        switch (this.format_) {
            case 1: {
                return FORMAT_0100;
            }
            case 2: {
                return FORMAT_0200;
            }
            case 4: {
                return FORMAT_0400;
            }
        }
        return FORMAT_0300;
    }

    public void setFilterCreationDate(Date filterCreationDateStart, Date filterCreationDateEnd) {
        this.filterCreationDateStart_ = filterCreationDateStart;
        this.filterCreationDateEnd_ = filterCreationDateEnd;
        this.resetHandle();
    }

    public void setFilterDevices(String[] devices) {
        this.filterDevices_ = devices;
        this.resetHandle();
    }

    public void setFilterFormType(String formType) {
        this.filterFormType_ = formType;
        this.resetHandle();
    }

    public void setFilterJobInformation(String filterJobName, String filterJobUser, String filterJobNumber) {
        this.filterJobName_ = filterJobName == null ? "" : filterJobName.trim();
        this.filterJobUser_ = filterJobUser == null ? "" : filterJobUser.trim();
        String string = this.filterJobNumber_ = filterJobNumber == null ? "" : filterJobNumber.trim();
        if (this.filterJobName_.equals("*")) {
            this.filterJobUser_ = "";
            this.filterJobNumber_ = "";
        }
        this.resetHandle();
    }

    public void setFilterJobSystemName(String systemName) {
        this.filterJobSystemName_ = systemName;
        this.resetHandle();
    }

    public void setFilterOutputQueues(String[] filterOutputQueues) {
        if (filterOutputQueues == null) {
            this.filterOutputQueues_ = null;
        } else {
            this.filterOutputQueues_ = new QSYSObjectPathName[filterOutputQueues.length];
            for (int i = 0; i < filterOutputQueues.length; ++i) {
                this.filterOutputQueues_[i] = new QSYSObjectPathName(filterOutputQueues[i]);
                if (this.filterOutputQueues_[i].getObjectType().equals("OUTQ")) continue;
                Trace.log(4, "Object type is not valid, path: '" + filterOutputQueues[i] + "'");
            }
        }
        this.resetHandle();
    }

    public void setFilterStatuses(String[] statuses) {
        this.filterStatuses_ = statuses;
        this.resetHandle();
    }

    public void setFilterUserData(String userData) {
        this.filterUserData_ = userData;
        this.resetHandle();
    }

    public void setFilterUsers(String[] users) {
        this.filterUsers_ = users;
        this.resetHandle();
    }

    public void setFormat(String format) {
        if (format == null) {
            Trace.log(2, "Parameter 'format' is null.");
            throw new NullPointerException("format");
        }
        if ((format = format.toUpperCase().trim()).equals(FORMAT_0100)) {
            this.format_ = 1;
        } else if (format.equals(FORMAT_0200)) {
            this.format_ = 2;
        } else if (format.equals(FORMAT_0300)) {
            this.format_ = 3;
        } else if (format.equals(FORMAT_0400)) {
            this.format_ = 4;
        } else {
            Trace.log(2, "Value of parameter 'format' is not valid: " + format);
            throw new ExtendedIllegalArgumentException("format (" + format + ")", 2);
        }
        this.resetHandle();
    }
}

