/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.jta.JtaTransactionErrorHandler;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.apache.camel.jta.TransactionErrorHandler;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.TransactionErrorHandlerDefinition;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionErrorHandlerReifier
extends ErrorHandlerReifier<JtaTransactionErrorHandlerDefinition> {
    private static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionErrorHandlerReifier.class);

    public JtaTransactionErrorHandlerReifier(Route route, JtaTransactionErrorHandlerDefinition definition) {
        super(route, definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        JtaTransactionPolicy transactionPolicy = this.resolveTransactionPolicy((JtaTransactionErrorHandlerDefinition)this.definition);
        ObjectHelper.notNull(transactionPolicy, "transactionPolicy", this);
        RedeliveryPolicy redeliveryPolicy = this.resolveRedeliveryPolicy((TransactionErrorHandlerDefinition)this.definition, this.camelContext);
        CamelLogger logger = this.resolveLogger((TransactionErrorHandlerDefinition)this.definition);
        LoggingLevel rollbackLoggingLevel = this.resolveRollbackLoggingLevel((TransactionErrorHandlerDefinition)this.definition);
        JtaTransactionErrorHandler answer = new JtaTransactionErrorHandler(this.camelContext, processor, logger, this.getProcessor(((JtaTransactionErrorHandlerDefinition)this.definition).getOnRedeliveryProcessor(), ((JtaTransactionErrorHandlerDefinition)this.definition).getOnRedeliveryRef()), redeliveryPolicy, transactionPolicy, this.resolveRetryWhilePolicy((TransactionErrorHandlerDefinition)this.definition, this.camelContext), this.getExecutorService(((JtaTransactionErrorHandlerDefinition)this.definition).getExecutorServiceBean(), ((JtaTransactionErrorHandlerDefinition)this.definition).getExecutorServiceRef()), rollbackLoggingLevel, this.getProcessor(((JtaTransactionErrorHandlerDefinition)this.definition).getOnExceptionOccurredProcessor(), ((JtaTransactionErrorHandlerDefinition)this.definition).getOnExceptionOccurredRef()));
        this.configure(answer);
        return answer;
    }

    private JtaTransactionPolicy resolveTransactionPolicy(JtaTransactionErrorHandlerDefinition definition) {
        JtaTransactionPolicy answer = (JtaTransactionPolicy)definition.getTransactedPolicy();
        if (answer == null && definition.getTransactedPolicyRef() != null) {
            answer = this.mandatoryLookup(definition.getTransactedPolicyRef(), JtaTransactionPolicy.class);
        }
        if (answer == null) {
            JtaTransactionPolicy policy;
            LOG.debug("No transaction policy configured on error handler. Will try find it in the registry.");
            Map<String, JtaTransactionPolicy> mapPolicy = this.findByTypeWithName(JtaTransactionPolicy.class);
            if (mapPolicy != null && mapPolicy.size() == 1 && (policy = mapPolicy.values().iterator().next()) != null) {
                answer = policy;
            }
            if (answer == null && (policy = this.lookupByNameAndType(PROPAGATION_REQUIRED, JtaTransactionPolicy.class)) != null) {
                answer = policy;
            }
            if (answer != null) {
                LOG.debug("Found TransactionPolicy in registry to use: {}", (Object)answer);
            }
        }
        return answer;
    }

    private CamelLogger resolveLogger(TransactionErrorHandlerDefinition definition) {
        CamelLogger answer = definition.getLoggerBean();
        if (answer == null && definition.getLoggerRef() != null) {
            answer = this.mandatoryLookup(definition.getLoggerRef(), CamelLogger.class);
        }
        if (answer == null) {
            answer = new CamelLogger(LoggerFactory.getLogger(TransactionErrorHandler.class), LoggingLevel.ERROR);
        }
        if (definition.getLevel() != null) {
            answer.setLevel(this.parse(LoggingLevel.class, definition.getLevel()));
        }
        return answer;
    }

    private LoggingLevel resolveRollbackLoggingLevel(TransactionErrorHandlerDefinition definition) {
        LoggingLevel answer = LoggingLevel.WARN;
        if (definition.getRollbackLoggingLevel() != null) {
            answer = this.parse(LoggingLevel.class, definition.getRollbackLoggingLevel());
        }
        return answer;
    }

    private RedeliveryPolicy resolveRedeliveryPolicy(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        RedeliveryPolicy answer = null;
        RedeliveryPolicyDefinition def = definition.getRedeliveryPolicy();
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            def = this.lookupByNameAndType(definition.getRedeliveryPolicyRef(), RedeliveryPolicyDefinition.class);
        }
        if (def != null) {
            answer = ErrorHandlerReifier.createRedeliveryPolicy(def, camelContext, null);
        }
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            answer = this.mandatoryLookup(definition.getRedeliveryPolicyRef(), RedeliveryPolicy.class);
        }
        if (answer == null) {
            answer = RedeliveryPolicy.DEFAULT_POLICY;
        }
        return answer;
    }

    private Predicate resolveRetryWhilePolicy(TransactionErrorHandlerDefinition definition, CamelContext camelContext) {
        Predicate answer = definition.getRetryWhilePredicate();
        if (answer == null && definition.getRetryWhileRef() != null) {
            Language bean = camelContext.resolveLanguage("bean");
            answer = bean.createPredicate(definition.getRetryWhileRef());
            answer.initPredicate(camelContext);
        }
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService(ScheduledExecutorService executorService, String executorServiceRef) {
        if (executorService == null || executorService.isShutdown()) {
            if (executorServiceRef != null) {
                executorService = this.lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorService " + executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = null;
            }
        }
        return executorService;
    }
}

