/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import jakarta.transaction.TransactionRolledbackException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TransactionErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor,
ShutdownPrepared,
Navigate<Processor> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionErrorHandler.class);
    protected final CamelContext camelContext;
    protected final Processor output;
    protected volatile boolean preparingShutdown;
    private JtaTransactionPolicy transactionPolicy;
    private final String transactionKey;
    private final LoggingLevel rollbackLoggingLevel;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, JtaTransactionPolicy transactionPolicy, LoggingLevel rollbackLoggingLevel) {
        this.camelContext = camelContext;
        this.output = output;
        this.transactionPolicy = transactionPolicy;
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        this.transactionKey = ObjectHelper.getIdentityHashCode(transactionPolicy);
    }

    @Override
    public ErrorHandler clone(Processor output) {
        TransactionErrorHandler answer = new TransactionErrorHandler(this.camelContext, output, this.transactionPolicy, this.rollbackLoggingLevel);
        if (this.exceptionPolicies != null) {
            answer.exceptionPolicies = this.exceptionPolicies;
        }
        return answer;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork().isTransactedBy(this.transactionKey)) {
            this.processByErrorHandler(exchange);
        } else {
            this.processInTransaction(exchange);
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange) {
        String redelivered = Boolean.toString(exchange.isExternalRedelivered());
        String ids = ExchangeHelper.logIds(exchange);
        try {
            exchange.getUnitOfWork().beginTransactedBy(this.transactionKey);
            this.logTransactionBegin(redelivered, ids);
            this.doInTransactionTemplate(exchange);
            this.logTransactionCommit(redelivered, ids);
        }
        catch (TransactionRolledbackException e) {
            this.logTransactionRollback(redelivered, ids, null, true);
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.logTransactionRollback(redelivered, ids, e, false);
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy(this.transactionKey);
        }
        boolean onlyLast = exchange.isRollbackOnlyLast();
        exchange.setRollbackOnlyLast(false);
        if (onlyLast) {
            if (LOG.isDebugEnabled()) {
                Exception cause = exchange.getException();
                if (cause != null) {
                    LOG.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast and caught: ", new Object[]{this.transactionKey, redelivered, ids, cause});
                } else {
                    LOG.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast", new Object[]{this.transactionKey, redelivered, ids});
                }
            }
            exchange.setException(null);
        }
    }

    public void setTransactionPolicy(JtaTransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
    }

    protected void doInTransactionTemplate(final Exchange exchange) throws Throwable {
        this.transactionPolicy.run(new JtaTransactionPolicy.Runnable(){

            @Override
            public void run() throws Throwable {
                TransactionErrorHandler.this.processByErrorHandler(exchange);
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    Exception rce = exchange.getException() != null ? exchange.getException() : new TransactionRolledbackException();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Throwing runtime exception to force transaction to rollback on {}", (Object)TransactionErrorHandler.this.transactionPolicy);
                    }
                    throw rce;
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange) {
        try {
            this.output.process(exchange);
        }
        catch (Throwable e) {
            throw new RuntimeCamelException(e);
        }
    }

    private void logTransactionBegin(String redelivered, String ids) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction begin ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
        }
    }

    private void logTransactionCommit(String redelivered, String ids) {
        if ("true".equals(redelivered) && (this.rollbackLoggingLevel == LoggingLevel.INFO || this.rollbackLoggingLevel == LoggingLevel.WARN || this.rollbackLoggingLevel == LoggingLevel.ERROR)) {
            LOG.info("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
            return;
        }
        LOG.debug("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
    }

    public void doLog(String redelivered, String ids, Throwable e, boolean rollbackOnly, Level level) {
        if (rollbackOnly) {
            LOG.atLevel(level).log("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
        } else {
            LOG.atLevel(level).log("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        }
    }

    private void logTransactionRollback(String redelivered, String ids, Throwable e, boolean rollbackOnly) {
        if (this.rollbackLoggingLevel != LoggingLevel.OFF) {
            if (this.rollbackLoggingLevel == LoggingLevel.ERROR && LOG.isErrorEnabled()) {
                this.doLog(redelivered, ids, e, rollbackOnly, Level.ERROR);
            } else if (this.rollbackLoggingLevel == LoggingLevel.WARN && LOG.isWarnEnabled()) {
                this.doLog(redelivered, ids, e, rollbackOnly, Level.WARN);
            } else if (this.rollbackLoggingLevel == LoggingLevel.INFO && LOG.isInfoEnabled()) {
                this.doLog(redelivered, ids, e, rollbackOnly, Level.INFO);
            } else if (this.rollbackLoggingLevel == LoggingLevel.DEBUG && LOG.isDebugEnabled()) {
                this.doLog(redelivered, ids, e, rollbackOnly, Level.DEBUG);
            } else if (this.rollbackLoggingLevel == LoggingLevel.TRACE && LOG.isTraceEnabled()) {
                this.doLog(redelivered, ids, e, rollbackOnly, Level.TRACE);
            }
        }
    }

    @Override
    public Processor getOutput() {
        return this.output;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.output);
        this.preparingShutdown = false;
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.output);
    }

    @Override
    public boolean supportTransacted() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.output != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.output);
        return answer;
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        LOG.trace("Prepare shutdown on error handler {}", (Object)this);
        this.preparingShutdown = true;
    }
}

