/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.PollOnError;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class KafkaEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        KafkaEndpoint target = (KafkaEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                target.getConfiguration().setAdditionalProperties(KafkaEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "allowmanualcommit": 
            case "allowManualCommit": {
                target.getConfiguration().setAllowManualCommit(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autocommitenable": 
            case "autoCommitEnable": {
                target.getConfiguration().setAutoCommitEnable(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autocommitintervalms": 
            case "autoCommitIntervalMs": {
                target.getConfiguration().setAutoCommitIntervalMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "autooffsetreset": 
            case "autoOffsetReset": {
                target.getConfiguration().setAutoOffsetReset(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "batchwithindividualheaders": 
            case "batchWithIndividualHeaders": {
                target.getConfiguration().setBatchWithIndividualHeaders(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "batching": {
                target.getConfiguration().setBatching(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "breakonfirsterror": 
            case "breakOnFirstError": {
                target.getConfiguration().setBreakOnFirstError(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "brokers": {
                target.getConfiguration().setBrokers(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "buffermemorysize": 
            case "bufferMemorySize": {
                target.getConfiguration().setBufferMemorySize(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "checkcrcs": 
            case "checkCrcs": {
                target.getConfiguration().setCheckCrcs(KafkaEndpointConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                target.getConfiguration().setClientId(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "committimeoutms": 
            case "commitTimeoutMs": {
                target.getConfiguration().setCommitTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                target.getConfiguration().setCompressionCodec(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "connectionmaxidlems": 
            case "connectionMaxIdleMs": {
                target.getConfiguration().setConnectionMaxIdleMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "consumerrequesttimeoutms": 
            case "consumerRequestTimeoutMs": {
                target.getConfiguration().setConsumerRequestTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "consumerscount": 
            case "consumersCount": {
                target.getConfiguration().setConsumersCount(KafkaEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "deliverytimeoutms": 
            case "deliveryTimeoutMs": {
                target.getConfiguration().setDeliveryTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "enableidempotence": 
            case "enableIdempotence": {
                target.getConfiguration().setEnableIdempotence(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(KafkaEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(KafkaEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "fetchmaxbytes": 
            case "fetchMaxBytes": {
                target.getConfiguration().setFetchMaxBytes(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "fetchminbytes": 
            case "fetchMinBytes": {
                target.getConfiguration().setFetchMinBytes(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "fetchwaitmaxms": 
            case "fetchWaitMaxMs": {
                target.getConfiguration().setFetchWaitMaxMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "groupid": 
            case "groupId": {
                target.getConfiguration().setGroupId(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "groupinstanceid": 
            case "groupInstanceId": {
                target.getConfiguration().setGroupInstanceId(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "headerdeserializer": 
            case "headerDeserializer": {
                target.getConfiguration().setHeaderDeserializer(KafkaEndpointConfigurer.property(camelContext, KafkaHeaderDeserializer.class, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.getConfiguration().setHeaderFilterStrategy(KafkaEndpointConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "headerserializer": 
            case "headerSerializer": {
                target.getConfiguration().setHeaderSerializer(KafkaEndpointConfigurer.property(camelContext, KafkaHeaderSerializer.class, value));
                return true;
            }
            case "heartbeatintervalms": 
            case "heartbeatIntervalMs": {
                target.getConfiguration().setHeartbeatIntervalMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "interceptorclasses": 
            case "interceptorClasses": {
                target.getConfiguration().setInterceptorClasses(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "isolationlevel": 
            case "isolationLevel": {
                target.getConfiguration().setIsolationLevel(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "kafkaclientfactory": 
            case "kafkaClientFactory": {
                target.setKafkaClientFactory(KafkaEndpointConfigurer.property(camelContext, KafkaClientFactory.class, value));
                return true;
            }
            case "kafkamanualcommitfactory": 
            case "kafkaManualCommitFactory": {
                target.setKafkaManualCommitFactory(KafkaEndpointConfigurer.property(camelContext, KafkaManualCommitFactory.class, value));
                return true;
            }
            case "kerberosbeforereloginmintime": 
            case "kerberosBeforeReloginMinTime": {
                target.getConfiguration().setKerberosBeforeReloginMinTime(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "kerberosconfiglocation": 
            case "kerberosConfigLocation": {
                target.getConfiguration().setKerberosConfigLocation(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "kerberosinitcmd": 
            case "kerberosInitCmd": {
                target.getConfiguration().setKerberosInitCmd(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "kerberosprincipaltolocalrules": 
            case "kerberosPrincipalToLocalRules": {
                target.getConfiguration().setKerberosPrincipalToLocalRules(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "kerberosrenewjitter": 
            case "kerberosRenewJitter": {
                target.getConfiguration().setKerberosRenewJitter(KafkaEndpointConfigurer.property(camelContext, Double.class, value));
                return true;
            }
            case "kerberosrenewwindowfactor": 
            case "kerberosRenewWindowFactor": {
                target.getConfiguration().setKerberosRenewWindowFactor(KafkaEndpointConfigurer.property(camelContext, Double.class, value));
                return true;
            }
            case "key": {
                target.getConfiguration().setKey(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "keydeserializer": 
            case "keyDeserializer": {
                target.getConfiguration().setKeyDeserializer(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "keyserializer": 
            case "keySerializer": {
                target.getConfiguration().setKeySerializer(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lingerms": 
            case "lingerMs": {
                target.getConfiguration().setLingerMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxblockms": 
            case "maxBlockMs": {
                target.getConfiguration().setMaxBlockMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxinflightrequest": 
            case "maxInFlightRequest": {
                target.getConfiguration().setMaxInFlightRequest(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxpartitionfetchbytes": 
            case "maxPartitionFetchBytes": {
                target.getConfiguration().setMaxPartitionFetchBytes(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxpollintervalms": 
            case "maxPollIntervalMs": {
                target.getConfiguration().setMaxPollIntervalMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxpollrecords": 
            case "maxPollRecords": {
                target.getConfiguration().setMaxPollRecords(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxrequestsize": 
            case "maxRequestSize": {
                target.getConfiguration().setMaxRequestSize(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "metadatamaxagems": 
            case "metadataMaxAgeMs": {
                target.getConfiguration().setMetadataMaxAgeMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "metricreporters": 
            case "metricReporters": {
                target.getConfiguration().setMetricReporters(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "metricssamplewindowms": 
            case "metricsSampleWindowMs": {
                target.getConfiguration().setMetricsSampleWindowMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "noofmetricssample": 
            case "noOfMetricsSample": {
                target.getConfiguration().setNoOfMetricsSample(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "offsetrepository": 
            case "offsetRepository": {
                target.getConfiguration().setOffsetRepository(KafkaEndpointConfigurer.property(camelContext, StateRepository.class, value));
                return true;
            }
            case "partitionassignor": 
            case "partitionAssignor": {
                target.getConfiguration().setPartitionAssignor(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "partitionkey": 
            case "partitionKey": {
                target.getConfiguration().setPartitionKey(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "partitioner": {
                target.getConfiguration().setPartitioner(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "partitionerignorekeys": 
            case "partitionerIgnoreKeys": {
                target.getConfiguration().setPartitionerIgnoreKeys(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "pollonerror": 
            case "pollOnError": {
                target.getConfiguration().setPollOnError(KafkaEndpointConfigurer.property(camelContext, PollOnError.class, value));
                return true;
            }
            case "polltimeoutms": 
            case "pollTimeoutMs": {
                target.getConfiguration().setPollTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "prevalidatehostandport": 
            case "preValidateHostAndPort": {
                target.getConfiguration().setPreValidateHostAndPort(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "producerbatchsize": 
            case "producerBatchSize": {
                target.getConfiguration().setProducerBatchSize(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "queuebufferingmaxmessages": 
            case "queueBufferingMaxMessages": {
                target.getConfiguration().setQueueBufferingMaxMessages(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "receivebufferbytes": 
            case "receiveBufferBytes": {
                target.getConfiguration().setReceiveBufferBytes(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "reconnectbackoffmaxms": 
            case "reconnectBackoffMaxMs": {
                target.getConfiguration().setReconnectBackoffMaxMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "reconnectbackoffms": 
            case "reconnectBackoffMs": {
                target.getConfiguration().setReconnectBackoffMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "recordmetadata": 
            case "recordMetadata": {
                target.getConfiguration().setRecordMetadata(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "requestrequiredacks": 
            case "requestRequiredAcks": {
                target.getConfiguration().setRequestRequiredAcks(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "requesttimeoutms": 
            case "requestTimeoutMs": {
                target.getConfiguration().setRequestTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "retries": {
                target.getConfiguration().setRetries(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "retrybackoffmaxms": 
            case "retryBackoffMaxMs": {
                target.getConfiguration().setRetryBackoffMaxMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "retrybackoffms": 
            case "retryBackoffMs": {
                target.getConfiguration().setRetryBackoffMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "sasljaasconfig": 
            case "saslJaasConfig": {
                target.getConfiguration().setSaslJaasConfig(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "saslkerberosservicename": 
            case "saslKerberosServiceName": {
                target.getConfiguration().setSaslKerberosServiceName(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                target.getConfiguration().setSaslMechanism(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "schemaregistryurl": 
            case "schemaRegistryURL": {
                target.getConfiguration().setSchemaRegistryURL(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "securityprotocol": 
            case "securityProtocol": {
                target.getConfiguration().setSecurityProtocol(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "seekto": 
            case "seekTo": {
                target.getConfiguration().setSeekTo(KafkaEndpointConfigurer.property(camelContext, SeekPolicy.class, value));
                return true;
            }
            case "sendbufferbytes": 
            case "sendBufferBytes": {
                target.getConfiguration().setSendBufferBytes(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "sessiontimeoutms": 
            case "sessionTimeoutMs": {
                target.getConfiguration().setSessionTimeoutMs(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "shutdowntimeout": 
            case "shutdownTimeout": {
                target.getConfiguration().setShutdownTimeout(KafkaEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "specificavroreader": 
            case "specificAvroReader": {
                target.getConfiguration().setSpecificAvroReader(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sslciphersuites": 
            case "sslCipherSuites": {
                target.getConfiguration().setSslCipherSuites(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters(KafkaEndpointConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "sslenabledprotocols": 
            case "sslEnabledProtocols": {
                target.getConfiguration().setSslEnabledProtocols(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslendpointalgorithm": 
            case "sslEndpointAlgorithm": {
                target.getConfiguration().setSslEndpointAlgorithm(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslkeypassword": 
            case "sslKeyPassword": {
                target.getConfiguration().setSslKeyPassword(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslkeymanageralgorithm": 
            case "sslKeymanagerAlgorithm": {
                target.getConfiguration().setSslKeymanagerAlgorithm(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslkeystorelocation": 
            case "sslKeystoreLocation": {
                target.getConfiguration().setSslKeystoreLocation(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslkeystorepassword": 
            case "sslKeystorePassword": {
                target.getConfiguration().setSslKeystorePassword(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslkeystoretype": 
            case "sslKeystoreType": {
                target.getConfiguration().setSslKeystoreType(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslprotocol": 
            case "sslProtocol": {
                target.getConfiguration().setSslProtocol(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslprovider": 
            case "sslProvider": {
                target.getConfiguration().setSslProvider(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ssltrustmanageralgorithm": 
            case "sslTrustmanagerAlgorithm": {
                target.getConfiguration().setSslTrustmanagerAlgorithm(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ssltruststorelocation": 
            case "sslTruststoreLocation": {
                target.getConfiguration().setSslTruststoreLocation(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ssltruststorepassword": 
            case "sslTruststorePassword": {
                target.getConfiguration().setSslTruststorePassword(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ssltruststoretype": 
            case "sslTruststoreType": {
                target.getConfiguration().setSslTruststoreType(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "synchronous": {
                target.getConfiguration().setSynchronous(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "topicispattern": 
            case "topicIsPattern": {
                target.getConfiguration().setTopicIsPattern(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useiterator": 
            case "useIterator": {
                target.getConfiguration().setUseIterator(KafkaEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "valuedeserializer": 
            case "valueDeserializer": {
                target.getConfiguration().setValueDeserializer(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "valueserializer": 
            case "valueSerializer": {
                target.getConfiguration().setValueSerializer(KafkaEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "workerpool": 
            case "workerPool": {
                target.getConfiguration().setWorkerPool(KafkaEndpointConfigurer.property(camelContext, ExecutorService.class, value));
                return true;
            }
            case "workerpoolcoresize": 
            case "workerPoolCoreSize": {
                target.getConfiguration().setWorkerPoolCoreSize(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                target.getConfiguration().setWorkerPoolMaxSize(KafkaEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                return Map.class;
            }
            case "allowmanualcommit": 
            case "allowManualCommit": {
                return Boolean.TYPE;
            }
            case "autocommitenable": 
            case "autoCommitEnable": {
                return Boolean.TYPE;
            }
            case "autocommitintervalms": 
            case "autoCommitIntervalMs": {
                return Integer.class;
            }
            case "autooffsetreset": 
            case "autoOffsetReset": {
                return String.class;
            }
            case "batchwithindividualheaders": 
            case "batchWithIndividualHeaders": {
                return Boolean.TYPE;
            }
            case "batching": {
                return Boolean.TYPE;
            }
            case "breakonfirsterror": 
            case "breakOnFirstError": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "brokers": {
                return String.class;
            }
            case "buffermemorysize": 
            case "bufferMemorySize": {
                return Integer.class;
            }
            case "checkcrcs": 
            case "checkCrcs": {
                return Boolean.class;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "committimeoutms": 
            case "commitTimeoutMs": {
                return Long.class;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return String.class;
            }
            case "connectionmaxidlems": 
            case "connectionMaxIdleMs": {
                return Integer.class;
            }
            case "consumerrequesttimeoutms": 
            case "consumerRequestTimeoutMs": {
                return Integer.class;
            }
            case "consumerscount": 
            case "consumersCount": {
                return Integer.TYPE;
            }
            case "deliverytimeoutms": 
            case "deliveryTimeoutMs": {
                return Integer.class;
            }
            case "enableidempotence": 
            case "enableIdempotence": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "fetchmaxbytes": 
            case "fetchMaxBytes": {
                return Integer.class;
            }
            case "fetchminbytes": 
            case "fetchMinBytes": {
                return Integer.class;
            }
            case "fetchwaitmaxms": 
            case "fetchWaitMaxMs": {
                return Integer.class;
            }
            case "groupid": 
            case "groupId": {
                return String.class;
            }
            case "groupinstanceid": 
            case "groupInstanceId": {
                return String.class;
            }
            case "headerdeserializer": 
            case "headerDeserializer": {
                return KafkaHeaderDeserializer.class;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "headerserializer": 
            case "headerSerializer": {
                return KafkaHeaderSerializer.class;
            }
            case "heartbeatintervalms": 
            case "heartbeatIntervalMs": {
                return Integer.class;
            }
            case "interceptorclasses": 
            case "interceptorClasses": {
                return String.class;
            }
            case "isolationlevel": 
            case "isolationLevel": {
                return String.class;
            }
            case "kafkaclientfactory": 
            case "kafkaClientFactory": {
                return KafkaClientFactory.class;
            }
            case "kafkamanualcommitfactory": 
            case "kafkaManualCommitFactory": {
                return KafkaManualCommitFactory.class;
            }
            case "kerberosbeforereloginmintime": 
            case "kerberosBeforeReloginMinTime": {
                return Integer.class;
            }
            case "kerberosconfiglocation": 
            case "kerberosConfigLocation": {
                return String.class;
            }
            case "kerberosinitcmd": 
            case "kerberosInitCmd": {
                return String.class;
            }
            case "kerberosprincipaltolocalrules": 
            case "kerberosPrincipalToLocalRules": {
                return String.class;
            }
            case "kerberosrenewjitter": 
            case "kerberosRenewJitter": {
                return Double.class;
            }
            case "kerberosrenewwindowfactor": 
            case "kerberosRenewWindowFactor": {
                return Double.class;
            }
            case "key": {
                return String.class;
            }
            case "keydeserializer": 
            case "keyDeserializer": {
                return String.class;
            }
            case "keyserializer": 
            case "keySerializer": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "lingerms": 
            case "lingerMs": {
                return Integer.class;
            }
            case "maxblockms": 
            case "maxBlockMs": {
                return Integer.class;
            }
            case "maxinflightrequest": 
            case "maxInFlightRequest": {
                return Integer.class;
            }
            case "maxpartitionfetchbytes": 
            case "maxPartitionFetchBytes": {
                return Integer.class;
            }
            case "maxpollintervalms": 
            case "maxPollIntervalMs": {
                return Integer.class;
            }
            case "maxpollrecords": 
            case "maxPollRecords": {
                return Integer.class;
            }
            case "maxrequestsize": 
            case "maxRequestSize": {
                return Integer.class;
            }
            case "metadatamaxagems": 
            case "metadataMaxAgeMs": {
                return Integer.class;
            }
            case "metricreporters": 
            case "metricReporters": {
                return String.class;
            }
            case "metricssamplewindowms": 
            case "metricsSampleWindowMs": {
                return Integer.class;
            }
            case "noofmetricssample": 
            case "noOfMetricsSample": {
                return Integer.class;
            }
            case "offsetrepository": 
            case "offsetRepository": {
                return StateRepository.class;
            }
            case "partitionassignor": 
            case "partitionAssignor": {
                return String.class;
            }
            case "partitionkey": 
            case "partitionKey": {
                return Integer.class;
            }
            case "partitioner": {
                return String.class;
            }
            case "partitionerignorekeys": 
            case "partitionerIgnoreKeys": {
                return Boolean.TYPE;
            }
            case "pollonerror": 
            case "pollOnError": {
                return PollOnError.class;
            }
            case "polltimeoutms": 
            case "pollTimeoutMs": {
                return Long.class;
            }
            case "prevalidatehostandport": 
            case "preValidateHostAndPort": {
                return Boolean.TYPE;
            }
            case "producerbatchsize": 
            case "producerBatchSize": {
                return Integer.class;
            }
            case "queuebufferingmaxmessages": 
            case "queueBufferingMaxMessages": {
                return Integer.class;
            }
            case "receivebufferbytes": 
            case "receiveBufferBytes": {
                return Integer.class;
            }
            case "reconnectbackoffmaxms": 
            case "reconnectBackoffMaxMs": {
                return Integer.class;
            }
            case "reconnectbackoffms": 
            case "reconnectBackoffMs": {
                return Integer.class;
            }
            case "recordmetadata": 
            case "recordMetadata": {
                return Boolean.TYPE;
            }
            case "requestrequiredacks": 
            case "requestRequiredAcks": {
                return String.class;
            }
            case "requesttimeoutms": 
            case "requestTimeoutMs": {
                return Integer.class;
            }
            case "retries": {
                return Integer.class;
            }
            case "retrybackoffmaxms": 
            case "retryBackoffMaxMs": {
                return Integer.class;
            }
            case "retrybackoffms": 
            case "retryBackoffMs": {
                return Integer.class;
            }
            case "sasljaasconfig": 
            case "saslJaasConfig": {
                return String.class;
            }
            case "saslkerberosservicename": 
            case "saslKerberosServiceName": {
                return String.class;
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return String.class;
            }
            case "schemaregistryurl": 
            case "schemaRegistryURL": {
                return String.class;
            }
            case "securityprotocol": 
            case "securityProtocol": {
                return String.class;
            }
            case "seekto": 
            case "seekTo": {
                return SeekPolicy.class;
            }
            case "sendbufferbytes": 
            case "sendBufferBytes": {
                return Integer.class;
            }
            case "sessiontimeoutms": 
            case "sessionTimeoutMs": {
                return Integer.class;
            }
            case "shutdowntimeout": 
            case "shutdownTimeout": {
                return Integer.TYPE;
            }
            case "specificavroreader": 
            case "specificAvroReader": {
                return Boolean.TYPE;
            }
            case "sslciphersuites": 
            case "sslCipherSuites": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "sslenabledprotocols": 
            case "sslEnabledProtocols": {
                return String.class;
            }
            case "sslendpointalgorithm": 
            case "sslEndpointAlgorithm": {
                return String.class;
            }
            case "sslkeypassword": 
            case "sslKeyPassword": {
                return String.class;
            }
            case "sslkeymanageralgorithm": 
            case "sslKeymanagerAlgorithm": {
                return String.class;
            }
            case "sslkeystorelocation": 
            case "sslKeystoreLocation": {
                return String.class;
            }
            case "sslkeystorepassword": 
            case "sslKeystorePassword": {
                return String.class;
            }
            case "sslkeystoretype": 
            case "sslKeystoreType": {
                return String.class;
            }
            case "sslprotocol": 
            case "sslProtocol": {
                return String.class;
            }
            case "sslprovider": 
            case "sslProvider": {
                return String.class;
            }
            case "ssltrustmanageralgorithm": 
            case "sslTrustmanagerAlgorithm": {
                return String.class;
            }
            case "ssltruststorelocation": 
            case "sslTruststoreLocation": {
                return String.class;
            }
            case "ssltruststorepassword": 
            case "sslTruststorePassword": {
                return String.class;
            }
            case "ssltruststoretype": 
            case "sslTruststoreType": {
                return String.class;
            }
            case "synchronous": {
                return Boolean.TYPE;
            }
            case "topicispattern": 
            case "topicIsPattern": {
                return Boolean.TYPE;
            }
            case "useiterator": 
            case "useIterator": {
                return Boolean.TYPE;
            }
            case "valuedeserializer": 
            case "valueDeserializer": {
                return String.class;
            }
            case "valueserializer": 
            case "valueSerializer": {
                return String.class;
            }
            case "workerpool": 
            case "workerPool": {
                return ExecutorService.class;
            }
            case "workerpoolcoresize": 
            case "workerPoolCoreSize": {
                return Integer.class;
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        KafkaEndpoint target = (KafkaEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                return target.getConfiguration().getAdditionalProperties();
            }
            case "allowmanualcommit": 
            case "allowManualCommit": {
                return target.getConfiguration().isAllowManualCommit();
            }
            case "autocommitenable": 
            case "autoCommitEnable": {
                return target.getConfiguration().isAutoCommitEnable();
            }
            case "autocommitintervalms": 
            case "autoCommitIntervalMs": {
                return target.getConfiguration().getAutoCommitIntervalMs();
            }
            case "autooffsetreset": 
            case "autoOffsetReset": {
                return target.getConfiguration().getAutoOffsetReset();
            }
            case "batchwithindividualheaders": 
            case "batchWithIndividualHeaders": {
                return target.getConfiguration().isBatchWithIndividualHeaders();
            }
            case "batching": {
                return target.getConfiguration().isBatching();
            }
            case "breakonfirsterror": 
            case "breakOnFirstError": {
                return target.getConfiguration().isBreakOnFirstError();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "brokers": {
                return target.getConfiguration().getBrokers();
            }
            case "buffermemorysize": 
            case "bufferMemorySize": {
                return target.getConfiguration().getBufferMemorySize();
            }
            case "checkcrcs": 
            case "checkCrcs": {
                return target.getConfiguration().getCheckCrcs();
            }
            case "clientid": 
            case "clientId": {
                return target.getConfiguration().getClientId();
            }
            case "committimeoutms": 
            case "commitTimeoutMs": {
                return target.getConfiguration().getCommitTimeoutMs();
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return target.getConfiguration().getCompressionCodec();
            }
            case "connectionmaxidlems": 
            case "connectionMaxIdleMs": {
                return target.getConfiguration().getConnectionMaxIdleMs();
            }
            case "consumerrequesttimeoutms": 
            case "consumerRequestTimeoutMs": {
                return target.getConfiguration().getConsumerRequestTimeoutMs();
            }
            case "consumerscount": 
            case "consumersCount": {
                return target.getConfiguration().getConsumersCount();
            }
            case "deliverytimeoutms": 
            case "deliveryTimeoutMs": {
                return target.getConfiguration().getDeliveryTimeoutMs();
            }
            case "enableidempotence": 
            case "enableIdempotence": {
                return target.getConfiguration().isEnableIdempotence();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "fetchmaxbytes": 
            case "fetchMaxBytes": {
                return target.getConfiguration().getFetchMaxBytes();
            }
            case "fetchminbytes": 
            case "fetchMinBytes": {
                return target.getConfiguration().getFetchMinBytes();
            }
            case "fetchwaitmaxms": 
            case "fetchWaitMaxMs": {
                return target.getConfiguration().getFetchWaitMaxMs();
            }
            case "groupid": 
            case "groupId": {
                return target.getConfiguration().getGroupId();
            }
            case "groupinstanceid": 
            case "groupInstanceId": {
                return target.getConfiguration().getGroupInstanceId();
            }
            case "headerdeserializer": 
            case "headerDeserializer": {
                return target.getConfiguration().getHeaderDeserializer();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getConfiguration().getHeaderFilterStrategy();
            }
            case "headerserializer": 
            case "headerSerializer": {
                return target.getConfiguration().getHeaderSerializer();
            }
            case "heartbeatintervalms": 
            case "heartbeatIntervalMs": {
                return target.getConfiguration().getHeartbeatIntervalMs();
            }
            case "interceptorclasses": 
            case "interceptorClasses": {
                return target.getConfiguration().getInterceptorClasses();
            }
            case "isolationlevel": 
            case "isolationLevel": {
                return target.getConfiguration().getIsolationLevel();
            }
            case "kafkaclientfactory": 
            case "kafkaClientFactory": {
                return target.getKafkaClientFactory();
            }
            case "kafkamanualcommitfactory": 
            case "kafkaManualCommitFactory": {
                return target.getKafkaManualCommitFactory();
            }
            case "kerberosbeforereloginmintime": 
            case "kerberosBeforeReloginMinTime": {
                return target.getConfiguration().getKerberosBeforeReloginMinTime();
            }
            case "kerberosconfiglocation": 
            case "kerberosConfigLocation": {
                return target.getConfiguration().getKerberosConfigLocation();
            }
            case "kerberosinitcmd": 
            case "kerberosInitCmd": {
                return target.getConfiguration().getKerberosInitCmd();
            }
            case "kerberosprincipaltolocalrules": 
            case "kerberosPrincipalToLocalRules": {
                return target.getConfiguration().getKerberosPrincipalToLocalRules();
            }
            case "kerberosrenewjitter": 
            case "kerberosRenewJitter": {
                return target.getConfiguration().getKerberosRenewJitter();
            }
            case "kerberosrenewwindowfactor": 
            case "kerberosRenewWindowFactor": {
                return target.getConfiguration().getKerberosRenewWindowFactor();
            }
            case "key": {
                return target.getConfiguration().getKey();
            }
            case "keydeserializer": 
            case "keyDeserializer": {
                return target.getConfiguration().getKeyDeserializer();
            }
            case "keyserializer": 
            case "keySerializer": {
                return target.getConfiguration().getKeySerializer();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "lingerms": 
            case "lingerMs": {
                return target.getConfiguration().getLingerMs();
            }
            case "maxblockms": 
            case "maxBlockMs": {
                return target.getConfiguration().getMaxBlockMs();
            }
            case "maxinflightrequest": 
            case "maxInFlightRequest": {
                return target.getConfiguration().getMaxInFlightRequest();
            }
            case "maxpartitionfetchbytes": 
            case "maxPartitionFetchBytes": {
                return target.getConfiguration().getMaxPartitionFetchBytes();
            }
            case "maxpollintervalms": 
            case "maxPollIntervalMs": {
                return target.getConfiguration().getMaxPollIntervalMs();
            }
            case "maxpollrecords": 
            case "maxPollRecords": {
                return target.getConfiguration().getMaxPollRecords();
            }
            case "maxrequestsize": 
            case "maxRequestSize": {
                return target.getConfiguration().getMaxRequestSize();
            }
            case "metadatamaxagems": 
            case "metadataMaxAgeMs": {
                return target.getConfiguration().getMetadataMaxAgeMs();
            }
            case "metricreporters": 
            case "metricReporters": {
                return target.getConfiguration().getMetricReporters();
            }
            case "metricssamplewindowms": 
            case "metricsSampleWindowMs": {
                return target.getConfiguration().getMetricsSampleWindowMs();
            }
            case "noofmetricssample": 
            case "noOfMetricsSample": {
                return target.getConfiguration().getNoOfMetricsSample();
            }
            case "offsetrepository": 
            case "offsetRepository": {
                return target.getConfiguration().getOffsetRepository();
            }
            case "partitionassignor": 
            case "partitionAssignor": {
                return target.getConfiguration().getPartitionAssignor();
            }
            case "partitionkey": 
            case "partitionKey": {
                return target.getConfiguration().getPartitionKey();
            }
            case "partitioner": {
                return target.getConfiguration().getPartitioner();
            }
            case "partitionerignorekeys": 
            case "partitionerIgnoreKeys": {
                return target.getConfiguration().isPartitionerIgnoreKeys();
            }
            case "pollonerror": 
            case "pollOnError": {
                return target.getConfiguration().getPollOnError();
            }
            case "polltimeoutms": 
            case "pollTimeoutMs": {
                return target.getConfiguration().getPollTimeoutMs();
            }
            case "prevalidatehostandport": 
            case "preValidateHostAndPort": {
                return target.getConfiguration().isPreValidateHostAndPort();
            }
            case "producerbatchsize": 
            case "producerBatchSize": {
                return target.getConfiguration().getProducerBatchSize();
            }
            case "queuebufferingmaxmessages": 
            case "queueBufferingMaxMessages": {
                return target.getConfiguration().getQueueBufferingMaxMessages();
            }
            case "receivebufferbytes": 
            case "receiveBufferBytes": {
                return target.getConfiguration().getReceiveBufferBytes();
            }
            case "reconnectbackoffmaxms": 
            case "reconnectBackoffMaxMs": {
                return target.getConfiguration().getReconnectBackoffMaxMs();
            }
            case "reconnectbackoffms": 
            case "reconnectBackoffMs": {
                return target.getConfiguration().getReconnectBackoffMs();
            }
            case "recordmetadata": 
            case "recordMetadata": {
                return target.getConfiguration().isRecordMetadata();
            }
            case "requestrequiredacks": 
            case "requestRequiredAcks": {
                return target.getConfiguration().getRequestRequiredAcks();
            }
            case "requesttimeoutms": 
            case "requestTimeoutMs": {
                return target.getConfiguration().getRequestTimeoutMs();
            }
            case "retries": {
                return target.getConfiguration().getRetries();
            }
            case "retrybackoffmaxms": 
            case "retryBackoffMaxMs": {
                return target.getConfiguration().getRetryBackoffMaxMs();
            }
            case "retrybackoffms": 
            case "retryBackoffMs": {
                return target.getConfiguration().getRetryBackoffMs();
            }
            case "sasljaasconfig": 
            case "saslJaasConfig": {
                return target.getConfiguration().getSaslJaasConfig();
            }
            case "saslkerberosservicename": 
            case "saslKerberosServiceName": {
                return target.getConfiguration().getSaslKerberosServiceName();
            }
            case "saslmechanism": 
            case "saslMechanism": {
                return target.getConfiguration().getSaslMechanism();
            }
            case "schemaregistryurl": 
            case "schemaRegistryURL": {
                return target.getConfiguration().getSchemaRegistryURL();
            }
            case "securityprotocol": 
            case "securityProtocol": {
                return target.getConfiguration().getSecurityProtocol();
            }
            case "seekto": 
            case "seekTo": {
                return target.getConfiguration().getSeekTo();
            }
            case "sendbufferbytes": 
            case "sendBufferBytes": {
                return target.getConfiguration().getSendBufferBytes();
            }
            case "sessiontimeoutms": 
            case "sessionTimeoutMs": {
                return target.getConfiguration().getSessionTimeoutMs();
            }
            case "shutdowntimeout": 
            case "shutdownTimeout": {
                return target.getConfiguration().getShutdownTimeout();
            }
            case "specificavroreader": 
            case "specificAvroReader": {
                return target.getConfiguration().isSpecificAvroReader();
            }
            case "sslciphersuites": 
            case "sslCipherSuites": {
                return target.getConfiguration().getSslCipherSuites();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "sslenabledprotocols": 
            case "sslEnabledProtocols": {
                return target.getConfiguration().getSslEnabledProtocols();
            }
            case "sslendpointalgorithm": 
            case "sslEndpointAlgorithm": {
                return target.getConfiguration().getSslEndpointAlgorithm();
            }
            case "sslkeypassword": 
            case "sslKeyPassword": {
                return target.getConfiguration().getSslKeyPassword();
            }
            case "sslkeymanageralgorithm": 
            case "sslKeymanagerAlgorithm": {
                return target.getConfiguration().getSslKeymanagerAlgorithm();
            }
            case "sslkeystorelocation": 
            case "sslKeystoreLocation": {
                return target.getConfiguration().getSslKeystoreLocation();
            }
            case "sslkeystorepassword": 
            case "sslKeystorePassword": {
                return target.getConfiguration().getSslKeystorePassword();
            }
            case "sslkeystoretype": 
            case "sslKeystoreType": {
                return target.getConfiguration().getSslKeystoreType();
            }
            case "sslprotocol": 
            case "sslProtocol": {
                return target.getConfiguration().getSslProtocol();
            }
            case "sslprovider": 
            case "sslProvider": {
                return target.getConfiguration().getSslProvider();
            }
            case "ssltrustmanageralgorithm": 
            case "sslTrustmanagerAlgorithm": {
                return target.getConfiguration().getSslTrustmanagerAlgorithm();
            }
            case "ssltruststorelocation": 
            case "sslTruststoreLocation": {
                return target.getConfiguration().getSslTruststoreLocation();
            }
            case "ssltruststorepassword": 
            case "sslTruststorePassword": {
                return target.getConfiguration().getSslTruststorePassword();
            }
            case "ssltruststoretype": 
            case "sslTruststoreType": {
                return target.getConfiguration().getSslTruststoreType();
            }
            case "synchronous": {
                return target.getConfiguration().isSynchronous();
            }
            case "topicispattern": 
            case "topicIsPattern": {
                return target.getConfiguration().isTopicIsPattern();
            }
            case "useiterator": 
            case "useIterator": {
                return target.getConfiguration().isUseIterator();
            }
            case "valuedeserializer": 
            case "valueDeserializer": {
                return target.getConfiguration().getValueDeserializer();
            }
            case "valueserializer": 
            case "valueSerializer": {
                return target.getConfiguration().getValueSerializer();
            }
            case "workerpool": 
            case "workerPool": {
                return target.getConfiguration().getWorkerPool();
            }
            case "workerpoolcoresize": 
            case "workerPoolCoreSize": {
                return target.getConfiguration().getWorkerPoolCoreSize();
            }
            case "workerpoolmaxsize": 
            case "workerPoolMaxSize": {
                return target.getConfiguration().getWorkerPoolMaxSize();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "additionalproperties": 
            case "additionalProperties": {
                return Object.class;
            }
            case "offsetrepository": 
            case "offsetRepository": {
                return String.class;
            }
        }
        return null;
    }
}

