/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

@SendDynamic(value="kafka")
public class KafkaSendDynamicAware
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private String scheme;

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String originalDestination;
        String destination = this.parseTopicName(entry.getUri());
        if (destination != null && !destination.equals(originalDestination = this.parseTopicName(entry.getOriginalUri()))) {
            String answer = entry.getUri();
            answer = StringHelper.replaceFirst(answer, destination, originalDestination);
            return answer;
        }
        return null;
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        if (exchange.getMessage().getHeader("kafka.OVERRIDE_TOPIC") != null) {
            return null;
        }
        final String topicName = this.parseTopicName(entry.getUri());
        return new Processor(){

            @Override
            public void process(Exchange exchange) throws Exception {
                exchange.getMessage().setHeader("kafka.OVERRIDE_TOPIC", topicName);
            }
        };
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    private String parseTopicName(String uri) {
        int pos = (uri = StringHelper.before(uri, "?", uri)).indexOf(58);
        if (pos == -1) {
            return null;
        }
        uri = uri.substring(pos + 1);
        if (uri.startsWith("//")) {
            uri = uri.substring(2);
        }
        return uri;
    }
}

