/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="blocked", displayName="Blocked Exchanges", description="Display blocked exchanges")
public class BlockedConsole
extends AbstractDevConsole {
    public BlockedConsole() {
        super("camel", "blocked", "Blocked Exchanges", "Display blocked exchanges");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        AsyncProcessorAwaitManager am = PluginHelper.getAsyncProcessorAwaitManager(this.getCamelContext());
        sb.append(String.format("\n    Blocked: %s", am.size()));
        for (AsyncProcessorAwaitManager.AwaitThread at : am.browse()) {
            String age = TimeUtils.printDuration(at.getWaitDuration(), true);
            sb.append(String.format("\n    %s (at: %s/%s age: %s)", at.getExchange().getExchangeId(), at.getRouteId(), at.getNodeId(), age));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        AsyncProcessorAwaitManager am = PluginHelper.getAsyncProcessorAwaitManager(this.getCamelContext());
        root.put("blocked", am.size());
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (AsyncProcessorAwaitManager.AwaitThread at : am.browse()) {
            JsonObject props = new JsonObject();
            props.put("exchangeId", at.getExchange().getExchangeId());
            props.put("routeId", at.getRouteId());
            props.put("nodeId", at.getNodeId());
            props.put("duration", at.getWaitDuration());
            list.add(props);
        }
        if (!list.isEmpty()) {
            root.put("exchanges", list);
        }
        return root;
    }
}

