/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDevConsolesLoader {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/dev-console";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDevConsolesLoader.class);
    protected final CamelContext camelContext;
    protected final PackageScanResourceResolver resolver;
    protected final DevConsoleResolver devConsoleResolver;

    public DefaultDevConsolesLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resolver = PluginHelper.getPackageScanResourceResolver(camelContext);
        this.devConsoleResolver = PluginHelper.getDevConsoleResolver(camelContext);
    }

    public Collection<DevConsole> loadDevConsoles() {
        return this.loadDevConsoles(false);
    }

    public Collection<DevConsole> loadDevConsoles(boolean force) {
        ArrayList<DevConsole> answer = new ArrayList<DevConsole>();
        if (force) {
            ServiceHelper.stopService(this.devConsoleResolver);
            ServiceHelper.startService(this.devConsoleResolver);
        }
        try {
            LOG.trace("Searching for {} dev consoles", (Object)META_INF_SERVICES);
            Collection<Resource> resources = this.resolver.findResources("META-INF/services/org/apache/camel/dev-console/*");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} dev consoles from classpath scanning", (Object)resources.size());
            }
            for (Resource resource : resources) {
                LOG.trace("Resource: {}", (Object)resource);
                if (!this.acceptResource(resource)) continue;
                String id = this.extractId(resource);
                LOG.trace("Loading DevConsole: {}", (Object)id);
                DevConsole dc = this.devConsoleResolver.resolveDevConsole(id);
                if (dc == null) continue;
                LOG.debug("Loaded DevConsole: {}/{}", (Object)dc.getGroup(), (Object)dc.getId());
                answer.add(dc);
            }
        }
        catch (Exception e) {
            LOG.warn("Error during scanning for custom dev-consoles on classpath due to: {}. This exception is ignored.", (Object)e.getMessage());
        }
        return answer;
    }

    protected boolean acceptResource(Resource resource) {
        String loc = resource.getLocation();
        if (loc == null) {
            return false;
        }
        return !loc.endsWith("default-registry");
    }

    protected String extractId(Resource resource) {
        String loc = resource.getLocation();
        return StringHelper.after(loc, "META-INF/services/org/apache/camel/dev-console/");
    }
}

