/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.UnitUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="memory", displayName="JVM Memory", description="Displays JVM memory information")
@Configurer(bootstrap=true, extended=true)
public class MemoryDevConsole
extends AbstractDevConsole {
    public MemoryDevConsole() {
        super("jvm", "memory", "JVM Memory", "Displays JVM memory information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            sb.append(String.format("Heap Init: %s\n", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getInit())));
            sb.append(String.format("Heap Max: %s\n", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getMax())));
            sb.append(String.format("Heap Used: %s\n", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getUsed())));
            sb.append(String.format("Heap Committed: %s\n", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getCommitted())));
            sb.append("\n");
            sb.append(String.format("Non-Heap Init: %s\n", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getInit())));
            sb.append(String.format("Non-Heap Max: %s\n", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getMax())));
            sb.append(String.format("Non-Heap Used: %s\n", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getUsed())));
            sb.append(String.format("Non-Heap Committed: %s\n", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getCommitted())));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            root.put("heapMemoryInit", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getInit()));
            root.put("heapMemoryMax", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getMax()));
            root.put("heapMemoryUsed", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getUsed()));
            root.put("heapMemoryCommitted", UnitUtils.printUnitFromBytesDot(mb.getHeapMemoryUsage().getCommitted()));
            root.put("nonHeapMemoryInit", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getInit()));
            root.put("nonHeapMemoryMax", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getMax()));
            root.put("nonHeapMemoryUsed", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getUsed()));
            root.put("nonHeapMemoryCommitted", UnitUtils.printUnitFromBytesDot(mb.getNonHeapMemoryUsage().getCommitted()));
        }
        return root;
    }
}

