/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume.kafka;

import java.time.Duration;
import java.util.Properties;
import java.util.UUID;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategyConfiguration;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.support.resume.BasicResumeStrategyConfigurationBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaResumeStrategyConfigurationBuilder
extends BasicResumeStrategyConfigurationBuilder<KafkaResumeStrategyConfigurationBuilder, KafkaResumeStrategyConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaResumeStrategyConfigurationBuilder.class);
    private Properties producerProperties;
    private Properties consumerProperties;
    private String topic;
    private Duration maxInitializationDuration = Duration.ofSeconds(10L);
    private int maxInitializationRetries = 5;

    private KafkaResumeStrategyConfigurationBuilder() {
    }

    public KafkaResumeStrategyConfigurationBuilder(Properties producerProperties, Properties consumerProperties) {
        this.producerProperties = ObjectHelper.notNull(producerProperties, "producerProperties");
        this.consumerProperties = ObjectHelper.notNull(consumerProperties, "consumerProperties");
    }

    @Override
    public KafkaResumeStrategyConfigurationBuilder withCacheFillPolicy(Cacheable.FillPolicy cacheFillPolicy) {
        if (cacheFillPolicy == Cacheable.FillPolicy.MINIMIZING) {
            this.consumerProperties.setProperty("auto.offset.reset", "latest");
        } else {
            this.consumerProperties.setProperty("auto.offset.reset", "earliest");
        }
        return (KafkaResumeStrategyConfigurationBuilder)super.withCacheFillPolicy(cacheFillPolicy);
    }

    public KafkaResumeStrategyConfigurationBuilder withProducerProperty(String key, Object value) {
        this.producerProperties.put(key, value);
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withConsumerProperty(String key, Object value) {
        this.consumerProperties.put(key, value);
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withGroupId(String value) {
        this.consumerProperties.put("group.id", value);
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withEnableAutoCommit(boolean value) {
        this.consumerProperties.put("enable.auto.commit", (Object)value);
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withBootstrapServers(String value) {
        String bootstrapServers = StringHelper.notEmpty(value, "bootstrapServers");
        this.consumerProperties.put("bootstrap.servers", bootstrapServers);
        this.producerProperties.put("bootstrap.servers", bootstrapServers);
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withTopic(String value) {
        this.topic = value;
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withMaxInitializationDuration(Duration duration) {
        this.maxInitializationDuration = duration;
        return this;
    }

    public KafkaResumeStrategyConfigurationBuilder withMaxInitializationRetries(int retries) {
        this.maxInitializationRetries = retries;
        return this;
    }

    public static Properties createConsumerProperties() {
        Properties config = new Properties();
        config.put("key.deserializer", ByteArrayDeserializer.class.getName());
        config.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return config;
    }

    public static Properties createProducerProperties() {
        Properties config = new Properties();
        config.put("key.serializer", ByteArraySerializer.class.getName());
        config.put("value.serializer", ByteArraySerializer.class.getName());
        return config;
    }

    @Override
    public KafkaResumeStrategyConfiguration build() {
        KafkaResumeStrategyConfiguration resumeStrategyConfiguration = new KafkaResumeStrategyConfiguration();
        this.buildCommonConfiguration(resumeStrategyConfiguration);
        resumeStrategyConfiguration.setConsumerProperties(this.consumerProperties);
        resumeStrategyConfiguration.setProducerProperties(this.producerProperties);
        resumeStrategyConfiguration.setTopic(this.topic);
        resumeStrategyConfiguration.setMaxInitializationDuration(this.maxInitializationDuration);
        resumeStrategyConfiguration.setMaxInitializationRetries(this.maxInitializationRetries);
        return resumeStrategyConfiguration;
    }

    public static KafkaResumeStrategyConfigurationBuilder newBuilder() {
        Properties producerProperties = KafkaResumeStrategyConfigurationBuilder.createProducerProperties();
        Properties consumerProperties = KafkaResumeStrategyConfigurationBuilder.createConsumerProperties();
        KafkaResumeStrategyConfigurationBuilder builder = new KafkaResumeStrategyConfigurationBuilder(producerProperties, consumerProperties);
        String groupId = UUID.randomUUID().toString();
        LOG.debug("Creating consumer with {}[{}]", (Object)"group.id", (Object)groupId);
        builder.withGroupId(groupId);
        builder.withEnableAutoCommit(true);
        builder.withCacheFillPolicy(Cacheable.FillPolicy.MAXIMIZING);
        return builder;
    }

    public static KafkaResumeStrategyConfigurationBuilder newEmptyBuilder() {
        Properties producerProperties = new Properties();
        Properties consumerProperties = new Properties();
        KafkaResumeStrategyConfigurationBuilder builder = new KafkaResumeStrategyConfigurationBuilder(producerProperties, consumerProperties);
        String groupId = UUID.randomUUID().toString();
        LOG.debug("Creating consumer with {}[{}]", (Object)"group.id", (Object)groupId);
        builder.withGroupId(groupId);
        builder.withEnableAutoCommit(true);
        return builder;
    }
}

