/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;

public class KafkaProducerHealthCheck
extends AbstractHealthCheck {
    private final KafkaProducer kafkaProducer;
    private final String clientId;

    public KafkaProducerHealthCheck(KafkaProducer kafkaProducer, String clientId) {
        super("camel", "producer:kafka-" + clientId);
        this.kafkaProducer = kafkaProducer;
        this.clientId = clientId;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        if (!this.kafkaProducer.isReady()) {
            builder.down();
            builder.message("KafkaProducer is not ready");
            KafkaConfiguration cfg = this.kafkaProducer.getEndpoint().getConfiguration();
            Properties props = this.kafkaProducer.getProps();
            builder.detail("bootstrap.servers", props.getProperty("bootstrap.servers"));
            builder.detail("client.id", this.clientId);
            String gid = props.getProperty("group.id");
            if (gid != null) {
                builder.detail("group.id", gid);
            }
            builder.detail("topic", cfg.getTopic());
        } else {
            builder.up();
        }
    }
}

