/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.interop;

import java.nio.ByteBuffer;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;

public class JMSDeserializer
implements KafkaHeaderDeserializer {
    public boolean isLong(byte[] bytes) {
        return bytes.length == 8;
    }

    private static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = JMSDeserializer.toByteBuffer(bytes, 8);
        return buffer.getLong();
    }

    private static int bytesToInt(byte[] bytes) {
        ByteBuffer buffer = JMSDeserializer.toByteBuffer(bytes, 4);
        return buffer.getInt();
    }

    private static ByteBuffer toByteBuffer(byte[] bytes, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    @Override
    public Object deserialize(String key, byte[] value) {
        if (key.startsWith("JMS")) {
            switch (key) {
                case "JMSDestination": {
                    return new String(value);
                }
                case "JMSDeliveryMode": {
                    return JMSDeserializer.bytesToInt(value);
                }
                case "JMSTimestamp": {
                    return JMSDeserializer.bytesToLong(value);
                }
                case "JMSCorrelationID": {
                    return new String(value);
                }
                case "JMSReplyTo": {
                    return new String(value);
                }
                case "JMSRedelivered": {
                    return Boolean.parseBoolean(new String(value));
                }
                case "JMSType": {
                    return new String(value);
                }
                case "JMSExpiration": {
                    return this.isLong(value) ? JMSDeserializer.bytesToLong(value) : (long)JMSDeserializer.bytesToInt(value);
                }
                case "JMSPriority": {
                    return JMSDeserializer.bytesToInt(value);
                }
                case "JMSMessageID": {
                    return new String(value);
                }
            }
            return value;
        }
        return value;
    }
}

