/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="endpoint", displayName="Endpoints", description="Endpoint Registry information")
public class EndpointDevConsole
extends AbstractDevConsole {
    public EndpointDevConsole() {
        super("camel", "endpoint", "Endpoints", "Endpoint Registry information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List<RuntimeEndpointRegistry.Statistic> stats = null;
        RuntimeEndpointRegistry runtimeReg = this.getCamelContext().getRuntimeEndpointRegistry();
        if (runtimeReg != null) {
            stats = runtimeReg.getEndpointStatistics();
        }
        EndpointRegistry reg = this.getCamelContext().getEndpointRegistry();
        sb.append(String.format("    Endpoints: %s (static: %s dynamic: %s)\n", reg.size(), reg.staticSize(), reg.dynamicSize()));
        sb.append(String.format("    Maximum Cache Size: %s\n", reg.getMaximumCacheSize()));
        Collection<Endpoint> col = reg.getReadOnlyValues();
        if (!col.isEmpty()) {
            for (Endpoint e : col) {
                Optional<RuntimeEndpointRegistry.Statistic> stat;
                boolean stub = e.getComponent().getClass().getSimpleName().equals("StubComponent");
                boolean remote = e.isRemote();
                Object uri = e.toString();
                if (!((String)uri).startsWith("stub:") && stub) {
                    uri = (String)uri + " (stub)";
                }
                if ((stat = EndpointDevConsole.findStats(stats, e.getEndpointUri())).isPresent()) {
                    RuntimeEndpointRegistry.Statistic st = stat.get();
                    sb.append(String.format("\n    %s (remote: %s direction: %s, usage: %s)", uri, remote, st.getDirection(), st.getHits()));
                    continue;
                }
                sb.append(String.format("\n    %s (remote: %s)", uri, remote));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List<RuntimeEndpointRegistry.Statistic> stats = null;
        RuntimeEndpointRegistry runtimeReg = this.getCamelContext().getRuntimeEndpointRegistry();
        if (runtimeReg != null) {
            stats = runtimeReg.getEndpointStatistics();
        }
        EndpointRegistry reg = this.getCamelContext().getEndpointRegistry();
        root.put("size", reg.size());
        root.put("staticSize", reg.staticSize());
        root.put("dynamicSize", reg.dynamicSize());
        root.put("maximumCacheSize", reg.getMaximumCacheSize());
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put("endpoints", list);
        Collection<Endpoint> col = reg.getReadOnlyValues();
        for (Endpoint e : col) {
            JsonObject jo = new JsonObject();
            jo.put("uri", e.getEndpointUri());
            jo.put("remote", e.isRemote());
            boolean stub = e.getComponent().getClass().getSimpleName().equals("StubComponent");
            jo.put("stub", stub);
            Optional<RuntimeEndpointRegistry.Statistic> stat = EndpointDevConsole.findStats(stats, e.getEndpointUri());
            if (stat.isPresent()) {
                RuntimeEndpointRegistry.Statistic st = stat.get();
                jo.put("direction", st.getDirection());
                jo.put("hits", st.getHits());
                jo.put("routeId", st.getRouteId());
            }
            list.add(jo);
        }
        return root;
    }

    private static Optional<RuntimeEndpointRegistry.Statistic> findStats(List<RuntimeEndpointRegistry.Statistic> stats, String uri) {
        if (stats == null) {
            return Optional.empty();
        }
        return stats.stream().filter(s -> uri.equals(s.getUri())).findFirst();
    }
}

