/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="log", description="Logging framework")
public class LogDevConsole
extends AbstractDevConsole {
    private static final String LOG4J_MBEAN = "org.apache.logging.log4j2";

    public LogDevConsole() {
        super("camel", "log", "Log", "Logging framework");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> levels = LogDevConsole.fetchLoggingLevels();
        if (!levels.isEmpty()) {
            sb.append("Logging Levels:\n");
            levels.forEach((k, v) -> sb.append(String.format("\n    %s = %s", k, v)));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        Map<String, String> levels = LogDevConsole.fetchLoggingLevels();
        if (!levels.isEmpty()) {
            JsonObject props = new JsonObject();
            root.put("levels", props);
            props.putAll(levels);
        }
        return root;
    }

    private static Map<String, String> fetchLoggingLevels() {
        TreeMap<String, String> levels = new TreeMap<String, String>();
        try {
            MBeanServer ms = ManagementFactory.getPlatformMBeanServer();
            if (ms != null) {
                Set<ObjectName> set = ms.queryNames(new ObjectName("org.apache.logging.log4j2:type=*,component=Loggers,name=*"), null);
                for (ObjectName on : set) {
                    if (!ms.isRegistered(on)) continue;
                    String name = (String)ms.getAttribute(on, "Name");
                    String level = (String)ms.getAttribute(on, "Level");
                    if (name == null || name.isEmpty()) {
                        name = "root";
                    }
                    levels.put(name, level);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return levels;
    }
}

