/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="properties", description="Displays the properties loaded by Camel")
public class PropertiesDevConsole
extends AbstractDevConsole {
    public PropertiesDevConsole() {
        super("camel", "properties", "Properties", "Displays the properties loaded by Camel");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        String loc = String.join((CharSequence)", ", pc.getLocations());
        sb.append(String.format("Properties loaded from locations: %s", loc));
        sb.append("\n");
        Properties p = pc.loadProperties();
        OrderedLocationProperties olp = null;
        if (p instanceof OrderedLocationProperties) {
            olp = (OrderedLocationProperties)p;
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            String string = loc = olp != null ? LocationHelper.locationSummary(olp, k) : null;
            if (SensitiveUtils.containsSensitive(k)) {
                sb.append(String.format("    %s %s = xxxxxx%n", loc, k));
                continue;
            }
            sb.append(String.format("    %s %s = %s%n", loc, k, v));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        root.put("locations", pc.getLocations());
        JsonArray arr = new JsonArray();
        Properties p = pc.loadProperties();
        OrderedLocationProperties olp = null;
        if (p instanceof OrderedLocationProperties) {
            olp = (OrderedLocationProperties)p;
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            String loc = olp != null ? olp.getLocation(k) : null;
            JsonObject jo = new JsonObject();
            jo.put("key", k);
            jo.put("value", v);
            if (loc != null) {
                jo.put("location", loc);
                jo.put("internal", PropertiesDevConsole.isInternal(loc));
            }
            arr.add(jo);
        }
        if (!arr.isEmpty()) {
            root.put("properties", arr);
        }
        return root;
    }

    private static boolean isInternal(String loc) {
        if (loc == null) {
            return false;
        }
        return "initial".equals(loc) || "override".equals(loc);
    }
}

