/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DevConsole(name="route", description="Route information")
public class RouteDevConsole
extends AbstractDevConsole {
    private static final Logger LOG = LoggerFactory.getLogger(RouteDevConsole.class);
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String PROCESSORS = "processors";
    public static final String ACTION = "action";

    public RouteDevConsole() {
        super("camel", "route", "Route", "Route information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return "";
        }
        boolean processors = "true".equals(options.getOrDefault(PROCESSORS, "false"));
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            String ago;
            Date last;
            String thp;
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("    Id: %s", mrb.getRouteId()));
            if (mrb.getNodePrefixId() != null) {
                sb.append(String.format("    Node Prefix Id: %s", mrb.getNodePrefixId()));
            }
            sb.append(String.format("\n    From: %s", mrb.getEndpointUri()));
            sb.append(String.format("\n    Remote: %s", mrb.isRemoteEndpoint()));
            if (mrb.getSourceLocation() != null) {
                sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
            }
            sb.append(String.format("\n    State: %s", mrb.getState()));
            if (mrb.getLastError() != null) {
                String phase = StringHelper.capitalize(mrb.getLastError().getPhase().name().toLowerCase());
                String ago2 = TimeUtils.printSince(mrb.getLastError().getDate().getTime());
                sb.append(String.format("\n    Error Ago: %s", ago2));
                sb.append(String.format("\n    Error Phase: %s", phase));
                Throwable cause = mrb.getLastError().getException();
                if (cause != null) {
                    sb.append(String.format("\n    Error Message: %s", cause.getMessage()));
                    String stackTrace = ExceptionHelper.stackTraceToString(cause);
                    sb.append("\n\n");
                    sb.append(stackTrace);
                    sb.append("\n\n");
                }
            }
            sb.append(String.format("\n    Uptime: %s", mrb.getUptime()));
            String coverage = this.calculateRouteCoverage((ManagedRouteMBean)mrb, true);
            if (coverage != null) {
                sb.append(String.format("\n    Coverage: %s", coverage));
            }
            String load1 = this.getLoad1((ManagedRouteMBean)mrb);
            String load5 = this.getLoad5((ManagedRouteMBean)mrb);
            String load15 = this.getLoad15((ManagedRouteMBean)mrb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                sb.append(String.format("\n    Load Average: %s %s %s\n", load1, load5, load15));
            }
            if (!(thp = this.getThroughput((ManagedRouteMBean)mrb)).isEmpty()) {
                sb.append(String.format("\n    Messages/Sec: %s", thp));
            }
            sb.append(String.format("\n    Total: %s", mrb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mrb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mrb.getExchangesInflight()));
            long idle = mrb.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n    Idle Since: %s", TimeUtils.printDuration(idle)));
            } else {
                sb.append(String.format("\n    Idle Since: %s", ""));
            }
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration(mrb.getMeanProcessingTime(), true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration(mrb.getMaxProcessingTime(), true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration(mrb.getMinProcessingTime(), true)));
            if (mrb.getExchangesTotal() > 0L) {
                sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration(mrb.getLastProcessingTime(), true)));
                sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration(mrb.getDeltaProcessingTime(), true)));
            }
            if ((last = mrb.getLastExchangeCreatedTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Started: %s", ago));
            }
            if ((last = mrb.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Completed: %s", ago));
            }
            if ((last = mrb.getLastExchangeFailureTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Failed: %s", ago));
            }
            if (processors) {
                this.includeProcessorsText((ManagedRouteMBean)mrb, sb);
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    private void includeProcessorsText(ManagedRouteMBean mrb, StringBuilder sb) {
        Collection<String> ids;
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null) continue;
            mps.add(mp);
        }
        mps.sort(Comparator.comparingInt(ManagedProcessorMBean::getIndex));
        for (ManagedProcessorMBean mp : mps) {
            String ago;
            Date last;
            sb.append("\n");
            sb.append(String.format("\n        Id: %s", mp.getProcessorId()));
            if (mp.getNodePrefixId() != null) {
                sb.append(String.format("\n        Node Prefix Id: %s", mp.getNodePrefixId()));
            }
            sb.append(String.format("\n        Processor: %s", mp.getProcessorName()));
            sb.append(String.format("\n        Level: %d", mp.getLevel()));
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                sb.append(String.format("\n        Source: %s", loc));
            }
            sb.append(String.format("\n        Total: %s", mp.getExchangesTotal()));
            sb.append(String.format("\n        Failed: %s", mp.getExchangesFailed()));
            sb.append(String.format("\n        Inflight: %s", mp.getExchangesInflight()));
            long idle = mp.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n        Idle Since: %s", TimeUtils.printDuration(idle)));
            } else {
                sb.append(String.format("\n        Idle Since: %s", ""));
            }
            sb.append(String.format("\n        Mean Time: %s", TimeUtils.printDuration(mp.getMeanProcessingTime(), true)));
            sb.append(String.format("\n        Max Time: %s", TimeUtils.printDuration(mp.getMaxProcessingTime(), true)));
            sb.append(String.format("\n        Min Time: %s", TimeUtils.printDuration(mp.getMinProcessingTime(), true)));
            if (mp.getExchangesTotal() > 0L) {
                sb.append(String.format("\n        Last Time: %s", TimeUtils.printDuration(mp.getLastProcessingTime(), true)));
                sb.append(String.format("\n        Delta Time: %s", TimeUtils.printDuration(mp.getDeltaProcessingTime(), true)));
            }
            if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n        Since Last Completed: %s", ago));
            }
            if ((last = mp.getLastExchangeFailureTimestamp()) == null) continue;
            ago = TimeUtils.printSince(last.getTime());
            sb.append(String.format("\n        Since Last Failed: %s", ago));
        }
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return new JsonObject();
        }
        boolean processors = "true".equals(options.getOrDefault(PROCESSORS, "false"));
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            Date last;
            String thp;
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put("routeId", mrb.getRouteId());
            if (mrb.getNodePrefixId() != null) {
                jo.put("nodePrefixId", mrb.getNodePrefixId());
            }
            jo.put("from", mrb.getEndpointUri());
            jo.put("remote", mrb.isRemoteEndpoint());
            if (mrb.getSourceLocation() != null) {
                jo.put("source", mrb.getSourceLocation());
            }
            jo.put("state", mrb.getState());
            jo.put("uptime", mrb.getUptime());
            if (mrb.getLastError() != null) {
                String phase = StringHelper.capitalize(mrb.getLastError().getPhase().name().toLowerCase());
                JsonObject eo = new JsonObject();
                eo.put("phase", phase);
                eo.put("timestamp", mrb.getLastError().getDate().getTime());
                Throwable cause = mrb.getLastError().getException();
                if (cause != null) {
                    eo.put("message", cause.getMessage());
                    JsonArray arr2 = new JsonArray();
                    String trace = ExceptionHelper.stackTraceToString(cause);
                    eo.put("stackTrace", arr2);
                    Collections.addAll(arr2, trace.split("\n"));
                }
                jo.put("lastError", eo);
            }
            JsonObject stats = new JsonObject();
            String coverage = this.calculateRouteCoverage((ManagedRouteMBean)mrb, false);
            if (coverage != null) {
                stats.put("coverage", coverage);
            }
            String load1 = this.getLoad1((ManagedRouteMBean)mrb);
            String load5 = this.getLoad5((ManagedRouteMBean)mrb);
            String load15 = this.getLoad15((ManagedRouteMBean)mrb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                stats.put("load01", load1);
                stats.put("load05", load5);
                stats.put("load15", load15);
            }
            if (!(thp = this.getThroughput((ManagedRouteMBean)mrb)).isEmpty()) {
                stats.put("exchangesThroughput", thp);
            }
            stats.put("idleSince", mrb.getIdleSince());
            stats.put("exchangesTotal", mrb.getExchangesTotal());
            stats.put("exchangesFailed", mrb.getExchangesFailed());
            stats.put("exchangesInflight", mrb.getExchangesInflight());
            stats.put("meanProcessingTime", mrb.getMeanProcessingTime());
            stats.put("maxProcessingTime", mrb.getMaxProcessingTime());
            stats.put("minProcessingTime", mrb.getMinProcessingTime());
            if (mrb.getExchangesTotal() > 0L) {
                stats.put("lastProcessingTime", mrb.getLastProcessingTime());
                stats.put("deltaProcessingTime", mrb.getDeltaProcessingTime());
            }
            if ((last = mrb.getLastExchangeCreatedTimestamp()) != null) {
                stats.put("lastCreatedExchangeTimestamp", last.getTime());
            }
            if ((last = mrb.getLastExchangeCompletedTimestamp()) != null) {
                stats.put("lastCompletedExchangeTimestamp", last.getTime());
            }
            if ((last = mrb.getLastExchangeFailureTimestamp()) != null) {
                stats.put("lastFailedExchangeTimestamp", last.getTime());
            }
            jo.put("statistics", stats);
            if (processors) {
                JsonArray arr = new JsonArray();
                jo.put(PROCESSORS, arr);
                this.includeProcessorsJson((ManagedRouteMBean)mrb, arr);
            }
            return null;
        };
        this.doCall(options, task);
        root.put("routes", list);
        return root;
    }

    private void includeProcessorsJson(ManagedRouteMBean mrb, JsonArray arr) {
        Collection<String> ids;
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        List<ManagedProcessorMBean> mps = ids.stream().map(mcc::getManagedProcessor).filter(Objects::nonNull).sorted(Comparator.comparingInt(ManagedProcessorMBean::getIndex)).toList();
        for (ManagedProcessorMBean mp : mps) {
            String line;
            JsonObject jo = new JsonObject();
            arr.add(jo);
            jo.put("id", mp.getProcessorId());
            if (mp.getNodePrefixId() != null) {
                jo.put("nodePrefixId", mp.getNodePrefixId());
            }
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                jo.put("source", loc);
            }
            if ((line = ConsoleHelper.loadSourceLine(this.getCamelContext(), mp.getSourceLocation(), mp.getSourceLineNumber())) != null) {
                JsonArray ca = new JsonArray();
                jo.put("code", ca);
                JsonObject c = new JsonObject();
                if (mp.getSourceLineNumber() != null) {
                    c.put("line", mp.getSourceLineNumber());
                }
                c.put("code", Jsoner.escape(line));
                c.put("match", true);
                ca.add(c);
            }
            jo.put("processor", mp.getProcessorName());
            jo.put("level", mp.getLevel());
            JsonObject stats = RouteDevConsole.getStatsObject(mp);
            jo.put("statistics", stats);
        }
    }

    private static JsonObject getStatsObject(ManagedProcessorMBean mp) {
        Date last;
        JsonObject stats = new JsonObject();
        stats.put("idleSince", mp.getIdleSince());
        stats.put("exchangesTotal", mp.getExchangesTotal());
        stats.put("exchangesFailed", mp.getExchangesFailed());
        stats.put("exchangesInflight", mp.getExchangesInflight());
        stats.put("meanProcessingTime", mp.getMeanProcessingTime());
        stats.put("maxProcessingTime", mp.getMaxProcessingTime());
        stats.put("minProcessingTime", mp.getMinProcessingTime());
        if (mp.getExchangesTotal() > 0L) {
            stats.put("lastProcessingTime", mp.getLastProcessingTime());
            stats.put("deltaProcessingTime", mp.getDeltaProcessingTime());
        }
        if ((last = mp.getLastExchangeCreatedTimestamp()) != null) {
            stats.put("lastCreatedExchangeTimestamp", last.getTime());
        }
        if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
            stats.put("lastCompletedExchangeTimestamp", last.getTime());
        }
        if ((last = mp.getLastExchangeFailureTimestamp()) != null) {
            stats.put("lastFailedExchangeTimestamp", last.getTime());
        }
        return stats;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after(path, "/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List<Route> routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> RouteDevConsole.accept(r, filter)).filter(r -> RouteDevConsole.accept(r, subPath)).sorted(RouteDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly(mrb.getSourceLocation());
        return PatternHelper.matchPattern(mrb.getRouteId(), filter) || PatternHelper.matchPattern(mrb.getEndpointUri(), filter) || PatternHelper.matchPattern(mrb.getSourceLocationShort(), filter) || PatternHelper.matchPattern(onlyName, filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareToIgnoreCase(o2.getRouteId());
    }

    private String getLoad1(ManagedRouteMBean mrb) {
        String s = mrb.getLoad01();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad5(ManagedRouteMBean mrb) {
        String s = mrb.getLoad05();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad15(ManagedRouteMBean mrb) {
        String s = mrb.getLoad15();
        s = s.replace(',', '.');
        return s;
    }

    private String getThroughput(ManagedRouteMBean mrb) {
        String s = mrb.getThroughput();
        s = s.replace(',', '.');
        return s;
    }

    private String calculateRouteCoverage(ManagedRouteMBean mrb, boolean percent) {
        Collection<String> ids;
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return null;
        }
        int total = ids.size();
        int covered = 0;
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null || mp.getExchangesTotal() <= 0L) continue;
            ++covered;
        }
        if (percent) {
            double p = total > 0 ? (double)covered / (double)total * 100.0 : 0.0;
            String f = String.format("%.0f", p);
            return covered + "/" + total + " (" + f + "%)";
        }
        return covered + "/" + total;
    }

    protected void doAction(CamelContext camelContext, String command, String filter) {
        if (filter == null) {
            filter = "*";
        }
        String[] patterns = filter.split(",");
        List<String> ids = camelContext.getRoutes().stream().map(Route::getRouteId).filter(routeId -> {
            for (String p : patterns) {
                if (!PatternHelper.matchPattern(routeId, p)) continue;
                return true;
            }
            return false;
        }).toList();
        for (String id : ids) {
            try {
                if ("start".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.getRouteController().startAllRoutes();
                        continue;
                    }
                    camelContext.getRouteController().startRoute(id);
                    continue;
                }
                if ("stop".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.getRouteController().stopAllRoutes();
                        continue;
                    }
                    camelContext.getRouteController().stopRoute(id);
                    continue;
                }
                if ("suspend".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.suspend();
                        continue;
                    }
                    camelContext.getRouteController().suspendRoute(id);
                    continue;
                }
                if (!"resume".equals(command)) continue;
                if ("*".equals(id)) {
                    camelContext.resume();
                    continue;
                }
                camelContext.getRouteController().resumeRoute(id);
            }
            catch (Exception e) {
                LOG.warn("Error {} route: {} due to: {}. This exception is ignored.", new Object[]{command, id, e.getMessage(), e});
            }
        }
    }
}

