/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="top", displayName="Top Routes", description="Display the top routes")
public class TopDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";

    public TopDevConsole() {
        super("camel", "top", "Top Routes", "Display the top routes");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after(path, "/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        StringBuilder sb = new StringBuilder();
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            if (subPath == null || subPath.isBlank()) {
                Function<ManagedRouteMBean, Object> task = mrb -> {
                    if (!sb.isEmpty()) {
                        sb.append("\n");
                    }
                    sb.append(String.format("    Route Id: %s", mrb.getRouteId()));
                    sb.append(String.format("\n    From: %s", mrb.getEndpointUri()));
                    if (mrb.getSourceLocation() != null) {
                        sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
                    }
                    sb.append(String.format("\n    Total: %s", mrb.getExchangesTotal()));
                    sb.append(String.format("\n    Failed: %s", mrb.getExchangesFailed()));
                    sb.append(String.format("\n    Inflight: %s", mrb.getExchangesInflight()));
                    sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration(mrb.getMeanProcessingTime(), true)));
                    sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration(mrb.getMaxProcessingTime(), true)));
                    sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration(mrb.getMinProcessingTime(), true)));
                    sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration(mrb.getLastProcessingTime(), true)));
                    sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration(mrb.getDeltaProcessingTime(), true)));
                    sb.append(String.format("\n    Total Time: %s", TimeUtils.printDuration(mrb.getTotalProcessingTime(), true)));
                    sb.append("\n");
                    return null;
                };
                this.topRoutes(filter, max, mcc, task);
            } else {
                Function<ManagedProcessorMBean, Object> task = mpb -> {
                    if (!sb.isEmpty()) {
                        sb.append("\n");
                    }
                    sb.append(String.format("    Route Id: %s", mpb.getRouteId()));
                    sb.append(String.format("\n    Processor Id: %s", mpb.getProcessorId()));
                    Object loc = mpb.getSourceLocation();
                    StringBuilder code = new StringBuilder();
                    if (loc != null && mpb.getSourceLineNumber() != null) {
                        int line = mpb.getSourceLineNumber();
                        try {
                            loc = LoggerHelper.stripSourceLocationLineNumber((String)loc);
                            Resource resource = PluginHelper.getResourceLoader(this.getCamelContext()).resolveResource((String)loc);
                            if (resource != null) {
                                LineNumberReader reader = new LineNumberReader(resource.getReader());
                                for (int i = 1; i < line + 3; ++i) {
                                    String t = reader.readLine();
                                    if (t == null) continue;
                                    int low = line - 2;
                                    int high = line + 4;
                                    if (i < low || i > high) continue;
                                    String arrow = i == line ? "-->" : "   ";
                                    code.append(String.format("\n        %s #%s %s", arrow, i, t));
                                }
                                IOHelper.close((Closeable)reader);
                            }
                            loc = (String)loc + ":" + mpb.getSourceLineNumber();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (loc != null) {
                        sb.append(String.format("\n    Source: %s", loc));
                        if (!code.isEmpty()) {
                            sb.append((CharSequence)code);
                        }
                    }
                    sb.append(String.format("\n    Total: %s", mpb.getExchangesTotal()));
                    sb.append(String.format("\n    Failed: %s", mpb.getExchangesFailed()));
                    sb.append(String.format("\n    Inflight: %s", mpb.getExchangesInflight()));
                    sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration(mpb.getMeanProcessingTime(), true)));
                    sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration(mpb.getMaxProcessingTime(), true)));
                    sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration(mpb.getMinProcessingTime(), true)));
                    sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration(mpb.getLastProcessingTime(), true)));
                    sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration(mpb.getDeltaProcessingTime(), true)));
                    sb.append(String.format("\n    Total Time: %s", TimeUtils.printDuration(mpb.getTotalProcessingTime(), true)));
                    sb.append("\n");
                    return null;
                };
                this.topProcessors(filter, subPath, max, mcc, task);
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after(path, "/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            if (subPath == null || subPath.isBlank()) {
                Function<ManagedRouteMBean, Object> task = mrb -> {
                    JsonObject jo = new JsonObject();
                    list.add(jo);
                    jo.put("routeId", mrb.getRouteId());
                    jo.put("from", mrb.getEndpointUri());
                    if (mrb.getSourceLocation() != null) {
                        jo.put("source", mrb.getSourceLocation());
                    }
                    jo.put("state", mrb.getState());
                    jo.put("uptime", mrb.getUptime());
                    JsonObject stats = TopDevConsole.getStatsObject(mrb);
                    jo.put("statistics", stats);
                    return null;
                };
                this.topRoutes(filter, max, mcc, task);
                root.put("routes", list);
            } else {
                Function<ManagedProcessorMBean, Object> task = mpb -> {
                    JsonObject jo = new JsonObject();
                    list.add(jo);
                    jo.put("routeId", mpb.getRouteId());
                    jo.put("processorId", mpb.getProcessorId());
                    Object loc = mpb.getSourceLocation();
                    ArrayList<JsonObject> code = new ArrayList<JsonObject>();
                    if (loc != null && mpb.getSourceLineNumber() != null) {
                        int line = mpb.getSourceLineNumber();
                        try {
                            loc = LoggerHelper.stripSourceLocationLineNumber((String)loc);
                            Resource resource = PluginHelper.getResourceLoader(this.getCamelContext()).resolveResource((String)loc);
                            if (resource != null) {
                                LineNumberReader reader = new LineNumberReader(resource.getReader());
                                for (int i = 1; i < line + 3; ++i) {
                                    String t = reader.readLine();
                                    if (t == null) continue;
                                    int low = line - 2;
                                    int high = line + 4;
                                    if (i < low || i > high) continue;
                                    JsonObject c = new JsonObject();
                                    c.put("line", i);
                                    if (line == i) {
                                        c.put("match", true);
                                    }
                                    c.put("code", Jsoner.escape(t));
                                    code.add(c);
                                }
                                IOHelper.close((Closeable)reader);
                            }
                            loc = (String)loc + ":" + mpb.getSourceLineNumber();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (loc != null) {
                        jo.put("location", loc);
                        if (!code.isEmpty()) {
                            jo.put("code", code);
                        }
                    }
                    JsonObject stats = TopDevConsole.getStatsObject(mpb);
                    jo.put("statistics", stats);
                    return null;
                };
                this.topProcessors(filter, subPath, max, mcc, task);
                root.put("processors", list);
            }
        }
        return root;
    }

    private static JsonObject getStatsObject(ManagedProcessorMBean mpb) {
        JsonObject stats = new JsonObject();
        stats.put("exchangesTotal", mpb.getExchangesTotal());
        stats.put("exchangesFailed", mpb.getExchangesFailed());
        stats.put("exchangesInflight", mpb.getExchangesInflight());
        stats.put("meanProcessingTime", mpb.getMeanProcessingTime());
        stats.put("maxProcessingTime", mpb.getMaxProcessingTime());
        stats.put("minProcessingTime", mpb.getMinProcessingTime());
        stats.put("lastProcessingTime", mpb.getLastProcessingTime());
        stats.put("deltaProcessingTime", mpb.getDeltaProcessingTime());
        stats.put("totalProcessingTime", mpb.getTotalProcessingTime());
        return stats;
    }

    private static JsonObject getStatsObject(ManagedRouteMBean mrb) {
        JsonObject stats = new JsonObject();
        stats.put("exchangesTotal", mrb.getExchangesTotal());
        stats.put("exchangesFailed", mrb.getExchangesFailed());
        stats.put("exchangesInflight", mrb.getExchangesInflight());
        stats.put("meanProcessingTime", mrb.getMeanProcessingTime());
        stats.put("maxProcessingTime", mrb.getMaxProcessingTime());
        stats.put("minProcessingTime", mrb.getMinProcessingTime());
        stats.put("lastProcessingTime", mrb.getLastProcessingTime());
        stats.put("deltaProcessingTime", mrb.getDeltaProcessingTime());
        stats.put("totalProcessingTime", mrb.getTotalProcessingTime());
        return stats;
    }

    private void topRoutes(String filter, int max, ManagedCamelContext mcc, Function<ManagedRouteMBean, Object> task) {
        List<Route> routes = this.getCamelContext().getRoutes();
        routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> TopDevConsole.acceptRoute(r, filter)).sorted(TopDevConsole::top).limit(max).forEach(task::apply);
    }

    private void topProcessors(String filter, String subPath, int max, ManagedCamelContext mcc, Function<ManagedProcessorMBean, Object> task) {
        List<Route> routes = this.getCamelContext().getRoutes();
        ArrayList ids = new ArrayList();
        routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> TopDevConsole.acceptRoute(r, subPath)).forEach(r -> {
            try {
                ids.addAll(r.processorIds());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ids.stream().map(mcc::getManagedProcessor).filter(p -> TopDevConsole.acceptProcessor(p, filter)).sorted(TopDevConsole::top).limit(max).forEach(task::apply);
    }

    private static boolean acceptRoute(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly(mrb.getSourceLocation());
        return PatternHelper.matchPattern(mrb.getRouteId(), filter) || PatternHelper.matchPattern(mrb.getEndpointUri(), filter) || PatternHelper.matchPattern(mrb.getSourceLocationShort(), filter) || PatternHelper.matchPattern(onlyName, filter);
    }

    private static boolean acceptProcessor(ManagedProcessorMBean mpb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern(mpb.getProcessorId(), filter) || PatternHelper.matchPattern(mpb.getSourceLocation(), filter);
    }

    private static int top(ManagedPerformanceCounterMBean o1, ManagedPerformanceCounterMBean o2) {
        long m2;
        long m1 = o1.getMeanProcessingTime();
        if (m1 < (m2 = o2.getMeanProcessingTime())) {
            return 1;
        }
        if (m1 > m2) {
            return -1;
        }
        return 0;
    }
}

